/*
  File autogenerated by gengetopt version 2.12
  generated with the following command:
  ../src/gengetopt --input=./sample2.ggo --func-name=my_cmdline_parser --file-name=cmdline2 --unamed-opts --no-handle-help --no-handle-version 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline2.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
my_cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->str_opt_given = 0 ;
  args_info->int_opt_given = 0 ;
  args_info->short_opt_given = 0 ;
  args_info->long_opt_given = 0 ;
  args_info->float_opt_given = 0 ;
  args_info->double_opt_given = 0 ;
  args_info->long_double_opt_given = 0 ;
  args_info->long_long_opt_given = 0 ;
  args_info->func_opt_given = 0 ;
  args_info->flag_opt_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->str_opt_arg = NULL;
  args_info->flag_opt_flag = 0;
}

void
my_cmdline_parser_print_version (void)
{
  printf ("%s %s\n", MY_CMDLINE_PARSER_PACKAGE, MY_CMDLINE_PARSER_VERSION);
}

void
my_cmdline_parser_print_help (void)
{
  my_cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  this is just a test program for gengetopt\n"
  "\n"
  "Usage: %s [OPTIONS]... [FILES]...\n", MY_CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("%s\n","  -h, --help                        Print help and exit");
  printf("%s\n","  -V, --version                     Print version and exit");
  printf("%s\n","  -s, --str-opt=STRING              A string option");
  printf("%s\n","  -i, --int-opt=INT                 A int option");
  printf("%s\n","  -S, --short-opt=SHORT             A short option");
  printf("%s\n","  -l, --long-opt=LONG               A long option");
  printf("%s\n","  -f, --float-opt=FLOAT             A float option");
  printf("%s\n","  -d, --double-opt=DOUBLE           A double option");
  printf("%s\n","  -L, --long-double-opt=LONGDOUBLE  A long double option");
  printf("%s\n","  -y, --long-long-opt=LONGLONG      A long long option");
  printf("%s\n","  -F, --func-opt                    A function option");
  printf("%s\n","  -x, --flag-opt                    A flag option  (default=off)");
}

void
my_cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

void
my_cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  int i;
  if (args_info->str_opt_arg)
    {
      free (args_info->str_opt_arg); /* free previous argument */
      args_info->str_opt_arg = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
my_cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return my_cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
my_cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  
  result = my_cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);
  
  if (result == EXIT_FAILURE)
    {
      my_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
my_cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */
  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    my_cmdline_parser_init (args_info);

  my_cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "str-opt",	1, NULL, 's' },
        { "int-opt",	1, NULL, 'i' },
        { "short-opt",	1, NULL, 'S' },
        { "long-opt",	1, NULL, 'l' },
        { "float-opt",	1, NULL, 'f' },
        { "double-opt",	1, NULL, 'd' },
        { "long-double-opt",	1, NULL, 'L' },
        { "long-long-opt",	1, NULL, 'y' },
        { "func-opt",	0, NULL, 'F' },
        { "flag-opt",	0, NULL, 'x' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVs:i:S:l:f:d:L:y:Fx", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (local_args_info.help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->help_given && ! override)
            continue;
          local_args_info.help_given = 1;
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          if (local_args_info.version_given)
            {
              fprintf (stderr, "%s: `--version' (`-V') option given more than once%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->version_given && ! override)
            continue;
          local_args_info.version_given = 1;
          args_info->version_given = 1;
          return 0;

        case 's':	/* A string option.  */
          if (local_args_info.str_opt_given)
            {
              fprintf (stderr, "%s: `--str-opt' (`-s') option given more than once%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->str_opt_given && ! override)
            continue;
          local_args_info.str_opt_given = 1;
          args_info->str_opt_given = 1;
          if (args_info->str_opt_arg)
            free (args_info->str_opt_arg); /* free previous string */
          args_info->str_opt_arg = gengetopt_strdup (optarg);
          break;

        case 'i':	/* A int option.  */
          if (local_args_info.int_opt_given)
            {
              fprintf (stderr, "%s: `--int-opt' (`-i') option given more than once%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->int_opt_given && ! override)
            continue;
          local_args_info.int_opt_given = 1;
          args_info->int_opt_given = 1;
          args_info->int_opt_arg = strtol (optarg,&stop_char,0);
          break;

        case 'S':	/* A short option.  */
          if (local_args_info.short_opt_given)
            {
              fprintf (stderr, "%s: `--short-opt' (`-S') option given more than once%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->short_opt_given && ! override)
            continue;
          local_args_info.short_opt_given = 1;
          args_info->short_opt_given = 1;
          args_info->short_opt_arg = (short)strtol (optarg,&stop_char,0);
          break;

        case 'l':	/* A long option.  */
          if (local_args_info.long_opt_given)
            {
              fprintf (stderr, "%s: `--long-opt' (`-l') option given more than once%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->long_opt_given && ! override)
            continue;
          local_args_info.long_opt_given = 1;
          args_info->long_opt_given = 1;
          args_info->long_opt_arg = strtol (optarg,&stop_char,0);
          break;

        case 'f':	/* A float option.  */
          if (local_args_info.float_opt_given)
            {
              fprintf (stderr, "%s: `--float-opt' (`-f') option given more than once%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->float_opt_given && ! override)
            continue;
          local_args_info.float_opt_given = 1;
          args_info->float_opt_given = 1;
          args_info->float_opt_arg = (float)strtod (optarg, NULL);
          break;

        case 'd':	/* A double option.  */
          if (local_args_info.double_opt_given)
            {
              fprintf (stderr, "%s: `--double-opt' (`-d') option given more than once%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->double_opt_given && ! override)
            continue;
          local_args_info.double_opt_given = 1;
          args_info->double_opt_given = 1;
          args_info->double_opt_arg = strtod (optarg, NULL);
          break;

        case 'L':	/* A long double option.  */
          if (local_args_info.long_double_opt_given)
            {
              fprintf (stderr, "%s: `--long-double-opt' (`-L') option given more than once%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->long_double_opt_given && ! override)
            continue;
          local_args_info.long_double_opt_given = 1;
          args_info->long_double_opt_given = 1;
          args_info->long_double_opt_arg = (long double)strtod (optarg, NULL);
          break;

        case 'y':	/* A long long option.  */
          if (local_args_info.long_long_opt_given)
            {
              fprintf (stderr, "%s: `--long-long-opt' (`-y') option given more than once%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->long_long_opt_given && ! override)
            continue;
          local_args_info.long_long_opt_given = 1;
          args_info->long_long_opt_given = 1;
          #ifdef HAVE_LONG_LONG
          args_info->long_long_opt_arg = (long long int) strtol (optarg,&stop_char,0);
          #else
          args_info->long_long_opt_arg = (long) strtol (optarg,&stop_char,0);
          #endif
          break;

        case 'F':	/* A function option.  */
          if (local_args_info.func_opt_given)
            {
              fprintf (stderr, "%s: `--func-opt' (`-F') option given more than once%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->func_opt_given && ! override)
            continue;
          local_args_info.func_opt_given = 1;
          args_info->func_opt_given = 1;
          break;

        case 'x':	/* A flag option.  */
          if (local_args_info.flag_opt_given)
            {
              fprintf (stderr, "%s: `--flag-opt' (`-x') option given more than once%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->flag_opt_given && ! override)
            continue;
          local_args_info.flag_opt_given = 1;
          args_info->flag_opt_given = 1;
          args_info->flag_opt_flag = !(args_info->flag_opt_flag);
          break;


        case 0:	/* Long option with no short option */

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", MY_CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      if (! args_info->int_opt_given)
        {
          fprintf (stderr, "%s: '--int-opt' ('-i') option required%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
          error = 1;
        }
      if (! args_info->long_opt_given)
        {
          fprintf (stderr, "%s: '--long-opt' ('-l') option required%s\n", MY_CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
          error = 1;
        }
    }

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
  
      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ; 
    }
  
  return 0;

failure:
  my_cmdline_parser_free (&local_args_info);
  return (EXIT_FAILURE);
}
