// g++ 1.37.1 bug 900514_02

// g++ flags an error on the following legal code.

// In Section 12.3.2 it says "Defining conversion by both a constructor and
// a conversion function can lead to ambiguities."  However in the case below,
// the explicit cast syntax disambiguates the conversion as one which
// invokes the type conversion operator rather than the constructor.

// cfront 2.0 passes this test.

// keywords: user-defined type conversion operator, constructor

int converter_calls = 0;

struct st_0;

struct st_1 {
  int member;

  st_1 (st_0&);
  st_1 ();
};

st_1::st_1 ()
{
}

st_1::st_1 (st_0&)
{
}

struct st_0 {
  int member;

  operator st_1 ();
};

st_1 st_1_obj0;

st_0::operator st_1 ()
{
  converter_calls++;
  return st_1_obj0;
}

st_0 st_0_obj0;

int test ()
{
  st_1 st_1_local_obj0 = (st_1) st_0_obj0;  // gets bogus error

  return (converter_calls != 1);
}

int main () { return test (); }
