/*
  GNU Gama C++ library tests/statan
  Copyright (C) 2018  Ales Cepek <cepek@gnu.org>

  This file is part of the GNU Gama C++ library
  
  GNU Gama is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  GNU Gama is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Gama.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <iostream>
#include <vector>
#include <cmath>
#include "gnu_gama/statan.h"

using namespace GNU_gama;
using namespace std;

/*
  Testing data generated from the Octave script:

  % Kolmogorov-Smirnov cumulative distribution function

  N = 100;
  x = 1:3*N;

  c = kolmogorov_smirnov_cdf(x/N);

  printf('  std::vector<double> X = {\n');
  printf('    %6.3f,\n', x/N);
  printf('  };\n\n');

  printf('  std::vector<double> F = {\n');
  printf('    %20.16f,\n', c);
  printf('  };\n\n');

*/

int main()
{
  std::vector<double> X = {
     0.010,
     0.020,
     0.030,
     0.040,
     0.050,
     0.060,
     0.070,
     0.080,
     0.090,
     0.100,
     0.110,
     0.120,
     0.130,
     0.140,
     0.150,
     0.160,
     0.170,
     0.180,
     0.190,
     0.200,
     0.210,
     0.220,
     0.230,
     0.240,
     0.250,
     0.260,
     0.270,
     0.280,
     0.290,
     0.300,
     0.310,
     0.320,
     0.330,
     0.340,
     0.350,
     0.360,
     0.370,
     0.380,
     0.390,
     0.400,
     0.410,
     0.420,
     0.430,
     0.440,
     0.450,
     0.460,
     0.470,
     0.480,
     0.490,
     0.500,
     0.510,
     0.520,
     0.530,
     0.540,
     0.550,
     0.560,
     0.570,
     0.580,
     0.590,
     0.600,
     0.610,
     0.620,
     0.630,
     0.640,
     0.650,
     0.660,
     0.670,
     0.680,
     0.690,
     0.700,
     0.710,
     0.720,
     0.730,
     0.740,
     0.750,
     0.760,
     0.770,
     0.780,
     0.790,
     0.800,
     0.810,
     0.820,
     0.830,
     0.840,
     0.850,
     0.860,
     0.870,
     0.880,
     0.890,
     0.900,
     0.910,
     0.920,
     0.930,
     0.940,
     0.950,
     0.960,
     0.970,
     0.980,
     0.990,
     1.000,
     1.010,
     1.020,
     1.030,
     1.040,
     1.050,
     1.060,
     1.070,
     1.080,
     1.090,
     1.100,
     1.110,
     1.120,
     1.130,
     1.140,
     1.150,
     1.160,
     1.170,
     1.180,
     1.190,
     1.200,
     1.210,
     1.220,
     1.230,
     1.240,
     1.250,
     1.260,
     1.270,
     1.280,
     1.290,
     1.300,
     1.310,
     1.320,
     1.330,
     1.340,
     1.350,
     1.360,
     1.370,
     1.380,
     1.390,
     1.400,
     1.410,
     1.420,
     1.430,
     1.440,
     1.450,
     1.460,
     1.470,
     1.480,
     1.490,
     1.500,
     1.510,
     1.520,
     1.530,
     1.540,
     1.550,
     1.560,
     1.570,
     1.580,
     1.590,
     1.600,
     1.610,
     1.620,
     1.630,
     1.640,
     1.650,
     1.660,
     1.670,
     1.680,
     1.690,
     1.700,
     1.710,
     1.720,
     1.730,
     1.740,
     1.750,
     1.760,
     1.770,
     1.780,
     1.790,
     1.800,
     1.810,
     1.820,
     1.830,
     1.840,
     1.850,
     1.860,
     1.870,
     1.880,
     1.890,
     1.900,
     1.910,
     1.920,
     1.930,
     1.940,
     1.950,
     1.960,
     1.970,
     1.980,
     1.990,
     2.000,
     2.010,
     2.020,
     2.030,
     2.040,
     2.050,
     2.060,
     2.070,
     2.080,
     2.090,
     2.100,
     2.110,
     2.120,
     2.130,
     2.140,
     2.150,
     2.160,
     2.170,
     2.180,
     2.190,
     2.200,
     2.210,
     2.220,
     2.230,
     2.240,
     2.250,
     2.260,
     2.270,
     2.280,
     2.290,
     2.300,
     2.310,
     2.320,
     2.330,
     2.340,
     2.350,
     2.360,
     2.370,
     2.380,
     2.390,
     2.400,
     2.410,
     2.420,
     2.430,
     2.440,
     2.450,
     2.460,
     2.470,
     2.480,
     2.490,
     2.500,
     2.510,
     2.520,
     2.530,
     2.540,
     2.550,
     2.560,
     2.570,
     2.580,
     2.590,
     2.600,
     2.610,
     2.620,
     2.630,
     2.640,
     2.650,
     2.660,
     2.670,
     2.680,
     2.690,
     2.700,
     2.710,
     2.720,
     2.730,
     2.740,
     2.750,
     2.760,
     2.770,
     2.780,
     2.790,
     2.800,
     2.810,
     2.820,
     2.830,
     2.840,
     2.850,
     2.860,
     2.870,
     2.880,
     2.890,
     2.900,
     2.910,
     2.920,
     2.930,
     2.940,
     2.950,
     2.960,
     2.970,
     2.980,
     2.990,
     3.000,
  };

  std::vector<double> F = {
     -0.0000000000000002,
     -0.0000000000000007,
     -0.0000000000000007,
      0.0000000000000000,
     -0.0000000000000004,
      0.0000000000000003,
     -0.0000000000000002,
      0.0000000000000004,
      0.0000000000000003,
     -0.0000000000000009,
     -0.0000000000000002,
      0.0000000000000000,
      0.0000000000000001,
     -0.0000000000000004,
     -0.0000000000000004,
     -0.0000000000000004,
      0.0000000000000000,
      0.0000000000000006,
      0.0000000000000187,
      0.0000000000005052,
      0.0000000000084612,
      0.0000000000969703,
      0.0000000008109972,
      0.0000000052117123,
      0.0000000268238098,
      0.0000001143506816,
      0.0000004150287114,
      0.0000013118500100,
      0.0000036798638867,
      0.0000093058013345,
      0.0000214979429402,
      0.0000458798691124,
      0.0000913195321839,
      0.0001709051398499,
      0.0003028526297094,
      0.0005112230389244,
      0.0008263430341977,
      0.0012848541626136,
      0.0019293586152817,
      0.0028076732227018,
      0.0039717419633184,
      0.0054762857530424,
      0.0073772846259469,
      0.0097303918454438,
      0.0125893738470634,
      0.0160046569161170,
      0.0200220440648915,
      0.0246816463600168,
      0.0300170541057030,
      0.0360547563351249,
      0.0428138029189412,
      0.0503056926705223,
      0.0585344631213117,
      0.0674969528956592,
      0.0771832054108480,
      0.0875769824714370,
      0.0986563577168243,
      0.1103943623524432,
      0.1227596587441053,
      0.1357172209493956,
      0.1492290048401499,
      0.1632545939443841,
      0.1777518103723797,
      0.1926772831071908,
      0.2079869684910749,
      0.2236366199125360,
      0.2395822055016537,
      0.2557802740966107,
      0.2721882708834324,
      0.2887648049703109,
      0.3054698717755407,
      0.3222650335215252,
      0.3391135613717389,
      0.3559805428553221,
      0.3728329582237383,
      0.3896397293007148,
      0.4063717442418227,
      0.4230018614314098,
      0.4395048955269191,
      0.4558575884258019,
      0.4720385676876852,
      0.4880282947015028,
      0.5038090046494941,
      0.5193646400913112,
      0.5346807797748414,
      0.5497445640775661,
      0.5645446182944293,
      0.5790709748157754,
      0.5933149950819527,
      0.6072692920593457,
      0.6209276538553582,
      0.6342849689764843,
      0.6473371536332322,
      0.6600810814074335,
      0.6725145155204408,
      0.6846360438739461,
      0.6964450169777803,
      0.7079414888301412,
      0.7191261607744510,
      0.7300003283226455,
      0.7405658309064025,
      0.7508250044949375,
      0.7607806369998660,
      0.7704359263736811,
      0.7797944412980498,
      0.7888600843509027,
      0.7976370575367279,
      0.8061298300621494,
      0.8143431082384267,
      0.8222818073935988,
      0.8299510256793350,
      0.8373560196608747,
      0.8445021815825131,
      0.8513950182057211,
      0.8580401311219992,
      0.8644431984478214,
      0.8706099578143811,
      0.8765461905702343,
      0.8822577071202283,
      0.8877503333292750,
      0.8930298979244866,
      0.8981022208339364,
      0.9029731024047791,
      0.9076483134476674,
      0.9121335860583090,
      0.9164346051706320,
      0.9205570007993525,
      0.9245063409327896,
      0.9282881250395512,
      0.9319077781552336,
      0.9353706455175534,
      0.9386819877203854,
      0.9418469763590211,
      0.9448706901406196,
      0.9477581114352954,
      0.9505141232446221,
      0.9531435065655094,
      0.9556509381284765,
      0.9580409884903018,
      0.9603181204618856,
      0.9624866878529452,
      0.9645509345158719,
      0.9665149936717269,
      0.9683828875019569,
      0.9701585269899706,
      0.9718457119972405,
      0.9734481315590952,
      0.9749693643858435,
      0.9764128795553310,
      0.9777820373834749,
      0.9790800904597612,
      0.9803101848351146,
      0.9814753613499761,
      0.9825785570908445,
      0.9836226069639508,
      0.9846102453751553,
      0.9855441080055680,
      0.9864267336728061,
      0.9872605662682170,
      0.9880479567608034,
      0.9887911652589971,
      0.9894923631218381,
      0.9901536351115134,
      0.9907769815796212,
      0.9913643206799121,
      0.9919174906006621,
      0.9924382518102129,
      0.9929282893095985,
      0.9933892148865523,
      0.9938225693655559,
      0.9942298248489491,
      0.9946123869444733,
      0.9949715969749602,
      0.9953087341662101,
      0.9956250178094289,
      0.9959216093948986,
      0.9961996147138641,
      0.9964600859259026,
      0.9967040235893245,
      0.9969323786524203,
      0.9971460544036231,
      0.9973459083789015,
      0.9975327542249283,
      0.9977073635167933,
      0.9978704675292348,
      0.9980227589605634,
      0.9981648936086381,
      0.9982974919984292,
      0.9984211409608644,
      0.9985363951628127,
      0.9986437785881960,
      0.9987437859703583,
      0.9988368841759372,
      0.9989235135406014,
      0.9990040891571165,
      0.9990790021162979,
      0.9991486207014941,
      0.9992132915373217,
      0.9992733406934402,
      0.9993290747442203,
      0.9993807817852093,
      0.9994287324073470,
      0.9994731806299261,
      0.9995143647933237,
      0.9995525084125638,
      0.9995878209927871,
      0.9996204988077300,
      0.9996507256423223,
      0.9996786735005257,
      0.9997045032795369,
      0.9997283654114831,
      0.9997504004737336,
      0.9997707397689435,
      0.9997895058759412,
      0.9998068131725558,
      0.9998227683314680,
      0.9998374707901525,
      0.9998510131959615,
      0.9998634818273783,
      0.9998749569924504,
      0.9998855134053870,
      0.9998952205422829,
      0.9999041429769060,
      0.9999123406974610,
      0.9999198694052142,
      0.9999267807958362,
      0.9999331228242996,
      0.9999389399541306,
      0.9999442733917949,
      0.9999491613069676,
      0.9999536390394084,
      0.9999577392931391,
      0.9999614923185904,
      0.9999649260833611,
      0.9999680664322044,
      0.9999709372368327,
      0.9999735605361042,
      0.9999759566671312,
      0.9999781443878283,
      0.9999801409913883,
      0.9999819624131596,
      0.9999836233303689,
      0.9999851372551158,
      0.9999865166210432,
      0.9999877728640673,
      0.9999889164975327,
      0.9999899571821370,
      0.9999909037909527,
      0.9999917644698557,
      0.9999925466936559,
      0.9999932573182030,
      0.9999939026287327,
      0.9999944883846976,
      0.9999950198613176,
      0.9999955018880660,
      0.9999959388843012,
      0.9999963348922357,
      0.9999966936074252,
      0.9999970184069491,
      0.9999973123754448,
      0.9999975783291435,
      0.9999978188380519,
      0.9999980362464104,
      0.9999982326915517,
      0.9999984101212769,
      0.9999985703098556,
      0.9999987148727528,
      0.9999988452801754,
      0.9999989628695276,
      0.9999990688568569,
      0.9999991643473657,
      0.9999992503450623,
      0.9999993277616148,
      0.9999993974244706,
      0.9999994600842993,
      0.9999995164218105,
      0.9999995670539963,
      0.9999996125398450,
      0.9999996533855672,
      0.9999996900493728,
      0.9999997229458381,
      0.9999997524498921,
      0.9999997789004578,
      0.9999998026037722,
      0.9999998238364161,
      0.9999998428480742,
      0.9999998598640507,
      0.9999998750875593,
      0.9999998887018076,
      0.9999999008718936,
      0.9999999117465298,
      0.9999999214596098,
      0.9999999301316318,
      0.9999999378709907,
      0.9999999447751509,
      0.9999999509317092,
      0.9999999564193599,
      0.9999999613087678,
      0.9999999656633596,
      0.9999999695400406,
  };

  double maxc = 0, sumc = 0, diffc {};
  for (std::size_t i=0; i<F.size(); i++) {
    double x = X[i];
    diffc = KSprob(x) - F[i];
    sumc += diffc;
    if (abs(diffc) > abs(maxc)) maxc = diffc;
  }
  sumc /= F.size();

  cout << "Kolmogorov Smirnov - cumulative distribution function\n" << endl;
  cout << "diff max = " << maxc << "  avg = " << sumc << "\n\n";

  return abs(maxc) < 1e-12 ? 0 : 1;
}
