#!/bin/sh
#
# first-time-run.sh: prepare ~/.freetalk directory
# Copyright (c) 2005-2014 Freetalk Core Team
# This file is part of GNU Freetalk.
#
# Freetalk is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Freetalk is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see
# <http://www.gnu.org/licenses/>.

_init ()
{
    [ -z "${HOME}" ] && {
	echo "FATAL: \$HOME environment variable not present" >&2;
	return 1;
    }
    CONFIG_BASE="${HOME}/.freetalk";
    return 0;
}

normal ()
{
    [ -d "${CONFIG_BASE}" ] && return 0;
    echo "Welcome to freetalk! Running for the first time?";
    echo "Performing some one-time initializations ... ";
    mkdir -p "${CONFIG_BASE}" || {
	echo "FATAL: Could not create ${HOME}/.freetalk directory" >&2;
	return 1;
    }
    cat >> "${CONFIG_BASE}/freetalk.scm" <<EOF
; (ft-set-jid! "yourid@jabber.org")
; (ft-set-server! "talk.jabber.org")
; (ft-set-password! "p455w0rd")
; (ft-set-sslconn! #t)
; (ft-set-tlsconn! #t)
; (ft-set-proxy! #f)
; (ft-set-port! 5223)
; (add-hook! ft-login-hook
;            (lambda (status)
;              (if status
;                  (begin
;                    (ft-set-prompt! "~\\\/~ ")
;                    (ft-set-status-msg! "chat I use GNU Freetalk")))))
;;;
;;; Let ctrl-a display full roster, ctrl-e who i am, ctrl-h online buddies
; (ft-bind-to-ctrl-key #\a "(/who \"all\")")
; (ft-bind-to-ctrl-key #\e "(/whoami \"\")")
; (ft-bind-to-ctrl-key #\h "(/who \"\")")
; (ft-bind-to-ctrl-key #\x "(/next \"\")")
EOF
    mkdir -p "${CONFIG_BASE}/extensions";
    mkdir -p "${CONFIG_BASE}/history";
}

reset ()
{
    BACKUP=0;

    while [ -d "${HOME}/.freetalk-backup-${BACKUP}" ]
    do
      BACKUP=$((${BACKUP} + 1 ));
    done

    mv -v "${HOME}/.freetalk" "${HOME}/.freetalk-backup-${BACKUP}";
    echo "Creating fresh state ${HOME}/.freetalk";
    normal >/dev/null;

    printf "\nNOTE: Archived previous state to ${HOME}/.freetalk-backup-${BACKUP} !!!\n";
}

main ()
{
    local FUNC;

    [ -z "$1" ] && FUNC=normal;
    [ "$1" = "reset" ] && FUNC=reset;

    ${FUNC};
}
_init "$@" && main "$@"
