/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Iterator;
import java.util.Set;

public class StratPartPopularity
extends Strategy {
    private static final int COUNT_OFFSET = 1000;
    private Set<Part> forcedMatchParts;

    private StratPartPopularity(Set<Part> forcedMatchParts, NccGlobals globals) {
        super(globals);
        this.forcedMatchParts = forcedMatchParts;
    }

    private LeafList doYourJob2() {
        EquivRecord parts = this.globals.getParts();
        LeafList offspring = this.doFor(parts);
        this.setReasons(offspring);
        this.summary(offspring);
        return offspring;
    }

    private void setReasons(LeafList offspring) {
        Iterator<EquivRecord> it = offspring.iterator();
        while (it.hasNext()) {
            EquivRecord r = it.next();
            int value = r.getValue();
            String reason = "part has " + (value - 1000) + " different Wires attached";
            this.globals.status2(reason);
            r.setPartitionReason(reason);
        }
    }

    private void summary(LeafList offspring) {
        this.globals.status2("StratPartPopularity produced " + offspring.size() + " offspring");
        if (offspring.size() != 0) {
            this.globals.status2(offspring.sizeInfoString());
            this.globals.status2(this.offspringStats(offspring));
        }
    }

    @Override
    public Integer doFor(NetObject n) {
        this.error(!(n instanceof Part), "StratPartPopularity expects only Parts");
        Part p = (Part)n;
        return this.forcedMatchParts.contains(p) ? 0 : 1000 + p.numDistinctWires();
    }

    public static LeafList doYourJob(Set<Part> forcedMatchParts, NccGlobals globals) {
        StratPartPopularity pow = new StratPartPopularity(forcedMatchParts, globals);
        return pow.doYourJob2();
    }
}

