/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic1.g1;

import com.sun.electric.tool.placement.genetic1.Chromosome;
import com.sun.electric.tool.placement.genetic1.ChromosomeMutation;
import com.sun.electric.tool.placement.genetic1.Population;
import com.sun.electric.tool.placement.genetic1.PopulationMutation;
import com.sun.electric.tool.placement.genetic1.g1.ChromosomeMutationPadding;
import com.sun.electric.tool.placement.genetic1.g1.ChromsomeMutationMoveCells;
import com.sun.electric.tool.placement.genetic1.g1.ChromsomeMutationRotateCells;
import com.sun.electric.tool.placement.genetic1.g1.ChromsomeMutationSwapCells;
import java.util.ArrayList;
import java.util.List;

public class PopulationMutation2
implements PopulationMutation {
    public static final double MUTATION_RATE_LOWER = 0.004;
    public static final double MUTATION_RATE_INCREASE = 0.05;
    static double chromosomeSwapRate = 0.05;
    static final double geneSwapRate_START = 0.001;
    static final double geneSwapRate_STEP = 0.5;
    static double geneSwapRate_current;
    static double chromsomeRotationRate;
    static final double geneRotationRate_START = 0.001;
    static final double geneRotationRate_STEP = 0.5;
    static double geneRotationRate_current;
    static double chromosomeMoveRate;
    static double geneMoveRate_START;
    static double geneMoveRate_STEP;
    static double geneMoveRate_current;
    static double geneMoveDistance;
    static double chromosomeAlterPaddingRate;
    static final double genePaddingChangeRate_START = 0.001;
    static final double genePaddingChangeRate_STEP = 0.5;
    static double genePaddingChangeRate_current;
    static short chrosomeMaxPaddingChangeStep;
    static ChromosomeMutation swapCellsMutation;
    static ChromosomeMutation rotateCellsMutation;
    static ChromosomeMutation moveCellsMutation;
    static ChromosomeMutation changePaddingMutation;
    static int chromosomeSize;

    public PopulationMutation2(int chromosomesize) {
        chromosomeSize = chromosomesize;
        chrosomeMaxPaddingChangeStep = (short)10;
        swapCellsMutation = new ChromsomeMutationSwapCells();
        rotateCellsMutation = new ChromsomeMutationRotateCells();
        moveCellsMutation = new ChromsomeMutationMoveCells();
        changePaddingMutation = new ChromosomeMutationPadding(chrosomeMaxPaddingChangeStep);
        PopulationMutation2.resetMutationRates();
    }

    public static void resetMutationRates() {
        geneSwapRate_current = 0.001;
        geneRotationRate_current = 0.001;
        geneMoveRate_current = geneMoveRate_START;
        genePaddingChangeRate_current = 0.001;
        PopulationMutation2.applyMutationRates();
    }

    public static void increaseMutationRate() {
        geneSwapRate_current /= 0.5;
        geneRotationRate_current /= 0.5;
        geneMoveRate_current /= geneMoveRate_STEP;
        genePaddingChangeRate_current /= 0.5;
        PopulationMutation2.applyMutationRates();
    }

    public static void lowerMutationRate() {
        geneSwapRate_current *= 0.5;
        geneRotationRate_current *= 0.5;
        geneMoveRate_current *= geneMoveRate_STEP;
        genePaddingChangeRate_current *= 0.5;
        PopulationMutation2.applyMutationRates();
    }

    static void applyMutationRates() {
        swapCellsMutation.setMutationRate(geneSwapRate_current);
        rotateCellsMutation.setMutationRate(geneRotationRate_current);
        moveCellsMutation.setMutationRate(geneMoveRate_current);
        ((ChromsomeMutationMoveCells)moveCellsMutation).setGeneMoveDitance(geneMoveDistance, chromosomeSize);
        changePaddingMutation.setMutationRate(genePaddingChangeRate_current);
    }

    @Override
    public void mutate(Population p) {
        this.swapGene(p);
        this.rotateGenes(p);
        this.moveGenes(p);
        this.alterPadding(p);
    }

    private void alterPadding(Population p) {
        List<Chromosome> chromosome2Mutate = this.selectChromosome2Mutate(chromosomeAlterPaddingRate, p);
        for (Chromosome c : chromosome2Mutate) {
            changePaddingMutation.mutate(c, p.getRandomGenerator());
            c.altered = true;
            assert (c.isIndex2GenePosValid());
        }
        p.chromosomes.addAll(chromosome2Mutate);
    }

    private void moveGenes(Population p) {
        List<Chromosome> chromosome2Mutate = this.selectChromosome2Mutate(chromosomeMoveRate, p);
        for (Chromosome c : chromosome2Mutate) {
            moveCellsMutation.mutate(c, p.getRandomGenerator());
            c.altered = true;
            assert (c.isIndex2GenePosValid());
        }
        p.chromosomes.addAll(chromosome2Mutate);
    }

    private void rotateGenes(Population p) {
        List<Chromosome> chromosome2Mutate = this.selectChromosome2Mutate(chromsomeRotationRate, p);
        for (Chromosome c : chromosome2Mutate) {
            rotateCellsMutation.mutate(c, p.getRandomGenerator());
            c.altered = true;
            assert (c.isIndex2GenePosValid());
        }
        p.chromosomes.addAll(chromosome2Mutate);
    }

    private void swapGene(Population p) {
        List<Chromosome> chromosome2Mutate = this.selectChromosome2Mutate(chromosomeSwapRate, p);
        for (Chromosome c : chromosome2Mutate) {
            swapCellsMutation.mutate(c, p.getRandomGenerator());
            c.altered = true;
            assert (c.isIndex2GenePosValid());
        }
        p.chromosomes.addAll(chromosome2Mutate);
    }

    private List<Chromosome> selectChromosome2Mutate(double mutationRate, Population p) {
        ArrayList<Chromosome> chromosmes2mutate = new ArrayList<Chromosome>((int)((double)p.chromosomes.size() * mutationRate));
        while ((double)chromosmes2mutate.size() < (double)p.chromosomes.size() * mutationRate) {
            Chromosome c = p.chromosomes.get(p.getRandomGenerator().nextInt(p.chromosomes.size()));
            if (chromosmes2mutate.contains(c)) continue;
            chromosmes2mutate.add(c);
        }
        for (int i = 0; i < chromosmes2mutate.size(); ++i) {
            chromosmes2mutate.set(i, ((Chromosome)chromosmes2mutate.get(i)).clone());
        }
        return chromosmes2mutate;
    }

    static {
        chromsomeRotationRate = 0.05;
        chromosomeMoveRate = 0.1;
        geneMoveRate_START = 0.001;
        geneMoveRate_STEP = 0.5;
        geneMoveDistance = 0.001;
        chromosomeAlterPaddingRate = 0.05;
        chrosomeMaxPaddingChangeStep = (short)5;
    }
}

