/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class EDIFTab
extends PreferencePanel {
    private JTextArea textArea;
    private JScrollPane acceptedParamPane;
    private JPanel acceptedParameters;
    private JRadioButton allParameters;
    private ButtonGroup buttonGroup1;
    private JPanel configFile;
    private JPanel edif;
    private JButton edifBrowse;
    private JCheckBox edifCadenceCompatibility;
    private JTextField edifConfigFile;
    private JCheckBox edifImportStitchesCells;
    private JTextField edifInputScale;
    private JCheckBox edifShowArcNames;
    private JCheckBox edifShowNodeNames;
    private JCheckBox edifUseSchematicView;
    private JLabel jLabel1;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JRadioButton selectParameters;

    public EDIFTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.textArea = new JTextArea();
        this.acceptedParamPane.setViewportView(this.textArea);
        EDialog.makeTextFieldSelectAllOnTab(this.edifInputScale);
        EDialog.makeTextFieldSelectAllOnTab(this.edifConfigFile);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.edif;
    }

    @Override
    public String getName() {
        return "EDIF";
    }

    @Override
    public void init() {
        this.edifUseSchematicView.setSelected(IOTool.isEDIFUseSchematicView());
        this.edifInputScale.setText(TextUtils.formatDouble(IOTool.getEDIFInputScale()));
        this.edifImportStitchesCells.setSelected(IOTool.isEDIFImportStitchesCells());
        this.edifCadenceCompatibility.setSelected(IOTool.isEDIFCadenceCompatibility());
        this.edifShowArcNames.setSelected(IOTool.isEDIFShowArcNames());
        this.edifShowNodeNames.setSelected(IOTool.isEDIFShowNodeNames());
        this.edifConfigFile.setText(IOTool.getEDIFConfigurationFile());
        String ap = IOTool.getEDIFAcceptedParameters();
        String[] params = ap.split("/");
        this.textArea.removeAll();
        for (int i = 0; i < params.length; ++i) {
            this.textArea.append(params[i] + "\n");
        }
        if (IOTool.isEDIFImportAllParameters()) {
            this.allParameters.setSelected(true);
        } else {
            this.selectParameters.setSelected(true);
        }
    }

    @Override
    public void term() {
        String currentConfigFile;
        double currentInputScale;
        boolean currentBoolean = this.edifUseSchematicView.isSelected();
        if (currentBoolean != IOTool.isEDIFUseSchematicView()) {
            IOTool.setEDIFUseSchematicView(currentBoolean);
        }
        if ((currentInputScale = TextUtils.atof(this.edifInputScale.getText())) != IOTool.getEDIFInputScale()) {
            IOTool.setEDIFInputScale(currentInputScale);
        }
        if ((currentBoolean = this.edifImportStitchesCells.isSelected()) != IOTool.isEDIFImportStitchesCells()) {
            IOTool.setEDIFImportStitchesCells(currentBoolean);
        }
        if ((currentBoolean = this.edifCadenceCompatibility.isSelected()) != IOTool.isEDIFCadenceCompatibility()) {
            IOTool.setEDIFCadenceCompatibility(currentBoolean);
        }
        if ((currentBoolean = this.edifShowArcNames.isSelected()) != IOTool.isEDIFShowArcNames()) {
            IOTool.setEDIFShowArcNames(currentBoolean);
        }
        if ((currentBoolean = this.edifShowNodeNames.isSelected()) != IOTool.isEDIFShowNodeNames()) {
            IOTool.setEDIFShowNodeNames(currentBoolean);
        }
        if (!(currentConfigFile = this.edifConfigFile.getText()).equals(IOTool.getEDIFConfigurationFile())) {
            IOTool.setEDIFConfigurationFile(currentConfigFile);
        }
        StringBuffer ap = new StringBuffer();
        String allAP = this.textArea.getText();
        String[] params = allAP.split("\n");
        for (int i = 0; i < params.length; ++i) {
            String paramName = params[i].trim();
            if (paramName.length() == 0) continue;
            if (ap.length() > 0) {
                ap.append("/");
            }
            ap.append(paramName);
        }
        String currentAcceptedParams = ap.toString();
        if (!currentAcceptedParams.equals(IOTool.getEDIFAcceptedParameters())) {
            IOTool.setEDIFAcceptedParameters(currentAcceptedParams);
        }
        if ((currentBoolean = this.allParameters.isSelected()) != IOTool.isEDIFImportAllParameters()) {
            IOTool.setEDIFImportAllParameters(currentBoolean);
        }
    }

    @Override
    public void reset() {
        if (IOTool.isFactoryEDIFUseSchematicView() != IOTool.isEDIFUseSchematicView()) {
            IOTool.setEDIFUseSchematicView(IOTool.isFactoryEDIFUseSchematicView());
        }
        if (IOTool.getFactoryEDIFInputScale() != IOTool.getEDIFInputScale()) {
            IOTool.setEDIFInputScale(IOTool.getFactoryEDIFInputScale());
        }
        if (IOTool.isFactoryEDIFImportStitchesCells() != IOTool.isEDIFImportStitchesCells()) {
            IOTool.setEDIFImportStitchesCells(IOTool.isFactoryEDIFImportStitchesCells());
        }
        if (IOTool.isFactoryEDIFCadenceCompatibility() != IOTool.isEDIFCadenceCompatibility()) {
            IOTool.setEDIFCadenceCompatibility(IOTool.isFactoryEDIFCadenceCompatibility());
        }
        if (IOTool.isFactoryEDIFShowArcNames() != IOTool.isEDIFShowArcNames()) {
            IOTool.setEDIFShowArcNames(IOTool.isFactoryEDIFShowArcNames());
        }
        if (IOTool.isFactoryEDIFShowNodeNames() != IOTool.isEDIFShowNodeNames()) {
            IOTool.setEDIFShowNodeNames(IOTool.isFactoryEDIFShowNodeNames());
        }
        if (!IOTool.getFactoryEDIFConfigurationFile().equals(IOTool.getEDIFConfigurationFile())) {
            IOTool.setEDIFConfigurationFile(IOTool.getFactoryEDIFConfigurationFile());
        }
        if (!IOTool.getFactoryEDIFAcceptedParameters().equals(IOTool.getEDIFAcceptedParameters())) {
            IOTool.setEDIFAcceptedParameters(IOTool.getFactoryEDIFAcceptedParameters());
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.edif = new JPanel();
        this.edifUseSchematicView = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.edifInputScale = new JTextField();
        this.edifCadenceCompatibility = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.configFile = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.edifConfigFile = new JTextField();
        this.edifBrowse = new JButton();
        this.acceptedParameters = new JPanel();
        this.selectParameters = new JRadioButton();
        this.allParameters = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.acceptedParamPane = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.jLabel5 = new JLabel();
        this.edifShowArcNames = new JCheckBox();
        this.edifShowNodeNames = new JCheckBox();
        this.edifImportStitchesCells = new JCheckBox();
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EDIFTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.edif.setLayout(new GridBagLayout());
        this.edifUseSchematicView.setText("Use Schematic View when writing");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.edif.add((Component)this.edifUseSchematicView, gridBagConstraints);
        this.jLabel13.setText("Scale by:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.edif.add((Component)this.jLabel13, gridBagConstraints);
        this.edifInputScale.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.edif.add((Component)this.edifInputScale, gridBagConstraints);
        this.edifCadenceCompatibility.setText("Cadence compatibility");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.edif.add((Component)this.edifCadenceCompatibility, gridBagConstraints);
        this.jLabel4.setText("when reading");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.edif.add((Component)this.jLabel4, gridBagConstraints);
        this.configFile.setBorder(BorderFactory.createTitledBorder("Configuration File"));
        this.configFile.setLayout(new GridBagLayout());
        this.jLabel3.setText("EDIF reading and writing.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.configFile.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel2.setText("The configuration file provides overrides for controlling");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.configFile.add((Component)this.jLabel2, gridBagConstraints);
        this.edifConfigFile.setMinimumSize(new Dimension(200, 20));
        this.edifConfigFile.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.configFile.add((Component)this.edifConfigFile, gridBagConstraints);
        this.edifBrowse.setText("Browse...");
        this.edifBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EDIFTab.this.edifBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.configFile.add((Component)this.edifBrowse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.edif.add((Component)this.configFile, gridBagConstraints);
        this.acceptedParameters.setBorder(BorderFactory.createTitledBorder("Accepted Parameters"));
        this.acceptedParameters.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.selectParameters);
        this.selectParameters.setText("Parameters List");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.acceptedParameters.add((Component)this.selectParameters, gridBagConstraints);
        this.buttonGroup1.add(this.allParameters);
        this.allParameters.setText("All Parameters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.acceptedParameters.add((Component)this.allParameters, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.acceptedParamPane.setMinimumSize(new Dimension(150, 100));
        this.acceptedParamPane.setPreferredSize(new Dimension(150, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.jPanel1.add((Component)this.acceptedParamPane, gridBagConstraints);
        this.jLabel1.setText("Type parameter names (one per line)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel5.setText("that will be placed on nodes when reading EDIF");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 4, 0);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.acceptedParameters.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.edif.add((Component)this.acceptedParameters, gridBagConstraints);
        this.edifShowArcNames.setText("Show arc names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.edif.add((Component)this.edifShowArcNames, gridBagConstraints);
        this.edifShowNodeNames.setText("Show node names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.edif.add((Component)this.edifShowNodeNames, gridBagConstraints);
        this.edifImportStitchesCells.setText("Stitch cells when reading");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.edif.add((Component)this.edifImportStitchesCells, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.edif, gridBagConstraints);
        this.pack();
    }

    private void edifBrowseActionPerformed(ActionEvent evt) {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, null, null);
        if (fileName == null) {
            return;
        }
        this.edifConfigFile.setText(fileName);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

