/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Equipment;
import com.sun.electric.tool.simulation.test.Infrastructure;

class Agilent34970A
extends Equipment {
    public static final float MAX_AMPS = 3.0f;
    int lastChannel = -1;
    static final int CHANNEL_UNDEFINED = -1;

    public Agilent34970A(String name) {
        super(name);
    }

    public void reset() {
        this.write("*RST; *CLS");
    }

    public void selfTest() {
        System.out.println("Initiating self-test, please wait...");
        this.write("*TST?");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException _) {
            // empty catch block
        }
        String s = this.read(40);
        System.out.println("Self-test output: " + s);
    }

    public void display(String text2) {
        this.write("DISPLAY:TEXT '" + text2 + "'");
    }

    public void clearDisplay() {
        this.write("DISPLAY:TEXT:CLEAR");
    }

    public float readVoltage(int channel) {
        this.write("MEASURE:VOLTAGE:DC? (@" + channel + ")");
        String s = this.read(20);
        if (s.length() == 0) {
            this.handleError();
            Infrastructure.fatal("failed to read voltage on channel " + channel);
        }
        return Float.parseFloat(s);
    }

    String readError() {
        this.write("SYSTEM:ERROR?");
        String error = this.read(80);
        return error;
    }

    void handleError() {
        String error = this.readError();
        do {
            if (error.length() <= 0) {
                Infrastructure.fatal("No reply from Agilent34970A named " + this.toString());
            }
            Infrastructure.nonfatal("Agilent34970 named " + this.toString() + " reports error " + error);
        } while (!(error = this.readError()).equals("+0,\"No error\""));
    }

    public static void main(String[] args) {
        Agilent34970A dvm = new Agilent34970A("HP34970");
        dvm.reset();
        for (int channel = 101; channel < 120; ++channel) {
            float volts = dvm.readVoltage(channel);
            System.out.println(channel + ": " + volts + " V");
        }
    }
}

