/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.AbstractUserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.redisplay.VectorCache;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TechPalette;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioSystem;
import javax.swing.SwingUtilities;

public class User
extends Listener {
    private static User tool = new User();
    public static final Variable.Key FRAME_SIZE = Variable.newKey("FACET_schematic_page_size");
    public static final Variable.Key FRAME_COMPANY_NAME = Variable.newKey("USER_drawing_company_name");
    public static final Variable.Key FRAME_DESIGNER_NAME = Variable.newKey("USER_drawing_designer_name");
    public static final Variable.Key FRAME_LAST_CHANGED_BY = Variable.newKey("USER_drawing_last_changed_by");
    public static final Variable.Key FRAME_PROJECT_NAME = Variable.newKey("USER_drawing_project_name");
    private ArcProto currentArcProto = null;
    private Technology currentTech = null;
    private Map<String, PrimitivePort> preferredContactPortProtoMap = new HashMap<String, PrimitivePort>();
    private Map<String, List<PrimitivePort>> equivalentPortProtoMap = new HashMap<String, List<PrimitivePort>>();
    private static Map<EditWindow, Rectangle2D> changedWindowRects = new HashMap<EditWindow, Rectangle2D>();
    private Map<String, Pref> contactNodeProtoMap = new HashMap<String, Pref>();
    private static AudioClip clickSound = null;
    private static boolean hasSound = true;
    private static Pref cacheIconGenInputSide = Pref.makeIntPref("IconGenInputSide", User.tool.prefs, 0);
    private static Pref cacheIconGenOutputSide = Pref.makeIntPref("IconGenOutputSide", User.tool.prefs, 1);
    private static Pref cacheIconGenBidirSide = Pref.makeIntPref("IconGenBidirSide", User.tool.prefs, 2);
    private static Pref cacheIconGenPowerSide = Pref.makeIntPref("IconGenPowerSide", User.tool.prefs, 3);
    private static Pref cacheIconGenGroundSide = Pref.makeIntPref("IconGenGroundSide", User.tool.prefs, 3);
    private static Pref cacheIconGenClockSide = Pref.makeIntPref("IconGenClockSide", User.tool.prefs, 0);
    private static Pref cacheIconGenTopRot = Pref.makeIntPref("IconGenTopRot", User.tool.prefs, 0);
    private static Pref cacheIconGenBottomRot = Pref.makeIntPref("IconGenBottomRot", User.tool.prefs, 0);
    private static Pref cacheIconGenLeftRot = Pref.makeIntPref("IconGenLeftRot", User.tool.prefs, 0);
    private static Pref cacheIconGenRightRot = Pref.makeIntPref("IconGenRightRot", User.tool.prefs, 0);
    private static Pref cacheMoveNodeWithExport = Pref.makeBooleanPref("MoveNodeWithExport", User.tool.prefs, false);
    private static Pref cacheEasySelectionOfCellInstances = Pref.makeBooleanPref("EasySelectionOfCellInstances", User.tool.prefs, true);
    private static Pref cacheDraggingMustEncloseObjects = Pref.makeBooleanPref("DraggingMustEncloseObjects", User.tool.prefs, false);
    private static Pref cacheMouseOverHighlighting = Pref.makeBooleanPref("UseMouseOverHighlighting", User.tool.prefs, true);
    private static Pref cacheHighlightConnectedObjects = Pref.makeBooleanPref("HighlightConnectedObjects", User.tool.prefs, true);
    private static Pref cacheHighlightInvisibleObjects = Pref.makeBooleanPref("HighlightInvisibleObjects", User.tool.prefs, false);
    private static Pref cacheRoutingMode = Pref.makeBooleanPref("RoutingMode", User.tool.prefs, false);
    private static Pref cacheDefGridXSpacing = Pref.makeDoublePref("DefGridXSpacing", User.tool.prefs, 1.0);
    private static Pref cacheDefGridYSpacing = Pref.makeDoublePref("DefGridYSpacing", User.tool.prefs, 1.0);
    private static Pref cacheDefGridXBoldFrequency = Pref.makeIntPref("DefGridXBoldFrequency", User.tool.prefs, 10);
    private static Pref cacheDefGridYBoldFrequency = Pref.makeIntPref("DefGridYBoldFrequency", User.tool.prefs, 10);
    private static Pref cacheGridAlignMeasurementCursor = Pref.makeBooleanPref("GridAlignMeasurementCursor", User.tool.prefs, false);
    private static Pref cacheShowGridAxes = Pref.makeBooleanPref("ShowGridAxes", User.tool.prefs, false);
    private static Pref cacheDefaultTextCellFont = Pref.makeStringPref("DefaultTextCellFont", User.tool.prefs, "SansSerif");
    private static Pref cacheDefaultTextCellSize = Pref.makeIntPref("DefaultTextCellSize", User.tool.prefs, 12);
    private static Pref cacheGlobalTextScale = Pref.makeDoublePref("TextGlobalScale", User.tool.prefs, 1.0);
    private static Pref cacheDefaultTextExternalEditor = Pref.makeStringPref("DefaultTextExternalEditor", User.tool.prefs, "");
    private static Pref cacheFrameCompanyName = Pref.makeStringPref("FrameCompanyName", User.tool.prefs, "");
    private static Pref cacheFrameDesignerName = Pref.makeStringPref("FrameDesignerName", User.tool.prefs, "");
    private static Pref cacheFrameProjectName = Pref.makeStringPref("FrameProjectName", User.tool.prefs, "");
    private static Pref cacheDistanceUnits = Pref.makeIntServerPref("DistanceUnit", User.tool.prefs, -1);
    private static Pref cacheResistanceUnits = Pref.makeIntPref("ResistanceUnits", User.tool.prefs, TextUtils.UnitScale.NONE.getIndex());
    private static Pref cacheCapacitanceUnits = Pref.makeIntPref("CapacitanceUnits", User.tool.prefs, TextUtils.UnitScale.PICO.getIndex());
    private static Pref cacheInductanceUnits = Pref.makeIntPref("InductanceUnits", User.tool.prefs, TextUtils.UnitScale.NANO.getIndex());
    private static Pref cacheAmperageUnits = Pref.makeIntPref("AmperageUnits", User.tool.prefs, TextUtils.UnitScale.MILLI.getIndex());
    private static Pref cacheVoltageUnits = Pref.makeIntPref("VoltageUnits", User.tool.prefs, TextUtils.UnitScale.NONE.getIndex());
    private static Pref cacheTimeUnits = Pref.makeIntPref("TimeUnits", User.tool.prefs, TextUtils.UnitScale.NONE.getIndex());
    private static Pref cacheWorkingDirectory = Pref.makeStringPref("WorkingDirectory", User.tool.prefs, System.getProperty("user.dir"));
    private static Pref cacheRegressionPath = Pref.makeStringPref("Regression Path", User.getUserTool().prefs, "<set me up>");
    private static Pref cacheRecentlyOpenedLibraries = Pref.makeStringPref("RecentlyOpenedLibraries", User.tool.prefs, "");
    private static Pref cachePromptForIndexWhenDescending = Pref.makeBooleanPref("PromptForIndexWhenDescending", User.tool.prefs, false);
    private static Pref cacheBeepAfterLongJobs = Pref.makeBooleanPref("BeepAfterLongJobs", User.tool.prefs, false);
    private static Pref cacheJobVerboseMode = Pref.makeBooleanPref("JobVerboseMode", User.tool.prefs, false);
    private static Pref cacheRotateLayoutTransistors = Pref.makeBooleanPref("RotateLayoutTransistors", User.tool.prefs, false);
    private static Pref cacheSideBarOnRight = Pref.makeBooleanPref("SideBarOnRight", User.tool.prefs, false);
    private static Pref cacheDefaultWindowTab = Pref.makeIntPref("DefaultWindowTab", User.tool.prefs, 0);
    private static Pref cacheDefaultWindowXPos = Pref.makeIntPref("DefaultWindowXPos", User.tool.prefs, 0);
    private static Pref cacheDefaultWindowYPos = Pref.makeIntPref("DefaultWindowYPos", User.tool.prefs, 0);
    private static Pref cacheDefaultWindowXSize = Pref.makeIntPref("DefaultWindowXSize", User.tool.prefs, 0);
    private static Pref cacheDefaultWindowYSize = Pref.makeIntPref("DefaultWindowYSize", User.tool.prefs, 0);
    private static Pref cacheDefaultMessagesXPos = Pref.makeIntPref("DefaultMessagesXPos", User.tool.prefs, -1);
    private static Pref cacheDefaultMessagesYPos = Pref.makeIntPref("DefaultMessagesYPos", User.tool.prefs, -1);
    private static Pref cacheDefaultMessagesXSize = Pref.makeIntPref("DefaultMessagesXSize", User.tool.prefs, 0);
    private static Pref cacheDefaultMessagesYSize = Pref.makeIntPref("DefaultMessagesYSize", User.tool.prefs, 0);
    private static Pref cachePlayClickSoundsWhenCreatingArcs = Pref.makeBooleanServerPref("PlayClickSoundsWhenCreatingArcs", User.tool.prefs, true);
    private static Pref cacheShowHierarchicalCursorCoordinates = Pref.makeBooleanPref("ShowHierarchicalCursorCoordinates", User.tool.prefs, true);
    private static Pref cacheDimUpperLevelWhenDownInPlace = Pref.makeBooleanPref("DimUpperLevelWhenDownInPlace", User.tool.prefs, true);
    private static Pref cacheShowCellsInNewWindow = Pref.makeBooleanPref("ShowCellsInNewWindow", User.tool.prefs, true);
    private static Pref cacheErrorHighlightingPulsate = Pref.makeBooleanPref("ErrorHighlightingPulsate", User.tool.prefs, true);
    private static Pref cacheShiftWindowToErrors = Pref.makeBooleanPref("ShiftWindowToErrors", User.tool.prefs, false);
    private static Pref cacheKeepModelessDialogsOnTop = Pref.makeBooleanPref("KeepModelessDialogsOnTop", User.tool.prefs, false);
    private static Pref cacheCadenceMeasurementStyle = Pref.makeBooleanPref("cacheCadenceMeasurementStyle", User.tool.prefs, false);
    private static Pref cacheDockMessagesWindow = Pref.makeBooleanPref("dockMessagesWindow", User.tool.prefs, false);
    private static Pref cacheWhichDisplayAlgorithm = Pref.makeIntPref("WhichDisplayAlgorithm", User.tool.prefs, 1);
    private static Pref cacheUseCellGreekingImages = Pref.makeBooleanPref("UseCellGreekingImages", User.tool.prefs, false);
    private static Pref cacheGreekSizeLimit = Pref.makeDoublePref("GreekSizeLimit", User.tool.prefs, 3.0);
    private static Pref cacheGreekCellSizeLimit = Pref.makeDoublePref("GreekCellSizeLimit", User.tool.prefs, 0.1);
    private static Pref cachePatternedScaleLimit = Pref.makeDoublePref("PatternedScaleLimit", User.tool.prefs, 0.5);
    private static Pref cacheLegacyComposite = Pref.makeBooleanPref("LegacyComposite", User.tool.prefs, false);
    private static Pref cacheAlphaBlendingLimit = Pref.makeDoublePref("AlphaBlendingLimit", User.tool.prefs, 0.6);
    private static Pref cacheShowFileSelectionForNetlists = Pref.makeBooleanPref("ShowFileSelectionForNetlists", User.tool.prefs, true);
    private static Pref cachePanningDistance = Pref.makeIntPref("PanningDistance", User.tool.prefs, 1);
    private static Pref cacheDisplayStyle = Pref.makeIntPref("DisplayStyle", User.tool.prefs, 0);
    private static Pref cacheEnableLog = Pref.makeBooleanServerPref("EnableLog", User.tool.prefs, true);
    private static Pref cacheMultipleLog = Pref.makeBooleanServerPref("MultipleLog", User.tool.prefs, false);
    private static Pref cacheErrorLimit = Pref.makeIntServerPref("ErrorLimit", User.tool.prefs, 0);
    private static Pref cacheMaxUndoHistory = Pref.makeIntPref("MaxUndoHistory", User.tool.prefs, 40);
    private static Pref cacheMemorySize = Pref.makeIntPref("MemorySize", User.tool.prefs, 65);
    private static Pref cachePermSize = Pref.makeIntPref("PermSize", User.tool.prefs, 0);
    private static Pref cacheUseTwoJVMs = Pref.makeBooleanPref("UseTwoJVMs", User.tool.prefs, false);
    private static Pref cacheUseClientServer = Pref.makeBooleanPref("UseClientServer", User.tool.prefs, false);
    private static Pref cacheSnapshotLogging = Pref.makeBooleanPref("SnapshotLogging", User.tool.prefs, false);
    private static Pref cacheAutoTechnologySwitch = Pref.makeBooleanPref("AutoTechnologySwitch", User.tool.prefs, true);
    private static Pref cacheReconstructArcsAndExportsToDeletedCells = Pref.makeBooleanPref("ReconstructArcsToDeletedCells", User.tool.prefs, true);
    private static Pref cacheConvertSchematicLayoutWhenPasting = Pref.makeBooleanPref("ConvertSchematicLayoutWhenPasting", User.tool.prefs, true);
    private static Pref cacheCheckCellDates = Pref.makeBooleanPref("CheckCellDates", User.tool.prefs, false);
    private static Pref cacheDisallowModificationLockedPrims = Pref.makeBooleanServerPref("DisallowModificationLockedPrims", User.tool.prefs, false);
    private static Pref cacheDisallowModificationComplexNodes = Pref.makeBooleanServerPref("DisallowModificationComplexNodes", User.tool.prefs, false);
    private static Pref cacheMoveAfterDuplicate = Pref.makeBooleanPref("MoveAfterDuplicate", User.tool.prefs, true);
    private static Pref cacheDuplicateInPlace = Pref.makeBooleanPref("DuplicateInPlace", User.tool.prefs, false);
    private static Pref cacheDupCopiesExports = Pref.makeBooleanPref("DupCopiesExports", User.tool.prefs, false);
    private static Pref cacheIncrementRightmostIndex = Pref.makeBooleanPref("IncrementRightmostIndex", User.tool.prefs, true);
    private static Pref cacheExtractCopiesExports = Pref.makeBooleanPref("ExtractCopiesExports", User.tool.prefs, true);
    private static Pref cacheArcsAutoIncremented = Pref.makeBooleanPref("ArcsAutoIncremented", User.tool.prefs, true);
    private static Pref cacheNewNodeRotation = Pref.makeIntPref("NewNodeRotation", User.tool.prefs, 0);
    private static Pref cacheNewNodeMirrorX = Pref.makeBooleanPref("NewNodeMirrorX", User.tool.prefs, false);
    private static Pref cacheWaveformDigitalPanelHeight = Pref.makeIntPref("WaveformDigitalPanelHeight", User.tool.prefs, 30);
    private static Pref cacheWaveformAnalogPanelHeight = Pref.makeIntPref("WaveformAnalogPanelHeight", User.tool.prefs, 75);

    private User() {
        super("user");
    }

    @Override
    public void init() {
        this.setOn();
        this.setIncremental();
    }

    public static User getUserTool() {
        return tool;
    }

    @Override
    public void endBatch(Snapshot oldSnapshot, Snapshot newSnapshot, boolean undoRedo) {
        Iterator<WindowFrame> wit = WindowFrame.getWindows();
        while (wit.hasNext()) {
            Cell winCell;
            WindowFrame wf = wit.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || (winCell = content.getCell()) == null) continue;
            EditWindow wnd = (EditWindow)content;
            if (winCell.isLinked()) continue;
            wnd.setCell(null, null, null);
        }
        if (newSnapshot.environment != IdManager.stdIdManager.getInitialEnvironment()) {
            EditWindow.invokeRenderJob();
        }
    }

    public static void fixStaleCellReferences(IdMapper idMapper) {
        if (idMapper == null) {
            return;
        }
        AbstractUserInterface ui = Job.getExtendedUserInterface();
        EDatabase database = ui.getDatabase();
        LibId curLibId = ui.getCurrentLibraryId();
        if (curLibId != null && idMapper.get(curLibId) != curLibId) {
            ui.setCurrentLibrary(database.getLib(idMapper.get(curLibId)));
        }
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            CellId cellId;
            Cell newCell;
            WindowFrame frame = it.next();
            WindowContent wnd = frame.getContent();
            Cell cell = wnd.getCell();
            if (cell == null || cell.isLinked() || (newCell = database.getCell(cellId = idMapper.get(cell.getId()))) == null) continue;
            wnd.setCell(newCell, VarContext.globalContext, null);
        }
    }

    public static Rectangle2D getChangedInWindow(EditWindow wnd) {
        Rectangle2D changedArea = changedWindowRects.get(wnd);
        return changedArea;
    }

    public static void clearChangedInWindow(EditWindow wnd) {
        changedWindowRects.remove(wnd);
    }

    public static void technologyChanged() {
        VectorCache.theCache.clearCache();
        EditWindow.clearSubCellCache();
        WindowFrame.updateTechnologyLists();
    }

    public PrimitivePort getPreferredContactPortProto(ArcProto key1, ArcProto key2) {
        String key;
        PrimitivePort np;
        Technology tech = key1.getTechnology();
        if (this.currentTech != tech) {
            this.uploadCurrentData(tech, tech.getFactoryMenuPalette());
        }
        if ((np = this.preferredContactPortProtoMap.get(key = key1.getName() + "@" + key2.getName())) != null) {
            return np;
        }
        key = key2.getName() + "@" + key1.getName();
        return this.preferredContactPortProtoMap.get(key);
    }

    public List<PrimitivePort> getPrimitivePortConnectedToArc(ArcProto ap) {
        ArrayList<PrimitivePort> list2 = new ArrayList<PrimitivePort>();
        String name = ap.getName();
        block0: for (String key : this.preferredContactPortProtoMap.keySet()) {
            if (!key.contains(name)) continue;
            StringTokenizer t = new StringTokenizer(key, ", @", false);
            while (t.hasMoreTokens()) {
                String str = t.nextToken();
                if (!str.equals(name)) continue;
                PrimitivePort p = this.preferredContactPortProtoMap.get(key);
                if (p == null) continue block0;
                list2.add(p);
                continue block0;
            }
        }
        return list2;
    }

    private Pref getContactNodePref(Technology tech, String mainContactName) {
        Pref thisEntry = this.contactNodeProtoMap.get(mainContactName);
        if (thisEntry == null) {
            thisEntry = Pref.makeStringPref("ComponentMenuEntryFor" + mainContactName + "In" + tech.getTechName(), User.tool.prefs, mainContactName);
            this.contactNodeProtoMap.put(mainContactName, thisEntry);
        }
        return thisEntry;
    }

    public String getCurrentContactNodeProto(Technology tech, String mainContactName) {
        Pref thisEntry = this.getContactNodePref(tech, mainContactName);
        PrimitiveNode pn = tech.findNodeProto(thisEntry.getString());
        if (pn != null) {
            this.updatePrimitiveNodeConnections(pn);
        }
        return thisEntry.getString();
    }

    public void setCurrentContactNodeProto(Technology tech, String mainContactName, Object obj) {
        NodeProto np;
        if (obj instanceof NodeProto) {
            np = (NodeProto)obj;
        } else if (obj instanceof NodeInst) {
            np = ((NodeInst)obj).getProto();
        } else if (obj instanceof Xml.PrimitiveNode) {
            np = this.currentTech.findNodeProto(((Xml.PrimitiveNode)obj).name);
        } else if (obj instanceof Xml.MenuNodeInst) {
            np = this.currentTech.findNodeProto(((Xml.MenuNodeInst)obj).protoName);
        } else {
            return;
        }
        if (mainContactName != null) {
            Pref thisEntry = this.getContactNodePref(tech, mainContactName);
            thisEntry.setString(TechPalette.getItemName(tech, obj, true));
        }
        if (!(np instanceof PrimitiveNode)) {
            return;
        }
        this.updatePrimitiveNodeConnections((PrimitiveNode)np);
    }

    private void updatePrimitiveNodeConnections(PrimitiveNode pn) {
        if (pn.isNotUsed()) {
            return;
        }
        if (!pn.getFunction().isContact()) {
            return;
        }
        int numPorts = pn.getNumPorts();
        assert (numPorts == 1);
        for (int j = 0; j < numPorts; ++j) {
            PrimitivePort pp = pn.getPort(j);
            List<String> list2 = User.getArcNamesSorted(pp);
            for (int i = 1; i < list2.size(); ++i) {
                for (int k = 0; k < i; ++k) {
                    String key = list2.get(k) + "@" + list2.get(i);
                    this.preferredContactPortProtoMap.put(key, pp);
                }
            }
        }
    }

    public void uploadCurrentData(Technology tech, Xml.MenuPalette menuPalette) {
        this.currentTech = tech;
        this.equivalentPortProtoMap.clear();
        this.currentArcProto = null;
        this.setCurrentArcProto(tech.getArcs().next());
        this.preferredContactPortProtoMap.clear();
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            this.updatePrimitiveNodeConnections(it.next());
        }
        for (int i = 0; i < menuPalette.menuBoxes.size(); ++i) {
            List<?> menuBoxList = menuPalette.menuBoxes.get(i);
            if (menuBoxList == null || menuBoxList.isEmpty()) continue;
            this.setCurrentContactNodeProto(tech, null, menuBoxList.get(0));
        }
    }

    public void setEquivalentPortProto(Object obj) {
        NodeProto np;
        if (obj instanceof NodeProto) {
            np = (NodeProto)obj;
        } else if (obj instanceof NodeInst) {
            np = ((NodeInst)obj).getProto();
        } else {
            return;
        }
        if (!(np instanceof PrimitiveNode)) {
            return;
        }
        PrimitiveNode pn = (PrimitiveNode)np;
        if (pn.isNotUsed()) {
            return;
        }
        if (!pn.getFunction().isContact()) {
            return;
        }
        int numPorts = np.getNumPorts();
        assert (numPorts == 1);
        PrimitivePort pp = pn.getPort(0);
        if (pp instanceof PrimitivePort) {
            PrimitivePort p = pp;
            List<String> list2 = User.getArcNamesSorted(p);
            String key = User.getKeyFromList(list2);
            List<PrimitivePort> l = this.equivalentPortProtoMap.get(key);
            if (l == null) {
                l = new ArrayList<PrimitivePort>();
                this.equivalentPortProtoMap.put(key, l);
            }
            l.add(p);
        }
    }

    private static List<String> getArcNamesSorted(PrimitivePort p) {
        ArcProto[] arcs = p.getConnections();
        ArrayList<String> list2 = new ArrayList<String>(arcs.length);
        for (int i = 0; i < arcs.length; ++i) {
            ArcProto ap = arcs[i];
            if (ap.getTechnology() == Generic.tech()) continue;
            list2.add(ap.getName());
        }
        Collections.sort(list2);
        return list2;
    }

    private static String getKeyFromList(List<String> list2) {
        String key = "";
        for (String s : list2) {
            key = key + "@" + s;
        }
        return key;
    }

    public List<PrimitivePort> getEquivalentPorts(PrimitivePort p) {
        List<String> list2 = User.getArcNamesSorted(p);
        return this.equivalentPortProtoMap.get(User.getKeyFromList(list2));
    }

    public ArcProto getCurrentArcProto() {
        return this.currentArcProto;
    }

    public void setCurrentArcProtoTemporarily(ArcProto ap) {
        this.currentArcProto = ap;
    }

    public void setCurrentArcProto(ArcProto ap) {
        this.currentArcProto = ap;
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        if (wf != null) {
            wf.getPaletteTab().arcProtoChanged();
        }
    }

    public static void playSound() {
        if (!hasSound) {
            return;
        }
        if (clickSound == null) {
            try {
                boolean bl = hasSound = AudioSystem.getMixerInfo().length > 0;
                if (!hasSound) {
                    return;
                }
            }
            catch (Throwable t) {
                hasSound = false;
                return;
            }
            URL url = Resources.getURLResource(TopLevel.class, "Click.wav");
            if (url == null) {
                hasSound = false;
                return;
            }
            clickSound = Applet.newAudioClip(url);
        }
        clickSound.play();
    }

    public static void setCurrentLibrary(Library lib) {
        assert (SwingUtilities.isEventDispatchThread());
        Job.getExtendedUserInterface().setCurrentLibrary(lib);
    }

    public static String getDefaultTechnology() {
        return User.getDefaultTechnologySetting().getString();
    }

    public static Setting getDefaultTechnologySetting() {
        return ToolSettings.getDefaultTechnologySetting();
    }

    public static Technology getSchematicTechnology() {
        String t = User.getSchematicTechnologySetting().getString();
        Technology tech = Technology.findTechnology(t);
        if (tech == null) {
            return Technology.getMocmosTechnology();
        }
        return tech;
    }

    public static Setting getSchematicTechnologySetting() {
        return ToolSettings.getSchematicTechnologySetting();
    }

    public static Technology getFactorySchematicTechnology() {
        String t = (String)User.getSchematicTechnologySetting().getFactoryValue();
        Technology tech = Technology.findTechnology(t);
        if (tech == null) {
            return Technology.getMocmosTechnology();
        }
        return tech;
    }

    public static boolean isIncludeDateAndVersionInOutput() {
        return User.getIncludeDateAndVersionInOutputSetting().getBoolean();
    }

    public static Setting getIncludeDateAndVersionInOutputSetting() {
        return ToolSettings.getIncludeDateAndVersionInOutputSetting();
    }

    public static Setting getPSubstrateProcessLayoutTechnologySetting() {
        return ToolSettings.getPSubstrateProcessLayoutTechnologySetting();
    }

    public static boolean isPSubstrateProcessLayoutTechnology() {
        return User.getPSubstrateProcessLayoutTechnologySetting().getBoolean();
    }

    public static Setting getSoftTechnologiesSetting() {
        return ToolSettings.getSoftTechnologiesSetting();
    }

    public static int getIconGenInputSide() {
        return cacheIconGenInputSide.getInt();
    }

    public static void setIconGenInputSide(int side) {
        cacheIconGenInputSide.setInt(side);
    }

    public static int getFactoryIconGenInputSide() {
        return cacheIconGenInputSide.getIntFactoryValue();
    }

    public static int getIconGenOutputSide() {
        return cacheIconGenOutputSide.getInt();
    }

    public static void setIconGenOutputSide(int side) {
        cacheIconGenOutputSide.setInt(side);
    }

    public static int getFactoryIconGenOutputSide() {
        return cacheIconGenOutputSide.getIntFactoryValue();
    }

    public static int getIconGenBidirSide() {
        return cacheIconGenBidirSide.getInt();
    }

    public static void setIconGenBidirSide(int side) {
        cacheIconGenBidirSide.setInt(side);
    }

    public static int getFactoryIconGenBidirSide() {
        return cacheIconGenBidirSide.getIntFactoryValue();
    }

    public static int getIconGenPowerSide() {
        return cacheIconGenPowerSide.getInt();
    }

    public static void setIconGenPowerSide(int side) {
        cacheIconGenPowerSide.setInt(side);
    }

    public static int getFactoryIconGenPowerSide() {
        return cacheIconGenPowerSide.getIntFactoryValue();
    }

    public static int getIconGenGroundSide() {
        return cacheIconGenGroundSide.getInt();
    }

    public static void setIconGenGroundSide(int side) {
        cacheIconGenGroundSide.setInt(side);
    }

    public static int getFactoryIconGenGroundSide() {
        return cacheIconGenGroundSide.getIntFactoryValue();
    }

    public static int getIconGenClockSide() {
        return cacheIconGenClockSide.getInt();
    }

    public static void setIconGenClockSide(int side) {
        cacheIconGenClockSide.setInt(side);
    }

    public static int getFactoryIconGenClockSide() {
        return cacheIconGenClockSide.getIntFactoryValue();
    }

    public static int getIconGenTopRot() {
        return cacheIconGenTopRot.getInt();
    }

    public static void setIconGenTopRot(int rot) {
        cacheIconGenTopRot.setInt(rot);
    }

    public static int getFactoryIconGenTopRot() {
        return cacheIconGenTopRot.getIntFactoryValue();
    }

    public static int getIconGenBottomRot() {
        return cacheIconGenBottomRot.getInt();
    }

    public static void setIconGenBottomRot(int rot) {
        cacheIconGenBottomRot.setInt(rot);
    }

    public static int getFactoryIconGenBottomRot() {
        return cacheIconGenBottomRot.getIntFactoryValue();
    }

    public static int getIconGenLeftRot() {
        return cacheIconGenLeftRot.getInt();
    }

    public static void setIconGenLeftRot(int rot) {
        cacheIconGenLeftRot.setInt(rot);
    }

    public static int getFactoryIconGenLeftRot() {
        return cacheIconGenLeftRot.getIntFactoryValue();
    }

    public static int getIconGenRightRot() {
        return cacheIconGenRightRot.getInt();
    }

    public static void setIconGenRightRot(int rot) {
        cacheIconGenRightRot.setInt(rot);
    }

    public static int getFactoryIconGenRightRot() {
        return cacheIconGenRightRot.getIntFactoryValue();
    }

    public static int getPortDisplayLevel() {
        return UserInterfaceMain.getGraphicsPreferences().portDisplayLevel;
    }

    public static int getExportDisplayLevel() {
        return UserInterfaceMain.getGraphicsPreferences().exportDisplayLevel;
    }

    public static boolean isMoveNodeWithExport() {
        return cacheMoveNodeWithExport.getBoolean();
    }

    public static void setMoveNodeWithExport(boolean on) {
        cacheMoveNodeWithExport.setBoolean(on);
    }

    public static boolean isFactoryMoveNodeWithExport() {
        return cacheMoveNodeWithExport.getBooleanFactoryValue();
    }

    public static boolean isEasySelectionOfCellInstances() {
        return cacheEasySelectionOfCellInstances.getBoolean();
    }

    public static void setEasySelectionOfCellInstances(boolean on) {
        cacheEasySelectionOfCellInstances.setBoolean(on);
    }

    public static boolean isFactoryEasySelectionOfCellInstances() {
        return cacheEasySelectionOfCellInstances.getBooleanFactoryValue();
    }

    public static boolean isDraggingMustEncloseObjects() {
        return cacheDraggingMustEncloseObjects.getBoolean();
    }

    public static void setDraggingMustEncloseObjects(boolean on) {
        cacheDraggingMustEncloseObjects.setBoolean(on);
    }

    public static boolean isFactoryDraggingMustEncloseObjects() {
        return cacheDraggingMustEncloseObjects.getBooleanFactoryValue();
    }

    public static boolean isMouseOverHighlightingEnabled() {
        return cacheMouseOverHighlighting.getBoolean();
    }

    public static void setMouseOverHighlightingEnabled(boolean on) {
        cacheMouseOverHighlighting.setBoolean(on);
    }

    public static boolean isFactoryMouseOverHighlightingEnabled() {
        return cacheMouseOverHighlighting.getBooleanFactoryValue();
    }

    public static boolean isHighlightConnectedObjects() {
        return cacheHighlightConnectedObjects.getBoolean();
    }

    public static void setHighlightConnectedObjects(boolean on) {
        cacheHighlightConnectedObjects.setBoolean(on);
    }

    public static boolean isFactoryHighlightConnectedObjects() {
        return cacheHighlightConnectedObjects.getBooleanFactoryValue();
    }

    public static boolean isHighlightInvisibleObjects() {
        return cacheHighlightInvisibleObjects.getBoolean();
    }

    public static void setHighlightInvisibleObjects(boolean on) {
        cacheHighlightInvisibleObjects.setBoolean(on);
    }

    public static boolean isFactoryHighlightInvisibleObjects() {
        return cacheHighlightInvisibleObjects.getBooleanFactoryValue();
    }

    public static boolean isRoutingMode() {
        return cacheRoutingMode.getBoolean();
    }

    public static void setRoutingMode(boolean on) {
        cacheRoutingMode.setBoolean(on);
    }

    public static boolean isFactoryRoutingMode() {
        return cacheRoutingMode.getBooleanFactoryValue();
    }

    public static double getDefGridXSpacing() {
        return cacheDefGridXSpacing.getDouble();
    }

    public static void setDefGridXSpacing(double dist) {
        cacheDefGridXSpacing.setDouble(dist);
    }

    public static double getFactoryDefGridXSpacing() {
        return cacheDefGridXSpacing.getDoubleFactoryValue();
    }

    public static double getDefGridYSpacing() {
        return cacheDefGridYSpacing.getDouble();
    }

    public static void setDefGridYSpacing(double dist) {
        cacheDefGridYSpacing.setDouble(dist);
    }

    public static double getFactoryDefGridYSpacing() {
        return cacheDefGridYSpacing.getDoubleFactoryValue();
    }

    public static int getDefGridXBoldFrequency() {
        return cacheDefGridXBoldFrequency.getInt();
    }

    public static void setDefGridXBoldFrequency(int dist) {
        cacheDefGridXBoldFrequency.setInt(dist);
    }

    public static int getFactoryDefGridXBoldFrequency() {
        return cacheDefGridXBoldFrequency.getIntFactoryValue();
    }

    public static int getDefGridYBoldFrequency() {
        return cacheDefGridYBoldFrequency.getInt();
    }

    public static void setDefGridYBoldFrequency(int dist) {
        cacheDefGridYBoldFrequency.setInt(dist);
    }

    public static int getFactoryDefGridYBoldFrequency() {
        return cacheDefGridYBoldFrequency.getIntFactoryValue();
    }

    public static boolean isGridAlignMeasurementCursor() {
        return cacheGridAlignMeasurementCursor.getBoolean();
    }

    public static void setGridAlignMeasurementCursor(boolean dist) {
        cacheGridAlignMeasurementCursor.setBoolean(dist);
    }

    public static boolean isFactoryGridAlignMeasurementCursor() {
        return cacheGridAlignMeasurementCursor.getBooleanFactoryValue();
    }

    public static Dimension2D getAlignmentToGrid() {
        return UserInterfaceMain.getEditingPreferences().getAlignmentToGrid();
    }

    public static int getAlignmentToGridIndex() {
        return UserInterfaceMain.getEditingPreferences().getAlignmentToGridIndex();
    }

    public static Dimension2D[] getAlignmentToGridVector() {
        return UserInterfaceMain.getEditingPreferences().getAlignmentToGridVector();
    }

    public static void setAlignmentToGridVector(Dimension2D[] dist, int current) {
        assert (SwingUtilities.isEventDispatchThread());
        UserInterfaceMain.setEditingPreferences(UserInterfaceMain.getEditingPreferences().withAlignment(dist, current));
    }

    public static boolean isGridAxesShown() {
        return cacheShowGridAxes.getBoolean();
    }

    public static void setGridAxesShown(boolean s) {
        cacheShowGridAxes.setBoolean(s);
    }

    public static boolean isFactoryGridAxesShown() {
        return cacheShowGridAxes.getBooleanFactoryValue();
    }

    public static boolean isTextVisibilityOn(AbstractTextDescriptor.TextType textType) {
        return UserInterfaceMain.getGraphicsPreferences().isTextVisibilityOn(textType);
    }

    public static boolean isTextVisibilityOnNode() {
        return User.isTextVisibilityOn(AbstractTextDescriptor.TextType.NODE);
    }

    public static boolean isTextVisibilityOnArc() {
        return User.isTextVisibilityOn(AbstractTextDescriptor.TextType.ARC);
    }

    public static boolean isTextVisibilityOnPort() {
        return User.isTextVisibilityOn(AbstractTextDescriptor.TextType.PORT);
    }

    public static boolean isTextVisibilityOnExport() {
        return User.isTextVisibilityOn(AbstractTextDescriptor.TextType.EXPORT);
    }

    public static boolean isTextVisibilityOnAnnotation() {
        return User.isTextVisibilityOn(AbstractTextDescriptor.TextType.ANNOTATION);
    }

    public static boolean isTextVisibilityOnInstance() {
        return User.isTextVisibilityOn(AbstractTextDescriptor.TextType.INSTANCE);
    }

    public static boolean isTextVisibilityOnCell() {
        return User.isTextVisibilityOn(AbstractTextDescriptor.TextType.CELL);
    }

    public static String getDefaultFont() {
        return UserInterfaceMain.getGraphicsPreferences().defaultFont;
    }

    public static String getFactoryDefaultFont() {
        return "SansSerif";
    }

    public static String getDefaultTextCellFont() {
        return cacheDefaultTextCellFont.getString();
    }

    public static void setDefaultTextCellFont(String f2) {
        cacheDefaultTextCellFont.setString(f2);
    }

    public static String getFactoryDefaultTextCellFont() {
        return cacheDefaultTextCellFont.getStringFactoryValue();
    }

    public static int getDefaultTextCellSize() {
        return cacheDefaultTextCellSize.getInt();
    }

    public static void setDefaultTextCellSize(int s) {
        cacheDefaultTextCellSize.setInt(s);
    }

    public static int getFactoryDefaultTextCellSize() {
        return cacheDefaultTextCellSize.getIntFactoryValue();
    }

    public static double getGlobalTextScale() {
        return cacheGlobalTextScale.getDouble();
    }

    public static void setGlobalTextScale(double s) {
        cacheGlobalTextScale.setDouble(s);
    }

    public static double getFactoryGlobalTextScale() {
        return cacheGlobalTextScale.getDoubleFactoryValue();
    }

    public static String getDefaultTextExternalEditor() {
        return cacheDefaultTextExternalEditor.getString();
    }

    public static void setDefaultTextExternalEditor(String e) {
        cacheDefaultTextExternalEditor.setString(e);
    }

    public static String getFactoryDefaultTextExternalEditor() {
        return cacheDefaultTextExternalEditor.getStringFactoryValue();
    }

    public static String getFrameCompanyName() {
        return cacheFrameCompanyName.getString();
    }

    public static void setFrameCompanyName(String c) {
        cacheFrameCompanyName.setString(c);
    }

    public static String getFactoryFrameCompanyName() {
        return cacheFrameCompanyName.getStringFactoryValue();
    }

    public static String getFrameDesignerName() {
        return cacheFrameDesignerName.getString();
    }

    public static void setFrameDesignerName(String c) {
        cacheFrameDesignerName.setString(c);
    }

    public static String getFactoryFrameDesignerName() {
        return cacheFrameDesignerName.getStringFactoryValue();
    }

    public static String getFrameProjectName() {
        return cacheFrameProjectName.getString();
    }

    public static void setFrameProjectName(String c) {
        cacheFrameProjectName.setString(c);
    }

    public static String getFactoryFrameProjectName() {
        return cacheFrameProjectName.getStringFactoryValue();
    }

    public static int getColor(ColorPrefType pref) {
        return UserInterfaceMain.getGraphicsPreferences().getColor(pref).getRGB() & 0xFFFFFF;
    }

    public static void setColor(ColorPrefType pref, int color) {
        UserInterfaceMain.setGraphicsPreferences(UserInterfaceMain.getGraphicsPreferences().withColor(pref, new Color(color)));
    }

    public static void resetFactoryColor(ColorPrefType pref) {
        UserInterfaceMain.setGraphicsPreferences(UserInterfaceMain.getGraphicsPreferences().withColor(pref, pref.getFactoryDefaultColor()));
    }

    public static TextUtils.UnitScale getDistanceUnits() {
        int unitIndex = cacheDistanceUnits.getInt();
        if (unitIndex < 0) {
            return null;
        }
        return TextUtils.UnitScale.findFromIndex(unitIndex);
    }

    public static void setDistanceUnits(TextUtils.UnitScale us) {
        int unitIndex = -1;
        if (us != null) {
            unitIndex = us.getIndex();
        }
        cacheDistanceUnits.setInt(unitIndex);
    }

    public static TextUtils.UnitScale getFactoryDistanceUnits() {
        int unitIndex = cacheDistanceUnits.getIntFactoryValue();
        if (unitIndex < 0) {
            return null;
        }
        return TextUtils.UnitScale.findFromIndex(unitIndex);
    }

    public static TextUtils.UnitScale getResistanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheResistanceUnits.getInt());
    }

    public static void setResistanceUnits(TextUtils.UnitScale us) {
        cacheResistanceUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getFactoryResistanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheResistanceUnits.getIntFactoryValue());
    }

    public static TextUtils.UnitScale getCapacitanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheCapacitanceUnits.getInt());
    }

    public static void setCapacitanceUnits(TextUtils.UnitScale us) {
        cacheCapacitanceUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getFactoryCapacitanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheCapacitanceUnits.getIntFactoryValue());
    }

    public static TextUtils.UnitScale getInductanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheInductanceUnits.getInt());
    }

    public static void setInductanceUnits(TextUtils.UnitScale us) {
        cacheInductanceUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getFactoryInductanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheInductanceUnits.getIntFactoryValue());
    }

    public static TextUtils.UnitScale getAmperageUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheAmperageUnits.getInt());
    }

    public static void setAmperageUnits(TextUtils.UnitScale us) {
        cacheAmperageUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getFactoryAmperageUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheAmperageUnits.getIntFactoryValue());
    }

    public static TextUtils.UnitScale getVoltageUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheVoltageUnits.getInt());
    }

    public static void setVoltageUnits(TextUtils.UnitScale us) {
        cacheVoltageUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getFactoryVoltageUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheVoltageUnits.getIntFactoryValue());
    }

    public static TextUtils.UnitScale getTimeUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheTimeUnits.getInt());
    }

    public static void setTimeUnits(TextUtils.UnitScale us) {
        cacheTimeUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getFactoryTimeUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheTimeUnits.getIntFactoryValue());
    }

    public static String getWorkingDirectory() {
        return cacheWorkingDirectory.getString();
    }

    public static void setWorkingDirectory(String dir) {
        cacheWorkingDirectory.setString(dir);
    }

    public static String getRegressionPath() {
        return cacheRegressionPath.getString();
    }

    public static void setRegressionPath(String s) {
        cacheRegressionPath.setString(s);
    }

    public static String[] getRecentlyOpenedLibraries() {
        String libs = cacheRecentlyOpenedLibraries.getString();
        if (libs.equals("")) {
            return new String[0];
        }
        return libs.split("\n");
    }

    public static void addRecentlyOpenedLibrary(String s) {
        int maxLength = 16;
        String[] libs = User.getRecentlyOpenedLibraries();
        StringBuffer buf = new StringBuffer();
        buf.append(s);
        for (int i = 0; i < maxLength && i < libs.length; ++i) {
            if (s.equals(libs[i])) continue;
            buf.append("\n");
            buf.append(libs[i]);
        }
        cacheRecentlyOpenedLibraries.setString(buf.toString());
    }

    public static void clearRecentlyOpenedLibraries() {
        cacheRecentlyOpenedLibraries.setString("");
    }

    public static boolean isPromptForIndexWhenDescending() {
        return cachePromptForIndexWhenDescending.getBoolean();
    }

    public static void setPromptForIndexWhenDescending(boolean on) {
        cachePromptForIndexWhenDescending.setBoolean(on);
    }

    public static boolean isFactoryPromptForIndexWhenDescending() {
        return cachePromptForIndexWhenDescending.getBooleanFactoryValue();
    }

    public static boolean isBeepAfterLongJobs() {
        return cacheBeepAfterLongJobs.getBoolean();
    }

    public static void setBeepAfterLongJobs(boolean on) {
        cacheBeepAfterLongJobs.setBoolean(on);
    }

    public static boolean isFactoryBeepAfterLongJobs() {
        return cacheBeepAfterLongJobs.getBooleanFactoryValue();
    }

    public static boolean isJobVerboseMode() {
        return cacheJobVerboseMode.getBoolean();
    }

    public static void setJobVerboseMode(boolean on) {
        cacheJobVerboseMode.setBoolean(on);
    }

    public static boolean isFactoryJobVerboseMode() {
        return cacheJobVerboseMode.getBooleanFactoryValue();
    }

    public static boolean isRotateLayoutTransistors() {
        return cacheRotateLayoutTransistors.getBoolean();
    }

    public static void setRotateLayoutTransistors(boolean on) {
        cacheRotateLayoutTransistors.setBoolean(on);
    }

    public static boolean isFactoryRotateLayoutTransistors() {
        return cacheRotateLayoutTransistors.getBooleanFactoryValue();
    }

    public static boolean isSideBarOnRight() {
        return cacheSideBarOnRight.getBoolean();
    }

    public static void setSideBarOnRight(boolean on) {
        cacheSideBarOnRight.setBoolean(on);
    }

    public static boolean isFactorySideBarOnRight() {
        return cacheSideBarOnRight.getBooleanFactoryValue();
    }

    public static int getDefaultWindowTab() {
        return cacheDefaultWindowTab.getInt();
    }

    public static void setDefaultWindowTab(int t) {
        cacheDefaultWindowTab.setInt(t);
    }

    public static Point getDefaultWindowPos() {
        return new Point(cacheDefaultWindowXPos.getInt(), cacheDefaultWindowYPos.getInt());
    }

    public static void setDefaultWindowPos(Point pt) {
        cacheDefaultWindowXPos.setInt(pt.x);
        cacheDefaultWindowYPos.setInt(pt.y);
    }

    public static Dimension getDefaultWindowSize() {
        if (cacheDefaultWindowXSize.getInt() == 0 || cacheDefaultWindowYSize.getInt() == 0) {
            return null;
        }
        return new Dimension(cacheDefaultWindowXSize.getInt(), cacheDefaultWindowYSize.getInt());
    }

    public static void setDefaultWindowSize(Dimension sz) {
        cacheDefaultWindowXSize.setInt(sz.width);
        cacheDefaultWindowYSize.setInt(sz.height);
    }

    public static Point getDefaultMessagesPos() {
        if (cacheDefaultMessagesXPos.getInt() < 0 && cacheDefaultMessagesYPos.getInt() < 0) {
            return null;
        }
        return new Point(cacheDefaultMessagesXPos.getInt(), cacheDefaultMessagesYPos.getInt());
    }

    public static void setDefaultMessagesPos(Point pt) {
        cacheDefaultMessagesXPos.setInt(pt.x);
        cacheDefaultMessagesYPos.setInt(pt.y);
    }

    public static Dimension getDefaultMessagesSize() {
        if (cacheDefaultMessagesXSize.getInt() == 0 || cacheDefaultMessagesYSize.getInt() == 0) {
            return null;
        }
        return new Dimension(cacheDefaultMessagesXSize.getInt(), cacheDefaultMessagesYSize.getInt());
    }

    public static void setDefaultMessagesSize(Dimension sz) {
        cacheDefaultMessagesXSize.setInt(sz.width);
        cacheDefaultMessagesYSize.setInt(sz.height);
    }

    public static boolean isPlayClickSoundsWhenCreatingArcs() {
        return cachePlayClickSoundsWhenCreatingArcs.getBoolean();
    }

    public static void setPlayClickSoundsWhenCreatingArcs(boolean on) {
        cachePlayClickSoundsWhenCreatingArcs.setBoolean(on);
    }

    public static boolean isFactoryPlayClickSoundsWhenCreatingArcs() {
        return cachePlayClickSoundsWhenCreatingArcs.getBooleanFactoryValue();
    }

    public static boolean isShowHierarchicalCursorCoordinates() {
        return cacheShowHierarchicalCursorCoordinates.getBoolean();
    }

    public static void setShowHierarchicalCursorCoordinates(boolean on) {
        cacheShowHierarchicalCursorCoordinates.setBoolean(on);
    }

    public static boolean isFactoryShowHierarchicalCursorCoordinates() {
        return cacheShowHierarchicalCursorCoordinates.getBooleanFactoryValue();
    }

    public static boolean isDimUpperLevelWhenDownInPlace() {
        return cacheDimUpperLevelWhenDownInPlace.getBoolean();
    }

    public static void setDimUpperLevelWhenDownInPlace(boolean dim) {
        cacheDimUpperLevelWhenDownInPlace.setBoolean(dim);
    }

    public static boolean isFactoryDimUpperLevelWhenDownInPlace() {
        return cacheDimUpperLevelWhenDownInPlace.getBooleanFactoryValue();
    }

    public static boolean isShowCellsInNewWindow() {
        return cacheShowCellsInNewWindow.getBoolean();
    }

    public static void setShowCellsInNewWindow(boolean dim) {
        cacheShowCellsInNewWindow.setBoolean(dim);
    }

    public static boolean isFactoryShowCellsInNewWindow() {
        return cacheShowCellsInNewWindow.getBooleanFactoryValue();
    }

    public static boolean isErrorHighlightingPulsate() {
        return cacheErrorHighlightingPulsate.getBoolean();
    }

    public static void setErrorHighlightingPulsate(boolean dim) {
        cacheErrorHighlightingPulsate.setBoolean(dim);
    }

    public static boolean isFactoryErrorHighlightingPulsate() {
        return cacheErrorHighlightingPulsate.getBooleanFactoryValue();
    }

    public static boolean isShiftWindowToErrors() {
        return cacheShiftWindowToErrors.getBoolean();
    }

    public static void setShiftWindowToErrors(boolean dim) {
        cacheShiftWindowToErrors.setBoolean(dim);
    }

    public static boolean isFactoryShiftWindowToErrors() {
        return cacheShiftWindowToErrors.getBooleanFactoryValue();
    }

    public static boolean isKeepModelessDialogsOnTop() {
        return cacheKeepModelessDialogsOnTop.getBoolean();
    }

    public static void setKeepModelessDialogsOnTop(boolean dim) {
        cacheKeepModelessDialogsOnTop.setBoolean(dim);
    }

    public static boolean isFactoryKeepModelessDialogsOnTop() {
        return cacheKeepModelessDialogsOnTop.getBooleanFactoryValue();
    }

    public static boolean isCadenceMeasurementStyle() {
        return cacheCadenceMeasurementStyle.getBoolean();
    }

    public static void setCadenceMeasurementStyle(boolean dim) {
        cacheCadenceMeasurementStyle.setBoolean(dim);
    }

    public static boolean isFactoryCadenceMeasurementStyle() {
        return cacheCadenceMeasurementStyle.getBooleanFactoryValue();
    }

    public static boolean isDockMessagesWindow() {
        return cacheDockMessagesWindow.getBoolean();
    }

    public static void setDockMessagesWindow(boolean dock) {
        cacheDockMessagesWindow.setBoolean(dock);
    }

    public static boolean isFactoryDockMessagesWindow() {
        return cacheDockMessagesWindow.getBooleanFactoryValue();
    }

    public static int getDisplayAlgorithm() {
        return cacheWhichDisplayAlgorithm.getInt();
    }

    public static void setDisplayAlgorithm(int w) {
        cacheWhichDisplayAlgorithm.setInt(w);
    }

    public static int getFactoryDisplayAlgorithm() {
        return cacheWhichDisplayAlgorithm.getIntFactoryValue();
    }

    public static boolean isUseCellGreekingImages() {
        return cacheUseCellGreekingImages.getBoolean();
    }

    public static void setUseCellGreekingImages(boolean on) {
        cacheUseCellGreekingImages.setBoolean(on);
    }

    public static boolean isFactoryUseCellGreekingImages() {
        return cacheUseCellGreekingImages.getBooleanFactoryValue();
    }

    public static double getGreekSizeLimit() {
        return cacheGreekSizeLimit.getDouble();
    }

    public static void setGreekSizeLimit(double l) {
        cacheGreekSizeLimit.setDouble(l);
    }

    public static double getFactoryGreekSizeLimit() {
        return cacheGreekSizeLimit.getDoubleFactoryValue();
    }

    public static double getGreekCellSizeLimit() {
        return cacheGreekCellSizeLimit.getDouble();
    }

    public static void setGreekCellSizeLimit(double l) {
        cacheGreekCellSizeLimit.setDouble(l);
    }

    public static double getFactoryGreekCellSizeLimit() {
        return cacheGreekCellSizeLimit.getDoubleFactoryValue();
    }

    public static double getPatternedScaleLimit() {
        return cachePatternedScaleLimit.getDouble();
    }

    public static void setPatternedScaleLimit(double l) {
        cachePatternedScaleLimit.setDouble(l);
    }

    public static double getFactoryPatternedScaleLimit() {
        return cachePatternedScaleLimit.getDoubleFactoryValue();
    }

    public static boolean isLegacyComposite() {
        return cacheLegacyComposite.getBoolean();
    }

    public static void setLegacyComposite(boolean on) {
        cacheLegacyComposite.setBoolean(on);
    }

    public static boolean isFactoryLegacyComposite() {
        return cacheLegacyComposite.getBooleanFactoryValue();
    }

    public static double getAlphaBlendingOvercolorLimit() {
        return cacheAlphaBlendingLimit.getDouble();
    }

    public static void setAlphaBlendingOvercolorLimit(double l) {
        cacheAlphaBlendingLimit.setDouble(l);
    }

    public static double getFactoryAlphaBlendingOvercolorLimit() {
        return cacheAlphaBlendingLimit.getDoubleFactoryValue();
    }

    public static boolean isShowFileSelectionForNetlists() {
        return cacheShowFileSelectionForNetlists.getBoolean();
    }

    public static void setShowFileSelectionForNetlists(boolean on) {
        cacheShowFileSelectionForNetlists.setBoolean(on);
    }

    public static boolean isFactoryShowFileSelectionForNetlists() {
        return cacheShowFileSelectionForNetlists.getBooleanFactoryValue();
    }

    public static int getPanningDistance() {
        return cachePanningDistance.getInt();
    }

    public static void setPanningDistance(int d) {
        cachePanningDistance.setInt(d);
    }

    public static int getFactoryPanningDistance() {
        return cachePanningDistance.getIntFactoryValue();
    }

    public static int getDisplayStyle() {
        return cacheDisplayStyle.getInt();
    }

    public static void setDisplayStyle(int s) {
        cacheDisplayStyle.setInt(s);
    }

    public static int getFactoryDisplayStyle() {
        return cacheDisplayStyle.getIntFactoryValue();
    }

    public static boolean isEnableLog() {
        return cacheEnableLog.getBoolean();
    }

    public static void setEnableLog(boolean log2) {
        cacheEnableLog.setBoolean(log2);
    }

    public static boolean getFactoryEnableLog() {
        return cacheEnableLog.getBooleanFactoryValue();
    }

    public static boolean isMultipleLog() {
        return cacheMultipleLog.getBoolean();
    }

    public static void setMultipleLog(boolean log2) {
        cacheMultipleLog.setBoolean(log2);
    }

    public static boolean getFactoryMultipleLog() {
        return cacheMultipleLog.getBooleanFactoryValue();
    }

    public static int getErrorLimit() {
        return cacheErrorLimit.getInt();
    }

    public static void setErrorLimit(int limit) {
        cacheErrorLimit.setInt(limit);
    }

    public static int getFactoryErrorLimit() {
        return cacheErrorLimit.getIntFactoryValue();
    }

    public static int getMaxUndoHistory() {
        return cacheMaxUndoHistory.getInt();
    }

    public static void setMaxUndoHistory(int n) {
        cacheMaxUndoHistory.setInt(n);
    }

    public static int getFactoryMaxUndoHistory() {
        return cacheMaxUndoHistory.getIntFactoryValue();
    }

    public static int getMemorySize() {
        return cacheMemorySize.getInt();
    }

    public static void setMemorySize(int limit) {
        cacheMemorySize.setInt(limit);
    }

    public static int getFactoryMemorySize() {
        return cacheMemorySize.getIntFactoryValue();
    }

    public static int getPermSpace() {
        return cachePermSize.getInt();
    }

    public static void setPermSpace(int limit) {
        cachePermSize.setInt(limit);
    }

    public static int getFactoryPermSpace() {
        return cachePermSize.getIntFactoryValue();
    }

    public static boolean isUseTwoJVMs() {
        return cacheUseTwoJVMs.getBoolean();
    }

    public static void setUseTwoJVMs(boolean on) {
        cacheUseTwoJVMs.setBoolean(on);
    }

    public static boolean isFactoryUseTwoJVMs() {
        return cacheUseTwoJVMs.getBooleanFactoryValue();
    }

    public static boolean isUseClientServer() {
        return cacheUseClientServer.getBoolean();
    }

    public static void setUseClientServer(boolean on) {
        cacheUseClientServer.setBoolean(on);
    }

    public static boolean isFactoryUseClientServer() {
        return cacheUseClientServer.getBooleanFactoryValue();
    }

    public static boolean isSnapshotLogging() {
        return cacheSnapshotLogging.getBoolean();
    }

    public static void setSnapshotLogging(boolean on) {
        cacheSnapshotLogging.setBoolean(on);
    }

    public static boolean isFactorySnapshotLogging() {
        return cacheSnapshotLogging.getBooleanFactoryValue();
    }

    public static boolean isAutoTechnologySwitch() {
        return cacheAutoTechnologySwitch.getBoolean();
    }

    public static void setAutoTechnologySwitch(boolean on) {
        cacheAutoTechnologySwitch.setBoolean(on);
    }

    public static boolean isFactoryAutoTechnologySwitch() {
        return cacheAutoTechnologySwitch.getBooleanFactoryValue();
    }

    public static boolean isReconstructArcsAndExportsToDeletedCells() {
        return cacheReconstructArcsAndExportsToDeletedCells.getBoolean();
    }

    public static void setReconstructArcsAndExportsToDeletedCells(boolean on) {
        cacheReconstructArcsAndExportsToDeletedCells.setBoolean(on);
    }

    public static boolean isFactoryReconstructArcsAndExportsToDeletedCells() {
        return cacheReconstructArcsAndExportsToDeletedCells.getBooleanFactoryValue();
    }

    public static boolean isConvertSchematicLayoutWhenPasting() {
        return cacheConvertSchematicLayoutWhenPasting.getBoolean();
    }

    public static void setConvertSchematicLayoutWhenPasting(boolean on) {
        cacheConvertSchematicLayoutWhenPasting.setBoolean(on);
    }

    public static boolean isFactoryConvertSchematicLayoutWhenPasting() {
        return cacheConvertSchematicLayoutWhenPasting.getBooleanFactoryValue();
    }

    public static boolean isCheckCellDates() {
        return cacheCheckCellDates.getBoolean();
    }

    public static void setCheckCellDates(boolean on) {
        cacheCheckCellDates.setBoolean(on);
    }

    public static boolean isFactoryCheckCellDates() {
        return cacheCheckCellDates.getBooleanFactoryValue();
    }

    public static boolean isDisallowModificationLockedPrims() {
        return cacheDisallowModificationLockedPrims.getBoolean();
    }

    public static void setDisallowModificationLockedPrims(boolean on) {
        cacheDisallowModificationLockedPrims.setBoolean(on);
    }

    public static boolean isFactoryDisallowModificationLockedPrims() {
        return cacheDisallowModificationLockedPrims.getBooleanFactoryValue();
    }

    public static boolean isDisallowModificationComplexNodes() {
        return cacheDisallowModificationComplexNodes.getBoolean();
    }

    public static void setDisallowModificationComplexNodes(boolean on) {
        cacheDisallowModificationComplexNodes.setBoolean(on);
    }

    public static boolean isFactoryDisallowModificationComplexNodes() {
        return cacheDisallowModificationComplexNodes.getBooleanFactoryValue();
    }

    public static boolean isMoveAfterDuplicate() {
        return cacheMoveAfterDuplicate.getBoolean();
    }

    public static void setMoveAfterDuplicate(boolean on) {
        cacheMoveAfterDuplicate.setBoolean(on);
    }

    public static boolean isFactoryMoveAfterDuplicate() {
        return cacheMoveAfterDuplicate.getBooleanFactoryValue();
    }

    public static boolean isDuplicateInPlace() {
        return cacheDuplicateInPlace.getBoolean();
    }

    public static void setDuplicateInPlace(boolean on) {
        cacheDuplicateInPlace.setBoolean(on);
    }

    public static boolean isFactoryDuplicateInPlace() {
        return cacheDuplicateInPlace.getBooleanFactoryValue();
    }

    public static boolean isDupCopiesExports() {
        return cacheDupCopiesExports.getBoolean();
    }

    public static void setDupCopiesExports(boolean on) {
        cacheDupCopiesExports.setBoolean(on);
    }

    public static boolean isFactoryDupCopiesExports() {
        return cacheDupCopiesExports.getBooleanFactoryValue();
    }

    public static boolean isIncrementRightmostIndex() {
        return cacheIncrementRightmostIndex.getBoolean();
    }

    public static void setIncrementRightmostIndex(boolean on) {
        cacheIncrementRightmostIndex.setBoolean(on);
    }

    public static boolean isFactoryIncrementRightmostIndex() {
        return cacheIncrementRightmostIndex.getBooleanFactoryValue();
    }

    public static boolean isExtractCopiesExports() {
        return cacheExtractCopiesExports.getBoolean();
    }

    public static void setExtractCopiesExports(boolean on) {
        cacheExtractCopiesExports.setBoolean(on);
    }

    public static boolean isFactoryExtractCopiesExports() {
        return cacheExtractCopiesExports.getBooleanFactoryValue();
    }

    public static boolean isArcsAutoIncremented() {
        return cacheArcsAutoIncremented.getBoolean();
    }

    public static void setArcsAutoIncremented(boolean on) {
        cacheArcsAutoIncremented.setBoolean(on);
    }

    public static boolean isFactoryArcsAutoIncremented() {
        return cacheArcsAutoIncremented.getBooleanFactoryValue();
    }

    public static int getNewNodeRotation() {
        return cacheNewNodeRotation.getInt();
    }

    public static void setNewNodeRotation(int rot) {
        cacheNewNodeRotation.setInt(rot);
    }

    public static boolean isNewNodeMirrorX() {
        return cacheNewNodeMirrorX.getBoolean();
    }

    public static void setNewNodeMirrorX(boolean on) {
        cacheNewNodeMirrorX.setBoolean(on);
    }

    public static int getWaveformDigitalPanelHeight() {
        return cacheWaveformDigitalPanelHeight.getInt();
    }

    public static void setWaveformDigitalPanelHeight(int h) {
        cacheWaveformDigitalPanelHeight.setInt(h);
    }

    public static int getWaveformAnalogPanelHeight() {
        return cacheWaveformAnalogPanelHeight.getInt();
    }

    public static void setWaveformAnalogPanelHeight(int h) {
        cacheWaveformAnalogPanelHeight.setInt(h);
    }

    public static enum ColorPrefType {
        BACKGROUND("Background", Color.LIGHT_GRAY),
        GRID("Grid", Color.BLACK),
        MEASUREMENT("Measurement", Color.WHITE),
        HIGHLIGHT("Highlight", Color.WHITE),
        NODE_HIGHLIGHT("NodeHighlight", Color.BLUE),
        MOUSEOVER_HIGHLIGHT("MouseOverHighlight", new Color(51, 255, 255)),
        PORT_HIGHLIGHT("PortHighlight", Color.YELLOW),
        TEXT("Text", Color.BLACK),
        INSTANCE("InstanceOutline", Color.BLACK),
        DOWNINPLACEBORDER("DownInPlaceBorder", Color.RED),
        WAVE_BACKGROUND("WaveformBackground", Color.BLACK),
        WAVE_FOREGROUND("WaveformForeground", Color.WHITE),
        WAVE_STIMULI("WaveformStimuli", Color.RED),
        WAVE_OFF_STRENGTH("WaveformStrengthOff", Color.BLUE),
        WAVE_NODE_STRENGTH("WaveformStrengthNode", Color.GREEN),
        WAVE_GATE_STRENGTH("WaveformStrengthGate", Color.MAGENTA),
        WAVE_POWER_STRENGTH("WaveformStrengthPower", Color.LIGHT_GRAY),
        WAVE_CROSS_LOW("WaveformCrossProbeLow", Color.BLUE),
        WAVE_CROSS_HIGH("WaveformCrossProbeHigh", Color.GREEN),
        WAVE_CROSS_UNDEF("WaveformCrossProbeX", Color.BLACK),
        WAVE_CROSS_FLOAT("WaveformCrossProbeZ", Color.LIGHT_GRAY),
        INSTANCE_3D("3DColorInstanceCell", Color.GRAY),
        HIGHLIGHT_3D("3DColorHighlighted", Color.GRAY),
        AMBIENT_3D("3DColorAmbient", Color.GRAY),
        AXIS_X_3D("3DColorAxisX", Color.RED),
        AXIS_Y_3D("3DColorAxisY", Color.BLUE),
        AXIS_Z_3D("3DColorAxisZ", Color.GREEN),
        DIRECTIONAL_LIGHT_3D("3DColorDirectionalLight", Color.GRAY);

        private final String prefKey;
        private final Color factoryDefault;

        public String getPrefKey() {
            return this.prefKey;
        }

        public Color getFactoryDefaultColor() {
            return this.factoryDefault;
        }

        private ColorPrefType(String prefKey, Color factoryDefault) {
            this.prefKey = "Color" + prefKey;
            this.factoryDefault = factoryDefault;
        }
    }
}

