/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.metrics.boundingbox;

import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.metrics.AbstractMetric;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;

public class BBMetric
extends AbstractMetric {
    public BBMetric(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, Map<PlacementFrame.PlacementNetwork, List<PlacementAdapter.PlacementConnection>> optimalConnections) {
        super(nodesToPlace, allNetworks, optimalConnections);
    }

    @Override
    public Double compute() {
        double sum2 = 0.0;
        for (PlacementFrame.PlacementNetwork net : this.allNetworks) {
            sum2 += this.compute(net);
        }
        return new Double(sum2);
    }

    private double compute(PlacementFrame.PlacementNetwork net) {
        double leftmost = Double.MAX_VALUE;
        double rightmost = -1.7976931348623157E308;
        double uppermost = -1.7976931348623157E308;
        double undermost = Double.MAX_VALUE;
        if (this.optimalConnections != null) {
            List connections = (List)this.optimalConnections.get(net);
            for (PlacementAdapter.PlacementConnection pConn : connections) {
                Point2D.Double position = this.getPortPosition(pConn.getP1());
                if (position.getX() < leftmost) {
                    leftmost = position.getX();
                }
                if (position.getX() > rightmost) {
                    rightmost = position.getX();
                }
                if (position.getY() > uppermost) {
                    uppermost = position.getY();
                }
                if (position.getY() < undermost) {
                    undermost = position.getY();
                }
                if ((position = this.getPortPosition(pConn.getP2())).getX() < leftmost) {
                    leftmost = position.getX();
                }
                if (position.getX() > rightmost) {
                    rightmost = position.getX();
                }
                if (position.getY() > uppermost) {
                    uppermost = position.getY();
                }
                if (!(position.getY() < undermost)) continue;
                undermost = position.getY();
            }
        } else {
            for (PlacementFrame.PlacementPort pPort : net.getPortsOnNet()) {
                Point2D.Double position = this.getPortPosition(pPort);
                if (position.getX() < leftmost) {
                    leftmost = position.getX();
                }
                if (position.getX() > rightmost) {
                    rightmost = position.getX();
                }
                if (position.getY() > uppermost) {
                    uppermost = position.getY();
                }
                if (!(position.getY() < undermost)) continue;
                undermost = position.getY();
            }
        }
        return rightmost - leftmost + (uppermost - undermost);
    }

    @Override
    public String getMetricName() {
        return "Bounding Box Metric";
    }

    private Point2D.Double getPortPosition(PlacementFrame.PlacementPort port) {
        double x2 = port.getRotatedOffX() + port.getPlacementNode().getPlacementX();
        double y = port.getRotatedOffY() + port.getPlacementNode().getPlacementY();
        return new Point2D.Double(x2, y);
    }
}

