/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.PostScriptColor;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PostScript
extends Output {
    private static final int PSSCALE = 4;
    private static final double PSTEXTSCALE = 0.75;
    private static final int CORNERDATESIZE = 14;
    private static final String DEFAULTFONT = "Times-Roman";
    private static final String DEFAULTFONTBOLD = "Times-Bold";
    private static final String DEFAULTFONTITALIC = "Times-Italic";
    private static final String DEFAULTFONTBI = "Times-BoldItalic";
    private static final int HEADERDOT = 1;
    private static final int HEADERLINE = 2;
    private static final int HEADERPOLYGON = 3;
    private static final int HEADERFPOLYGON = 4;
    private static final int HEADERSTRING = 5;
    private boolean putHeaderDot;
    private boolean putHeaderLine;
    private boolean putHeaderPolygon;
    private boolean putHeaderFilledPolygon;
    private boolean putHeaderString;
    private boolean psUseColor;
    private boolean psUseColorMerge;
    private Cell cell;
    private int psNumPatternsEmitted;
    private Map<EGraphics, Integer> patternsEmitted;
    private int currentLayer;
    private int lastColor;
    private int lineWidth;
    private AffineTransform matrix;
    private static EGraphics blackGraphics = new EGraphics(false, false, null, 0, 100, 100, 100, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    PostScriptPreferences localPrefs;
    private String[] headerDot = new String[]{"/Putdot {", "    newpath moveto 0 0 rlineto stroke} def"};
    private String[] headerLine = new String[]{"/Drawline {", "    newpath moveto lineto stroke} def"};
    private String[] headerPolygon = new String[]{"/Polygon {", "    aload", "    length 2 idiv /len exch def", "    newpath", "    moveto", "    len 1 sub {lineto} repeat", "    closepath", "} def"};
    private String[] headerFilledPolygon = new String[]{"/BuildCharDict 10 dict def", "/StippleFont1 7 dict def", "StippleFont1 begin", "    /FontType 3 def", "    /FontMatrix [1 0 0 1 0 0] def", "    /FontBBox [0 0 1 1] def", "    /Encoding 256 array def", "    0 1 255 {Encoding exch /.notdef put} for", "    /CharacterDefs 40 dict def", "    CharacterDefs /.notdef {} put", "    /BuildChar", "        { BuildCharDict begin", "            /char exch def", "            /fontdict exch def", "            /charname fontdict /Encoding get", "            char get def", "            /charproc fontdict /CharacterDefs get", "            charname get def", "            1 0 0 0 1 1 setcachedevice", "            gsave charproc grestore", "        end", "    } def", "end", "/StippleFont StippleFont1 definefont pop", "/StippleCharYSize 128 def", "/StippleCharXSize StippleCharYSize def", "/Filledpolygon {", "    gsave", "    /StippleFont findfont StippleCharYSize scalefont setfont", "    /LowY exch def /LowX exch def", "    /HighY exch LowY add def /HighX exch LowX add def", "    Polygon clip", "    /Char exch def", "    /LowY LowY StippleCharYSize div truncate StippleCharYSize mul def", "    /LowX LowX StippleCharXSize div truncate StippleCharXSize mul def", "    /HighY HighY StippleCharYSize div 1 add truncate StippleCharYSize mul def", "    /HighX HighX StippleCharXSize div 1 add truncate StippleCharXSize mul def", "    LowY StippleCharYSize HighY ", "    { LowX exch moveto ", "        LowX StippleCharXSize HighX ", "        { Char show pop ", "        } for ", "    } for", "    grestore", "} def"};
    String[] headerString = new String[]{"/ComStart 92 def", "/ComSub  100 def", "/ComSup  117 def", "/ComNorm 125 def", "/SSSize .70 def", "/SubDy  -.20 def", "/SupDy   .40 def", "/StringShow {", "    /ComMode 0 def", "    /TSize exch def", "    /TString exch def", "    /NormY currentpoint exch pop def", "    TSize scaleFont", "    TString {", "        /CharCode exch def", "        ComMode 1 eq {", "            /ComMode 0 def", "            CharCode ComSub eq {", "                TSize SSSize mul scaleFont", "                currentpoint pop NormY TSize SubDy mul add moveto", "            } if", "            CharCode ComSup eq {", "                TSize SSSize mul scaleFont", "                currentpoint pop NormY TSize SupDy mul add moveto", "            } if", "            CharCode ComNorm eq {", "                TSize scaleFont", "                currentpoint pop NormY moveto", "            } if", "            CharCode ComStart eq {", "                ( ) dup 0 CharCode put show", "            } if", "        }", "        {", "            CharCode ComStart eq {", "                /ComMode 1 def", "            }", "            {", "                ( ) dup 0 CharCode put show", "            } ifelse", "        } ifelse", "    } forall ", "} def", "/StringLength {", "    /ComMode 0 def", "    /StrLen 0 def", "    /TSize exch def", "    /TString exch def", "    TSize scaleFont", "    TString {", "        /CharCode exch def", "        ComMode 1 eq {", "            /ComMode 0 def", "            CharCode ComSub eq {", "                TSize SSSize mul scaleFont", "            } if", "            CharCode ComSup eq {", "                TSize SSSize mul scaleFont", "            } if", "            CharCode ComNorm eq {", "                TSize scaleFont", "            } if", "            CharCode ComStart eq {", "                ( ) dup 0 CharCode put stringwidth pop StrLen add", "                /StrLen exch def", "            } if", "        }", "        {", "            CharCode ComStart eq {", "                /ComMode 1 def", "            }", "            {", "                ( ) dup 0 CharCode put stringwidth pop StrLen add", "                /StrLen exch def", "            } ifelse", "        } ifelse", "    } forall ", "    StrLen 0", "} def", "/Centerstring {", "    dup /TSize exch def", "    dup scaleFont exch dup TSize StringLength", "    pop 3 -1 roll .5 mul", "    exch 5 -1 roll exch 2 div sub", "    exch 4 -1 roll exch 2 div sub", "    moveto TSize StringShow", "} def", "/Topstring {", "    dup /TSize exch def", "    dup scaleFont exch dup TSize StringLength", "    pop 3 -1 roll .5 mul", "    exch 5 -1 roll exch 2 div sub", "    exch 4 -1 roll exch sub", "    moveto TSize StringShow", "} def", "/Botstring {", "    dup /TSize exch def", "    scaleFont dup TSize StringLength pop", "    4 -1 roll exch 2 div sub", "    3 -1 roll moveto TSize StringShow", "} def", "/Leftstring {", "    dup /TSize exch def", "    dup scaleFont .4 mul", "    3 -1 roll exch sub", "    3 -1 roll exch", "    moveto TSize StringShow", "} def", "/Rightstring {", "    dup /TSize exch def", "    dup scaleFont exch dup TSize StringLength", "    pop 3 -1 roll .4 mul", "    exch 5 -1 roll exch sub", "    exch 4 -1 roll exch sub", "    moveto TSize StringShow", "} def", "/Topleftstring {", "    dup /TSize exch def", "    dup scaleFont .5 mul", "    3 -1 roll exch sub", "    3 -1 roll exch", "    moveto TSize StringShow", "} def", "/Toprightstring {", "    dup /TSize exch def", "    dup scaleFont exch dup TSize StringLength", "    pop 3 -1 roll .5 mul", "    exch 5 -1 roll exch sub", "    exch 4 -1 roll exch sub", "    moveto TSize StringShow", "} def", "/Botleftstring {", "    dup /TSize exch def", "    scaleFont 3 1 roll moveto TSize StringShow", "} def", "/Botrightstring {", "    dup /TSize exch def", "    scaleFont dup TSize StringLength", "    pop 4 -1 roll exch", "    sub 3 -1 roll", "    moveto TSize StringShow", "} def", "/Min {", "    dup 3 -1 roll dup", "    3 1 roll gt", "    {exch} if pop", "} def", "/Boxstring {", "    dup /TSize exch def", "    dup scaleFont", "    exch dup TSize StringLength pop", "    3 -1 roll dup", "    6 -1 roll mul", "    3 -1 roll div", "    4 -1 roll", "    Min Min", "    Centerstring", "} def"};

    private PostScript(PostScriptPreferences pp, Cell cell) {
        this.localPrefs = pp;
        this.cell = cell;
    }

    private boolean writeCellToFile(String filePath) {
        if (this.localPrefs.printBounds == null) {
            return true;
        }
        boolean error = false;
        if (this.openTextOutputStream(filePath)) {
            error = true;
        } else {
            if (this.cell.getView().isTextView()) {
                this.printWriter.println("Library: " + this.cell.getLibrary().getName() + "   Cell: " + this.cell.noLibDescribe());
                if (this.localPrefs.includeDateAndVersionInOutput) {
                    this.printWriter.println("   Created: " + TextUtils.formatDate(this.cell.getCreationDate()) + "   Revised: " + TextUtils.formatDate(this.cell.getRevisionDate()));
                }
                this.printWriter.println("\n\n");
                Variable var = this.cell.getVar(Cell.CELL_TEXT_KEY);
                if (var != null) {
                    String[] strings = (String[])var.getObject();
                    for (int i = 0; i < strings.length; ++i) {
                        this.printWriter.println(strings[i]);
                    }
                }
            } else if (this.start()) {
                this.scanCircuit();
                this.done();
            }
            if (this.closeTextOutputStream()) {
                error = true;
            }
        }
        if (!error) {
            System.out.println(filePath + " written");
        }
        return error;
    }

    private boolean start() {
        double s;
        double j;
        double i;
        double scale;
        double pageMarginPS;
        this.putHeaderDot = false;
        this.putHeaderLine = false;
        this.putHeaderPolygon = false;
        this.putHeaderFilledPolygon = false;
        this.putHeaderString = false;
        this.psUseColorMerge = false;
        this.psUseColor = false;
        switch (this.localPrefs.printColorMethod) {
            case 1: {
                this.psUseColor = true;
                break;
            }
            case 2: {
                this.psUseColor = true;
                break;
            }
            case 3: {
                this.psUseColorMerge = true;
                this.psUseColor = true;
            }
        }
        double pageWid = this.localPrefs.pageWidth * 75.0;
        double pageHei = this.localPrefs.pageHeight * 75.0;
        double pageMargin = pageMarginPS = this.localPrefs.printMargin * 75.0;
        boolean rotatePlot = false;
        switch (this.localPrefs.printRotation) {
            case 1: {
                rotatePlot = true;
                break;
            }
            case 2: {
                if ((!(pageHei > pageWid) && !this.localPrefs.printForPlotter || !(this.localPrefs.printBounds.getWidth() > this.localPrefs.printBounds.getHeight())) && (!(pageWid > pageHei) || !(this.localPrefs.printBounds.getHeight() > this.localPrefs.printBounds.getWidth()))) break;
                rotatePlot = true;
            }
        }
        if (this.localPrefs.printForPlotter) {
            pageHei = rotatePlot ? pageWid * this.localPrefs.printBounds.getWidth() / this.localPrefs.printBounds.getHeight() : pageWid * this.localPrefs.printBounds.getHeight() / this.localPrefs.printBounds.getWidth();
        }
        if (this.psUseColorMerge && this.localPrefs.override == null) {
            PostScriptColor.psColorPlot(this, this.localPrefs, this.cell, pageWid, pageHei, pageMarginPS);
            return false;
        }
        double cX = this.localPrefs.printBounds.getCenterX();
        double cY = this.localPrefs.printBounds.getCenterY();
        double unitsX = (pageWid - pageMargin * 2.0) * 4.0;
        double unitsY = (pageHei - pageMargin * 2.0) * 4.0;
        if (this.localPrefs.printEncapsulate && (scale = IOTool.getPrintEPSScale(this.cell)) != 0.0) {
            unitsX *= scale;
            unitsY *= scale;
        }
        if (this.localPrefs.printForPlotter) {
            i = unitsX / this.localPrefs.printBounds.getWidth();
            j = unitsX / this.localPrefs.printBounds.getHeight();
        } else {
            i = Math.min(unitsX / this.localPrefs.printBounds.getWidth(), unitsY / this.localPrefs.printBounds.getHeight());
            j = Math.min(unitsX / this.localPrefs.printBounds.getHeight(), unitsY / this.localPrefs.printBounds.getWidth());
        }
        if (rotatePlot) {
            i = j;
        }
        double matrix00 = i;
        double matrix01 = 0.0;
        double matrix10 = 0.0;
        double matrix11 = i;
        double matrix20 = -i * cX + unitsX / 2.0 + pageMarginPS * 4.0;
        double matrix21 = this.localPrefs.printForPlotter ? -i * this.localPrefs.printBounds.getMinY() + pageMarginPS * 4.0 : -i * cY + unitsY / 2.0 + pageMarginPS * 4.0;
        this.matrix = new AffineTransform(matrix00, matrix01, matrix10, matrix11, matrix20, matrix21);
        if (this.localPrefs.printEncapsulate) {
            this.printWriter.println("%!PS-Adobe-2.0 EPSF-2.0");
        } else {
            this.printWriter.println("%!PS-Adobe-1.0");
        }
        this.printWriter.println("%%Title: " + this.cell.describe(false));
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.printWriter.println("%%Creator: Electric VLSI Design System version " + Version.getVersion());
            Date now = new Date();
            this.printWriter.println("%%CreationDate: " + TextUtils.formatDate(now));
        } else {
            this.printWriter.println("%%Creator: Electric VLSI Design System");
        }
        if (this.localPrefs.printEncapsulate) {
            this.printWriter.println("%%Pages: 0");
        } else {
            this.printWriter.println("%%Pages: 1");
        }
        this.emitCopyright("% ", "");
        double bblx = this.localPrefs.printBounds.getMinX();
        double bbhx = this.localPrefs.printBounds.getMaxX();
        double bbly = this.localPrefs.printBounds.getMinY();
        double bbhy = this.localPrefs.printBounds.getMaxY();
        Point2D bbCorner1 = this.psXform(new Point2D.Double(bblx, bbly));
        Point2D bbCorner2 = this.psXform(new Point2D.Double(bbhx, bbhy));
        bblx = bbCorner1.getX();
        bbly = bbCorner1.getY();
        bbhx = bbCorner2.getX();
        bbhy = bbCorner2.getY();
        if (rotatePlot) {
            double t1 = bblx;
            double t2 = bbhx;
            bblx = -bbhy + pageHei * 300.0 / 75.0;
            bbhx = -bbly + pageHei * 300.0 / 75.0;
            bbly = t1 + pageMargin * 2.0 * 300.0 / 75.0;
            bbhy = t2 + pageMargin * 2.0 * 300.0 / 75.0;
        }
        if (bblx > bbhx) {
            s = bblx;
            bblx = bbhx;
            bbhx = s;
        }
        if (bbly > bbhy) {
            s = bbly;
            bbly = bbhy;
            bbhy = s;
        }
        bblx = bblx / 300.0 * 72.0 * (double)(bblx >= 0.0 ? 1 : -1);
        bbly = bbly / 300.0 * 72.0 * (double)(bbly >= 0.0 ? 1 : -1);
        bbhx = bbhx / 300.0 * 72.0 * (double)(bbhx >= 0.0 ? 1 : -1);
        bbhy = bbhy / 300.0 * 72.0 * (double)(bbhy >= 0.0 ? 1 : -1);
        this.printWriter.println("%%BoundingBox: " + (int)(bblx - 1.0) + " " + (int)(bbly - 1.0) + " " + (int)(bbhx + 1.0) + " " + (int)(bbhy + 1.0));
        this.printWriter.println("%%DocumentFonts: Times-Roman");
        this.printWriter.println("%%EndComments");
        if (!this.localPrefs.printEncapsulate) {
            this.printWriter.println("%%Page: 1 1");
        }
        if (this.cell != null) {
            ERectangle bounds = this.cell.getBounds();
            this.printWriter.println("% cell dimensions: " + ((RectangularShape)bounds).getWidth() + " wide x " + ((RectangularShape)bounds).getHeight() + " high (database units)");
            this.printWriter.println("% origin: " + bounds.getMinX() + " " + bounds.getMinY());
        }
        if (this.localPrefs.printEncapsulate) {
            this.printWriter.println("% The EPS header should declare a private dictionary.");
        } else {
            this.printWriter.println("% The non-EPS header does not claim conformance to Adobe-2.0");
            this.printWriter.println("% because the structure may not be exactly correct.");
        }
        this.printWriter.println("%");
        if (this.localPrefs.printForPlotter) {
            this.printWriter.println("<< /PageSize [" + (int)(pageWid * 72.0 / 75.0) + " " + (int)(pageHei * 72.0 / 75.0) + "] >> setpagedevice");
        }
        this.printWriter.println("72 300 div 72 300 div scale");
        this.printWriter.println("/DefaultFont /Times-Roman def");
        this.printWriter.println("/scaleFont {");
        this.printWriter.println("    DefaultFont findfont");
        this.printWriter.println("    exch scalefont setfont} def");
        this.lineWidth = (int)(2.0 * this.localPrefs.printPSLineWidth);
        this.printWriter.println(this.lineWidth + " setlinewidth");
        this.printWriter.println("1 setlinecap");
        if (rotatePlot) {
            if (this.localPrefs.printForPlotter) {
                this.printWriter.println(pageWid / 75.0 + " 300 mul " + (pageHei - pageWid) / 2.0 / 75.0 + " 300 mul translate 90 rotate");
            } else {
                this.printWriter.println((pageHei + pageWid) / 2.0 / 75.0 + " 300 mul " + (pageHei - pageWid) / 2.0 / 75.0 + " 300 mul translate 90 rotate");
            }
        }
        if (this.psUseColor) {
            PolyBase poly = new PolyBase(this.localPrefs.printBounds);
            this.setColor(this.localPrefs.gp.getColor(User.ColorPrefType.BACKGROUND));
            Point2D[] points = poly.getPoints();
            this.putPSHeader(3);
            this.printWriter.print("[");
            for (int k = 0; k < points.length; ++k) {
                if (k != 0) {
                    this.printWriter.print(" ");
                }
                Point2D ps = this.psXform(points[k]);
                this.printWriter.print(TextUtils.formatDouble(ps.getX()) + " " + TextUtils.formatDouble(ps.getY()));
            }
            this.printWriter.println("] Polygon fill");
        }
        this.patternsEmitted = new HashMap<EGraphics, Integer>();
        this.psNumPatternsEmitted = 0;
        return true;
    }

    private void done() {
        if (this.psUseColor) {
            this.printWriter.println("0 0 0 setrgbcolor");
        }
        if (this.localPrefs.wnd != null && this.localPrefs.isGrid) {
            int gridx = (int)this.localPrefs.gridXSpacing;
            int gridy = (int)this.localPrefs.gridYSpacing;
            int lx = (int)this.cell.getBounds().getMinX();
            int ly = (int)this.cell.getBounds().getMinY();
            int hx = (int)this.cell.getBounds().getMaxX();
            int hy = (int)this.cell.getBounds().getMaxY();
            int gridlx = lx / gridx * gridx;
            int gridly = ly / gridy * gridy;
            if (gridlx > lx) {
                gridlx -= (gridlx - lx) / gridx * gridx;
            }
            if (gridly > ly) {
                gridly -= (gridly - ly) / gridy * gridy;
            }
            while (gridlx < lx) {
                gridlx += gridx;
            }
            while (gridly < ly) {
                gridly += gridy;
            }
            double matrix00 = this.matrix.getScaleX();
            double matrix01 = this.matrix.getShearX();
            double matrix10 = this.matrix.getShearY();
            double matrix11 = this.matrix.getScaleY();
            double matrix20 = this.matrix.getTranslateX();
            double matrix21 = this.matrix.getTranslateY();
            this.printWriter.println(gridlx + " " + gridx + " " + hx);
            this.printWriter.println("{");
            this.printWriter.println("    " + gridly + " " + gridy + " " + hy);
            this.printWriter.println("    {");
            this.printWriter.println("        dup 3 -1 roll dup dup");
            this.printWriter.println("        5 1 roll 3 1 roll");
            this.printWriter.println("        " + matrix00 + " mul exch " + matrix10 + " mul add " + matrix20 + " add");
            this.printWriter.println("        3 1 roll");
            this.printWriter.println("        " + matrix01 + " mul exch " + matrix11 + " mul add " + matrix21 + " add");
            this.printWriter.println("        newpath moveto 0 0 rlineto stroke");
            this.printWriter.println("    } for");
            this.printWriter.println("} for");
        }
        PostScriptFrame pf = new PostScriptFrame(this.cell, this);
        pf.renderFrame();
        if (this.localPrefs.plotDates) {
            this.putPSHeader(5);
            this.printWriter.print("0 112 ");
            this.writePSString("Cell: " + this.cell.describe(false));
            this.printWriter.println(" 56 Botleftstring");
            this.printWriter.print("0 56 ");
            this.writePSString("Created: " + TextUtils.formatDate(this.cell.getCreationDate()));
            this.printWriter.println(" 56 Botleftstring");
            this.printWriter.print("0 0 ");
            this.writePSString("Revised: " + TextUtils.formatDate(this.cell.getRevisionDate()));
            this.printWriter.println(" 56 Botleftstring");
        }
        this.printWriter.println("showpage");
        this.printWriter.println("%%Trailer");
    }

    private void scanCircuit() {
        this.lastColor = -1;
        if (this.localPrefs.override != null) {
            for (PolyBase poly : this.localPrefs.override) {
                Point2D[] pts = poly.getPoints();
                for (int i = 0; i < pts.length; ++i) {
                    poly.setPoint(i, pts[i].getX(), this.localPrefs.printBounds.getHeight() - pts[i].getY());
                }
            }
        }
        Job.getUserInterface().startProgressDialog("Writing PostScript", null);
        Job.getUserInterface().setProgressNote("Counting PostScript objects...");
        long totalObjects = this.recurseCircuitLevel(this.cell, DBMath.MATID, true, false, 0L);
        if (this.psUseColor) {
            List<Layer> layerList = this.cell.getTechnology().getLayersSortedByHeight();
            for (Layer layer : layerList) {
                if (this.localPrefs.invisibleLayers.contains(layer)) continue;
                Job.getUserInterface().setProgressNote("Writing layer " + layer.getName() + " (" + totalObjects + " objects...");
                this.currentLayer = layer.getIndex() + 1;
                this.recurseCircuitLevel(this.cell, DBMath.MATID, true, true, totalObjects);
            }
            this.currentLayer = 0;
            Job.getUserInterface().setProgressNote("Writing cell information (" + totalObjects + " objects...");
            this.recurseCircuitLevel(this.cell, DBMath.MATID, true, true, totalObjects);
        } else {
            this.currentLayer = -1;
            Job.getUserInterface().setProgressNote("Found " + totalObjects + " PostScript objects...");
            this.recurseCircuitLevel(this.cell, DBMath.MATID, true, true, totalObjects);
        }
        Job.getUserInterface().stopProgressDialog();
    }

    private int recurseCircuitLevel(Cell cell, AffineTransform trans, boolean topLevel, boolean real, long progressTotal) {
        int numObjects = 0;
        if (this.localPrefs.override != null) {
            for (PolyBase poly : this.localPrefs.override) {
                if (real) {
                    this.psPoly(poly);
                }
                if (progressTotal == 0L || ++numObjects % 100 != 0) continue;
                long pct = (long)(numObjects * 100) / progressTotal;
                Job.getUserInterface().setProgressValue((int)pct);
            }
            return numObjects;
        }
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            AffineTransform subRot = ni.rotateOut();
            subRot.preConcatenate(trans);
            if (!ni.isCellInstance()) {
                if (!topLevel && (ni.isVisInside() || ni.getProto() == Generic.tech().essentialBoundsNode || ni.getProto() == Generic.tech().cellCenterNode)) continue;
                if (real) {
                    PrimitiveNode prim = (PrimitiveNode)ni.getProto();
                    Technology tech = prim.getTechnology();
                    Poly[] polys = tech.getShapeOfNode(ni);
                    for (int i = 0; i < polys.length; ++i) {
                        polys[i].transform(subRot);
                        this.psPoly(polys[i]);
                    }
                }
                if (progressTotal != 0L && ++numObjects % 100 == 0) {
                    long pct = (long)(numObjects * 100) / progressTotal;
                    Job.getUserInterface().setProgressValue((int)pct);
                }
            } else {
                Cell subCell = (Cell)ni.getProto();
                AffineTransform subTrans = ni.translateOut();
                subTrans.preConcatenate(subRot);
                if (!this.localPrefs.expansionState.isExpanded(ni)) {
                    if (real) {
                        ERectangle bounds = subCell.getBounds();
                        Poly poly = new Poly(bounds.getCenterX(), bounds.getCenterY(), ni.getXSize(), ni.getYSize());
                        poly.transform(subTrans);
                        poly.setStyle(Poly.Type.CLOSED);
                        poly.setLayer(null);
                        poly.setGraphicsOverride(blackGraphics);
                        this.psPoly(poly);
                        if (this.localPrefs.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.INSTANCE)) {
                            poly.setStyle(Poly.Type.TEXTBOX);
                            TextDescriptor td = TextDescriptor.getInstanceTextDescriptor().withAbsSize(24);
                            poly.setTextDescriptor(td);
                            poly.setString(ni.getProto().describe(false));
                            this.psPoly(poly);
                        }
                        if (topLevel) {
                            this.showCellPorts(ni, trans, null);
                        }
                    }
                    if (progressTotal != 0L && ++numObjects % 100 == 0) {
                        long pct = (long)(numObjects * 100) / progressTotal;
                        Job.getUserInterface().setProgressValue((int)pct);
                    }
                } else {
                    this.recurseCircuitLevel(subCell, subTrans, false, real, progressTotal);
                    if (topLevel && real) {
                        this.showCellPorts(ni, trans, Color.BLACK);
                    }
                }
            }
            if (real && this.localPrefs.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.NODE)) {
                Poly[] textPolys = ni.getDisplayableVariables(this.localPrefs.wnd, this.localPrefs.gp.isShowTempNames());
                for (int i = 0; i < textPolys.length; ++i) {
                    textPolys[i].transform(subRot);
                    this.psPoly(textPolys[i]);
                }
            }
            if (!topLevel || !this.localPrefs.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.EXPORT)) continue;
            Iterator<Export> eIt = ni.getExports();
            while (eIt.hasNext()) {
                Export e = eIt.next();
                if (real) {
                    Poly poly = e.getNamePoly();
                    if (this.localPrefs.gp.exportDisplayLevel == 2) {
                        this.drawCross(poly.getCenterX(), poly.getCenterY(), false);
                    } else {
                        if (this.localPrefs.gp.exportDisplayLevel == 1) {
                            String portName = e.getShortName();
                            poly.setString(portName);
                        }
                        TextDescriptor descript = poly.getTextDescriptor();
                        Poly.Type style = descript.getPos().getPolyType();
                        style = Poly.rotateType(style, ni);
                        poly.setStyle(style);
                        this.psPoly(poly);
                    }
                    Rectangle2D rect = (Rectangle2D)poly.getBounds2D().clone();
                    Poly[] polys = e.getDisplayableVariables(rect, this.localPrefs.wnd, true, this.localPrefs.gp.isShowTempNames());
                    for (int i = 0; i < polys.length; ++i) {
                        this.psPoly(polys[i]);
                    }
                }
                if (progressTotal == 0L || ++numObjects % 100 != 0) continue;
                long pct = (long)(numObjects * 100) / progressTotal;
                Job.getUserInterface().setProgressValue((int)pct);
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (real) {
                Technology tech = ai.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfArc(ai);
                for (int i = 0; i < polys.length; ++i) {
                    polys[i].transform(trans);
                    this.psPoly(polys[i]);
                }
                if (topLevel && this.localPrefs.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.ARC)) {
                    Poly[] textPolys = ai.getDisplayableVariables(this.localPrefs.wnd, this.localPrefs.gp.isShowTempNames());
                    for (int i = 0; i < textPolys.length; ++i) {
                        textPolys[i].transform(trans);
                        this.psPoly(textPolys[i]);
                    }
                }
            }
            if (progressTotal == 0L || ++numObjects % 100 != 0) continue;
            long pct = (long)(numObjects * 100) / progressTotal;
            Job.getUserInterface().setProgressValue((int)pct);
        }
        if (topLevel && real && this.localPrefs.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.CELL)) {
            Rectangle2D.Double CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            Poly[] polys = cell.getDisplayableVariables(CENTERRECT, this.localPrefs.wnd, true, this.localPrefs.gp.isShowTempNames());
            for (int i = 0; i < polys.length; ++i) {
                this.psPoly(polys[i]);
            }
        }
        return numObjects;
    }

    private void showCellPorts(NodeInst ni, AffineTransform trans, Color col) {
        PortInst pi;
        int numPorts = ni.getProto().getNumPorts();
        boolean[] shownPorts = new boolean[numPorts];
        Iterator<Object> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            pi = con.getPortInst();
            shownPorts[pi.getPortIndex()] = true;
        }
        it = ni.getExports();
        while (it.hasNext()) {
            Export exp = (Export)it.next();
            pi = exp.getOriginalPort();
            shownPorts[pi.getPortIndex()] = true;
        }
        for (int i = 0; i < numPorts; ++i) {
            Export pp;
            Poly portPoly;
            if (shownPorts[i] || (portPoly = ni.getShapeOfPort(pp = (Export)ni.getProto().getPort(i))) == null) continue;
            portPoly.transform(trans);
            Color portColor = col;
            if (portColor == null) {
                portColor = pp.getBasePort().getPortColor(this.localPrefs.gp);
            }
            this.setColor(portColor);
            if (this.localPrefs.gp.portDisplayLevel == 2) {
                this.drawCross(portPoly.getCenterX(), portPoly.getCenterY(), false);
                continue;
            }
            if (!this.localPrefs.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.PORT)) continue;
            TextDescriptor descript = portPoly.getTextDescriptor();
            if (descript == null) {
                descript = AbstractTextDescriptor.TextType.EXPORT.getFactoryTextDescriptor();
            }
            TextDescriptor portDescript = pp.getTextDescriptor(Export.EXPORT_NAME).withColorIndex(descript.getColorIndex());
            Poly.Type type = descript.getPos().getPolyType();
            portPoly.setStyle(type);
            String portName = pp.getName();
            if (this.localPrefs.gp.portDisplayLevel == 1) {
                portName = pp.getShortName();
            }
            portPoly.setString(portName);
            portPoly.setTextDescriptor(portDescript);
            this.psText(portPoly);
        }
    }

    public static boolean syncAll() {
        boolean syncOther = false;
        Iterator<Library> lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = lIt.next();
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                String fileName;
                Cell aCell = cIt.next();
                Variable var = aCell.getVar(IOTool.POSTSCRIPT_FILENAME);
                if (var == null || (fileName = (String)var.getObject()).trim().length() <= 0) continue;
                syncOther = true;
                break;
            }
            if (!syncOther) continue;
            break;
        }
        if (syncOther) {
            String[] options = new String[]{"Yes", "No"};
            int ret = Job.getUserInterface().askForChoice("Would you like to synchronize all PostScript drawings?", "Synchronize EPS files", options, options[1]);
            if (ret == 1) {
                syncOther = false;
            }
        }
        if (syncOther) {
            PostScript.synchronizeEPSFiles();
            return true;
        }
        return false;
    }

    private static boolean synchronizeEPSFiles() {
        PostScriptPreferences psp = new PostScriptPreferences(false, null, null);
        int numSyncs = 0;
        Iterator<Library> lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library oLib = lIt.next();
            Iterator<Cell> cIt = oLib.getCells();
            while (cIt.hasNext()) {
                Date lastChangeDate;
                Date lastSavedDate;
                Cell oCell = cIt.next();
                String syncFileName = IOTool.getPrintEPSSynchronizeFile(oCell);
                if (syncFileName.length() == 0 || (lastSavedDate = IOTool.getPrintEPSSavedDate(oCell)) != null && lastSavedDate.after(lastChangeDate = oCell.getRevisionDate())) continue;
                PostScript out = new PostScript(psp, oCell);
                boolean err2 = out.writeCellToFile(syncFileName);
                if (err2) {
                    return true;
                }
                IOTool.setPrintEPSSavedDate(oCell, new Date());
                ++numSyncs;
            }
        }
        if (numSyncs == 0) {
            System.out.println("No PostScript files needed to be written");
        }
        return false;
    }

    private void setColor(Color col) {
        if (this.psUseColor && col.getRGB() != this.lastColor) {
            this.lastColor = col.getRGB();
            this.printWriter.println((float)col.getRed() / 255.0f + " " + (float)col.getGreen() / 255.0f + " " + (float)col.getBlue() / 255.0f + " setrgbcolor");
        }
    }

    private void psPoly(PolyBase poly) {
        Layer layer = poly.getLayer();
        EGraphics gra = null;
        int index = 0;
        Color col = Color.BLACK;
        Technology tech = this.cell.getTechnology();
        if (layer != null) {
            tech = layer.getTechnology();
            index = layer.getIndex();
            if (this.localPrefs.invisibleLayers.contains(layer)) {
                return;
            }
            if (poly instanceof Poly) {
                gra = ((Poly)poly).getGraphicsOverride();
            }
            if (gra == null) {
                gra = this.localPrefs.gp.getGraphics(layer);
            }
            col = gra.getColor();
        }
        if (this.currentLayer >= 0 && (this.currentLayer == 0 ? tech == this.cell.getTechnology() : tech != this.cell.getTechnology() || this.currentLayer - 1 != index)) {
            return;
        }
        this.setColor(col);
        Poly.Type type = poly.getStyle();
        Point2D[] points = poly.getPoints();
        if (type == Poly.Type.FILLED) {
            Rectangle2D polyBox = poly.getBox();
            if (polyBox != null) {
                if (polyBox.getWidth() == 0.0) {
                    if (polyBox.getHeight() == 0.0) {
                        this.psDot(new Point2D.Double(polyBox.getCenterX(), polyBox.getCenterY()));
                    } else {
                        this.psLine(new Point2D.Double(polyBox.getCenterX(), polyBox.getMinY()), new Point2D.Double(polyBox.getCenterX(), polyBox.getMaxY()), 0);
                    }
                    return;
                }
                if (polyBox.getHeight() == 0.0) {
                    this.psLine(new Point2D.Double(polyBox.getMinX(), polyBox.getCenterY()), new Point2D.Double(polyBox.getMaxX(), polyBox.getCenterY()), 0);
                    return;
                }
                this.psPolygon(poly);
                return;
            }
            if (points.length == 1) {
                this.psDot(points[0]);
                return;
            }
            if (points.length == 2) {
                this.psLine(points[0], points[1], 0);
                return;
            }
            this.psPolygon(poly);
            return;
        }
        if (type == Poly.Type.CLOSED) {
            Point2D lastPt = points[points.length - 1];
            for (int k = 0; k < points.length; ++k) {
                this.psLine(lastPt, points[k], 0);
                lastPt = points[k];
            }
            return;
        }
        if (type == Poly.Type.OPENED || type == Poly.Type.OPENEDT1 || type == Poly.Type.OPENEDT2 || type == Poly.Type.OPENEDT3) {
            int lineType = 0;
            if (type == Poly.Type.OPENEDT1) {
                lineType = 1;
            } else if (type == Poly.Type.OPENEDT2) {
                lineType = 2;
            } else if (type == Poly.Type.OPENEDT3) {
                lineType = 3;
            }
            for (int k = 1; k < points.length; ++k) {
                this.psLine(points[k - 1], points[k], lineType);
            }
            return;
        }
        if (type == Poly.Type.VECTORS) {
            for (int k = 0; k < points.length; k += 2) {
                this.psLine(points[k], points[k + 1], 0);
            }
            return;
        }
        if (type == Poly.Type.CROSS || type == Poly.Type.BIGCROSS) {
            double x2 = poly.getCenterX();
            double y = poly.getCenterY();
            this.drawCross(x2, y, type == Poly.Type.BIGCROSS);
            return;
        }
        if (type == Poly.Type.CROSSED) {
            Rectangle2D bounds = poly.getBounds2D();
            this.psLine(new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), 0);
            this.psLine(new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), 0);
            this.psLine(new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), 0);
            this.psLine(new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), 0);
            this.psLine(new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), 0);
            this.psLine(new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), 0);
            return;
        }
        if (type == Poly.Type.DISC) {
            this.psDisc(points[0], points[1]);
            type = Poly.Type.CIRCLE;
        }
        if (type == Poly.Type.CIRCLE || type == Poly.Type.THICKCIRCLE) {
            this.psCircle(points[0], points[1]);
            return;
        }
        if (type == Poly.Type.CIRCLEARC || type == Poly.Type.THICKCIRCLEARC) {
            this.psArc(points[0], points[1], points[2]);
            return;
        }
        this.psText((Poly)poly);
    }

    private void drawCross(double x2, double y, boolean bigCross) {
        double amount = 0.25;
        if (bigCross) {
            amount = 0.5;
        }
        this.psLine(new Point2D.Double(x2 - amount, y), new Point2D.Double(x2 + amount, y), 0);
        this.psLine(new Point2D.Double(x2, y + amount), new Point2D.Double(x2, y - amount), 0);
    }

    private void psDot(Point2D pt) {
        Point2D ps = this.psXform(pt);
        this.putPSHeader(1);
        this.printWriter.println(TextUtils.formatDouble(ps.getX()) + " " + TextUtils.formatDouble(ps.getY()) + " Putdot");
    }

    private void psLine(Point2D from2, Point2D to2, int pattern) {
        Point2D pt1 = this.psXform(from2);
        Point2D pt2 = this.psXform(to2);
        this.putPSHeader(2);
        int i = 2;
        switch (pattern) {
            case 0: {
                this.printWriter.println(TextUtils.formatDouble(pt1.getX()) + " " + TextUtils.formatDouble(pt1.getY()) + " " + TextUtils.formatDouble(pt2.getX()) + " " + TextUtils.formatDouble(pt2.getY()) + " Drawline");
                break;
            }
            case 1: {
                this.printWriter.print("[" + i + " " + i * 3 + "] 0 setdash ");
                this.printWriter.println(TextUtils.formatDouble(pt1.getX()) + " " + TextUtils.formatDouble(pt1.getY()) + " " + TextUtils.formatDouble(pt2.getX()) + " " + TextUtils.formatDouble(pt2.getY()) + " Drawline");
                this.printWriter.println(" [] 0 setdash");
                break;
            }
            case 2: {
                this.printWriter.print("[" + i * 6 + " " + i * 3 + "] 0 setdash ");
                this.printWriter.println(TextUtils.formatDouble(pt1.getX()) + " " + TextUtils.formatDouble(pt1.getY()) + " " + TextUtils.formatDouble(pt2.getX()) + " " + TextUtils.formatDouble(pt2.getY()) + " Drawline");
                this.printWriter.println(" [] 0 setdash");
                break;
            }
            case 3: {
                this.printWriter.print(this.lineWidth * 2 + " setlinewidth ");
                this.printWriter.println(TextUtils.formatDouble(pt1.getX()) + " " + TextUtils.formatDouble(pt1.getY()) + " " + TextUtils.formatDouble(pt2.getX()) + " " + TextUtils.formatDouble(pt2.getY()) + " Drawline");
                this.printWriter.println(this.lineWidth + " setlinewidth");
            }
        }
    }

    private void psArc(Point2D center, Point2D pt1, Point2D pt2) {
        Point2D pc = this.psXform(center);
        Point2D ps1 = this.psXform(pt1);
        Point2D ps2 = this.psXform(pt2);
        double radius = pc.distance(ps1);
        int startAngle = (DBMath.figureAngle(pc, ps2) + 5) / 10;
        int endAngle = (DBMath.figureAngle(pc, ps1) + 5) / 10;
        this.printWriter.println("newpath " + TextUtils.formatDouble(pc.getX()) + " " + TextUtils.formatDouble(pc.getY()) + " " + radius + " " + startAngle + " " + endAngle + " arc stroke");
    }

    private void psCircle(Point2D center, Point2D pt) {
        Point2D pc = this.psXform(center);
        Point2D ps = this.psXform(pt);
        double radius = pc.distance(ps);
        this.printWriter.println("newpath " + TextUtils.formatDouble(pc.getX()) + " " + TextUtils.formatDouble(pc.getY()) + " " + radius + " 0 360 arc stroke");
    }

    private void psDisc(Point2D center, Point2D pt) {
        Point2D pc = this.psXform(center);
        Point2D ps = this.psXform(pt);
        double radius = pc.distance(ps);
        this.printWriter.println("newpath " + TextUtils.formatDouble(pc.getX()) + " " + TextUtils.formatDouble(pc.getY()) + " " + radius + " 0 360 arc fill");
    }

    private void psPolygon(PolyBase poly) {
        double ly;
        double lx;
        boolean stipplePattern;
        Point2D[] points = poly.getPoints();
        if (points.length == 0) {
            return;
        }
        EGraphics desc = null;
        if (poly instanceof Poly) {
            desc = ((Poly)poly).getGraphicsOverride();
        }
        if (desc == null) {
            desc = this.localPrefs.gp.getGraphics(poly.getLayer());
        }
        if (stipplePattern = desc.isPatternedOnPrinter()) {
            int[] pattern = desc.getPattern();
            boolean solid = true;
            for (int i = 0; i < 8; ++i) {
                if (pattern[i] == 65535) continue;
                solid = false;
                break;
            }
            if (solid) {
                stipplePattern = false;
            }
        }
        if (!stipplePattern) {
            this.putPSHeader(3);
            this.printWriter.print("[");
            for (int i = 0; i < points.length; ++i) {
                if (i != 0) {
                    this.printWriter.print(" ");
                }
                Point2D ps = this.psXform(points[i]);
                this.printWriter.print(TextUtils.formatDouble(ps.getX()) + " " + TextUtils.formatDouble(ps.getY()));
            }
            this.printWriter.println("] Polygon fill");
            return;
        }
        this.putPSHeader(3);
        this.putPSHeader(4);
        this.printWriter.print("(" + this.psPattern(desc) + ") [");
        Point2D ps = this.psXform(points[0]);
        double hx = lx = ps.getX();
        double hy = ly = ps.getY();
        for (int i = 0; i < points.length; ++i) {
            if (i != 0) {
                this.printWriter.print(" ");
            }
            Point2D psi = this.psXform(points[i]);
            this.printWriter.print(psi.getX() + " " + psi.getY());
            if (psi.getX() < lx) {
                lx = psi.getX();
            }
            if (psi.getX() > hx) {
                hx = psi.getX();
            }
            if (psi.getY() < ly) {
                ly = psi.getY();
            }
            if (!(psi.getY() > hy)) continue;
            hy = psi.getY();
        }
        this.printWriter.println("] " + TextUtils.formatDouble(hx - lx + 1.0) + " " + TextUtils.formatDouble(hy - ly + 1.0) + " " + TextUtils.formatDouble(lx) + " " + TextUtils.formatDouble(ly) + " Filledpolygon");
    }

    private void psText(Poly poly) {
        AbstractTextDescriptor.ActiveFont af;
        Color full;
        Poly.Type style = poly.getStyle();
        TextDescriptor td = poly.getTextDescriptor();
        if (td == null) {
            return;
        }
        int size2 = (int)(td.getTrueSize(this.localPrefs.wnd) * 0.75 * 4.0);
        Rectangle2D bounds = poly.getBounds2D();
        if (size2 <= 0) {
            return;
        }
        String text2 = poly.getString().trim();
        if (text2.length() == 0) {
            return;
        }
        Point2D psL = this.psXform(new Point2D.Double(bounds.getMinX(), bounds.getMinY()));
        Point2D psH = this.psXform(new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()));
        double cX = (psL.getX() + psH.getX()) / 2.0;
        double cY = (psL.getY() + psH.getY()) / 2.0;
        double sX = Math.abs(psH.getX() - psL.getX());
        double sY = Math.abs(psH.getY() - psL.getY());
        this.putPSHeader(5);
        int index = td.getColorIndex();
        if (index == 0) {
            full = this.localPrefs.gp.getColor(User.ColorPrefType.TEXT);
        } else {
            Color[] map2 = this.localPrefs.gp.getColorMap(this.cell.getTechnology());
            full = EGraphics.getColorFromIndex(index, map2);
        }
        this.setColor(full);
        boolean changedFont = false;
        String faceName = null;
        int faceNumber = td.getFace();
        if (faceNumber != 0 && (af = AbstractTextDescriptor.ActiveFont.findActiveFont(faceNumber)) != null) {
            faceName = af.getName();
        }
        if (faceName != null) {
            String fixedFaceName = faceName.replace(' ', '-');
            this.printWriter.println("/DefaultFont /" + fixedFaceName + " def");
            changedFont = true;
        } else if (td.isItalic()) {
            if (td.isBold()) {
                this.printWriter.println("/DefaultFont /Times-BoldItalic def");
                changedFont = true;
            } else {
                this.printWriter.println("/DefaultFont /Times-Italic def");
                changedFont = true;
            }
        } else if (td.isBold()) {
            this.printWriter.println("/DefaultFont /Times-Bold def");
            changedFont = true;
        }
        if (poly.getStyle() == Poly.Type.TEXTBOX) {
            this.printWriter.print(TextUtils.formatDouble(cX) + " " + TextUtils.formatDouble(cY) + " " + TextUtils.formatDouble(sX) + " " + TextUtils.formatDouble(sY) + " ");
            this.writePSString(text2);
            this.printWriter.println(" " + size2 + " Boxstring");
        } else {
            String opName = null;
            double x2 = 0.0;
            double y = 0.0;
            if (style == Poly.Type.TEXTCENT) {
                x2 = cX;
                y = cY;
                opName = "Centerstring";
            } else if (style == Poly.Type.TEXTTOP) {
                x2 = cX;
                y = psH.getY();
                opName = "Topstring";
            } else if (style == Poly.Type.TEXTBOT) {
                x2 = cX;
                y = psL.getY();
                opName = "Botstring";
            } else if (style == Poly.Type.TEXTLEFT) {
                x2 = psL.getX();
                y = cY;
                opName = "Leftstring";
            } else if (style == Poly.Type.TEXTRIGHT) {
                x2 = psH.getX();
                y = cY;
                opName = "Rightstring";
            } else if (style == Poly.Type.TEXTTOPLEFT) {
                x2 = psL.getX();
                y = psH.getY();
                opName = "Topleftstring";
            } else if (style == Poly.Type.TEXTTOPRIGHT) {
                x2 = psH.getX();
                y = psH.getY();
                opName = "Toprightstring";
            } else if (style == Poly.Type.TEXTBOTLEFT) {
                x2 = psL.getX();
                y = psL.getY();
                opName = "Botleftstring";
            } else if (style == Poly.Type.TEXTBOTRIGHT) {
                x2 = psH.getX();
                y = psL.getY();
                opName = "Botrightstring";
            }
            int xoff = (int)x2;
            int yoff = (int)y;
            double descenderoffset = size2 / 12;
            AbstractTextDescriptor.Rotation rot = td.getRotation();
            if (rot == AbstractTextDescriptor.Rotation.ROT0) {
                y += descenderoffset;
            } else if (rot == AbstractTextDescriptor.Rotation.ROT90) {
                x2 -= descenderoffset;
            } else if (rot == AbstractTextDescriptor.Rotation.ROT180) {
                y -= descenderoffset;
            } else if (rot == AbstractTextDescriptor.Rotation.ROT270) {
                x2 += descenderoffset;
            }
            if (rot != AbstractTextDescriptor.Rotation.ROT0) {
                if (rot == AbstractTextDescriptor.Rotation.ROT90 || rot == AbstractTextDescriptor.Rotation.ROT270) {
                    if (style == Poly.Type.TEXTTOP) {
                        opName = "Rightstring";
                    } else if (style == Poly.Type.TEXTBOT) {
                        opName = "Leftstring";
                    } else if (style == Poly.Type.TEXTLEFT) {
                        opName = "Botstring";
                    } else if (style == Poly.Type.TEXTRIGHT) {
                        opName = "Topstring";
                    } else if (style == Poly.Type.TEXTTOPLEFT) {
                        opName = "Botrightstring";
                    } else if (style == Poly.Type.TEXTBOTRIGHT) {
                        opName = "Topleftstring";
                    }
                }
                y = 0.0;
                x2 = 0.0;
                if (rot == AbstractTextDescriptor.Rotation.ROT90) {
                    this.printWriter.println(xoff + " " + yoff + " translate 90 rotate");
                } else if (rot == AbstractTextDescriptor.Rotation.ROT180) {
                    this.printWriter.println(xoff + " " + yoff + " translate 180 rotate");
                } else if (rot == AbstractTextDescriptor.Rotation.ROT270) {
                    this.printWriter.println(xoff + " " + yoff + " translate 270 rotate");
                }
            }
            this.printWriter.print(TextUtils.formatDouble(x2) + " " + TextUtils.formatDouble(y) + " ");
            this.writePSString(text2);
            this.printWriter.println(" " + size2 + " " + opName);
            if (rot != AbstractTextDescriptor.Rotation.ROT0) {
                if (rot == AbstractTextDescriptor.Rotation.ROT90) {
                    this.printWriter.println("-90 rotate " + -xoff + " " + -yoff + " translate");
                } else if (rot == AbstractTextDescriptor.Rotation.ROT180) {
                    this.printWriter.println("-180 rotate " + -xoff + " " + -yoff + " translate");
                } else if (rot == AbstractTextDescriptor.Rotation.ROT270) {
                    this.printWriter.println("-270 rotate " + -xoff + " " + -yoff + " translate");
                }
            }
        }
        if (changedFont) {
            this.printWriter.println("/DefaultFont /Times-Roman def");
        }
    }

    private void putPSHeader(int which) {
        switch (which) {
            case 1: {
                if (this.putHeaderDot) {
                    return;
                }
                this.putHeaderDot = true;
                for (int i = 0; i < this.headerDot.length; ++i) {
                    this.printWriter.println(this.headerDot[i]);
                }
                break;
            }
            case 2: {
                if (this.putHeaderLine) {
                    return;
                }
                this.putHeaderLine = true;
                for (int i = 0; i < this.headerLine.length; ++i) {
                    this.printWriter.println(this.headerLine[i]);
                }
                break;
            }
            case 3: {
                if (this.putHeaderPolygon) {
                    return;
                }
                this.putHeaderPolygon = true;
                for (int i = 0; i < this.headerPolygon.length; ++i) {
                    this.printWriter.println(this.headerPolygon[i]);
                }
                break;
            }
            case 4: {
                if (this.putHeaderFilledPolygon) {
                    return;
                }
                this.putHeaderFilledPolygon = true;
                for (int i = 0; i < this.headerFilledPolygon.length; ++i) {
                    this.printWriter.println(this.headerFilledPolygon[i]);
                }
                break;
            }
            case 5: {
                if (this.putHeaderString) {
                    return;
                }
                this.putHeaderString = true;
                for (int i = 0; i < this.headerString.length; ++i) {
                    this.printWriter.println(this.headerString[i]);
                }
                break;
            }
        }
    }

    private char psPattern(EGraphics col) {
        Integer index = this.patternsEmitted.get(col);
        if (index != null) {
            return (char)(65 + index);
        }
        this.patternsEmitted.put(col, new Integer(this.psNumPatternsEmitted));
        int[] raster = col.getPattern();
        char indexChar = (char)(this.psNumPatternsEmitted + 65);
        ++this.psNumPatternsEmitted;
        this.printWriter.println("StippleFont1 begin");
        this.printWriter.println("    Encoding (" + indexChar + ") 0 get /Stipple" + indexChar + " put");
        this.printWriter.println("    CharacterDefs /Stipple" + indexChar + " {");
        this.printWriter.println("        128 128 true [128 0 0 -128 0 128]");
        this.printWriter.println("        { <");
        for (int i = 0; i < 8; ++i) {
            int k;
            int bl = raster[i] & 0xFF;
            int bh = (raster[i] & 0xFF00) >> 8;
            int bld = 0;
            int bhd = 0;
            for (k = 0; k < 8; ++k) {
                bld <<= 1;
                bld |= bl & 1;
                bld <<= 1;
                bld |= bl & 1;
                bl >>= 1;
                bhd <<= 1;
                bhd |= bh & 1;
                bhd <<= 1;
                bhd |= bh & 1;
                bh >>= 1;
            }
            for (k = 0; k < 2; ++k) {
                this.printWriter.print("            ");
                for (int j = 0; j < 4; ++j) {
                    this.printWriter.print((bhd & 0xFFFF) + " " + (bld & 0xFFFF) + " ");
                }
                this.printWriter.println();
            }
        }
        this.printWriter.println("        > } imagemask");
        this.printWriter.println("    } put");
        this.printWriter.println("end");
        return indexChar;
    }

    private Point2D psXform(Point2D pt) {
        Point2D.Double result2 = new Point2D.Double();
        this.matrix.transform(pt, result2);
        return result2;
    }

    public void writePSString(String str) {
        this.printWriter.print("(");
        for (int i = 0; i < str.length(); ++i) {
            char ca = str.charAt(i);
            if (ca == '(' || ca == ')' || ca == '\\') {
                this.printWriter.print("\\");
            }
            this.printWriter.print(ca);
        }
        this.printWriter.print(")");
    }

    private static class PostScriptFrame
    extends Cell.FrameDescription {
        private PostScript writer;

        public PostScriptFrame(Cell cell, PostScript writer) {
            super(cell, 0);
            this.writer = writer;
        }

        @Override
        public void showFrameLine(Point2D from2, Point2D to2) {
            this.writer.psLine(from2, to2, 0);
        }

        @Override
        public void showFrameText(Point2D ctr, double size2, double maxWid, double maxHei, String string2) {
            Poly poly = null;
            if (maxWid > 0.0 && maxHei > 0.0) {
                poly = new Poly(ctr.getX(), ctr.getY(), maxWid, maxHei);
                poly.setStyle(Poly.Type.TEXTBOX);
            } else {
                Point2D[] points = new Point2D[]{ctr};
                poly = new Poly(points);
                poly.setStyle(Poly.Type.TEXTCENT);
            }
            poly.setString(string2);
            TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withRelSize(size2 * 0.75);
            poly.setTextDescriptor(td);
            this.writer.psText(poly);
        }
    }

    public static class PostScriptPreferences
    extends Output.OutputPreferences {
        List<PolyBase> override;
        boolean plotDates = IOTool.isFactoryPlotDate();
        int printColorMethod = IOTool.getFactoryPrintColorMethod();
        boolean printForPlotter = IOTool.isFactoryPrintForPlotter();
        boolean printEncapsulate = IOTool.isFactoryPrintEncapsulated();
        double pageWidth = IOTool.getFactoryPrintWidth();
        double pageHeight = IOTool.getFactoryPrintHeight();
        double printMargin = IOTool.getFactoryPrintMargin();
        int printRotation = IOTool.getFactoryPrintRotation();
        double printPSLineWidth = IOTool.getFactoryPrintPSLineWidth();
        GraphicsPreferences gp;
        EditWindow0.EditWindowSmall wnd;
        ERectangle printBounds;
        Set<Layer> invisibleLayers = new HashSet<Layer>();
        boolean isGrid = false;
        double gridXSpacing;
        double gridYSpacing;
        boolean showTempNames;
        NodeInst.ExpansionState expansionState;

        PostScriptPreferences(boolean factory, List<PolyBase> override, Cell cell) {
            super(factory);
            this.override = override;
            this.gp = new GraphicsPreferences(factory);
            LayerVisibility lv = new LayerVisibility(factory);
            for (Technology tech : TechPool.getThreadTechPool().values()) {
                Iterator<Layer> it = tech.getLayers();
                while (it.hasNext()) {
                    Layer layer = it.next();
                    if (lv.isVisible(layer)) continue;
                    this.invisibleLayers.add(layer);
                }
            }
            if (factory) {
                this.expansionState = new NodeInst.ExpansionState(null, 1);
            } else {
                this.expansionState = new NodeInst.ExpansionState(cell, 2);
                this.fillPrefs();
            }
        }

        private void fillPrefs() {
            this.plotDates = IOTool.isPlotDate();
            this.printColorMethod = IOTool.getPrintColorMethod();
            this.printForPlotter = IOTool.isPrintForPlotter();
            this.printEncapsulate = IOTool.isPrintEncapsulated();
            this.pageWidth = IOTool.getPrintWidth();
            this.pageHeight = IOTool.getPrintHeight();
            this.printMargin = IOTool.getPrintMargin();
            this.printRotation = IOTool.getPrintRotation();
            this.printPSLineWidth = IOTool.getPrintPSLineWidth();
            UserInterface ui = Job.getUserInterface();
            EditWindow_ localWnd = ui.getCurrentEditWindow_();
            this.wnd = new EditWindow0.EditWindowSmall(localWnd);
            this.isGrid = localWnd.isGrid();
            this.gridXSpacing = localWnd.getGridXSpacing();
            this.gridYSpacing = localWnd.getGridYSpacing();
            this.printBounds = null;
            if (this.override != null) {
                double lX = 0.0;
                double hX = 0.0;
                double lY = 0.0;
                double hY = 0.0;
                boolean first = true;
                for (PolyBase poly : this.override) {
                    Point2D[] points = poly.getPoints();
                    for (int i = 0; i < points.length; ++i) {
                        double x2 = points[i].getX();
                        double y = points[i].getY();
                        if (first) {
                            first = false;
                            lX = hX = x2;
                            lY = hY = y;
                            continue;
                        }
                        if (x2 < lX) {
                            lX = x2;
                        }
                        if (x2 > hX) {
                            hX = x2;
                        }
                        if (y < lY) {
                            lY = y;
                        }
                        if (!(y > hY)) continue;
                        hY = y;
                    }
                }
                this.printBounds = ERectangle.fromLambda(lX, lY, hX - lX, hY - lY);
            } else {
                Cell cell = localWnd.getCell();
                this.printBounds = ERectangle.fromLambda(Output.getAreaToPrint(cell, false, localWnd));
            }
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            PostScript out = new PostScript(this, cell);
            out.writeCellToFile(filePath);
            return out.finishWrite();
        }
    }
}

