/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io;

import java.util.ArrayList;
import java.util.List;

public class CSVFile {
    private static final Character NEWLINE = Character.valueOf('\n');
    private List<String> header;
    private List<List<String>> lines;
    private Character separator;

    public CSVFile(Character separator) {
        this.separator = separator;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public void setHeader(List<String> header) {
        this.header = header;
    }

    public List<List<String>> getLines() {
        return this.lines;
    }

    public void addLine(List<String> line) {
        if (this.lines == null) {
            this.lines = new ArrayList<List<String>>();
        }
        this.lines.add(line);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.header != null) {
            builder.append(this.createLineEntry(this.header));
            builder.append(NEWLINE);
        }
        if (this.lines != null) {
            for (List<String> line : this.lines) {
                builder.append(this.createLineEntry(line));
                builder.append(NEWLINE);
            }
        }
        return builder.substring(0, builder.length());
    }

    private String createLineEntry(List<String> line) {
        StringBuilder builder = new StringBuilder();
        for (String elem2 : line) {
            builder.append(elem2);
            builder.append(this.separator);
        }
        return builder.substring(0, builder.length() - 1);
    }
}

