/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightEOBJ;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HighlightArea
extends Highlight {
    protected Rectangle2D bounds = new Rectangle2D.Double();

    HighlightArea(Cell c, Rectangle2D area) {
        super(c);
        this.bounds.setRect(area);
    }

    @Override
    public void showInternalHighlight(EditWindow wnd, Graphics g, int highOffX, int highOffY, boolean onlyHighlight, boolean setConnected) {
        Point2D[] points = new Point2D.Double[]{new Point2D.Double(this.bounds.getMinX(), this.bounds.getMinY()), new Point2D.Double(this.bounds.getMinX(), this.bounds.getMaxY()), new Point2D.Double(this.bounds.getMaxX(), this.bounds.getMaxY()), new Point2D.Double(this.bounds.getMaxX(), this.bounds.getMinY()), new Point2D.Double(this.bounds.getMinX(), this.bounds.getMinY())};
        HighlightArea.drawOutlineFromPoints(wnd, g, points, highOffX, highOffY, false, false);
    }

    @Override
    void getHighlightedEObjs(Highlighter highlighter, List<Geometric> list2, boolean wantNodes, boolean wantArcs) {
        List<Highlight> inArea = Highlighter.findAllInArea(highlighter, this.cell, false, false, false, false, false, this.bounds, null);
        for (Highlight ah : inArea) {
            if (!(ah instanceof HighlightEOBJ)) continue;
            ElectricObject eobj = ((HighlightEOBJ)ah).eobj;
            if (eobj instanceof ArcInst) {
                if (!wantArcs) continue;
                list2.add((ArcInst)eobj);
                continue;
            }
            if (eobj instanceof NodeInst) {
                if (!wantNodes) continue;
                list2.add((NodeInst)eobj);
                continue;
            }
            if (!(eobj instanceof PortInst) || !wantNodes) continue;
            list2.add(((PortInst)eobj).getNodeInst());
        }
    }

    @Override
    void getHighlightedNodes(Highlighter highlighter, List<NodeInst> list2) {
        List<Highlight> inArea = Highlighter.findAllInArea(highlighter, this.cell, false, false, false, false, false, this.bounds, null);
        for (Highlight ah : inArea) {
            if (!(ah instanceof HighlightEOBJ)) continue;
            ElectricObject eobj = ((HighlightEOBJ)ah).eobj;
            if (eobj instanceof NodeInst) {
                list2.add((NodeInst)eobj);
                continue;
            }
            if (!(eobj instanceof PortInst)) continue;
            list2.add(((PortInst)eobj).getNodeInst());
        }
    }

    @Override
    void getHighlightedArcs(Highlighter highlighter, List<ArcInst> list2) {
        List<Highlight> inArea = Highlighter.findAllInArea(highlighter, this.cell, false, false, false, false, false, this.bounds, null);
        for (Highlight ah : inArea) {
            ElectricObject eobj;
            if (!(ah instanceof HighlightEOBJ) || !((eobj = ((HighlightEOBJ)ah).eobj) instanceof ArcInst)) continue;
            list2.add((ArcInst)eobj);
        }
    }

    @Override
    Rectangle2D getHighlightedArea(EditWindow wnd) {
        return this.bounds;
    }

    @Override
    public String getInfo() {
        String description = "Area from " + this.bounds.getMinX() + "<=X<=" + this.bounds.getMaxX() + " and " + this.bounds.getMinY() + "<=Y<=" + this.bounds.getMaxY();
        return description;
    }
}

