/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EGraphics
implements Serializable {
    public static final J3DTransparencyOption DEFAULT_MODE = J3DTransparencyOption.NONE;
    public static final double DEFAULT_FACTOR = 0.0;
    private static Map<String, Outline> outlineNames = new HashMap<String, Outline>();
    private final boolean displayPatterned;
    private final boolean printPatterned;
    private final Outline patternOutline;
    private final int transparentLayer;
    private final Color color;
    private final double opacity;
    private final boolean foreground;
    private final int[] pattern;
    private final int[] reversedPattern;
    private final J3DTransparencyOption transparencyMode;
    private final double transparencyFactor;
    public static final int FULLRGBBIT = 1;
    public static final int OPAQUEBIT = 2;
    public static final int WHITE = 2;
    public static final int BLACK = 6;
    public static final int RED = 10;
    public static final int BLUE = 14;
    public static final int GREEN = 18;
    public static final int CYAN = 22;
    public static final int MAGENTA = 26;
    public static final int YELLOW = 30;
    public static final int CELLTXT = 34;
    public static final int CELLOUT = 38;
    public static final int WINBOR = 42;
    public static final int HWINBOR = 46;
    public static final int MENBOR = 50;
    public static final int HMENBOR = 54;
    public static final int MENTXT = 58;
    public static final int MENGLY = 62;
    public static final int CURSOR = 66;
    public static final int GRAY = 70;
    public static final int ORANGE = 74;
    public static final int PURPLE = 78;
    public static final int BROWN = 82;
    public static final int LGRAY = 86;
    public static final int DGRAY = 90;
    public static final int LRED = 94;
    public static final int DRED = 98;
    public static final int LGREEN = 102;
    public static final int DGREEN = 106;
    public static final int LBLUE = 110;
    public static final int DBLUE = 114;
    public static final int LAYERT1 = 4;
    public static final int LAYERT2 = 8;
    public static final int LAYERT3 = 16;
    public static final int LAYERT4 = 32;
    public static final int LAYERT5 = 64;
    public static final int LAYERT6 = 128;
    public static final int LAYERT7 = 256;
    public static final int LAYERT8 = 512;
    public static final int LAYERT9 = 1024;
    public static final int LAYERT10 = 2048;
    public static final int LAYERT11 = 4096;
    public static final int LAYERT12 = 8192;
    public static final int TRANSPARENT_1 = 1;
    public static final int TRANSPARENT_2 = 2;
    public static final int TRANSPARENT_3 = 3;
    public static final int TRANSPARENT_4 = 4;
    public static final int TRANSPARENT_5 = 5;
    public static final int TRANSPARENT_6 = 6;
    public static final int TRANSPARENT_7 = 7;
    public static final int TRANSPARENT_8 = 8;
    public static final int TRANSPARENT_9 = 9;
    public static final int TRANSPARENT_10 = 10;
    public static final int TRANSPARENT_11 = 11;
    public static final int TRANSPARENT_12 = 12;

    public EGraphics(boolean displayPatterned, boolean printPatterned, Outline outlineWhenPatterned, int transparentLayer, int red, int green, int blue, double opacity, boolean foreground, int[] pattern) {
        this(displayPatterned, printPatterned, outlineWhenPatterned, transparentLayer, red, green, blue, opacity, foreground, pattern, DEFAULT_MODE, 0.0);
    }

    public EGraphics(boolean displayPatterned, boolean printPatterned, Outline outlineWhenPatterned, int transparentLayer, int red, int green, int blue, double opacity, boolean foreground, int[] pattern, J3DTransparencyOption transparencyMode, double transparencyFactor) {
        this.displayPatterned = displayPatterned;
        this.printPatterned = printPatterned;
        Outline outline = this.patternOutline = outlineWhenPatterned != null ? outlineWhenPatterned : Outline.NOPAT;
        if (transparentLayer < 0 || transparentLayer > 12) {
            System.out.println("Graphics transparent color bad: " + transparentLayer);
            transparentLayer = 0;
        }
        this.transparentLayer = transparentLayer;
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            System.out.println("Graphics color bad: (" + red + "," + green + "," + blue + ")");
            red = Math.min(Math.max(red, 0), 255);
            green = Math.max(Math.max(green, 0), 255);
            blue = Math.max(Math.max(blue, 0), 255);
        }
        this.color = new Color(red, green, blue);
        this.opacity = EGraphics.validateOpacity(opacity);
        this.foreground = foreground;
        if (pattern.length != 16) {
            throw new IllegalArgumentException("Graphics bad: has " + pattern.length + " pattern entries instead of 16");
        }
        this.pattern = (int[])pattern.clone();
        int i = 0;
        while (i < this.pattern.length) {
            int n = i++;
            this.pattern[n] = this.pattern[n] & 0xFFFF;
        }
        this.reversedPattern = this.makeReversedPattern(this.pattern);
        this.transparencyMode = transparencyMode != null ? transparencyMode : J3DTransparencyOption.NONE;
        this.transparencyFactor = transparencyFactor;
    }

    private EGraphics(boolean displayPatterned, boolean printPatterned, Outline outlineWhenPatterned, int transparentLayer, Color opaqueColor, double opacity, boolean foreground, int[] pattern, int[] reversedPattern, J3DTransparencyOption transparencyMode, double transparencyFactor) {
        this.displayPatterned = displayPatterned;
        this.printPatterned = printPatterned;
        this.patternOutline = outlineWhenPatterned;
        this.transparentLayer = transparentLayer;
        this.color = opaqueColor;
        this.opacity = EGraphics.validateOpacity(opacity);
        this.foreground = foreground;
        this.pattern = pattern;
        this.reversedPattern = reversedPattern;
        this.transparencyMode = transparencyMode;
        this.transparencyFactor = transparencyFactor;
    }

    private String makePatString(int[] pattern) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            if (i > 0) {
                sb.append("/");
            }
            sb.append(Integer.toString(pattern[i]));
        }
        return sb.toString();
    }

    private void parsePatString(String patString, int[] pattern) {
        int pos = 0;
        for (int i = 0; i < 16; ++i) {
            pattern[i] = TextUtils.atoi(patString.substring(pos)) & 0xFFFF;
            pos = patString.indexOf(47, pos) + 1;
        }
    }

    public boolean isPatternedOnDisplay() {
        return this.displayPatterned;
    }

    public EGraphics withPatternedOnDisplay(boolean p) {
        if (p == this.displayPatterned) {
            return this;
        }
        return new EGraphics(p, this.printPatterned, this.patternOutline, this.transparentLayer, this.color, this.opacity, this.foreground, this.pattern, this.reversedPattern, this.transparencyMode, this.transparencyFactor);
    }

    public boolean isPatternedOnPrinter() {
        return this.printPatterned;
    }

    public EGraphics withPatternedOnPrinter(boolean p) {
        if (p == this.printPatterned) {
            return this;
        }
        return new EGraphics(this.displayPatterned, p, this.patternOutline, this.transparentLayer, this.color, this.opacity, this.foreground, this.pattern, this.reversedPattern, this.transparencyMode, this.transparencyFactor);
    }

    public Outline getOutlined() {
        return this.patternOutline;
    }

    public EGraphics withOutlined(Outline o) {
        if (o == null) {
            o = Outline.NOPAT;
        }
        if (o == this.patternOutline) {
            return this;
        }
        return new EGraphics(this.displayPatterned, this.printPatterned, o, this.transparentLayer, this.color, this.opacity, this.foreground, this.pattern, this.reversedPattern, this.transparencyMode, this.transparencyFactor);
    }

    public int getTransparentLayer() {
        return this.transparentLayer;
    }

    public EGraphics withTransparentLayer(int transparentLayer) {
        if (transparentLayer < 0 || transparentLayer > 12) {
            System.out.println("Graphics transparent color bad: " + transparentLayer);
            transparentLayer = 0;
        }
        if (transparentLayer == this.transparentLayer) {
            return this;
        }
        return new EGraphics(this.displayPatterned, this.printPatterned, this.patternOutline, transparentLayer, this.color, this.opacity, this.foreground, this.pattern, this.reversedPattern, this.transparencyMode, this.transparencyFactor);
    }

    public int[] getPattern() {
        return this.pattern;
    }

    public int[] getReversedPattern() {
        return this.reversedPattern;
    }

    public String getPatternString() {
        return this.makePatString(this.pattern);
    }

    public EGraphics withPattern(int[] pattern) {
        if (pattern.length != 16) {
            throw new IllegalArgumentException("Graphics bad: has " + pattern.length + " pattern entries instead of 16");
        }
        pattern = (int[])pattern.clone();
        int i = 0;
        while (i < this.pattern.length) {
            int n = i++;
            pattern[n] = pattern[n] & 0xFFFF;
        }
        if (Arrays.equals(pattern, this.pattern)) {
            return this;
        }
        int[] reversedPattern = this.makeReversedPattern(pattern);
        return new EGraphics(this.displayPatterned, this.printPatterned, this.patternOutline, this.transparentLayer, this.color, this.opacity, this.foreground, pattern, reversedPattern, this.transparencyMode, this.transparencyFactor);
    }

    public EGraphics withPattern(String patternStr) {
        int[] pattern = new int[16];
        this.parsePatString(patternStr, pattern);
        return this.withPattern(pattern);
    }

    private int[] makeReversedPattern(int[] pattern) {
        int[] reversedPattern = new int[16];
        for (int i = 0; i < reversedPattern.length; ++i) {
            int shortPattern = pattern[i];
            if (shortPattern >>> 16 != 0) {
                System.out.println("Graphics bad: has " + Integer.toHexString(shortPattern) + " pattern line");
                shortPattern &= 0xFFFF;
            }
            for (int j = 0; j < 16; ++j) {
                if ((shortPattern & 1 << 15 - j) == 0) continue;
                int n = i;
                reversedPattern[n] = reversedPattern[n] | 65537 << j;
            }
        }
        return reversedPattern;
    }

    public double getOpacity() {
        return this.opacity;
    }

    private static double validateOpacity(double opacity) {
        if (opacity < 0.0) {
            System.out.println("Opacity " + opacity + " smaller than 0. Resetting to 0");
            return 0.0;
        }
        if (opacity > 1.0) {
            System.out.println("Opacity " + opacity + " bigger than 1. Resetting to 1");
            return 1.0;
        }
        return opacity;
    }

    public EGraphics withOpacity(double opacity) {
        if ((opacity = EGraphics.validateOpacity(opacity)) == this.opacity) {
            return this;
        }
        return new EGraphics(this.displayPatterned, this.printPatterned, this.patternOutline, this.transparentLayer, this.color, opacity, this.foreground, this.pattern, this.reversedPattern, this.transparencyMode, this.transparencyFactor);
    }

    public boolean getForeground() {
        return this.foreground;
    }

    public EGraphics withForeground(boolean f) {
        if (f == this.foreground) {
            return this;
        }
        return new EGraphics(this.displayPatterned, this.printPatterned, this.patternOutline, this.transparentLayer, this.color, this.opacity, f, this.pattern, this.reversedPattern, this.transparencyMode, this.transparencyFactor);
    }

    public Color getAlphaColor() {
        int alpha = (int)(this.opacity * 255.0);
        return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), alpha);
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColor(Color[] transparentColors) {
        if (this.transparentLayer > 0 && this.transparentLayer <= transparentColors.length) {
            return transparentColors[this.transparentLayer - 1];
        }
        return this.color;
    }

    public int getRGB() {
        return this.color.getRGB() & 0xFFFFFF;
    }

    public EGraphics withColor(Color color) {
        if (color.getAlpha() != 255) {
            color = new Color(color.getRGB());
        }
        if (color.equals(this.color)) {
            return this;
        }
        assert (color.getAlpha() == 255);
        return new EGraphics(this.displayPatterned, this.printPatterned, this.patternOutline, this.transparentLayer, new Color(color.getRed(), color.getGreen(), color.getBlue()), this.opacity, this.foreground, this.pattern, this.reversedPattern, this.transparencyMode, this.transparencyFactor);
    }

    public static Color getColorFromIndex(int colorIndex, Color[] colorMap) {
        int trueIndex;
        Technology curTech;
        if ((colorIndex & 2) != 0) {
            switch (colorIndex) {
                case 2: {
                    return new Color(255, 255, 255);
                }
                case 6: {
                    return new Color(0, 0, 0);
                }
                case 10: {
                    return new Color(255, 0, 0);
                }
                case 14: {
                    return new Color(0, 0, 255);
                }
                case 18: {
                    return new Color(0, 255, 0);
                }
                case 22: {
                    return new Color(0, 255, 255);
                }
                case 26: {
                    return new Color(255, 0, 255);
                }
                case 30: {
                    return new Color(255, 255, 0);
                }
                case 34: {
                    return new Color(0, 0, 0);
                }
                case 38: {
                    return new Color(0, 0, 0);
                }
                case 42: {
                    return new Color(0, 0, 0);
                }
                case 46: {
                    return new Color(0, 255, 0);
                }
                case 50: {
                    return new Color(0, 0, 0);
                }
                case 54: {
                    return new Color(255, 255, 255);
                }
                case 58: {
                    return new Color(0, 0, 0);
                }
                case 62: {
                    return new Color(0, 0, 0);
                }
                case 66: {
                    return new Color(0, 0, 0);
                }
                case 70: {
                    return new Color(180, 180, 180);
                }
                case 74: {
                    return new Color(255, 190, 6);
                }
                case 78: {
                    return new Color(186, 0, 255);
                }
                case 82: {
                    return new Color(139, 99, 46);
                }
                case 86: {
                    return new Color(230, 230, 230);
                }
                case 90: {
                    return new Color(100, 100, 100);
                }
                case 94: {
                    return new Color(255, 150, 150);
                }
                case 98: {
                    return new Color(159, 80, 80);
                }
                case 102: {
                    return new Color(175, 255, 175);
                }
                case 106: {
                    return new Color(89, 159, 85);
                }
                case 110: {
                    return new Color(150, 150, 255);
                }
                case 114: {
                    return new Color(2, 15, 159);
                }
            }
            return null;
        }
        if ((colorIndex & 1) != 0) {
            return new Color(colorIndex >> 24 & 0xFF, colorIndex >> 16 & 0xFF, colorIndex >> 8 & 0xFF);
        }
        if (colorMap == null && (colorMap = (curTech = Technology.getCurrent()).getColorMap()) == null) {
            Technology altTech = Schematics.getDefaultSchematicTechnology();
            if (altTech != curTech) {
                colorMap = altTech.getColorMap();
            }
            if (colorMap == null) {
                return null;
            }
        }
        if ((trueIndex = colorIndex >> 2) < colorMap.length) {
            return colorMap[trueIndex];
        }
        return null;
    }

    public EGraphics withColorIndex(int colorIndex) {
        if ((colorIndex & 3) != 0) {
            return this.withColor(EGraphics.getColorFromIndex(colorIndex, null)).withTransparentLayer(0);
        }
        int transparentLayer = this.transparentLayer;
        if ((colorIndex & 4) != 0) {
            transparentLayer = 1;
        } else if ((colorIndex & 8) != 0) {
            transparentLayer = 2;
        } else if ((colorIndex & 0x10) != 0) {
            transparentLayer = 3;
        } else if ((colorIndex & 0x20) != 0) {
            transparentLayer = 4;
        } else if ((colorIndex & 0x40) != 0) {
            transparentLayer = 5;
        } else if ((colorIndex & 0x80) != 0) {
            transparentLayer = 6;
        } else if ((colorIndex & 0x100) != 0) {
            transparentLayer = 7;
        } else if ((colorIndex & 0x200) != 0) {
            transparentLayer = 8;
        } else if ((colorIndex & 0x400) != 0) {
            transparentLayer = 9;
        } else if ((colorIndex & 0x800) != 0) {
            transparentLayer = 10;
        } else if ((colorIndex & 0x1000) != 0) {
            transparentLayer = 11;
        } else if ((colorIndex & 0x2000) != 0) {
            transparentLayer = 12;
        }
        return this.withTransparentLayer(transparentLayer);
    }

    public static int makeIndex(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int index2 = red << 24 | green << 16 | blue << 8 | 1;
        return index2;
    }

    public static int makeIndex(int transparentLayer) {
        switch (transparentLayer) {
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
            case 6: {
                return 128;
            }
            case 7: {
                return 256;
            }
            case 8: {
                return 512;
            }
            case 9: {
                return 1024;
            }
            case 10: {
                return 2048;
            }
            case 11: {
                return 4096;
            }
            case 12: {
                return 8192;
            }
        }
        return 0;
    }

    public static int findColorIndex(String name) {
        if (name.equals("white")) {
            return 2;
        }
        if (name.equals("black")) {
            return 6;
        }
        if (name.equals("red")) {
            return 10;
        }
        if (name.equals("blue")) {
            return 14;
        }
        if (name.equals("green")) {
            return 18;
        }
        if (name.equals("cyan")) {
            return 22;
        }
        if (name.equals("magenta")) {
            return 26;
        }
        if (name.equals("yellow")) {
            return 30;
        }
        if (name.equals("gray")) {
            return 70;
        }
        if (name.equals("orange")) {
            return 74;
        }
        if (name.equals("purple")) {
            return 78;
        }
        if (name.equals("brown")) {
            return 82;
        }
        if (name.equals("light-gray")) {
            return 86;
        }
        if (name.equals("dark-gray")) {
            return 90;
        }
        if (name.equals("light-red")) {
            return 94;
        }
        if (name.equals("dark-red")) {
            return 98;
        }
        if (name.equals("light-green")) {
            return 102;
        }
        if (name.equals("dark-green")) {
            return 106;
        }
        if (name.equals("light-blue")) {
            return 110;
        }
        if (name.equals("dark-blue")) {
            return 114;
        }
        if (name.equals("transparent-1")) {
            return 4;
        }
        if (name.equals("transparent-2")) {
            return 8;
        }
        if (name.equals("transparent-3")) {
            return 16;
        }
        if (name.equals("transparent-4")) {
            return 32;
        }
        if (name.equals("transparent-5")) {
            return 64;
        }
        if (name.equals("transparent-6")) {
            return 128;
        }
        if (name.equals("transparent-7")) {
            return 256;
        }
        if (name.equals("transparent-8")) {
            return 512;
        }
        if (name.equals("transparent-9")) {
            return 1024;
        }
        if (name.equals("transparent-10")) {
            return 2048;
        }
        if (name.equals("transparent-11")) {
            return 4096;
        }
        if (name.equals("transparent-12")) {
            return 8192;
        }
        return 0;
    }

    public static String getColorIndexName(int colorIndex) {
        if ((colorIndex & 1) != 0) {
            int red = colorIndex >> 24 & 0xFF;
            int green = colorIndex >> 16 & 0xFF;
            int blue = colorIndex >> 8 & 0xFF;
            return "Color (" + red + "," + green + "," + blue + ")";
        }
        switch (colorIndex) {
            case 2: {
                return "white";
            }
            case 6: {
                return "black";
            }
            case 10: {
                return "red";
            }
            case 14: {
                return "blue";
            }
            case 18: {
                return "green";
            }
            case 22: {
                return "cyan";
            }
            case 26: {
                return "magenta";
            }
            case 30: {
                return "yellow";
            }
            case 70: {
                return "gray";
            }
            case 74: {
                return "orange";
            }
            case 78: {
                return "purple";
            }
            case 82: {
                return "brown";
            }
            case 86: {
                return "light-gray";
            }
            case 90: {
                return "dark-gray";
            }
            case 94: {
                return "light-red";
            }
            case 98: {
                return "dark-red";
            }
            case 102: {
                return "light-green";
            }
            case 106: {
                return "dark-green";
            }
            case 110: {
                return "light-blue";
            }
            case 114: {
                return "dark-blue";
            }
            case 4: {
                return "transparent-1";
            }
            case 8: {
                return "transparent-2";
            }
            case 16: {
                return "transparent-3";
            }
            case 32: {
                return "transparent-4";
            }
            case 64: {
                return "transparent-5";
            }
            case 128: {
                return "transparent-6";
            }
            case 256: {
                return "transparent-7";
            }
            case 512: {
                return "transparent-8";
            }
            case 1024: {
                return "transparent-9";
            }
            case 2048: {
                return "transparent-10";
            }
            case 4096: {
                return "transparent-11";
            }
            case 8192: {
                return "transparent-12";
            }
        }
        return "ColorIndex " + colorIndex;
    }

    public static int[] getColorIndices() {
        return new int[]{2, 6, 10, 14, 18, 22, 26, 30, 70, 74, 78, 82, 86, 90, 94, 98, 102, 106, 110, 114, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192};
    }

    public static int[] getTransparentColorIndices() {
        return new int[]{4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192};
    }

    public J3DTransparencyOption getTransparencyMode() {
        return this.transparencyMode;
    }

    public EGraphics withTransparencyMode(J3DTransparencyOption mode) {
        if (mode == null) {
            mode = J3DTransparencyOption.NONE;
        }
        if (mode == this.transparencyMode) {
            return this;
        }
        return new EGraphics(this.displayPatterned, this.printPatterned, this.patternOutline, this.transparentLayer, this.color, this.opacity, this.foreground, this.pattern, this.reversedPattern, mode, this.transparencyFactor);
    }

    public double getTransparencyFactor() {
        return this.transparencyFactor;
    }

    public EGraphics withTransparencyFactor(double factor) {
        if (factor == this.transparencyFactor) {
            return this;
        }
        return new EGraphics(this.displayPatterned, this.printPatterned, this.patternOutline, this.transparentLayer, this.color, this.opacity, this.foreground, this.pattern, this.reversedPattern, this.transparencyMode, factor);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EGraphics) {
            EGraphics that = (EGraphics)o;
            return this.displayPatterned == that.displayPatterned && this.printPatterned == that.printPatterned && this.patternOutline == that.patternOutline && this.transparentLayer == that.transparentLayer && this.color.equals(that.color) && this.opacity == that.opacity && this.foreground == that.foreground && Arrays.equals(this.pattern, that.pattern) && this.transparencyMode == that.transparencyMode && this.transparencyFactor == that.transparencyFactor;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.color.hashCode();
        if (this.pattern != null) {
            hash += 79 * this.pattern[0];
        }
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum J3DTransparencyOption {
        FASTEST,
        NICEST,
        BLENDED,
        SCREEN_DOOR,
        NONE;

        public final int mode = this.ordinal();

        public static J3DTransparencyOption valueOf(int mode) {
            return ((J3DTransparencyOption[])J3DTransparencyOption.class.getEnumConstants())[mode];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Outline {
        NOPAT("None", 0, 32, 1),
        PAT_S("Solid", -1, 32, 1),
        PAT_T1("Solid-Thick", -1, 32, 3),
        PAT_T2("Solid-Thicker", -1, 32, 5),
        PAT_DO1("Dotted-Close", 85, 8, 1),
        PAT_DO2("Dotted-Far", 17, 8, 1),
        PAT_DA1("Dashed-Short", 51, 8, 1),
        PAT_DA2("Dashed-Long", 15, 6, 1),
        PAT_DD1("Dotted-Dashed-Short", 57, 8, 1),
        PAT_DD2("Dotted-Dashed-Long", 243, 10, 1),
        PAT_DO1_T1("Dotted-Close-Thick", 15, 6, 3),
        PAT_DO2_T1("Dotted-Far-Thick", 15, 8, 3),
        PAT_DA1_T1("Dashed-Thick", 131071, 19, 3),
        PAT_DO1_T2("Dotted-Close-Thicker", 31, 8, 5),
        PAT_DO2_T2("Dotted-Far-Thicker", 127, 9, 5);

        private final String name;
        private final int pattern;
        private final int len;
        private final int thickness;
        private final boolean solid;

        private Outline(String name, int pattern, int len, int thickness) {
            this.name = name;
            outlineNames.put(name, this);
            this.pattern = pattern;
            this.len = len;
            this.thickness = thickness;
            this.solid = pattern == -1;
        }

        public String getName() {
            return this.name;
        }

        public String getConstName() {
            return this.name();
        }

        public int getIndex() {
            return this.ordinal();
        }

        public boolean isSolidPattern() {
            return this.solid;
        }

        public int getPattern() {
            return this.pattern;
        }

        public int getLen() {
            return this.len;
        }

        public int getThickness() {
            return this.thickness;
        }

        public static Outline findOutline(int index2) {
            return ((Outline[])Outline.class.getEnumConstants())[index2];
        }

        public static Outline findOutline(String name) {
            return (Outline)((Object)outlineNames.get(name));
        }

        public static List<Outline> getOutlines() {
            return Arrays.asList(Outline.class.getEnumConstants());
        }

        public String toString() {
            return this.name;
        }
    }
}

