/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement;

import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.placement.PlacementFrame;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacementSimple
extends PlacementFrame {
    @Override
    public String getAlgorithmName() {
        return "Simple";
    }

    @Override
    protected void runPlacement(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, String cellName) {
        double pPos = 0.0;
        double nPos = 0.0;
        double iPos = 0.0;
        ArrayList<PlacementFrame.PlacementNode> resistors = new ArrayList<PlacementFrame.PlacementNode>();
        ArrayList<PlacementFrame.PlacementNode> capacitors = new ArrayList<PlacementFrame.PlacementNode>();
        for (PlacementFrame.PlacementNode plNode : nodesToPlace) {
            if (plNode.getType() == Schematics.tech().transistorNode || plNode.getType() == Schematics.tech().transistor4Node) {
                PrimitiveNode.Function fun = Schematics.tech().getPrimitiveFunction((PrimitiveNode)plNode.getType(), plNode.getTechBits());
                if (fun.isPTypeTransistor()) {
                    plNode.setPlacement(pPos, 5.0);
                    plNode.setOrientation(Orientation.R);
                    pPos += 10.0;
                    continue;
                }
                plNode.setPlacement(nPos, -5.0);
                plNode.setOrientation(Orientation.R);
                nPos += 10.0;
                continue;
            }
            if (plNode.getType() == Schematics.tech().resistorNode) {
                resistors.add(plNode);
                continue;
            }
            if (plNode.getType() == Schematics.tech().capacitorNode) {
                capacitors.add(plNode);
                continue;
            }
            plNode.setPlacement(iPos, -10.0 - plNode.getType().getDefHeight());
            iPos += 30.0;
        }
        for (PlacementFrame.PlacementNode plNode : resistors) {
            plNode.setPlacement(pPos, 5.0);
            pPos += 10.0;
        }
        for (PlacementFrame.PlacementNode plNode : capacitors) {
            plNode.setPlacement(nPos, -5.0);
            nPos += 10.0;
        }
    }
}

