/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogAnalysis;
import com.sun.electric.tool.simulation.Stimuli;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PSpiceOut
extends Simulate {
    PSpiceOut() {
    }

    protected void readSimulationOutput(Stimuli sd, URL fileURL, Cell cell) throws IOException {
        if (this.openTextInput(fileURL)) {
            return;
        }
        PSpiceOut.startProgressDialog("PSpice output", fileURL.getFile());
        this.readPSpiceFile(cell, sd);
        PSpiceOut.stopProgressDialog();
        this.closeInput();
    }

    private void readPSpiceFile(Cell cell, Stimuli sd) throws IOException {
        String line;
        boolean first = true;
        AnalogAnalysis an = new AnalogAnalysis(sd, AnalogAnalysis.ANALYSIS_SIGNALS, false);
        sd.setCell(cell);
        ArrayList<String> signalNames = new ArrayList<String>();
        List[] values = null;
        int numSignals = 0;
        while ((line = this.getLine()) != null) {
            if (first) {
                String hsFormat;
                first = false;
                if (line.length() >= 20 && ((hsFormat = line.substring(16, 20)).equals("9007") || hsFormat.equals("9601"))) {
                    System.out.println("This is an HSPICE file, not a SPICE3/PSPICE file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return;
                }
                int ptr = 0;
                while (true) {
                    if (ptr < line.length() && Character.isWhitespace(line.charAt(ptr))) {
                        ++ptr;
                        continue;
                    }
                    if (ptr >= line.length()) break;
                    int start = ptr;
                    while (ptr < line.length() && !Character.isWhitespace(line.charAt(ptr))) {
                        ++ptr;
                    }
                    signalNames.add(line.substring(start, ptr));
                }
                numSignals = signalNames.size();
                values = new List[numSignals];
                for (int i = 0; i < numSignals; ++i) {
                    values[i] = new ArrayList();
                }
                continue;
            }
            int equalPos = line.indexOf("=");
            if (equalPos >= 0) {
                if (line.length() > equalPos + 3) {
                    line = line.substring(equalPos + 3);
                } else {
                    System.out.println("Missing value after '='.  This may not be a PSpice output file.");
                    return;
                }
            }
            int ptr = 0;
            int position = 0;
            while (true) {
                if (ptr < line.length() && Character.isWhitespace(line.charAt(ptr))) {
                    ++ptr;
                    continue;
                }
                if (ptr >= line.length() || line.charAt(ptr) == ')') break;
                int start = ptr;
                while (ptr < line.length() && !Character.isWhitespace(line.charAt(ptr))) {
                    ++ptr;
                }
                double value = TextUtils.atof(line.substring(start, ptr));
                values[position++].add(new Double(value));
            }
            if (position == numSignals) continue;
            System.out.println("Line of data has " + position + " values, but expect " + numSignals + ". Unable to recover from error.  This may not be a PSpice output file.");
            return;
        }
        if (numSignals == 0) {
            System.out.println("No data found in the file.  This may not be a PSpice output file.");
            return;
        }
        int numEvents = values[0].size();
        an.buildCommonTime(numEvents);
        for (int i = 0; i < numEvents; ++i) {
            an.setCommonTime(i, (Double)values[0].get(i));
        }
        for (int j = 1; j < numSignals; ++j) {
            double[] doubleValues = new double[numEvents];
            for (int i = 0; i < numEvents; ++i) {
                doubleValues[i] = (Double)values[j].get(i);
            }
            an.addSignal((String)signalNames.get(j), null, doubleValues);
        }
    }
}

