/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;

class HighlightPoly
extends Highlight {
    private Poly polygon;
    private Color color;

    HighlightPoly(Cell c, Poly p, Color col) {
        super(c);
        this.polygon = p;
        this.color = col;
    }

    public void showInternalHighlight(EditWindow wnd, Graphics g, int highOffX, int highOffY, boolean onlyHighlight, boolean setConnected) {
        Color oldColor = null;
        if (this.color != null) {
            oldColor = g.getColor();
            g.setColor(this.color);
        }
        Point2D[] points = this.polygon.getPoints();
        if (this.polygon.getStyle() == Poly.Type.FILLED) {
            int[] xPoints = new int[points.length];
            int[] yPoints = new int[points.length];
            for (int i = 0; i < points.length; ++i) {
                Point p = wnd.databaseToScreen(points[i].getX(), points[i].getY());
                xPoints[i] = p.x;
                yPoints[i] = p.y;
            }
            g.fillPolygon(xPoints, yPoints, points.length);
        } else {
            boolean opened = this.polygon.getStyle() == Poly.Type.OPENED;
            HighlightPoly.drawOutlineFromPoints(wnd, g, points, highOffX, highOffY, opened, false);
        }
        if (oldColor != null) {
            g.setColor(oldColor);
        }
    }
}

