/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.CellChangeJobs;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StitchFillJob
extends Job {
    private Cell topCell;
    private Library outLibrary;
    private List<Cell> generatedCells = new ArrayList<Cell>();
    private static final PinsArcPairSort pinsArcSort = new PinsArcPairSort();

    public StitchFillJob(Cell cell, Library lib, boolean doItNow) {
        super("Fill generator job", null, Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.topCell = cell;
        this.outLibrary = lib;
        if (doItNow) {
            try {
                if (this.doIt()) {
                    this.terminateOK();
                }
            }
            catch (JobException e) {
                e.printStackTrace();
            }
        } else {
            this.startJob();
        }
    }

    @Override
    public boolean doIt() throws JobException {
        Point2D.Double center = new Point2D.Double(0.0, 0.0);
        if (this.topCell == null) {
            Technology tech = null;
            ArrayList<NodeInst> fillCells = new ArrayList<NodeInst>();
            ArrayList<Geometric> fillGeoms = new ArrayList<Geometric>();
            String fillCellName = "NewFill{lay}";
            Library lib = Library.getCurrent();
            if (lib == null) {
                System.out.println("No current library available.");
                return false;
            }
            Cell oldCell = lib.findNodeProto(fillCellName);
            if (oldCell != null) {
                oldCell.kill();
            }
            Cell newCell = Cell.makeInstance(lib, fillCellName);
            Iterator<WindowFrame> itW = WindowFrame.getWindows();
            while (itW.hasNext()) {
                WindowFrame w = itW.next();
                Cell c = w.getContent().getCell();
                if (c == null) {
                    System.out.println("No cell in window '" + w.getTitle() + "'");
                    continue;
                }
                if (c.getView() != View.LAYOUT) {
                    System.out.println("Cell '" + c + "' is not a layout cell");
                    continue;
                }
                Technology t = c.getTechnology();
                if (tech == null) {
                    tech = t;
                } else if (tech != t) {
                    System.out.println("Mixing technologies in fill generator: " + tech.getTechName() + " " + t.getTechName());
                }
                NodeInst ni = NodeInst.makeInstance(c, center, c.getDefWidth(), c.getDefHeight(), newCell);
                fillCells.add(ni);
                fillGeoms.add(ni);
            }
            StitchFillJob.doTheJob(newCell, fillCellName, fillCells, fillGeoms, null, false, this);
            return true;
        }
        String[] instructions = this.topCell.getTextViewContents();
        if (instructions == null) {
            System.out.println("No fill instructions found.");
            return false;
        }
        for (String line : instructions) {
            if (line.startsWith("//")) continue;
            StringTokenizer parse = new StringTokenizer(line, ":", false);
            int count = 0;
            String fillCellName = null;
            String rest = null;
            while (parse.hasMoreTokens()) {
                assert (count < 2);
                String value = parse.nextToken();
                switch (count) {
                    case 0: {
                        fillCellName = value;
                        break;
                    }
                    default: {
                        rest = value;
                    }
                }
                ++count;
            }
            if (fillCellName == null) continue;
            int index = fillCellName.indexOf("(");
            boolean wideOption = false;
            ArrayList<TileInfo> tileList = new ArrayList<TileInfo>();
            if (index != -1) {
                String options = fillCellName.substring(index);
                fillCellName = fillCellName.substring(0, index);
                parse = new StringTokenizer(options, "(), ", false);
                while (parse.hasMoreTokens()) {
                    String option = parse.nextToken();
                    String lowerCase = option.toLowerCase();
                    if (lowerCase.equals("w")) {
                        wideOption = true;
                        fillCellName = fillCellName + "W";
                        continue;
                    }
                    if (!lowerCase.contains("x")) continue;
                    index = lowerCase.indexOf("x");
                    String str = lowerCase.substring(0, index);
                    int x = Integer.valueOf(str);
                    str = lowerCase.substring(index + 1, lowerCase.length());
                    int y = Integer.valueOf(str);
                    TileInfo tile = new TileInfo(x, y);
                    tileList.add(tile);
                }
            }
            parse = new StringTokenizer(rest, " ,", false);
            String newName = fillCellName + "{lay}";
            Cell oldCell = this.outLibrary.findNodeProto(newName);
            if (oldCell != null) {
                oldCell.kill();
            }
            Cell newCell = Cell.makeInstance(this.outLibrary, newName);
            Technology tech = null;
            ArrayList<NodeInst> fillCells = new ArrayList<NodeInst>();
            ArrayList<Geometric> fillGeoms = new ArrayList<Geometric>();
            while (parse.hasMoreTokens()) {
                Cell c;
                String fillCell = parse.nextToken();
                index = fillCell.indexOf("(");
                boolean instanceFlag = false;
                if (index != -1) {
                    instanceFlag = fillCell.toLowerCase().indexOf("(i") != -1;
                    fillCell = fillCell.substring(0, index);
                }
                if ((c = this.topCell.getLibrary().findNodeProto(fillCell + "{lay}")) == null) {
                    System.out.println("Cell '" + fillCell + "' does not exist");
                    continue;
                }
                if (c.getView() != View.LAYOUT) {
                    System.out.println("Cell '" + c + "' is not a layout cell");
                    continue;
                }
                Technology t = c.getTechnology();
                if (tech == null) {
                    tech = t;
                } else if (tech != t) {
                    System.out.println("Mixing technologies in fill generator: " + tech.getTechName() + " " + t.getTechName());
                }
                NodeInst ni = NodeInst.makeInstance(c, center, c.getDefWidth(), c.getDefHeight(), newCell);
                if (!instanceFlag) {
                    fillCells.add(ni);
                }
                fillGeoms.add(ni);
            }
            newCell.setTechnology(tech);
            this.generatedCells.add(newCell);
            StitchFillJob.doTheJob(newCell, fillCellName, fillCells, fillGeoms, tileList, wideOption, this);
        }
        return true;
    }

    public List<Cell> getGeneratedCells() {
        return this.generatedCells;
    }

    private static void doTheJob(Cell newCell, String fillCellName, List<NodeInst> fillCells, List<Geometric> fillGeoms, List<TileInfo> tileList, boolean wideOption, Job job) {
        ExportChanges.reExportNodes(newCell, fillGeoms, false, true, false, true);
        new CellChangeJobs.ExtractCellInstances(newCell, fillCells, Integer.MAX_VALUE, true, true);
        StitchFillJob.generateFill(newCell, wideOption);
        StitchFillJob.generateTiles(newCell, fillCellName, tileList, job);
    }

    private static void generateTiles(Cell template, String fillCellName, List<TileInfo> tileList, Job job) {
        if (tileList == null) {
            return;
        }
        for (TileInfo info : tileList) {
            String newTileName = fillCellName + info.x + "x" + info.y + "{lay}";
            Cell newTile = Cell.makeInstance(template.getLibrary(), newTileName);
            ArrayList<NodeInst> niList = new ArrayList<NodeInst>();
            ERectangle rect = template.getBounds();
            double width = ((RectangularShape)rect).getWidth();
            double height = ((RectangularShape)rect).getHeight();
            double xPos = 0.0;
            for (int i = 0; i < info.x; ++i) {
                double yPos = 0.0;
                for (int j = 0; j < info.y; ++j) {
                    NodeInst newNi = NodeInst.makeInstance(template, new Point2D.Double(xPos, yPos), width, height, newTile, Orientation.IDENT, null);
                    niList.add(newNi);
                    yPos += height;
                }
                xPos += width;
            }
            AutoStitch.AutoOptions prefs = new AutoStitch.AutoOptions();
            prefs.createExports = true;
            AutoStitch.runAutoStitch(newTile, niList, null, job, null, null, true, prefs, true);
        }
    }

    private static boolean generateFill(Cell theCell, boolean wideOption) {
        Serializable l;
        Export exp;
        SimpleWirer router = new SimpleWirer();
        ArrayList<Layer> listOfLayers = new ArrayList<Layer>(12);
        Iterator<Layer> itL = theCell.getTechnology().getLayers();
        while (itL.hasNext()) {
            Layer l2 = itL.next();
            if (!l2.getFunction().isMetal()) continue;
            l2.getFunction().getLevel();
            listOfLayers.add(l2);
        }
        Collections.sort(listOfLayers, Layer.layerSortByLevel);
        HashMap<ArcProto, Integer> arcsCreatedMap = new HashMap<ArcProto, Integer>();
        HashMap<NodeProto, Integer> nodesCreatedMap = new HashMap<NodeProto, Integer>();
        ArrayList<Route> routeList = new ArrayList<Route>();
        Layer[] topLayers = new Layer[2];
        Layer bottomLayer = null;
        HashMap<String, Area> totalAreas = new HashMap<String, Area>();
        for (int i = 0; i < listOfLayers.size() - 1; ++i) {
            Layer bottom = (Layer)listOfLayers.get(i);
            List<ArcInst> arcs = StitchFillJob.getArcsInGivenLayer(theCell.getArcs(), bottom, null, null);
            Layer top = (Layer)listOfLayers.get(i + 1);
            HashMap<String, ExtraArea> remainingGeos = new HashMap<String, ExtraArea>();
            for (ArcInst arcInst : arcs) {
                ExtraArea ea;
                Netlist netlist;
                String bottomName = StitchFillJob.getExportRootName(arcInst, netlist = theCell.getNetlist());
                if (bottomName == null) continue;
                ArrayList<PinsArcPair> pairs = new ArrayList<PinsArcPair>();
                Rectangle2D bounds = arcInst.getBounds();
                boolean horizontal = DBMath.isGreaterThan(bounds.getWidth(), bounds.getHeight());
                Area bottomA = new Area(bounds);
                if (bottomLayer == null || bottom == bottomLayer) {
                    Area totalA = (Area)totalAreas.get(bottomName);
                    if (totalA == null) {
                        totalA = new Area();
                        totalAreas.put(bottomName, totalA);
                    }
                    totalA.add(bottomA);
                }
                Iterator<RTBounds> it = theCell.searchIterator(bounds);
                while (it.hasNext()) {
                    boolean fullCoverageY;
                    String topName;
                    ArcInst nai;
                    Layer nl;
                    Geometric nGeom = (Geometric)it.next();
                    if (!(nGeom instanceof ArcInst) || (nl = (nai = (ArcInst)nGeom).getProto().getLayer(0)) != top || !StitchFillJob.isArcAligned(nai, !horizontal) || (topName = StitchFillJob.getExportRootName(nai, netlist)) == null || !topName.equals(bottomName)) continue;
                    Rectangle2D nBnds = nai.getBounds();
                    Area topA = new Area(nBnds);
                    topA.intersect(bottomA);
                    Rectangle2D resultBnd = topA.getBounds2D();
                    boolean fullCoverageX = horizontal ? DBMath.areEquals(resultBnd.getWidth(), nBnds.getWidth()) : DBMath.areEquals(resultBnd.getHeight(), nBnds.getHeight());
                    boolean bl = fullCoverageY = horizontal ? DBMath.areEquals(resultBnd.getHeight(), bounds.getHeight()) : DBMath.areEquals(resultBnd.getWidth(), bounds.getWidth());
                    if (!fullCoverageX || !fullCoverageY) {
                        Area a;
                        ExtraArea ea2 = (ExtraArea)remainingGeos.get(bottomName);
                        Area area = a = ea2 != null ? ea2.getArea(horizontal) : null;
                        if (a == null) {
                            a = new Area();
                            if (ea2 == null) {
                                ea2 = new ExtraArea(a, horizontal);
                                remainingGeos.put(bottomName, ea2);
                            } else {
                                ea2.setArea(a, horizontal);
                            }
                        }
                        a.add(topA);
                        continue;
                    }
                    EPoint insert = new EPoint(resultBnd.getCenterX(), resultBnd.getCenterY());
                    boolean insertedAlready = false;
                    for (PinsArcPair pp : pairs) {
                        if (!pp.insert.equals(insert) || !pp.cut.equals(resultBnd)) continue;
                        System.out.println();
                        insertedAlready = true;
                    }
                    if (insertedAlready) continue;
                    pairs.add(new PinsArcPair(nai, insert, resultBnd, horizontal));
                }
                Collections.sort(pairs, pinsArcSort);
                ArcInst mostLeft = arcInst;
                routeList.clear();
                if (bottomLayer == null) {
                    bottomLayer = bottom;
                }
                if (!pairs.isEmpty()) {
                    topLayers[0] = bottom;
                    topLayers[1] = top;
                }
                Area a = (ea = (ExtraArea)remainingGeos.get(bottomName)) != null ? ea.getArea(horizontal) : null;
                for (PinsArcPair pair : pairs) {
                    Route r = router.planRoute(theCell, mostLeft, pair.topArc, pair.insert, null, true, true, pair.cut);
                    routeList.add(r);
                    if (a == null) continue;
                    Area remove = new Area(pair.cut);
                    a.subtract(remove);
                }
                for (Route r : routeList) {
                    Router.createRouteNoJob(r, theCell, arcsCreatedMap, nodesCreatedMap);
                }
            }
            for (Map.Entry entry : remainingGeos.entrySet()) {
                ExtraArea ea = (ExtraArea)entry.getValue();
                for (int pos = 0; pos < 2; ++pos) {
                    boolean horizontal = pos == 0;
                    Area a = ea.getArea(horizontal);
                    if (a == null) continue;
                    Netlist netlist = theCell.getNetlist();
                    List<PolyBase> list = PolyBase.getPointsInArea(a, bottom, false, false);
                    List<ArcInst> at = StitchFillJob.getArcsInGivenLayer(theCell.getArcs(), top, (String)entry.getKey(), netlist);
                    ArrayList<PinsArcPair> pairs = new ArrayList<PinsArcPair>(2);
                    for (PolyBase p : list) {
                        Rectangle2D resultBnd = p.getBounds2D();
                        ArcInst topA = StitchFillJob.getArcInstOverlappingWithArea(resultBnd, at, horizontal, true);
                        if (topA == null) continue;
                        EPoint insert = new EPoint(resultBnd.getCenterX(), resultBnd.getCenterY());
                        Rectangle2D r = topA.getBounds();
                        boolean horizontal1 = !DBMath.isGreaterThan(r.getWidth(), r.getHeight());
                        pairs.add(new PinsArcPair(topA, insert, resultBnd, horizontal1));
                    }
                    Collections.sort(pairs, pinsArcSort);
                    List<ArcInst> ab = StitchFillJob.getArcsInGivenLayer(theCell.getArcs(), bottom, (String)entry.getKey(), netlist);
                    routeList.clear();
                    for (PinsArcPair pair : pairs) {
                        ArcInst bottomA = StitchFillJob.getArcInstOverlappingWithArea(pair.cut, ab, horizontal, false);
                        if (bottomA != null) {
                            Route r = router.planRoute(theCell, bottomA, pair.topArc, pair.insert, null, true, true, pair.cut);
                            ab.remove(bottomA);
                            topLayers[0] = bottom;
                            topLayers[1] = top;
                            routeList.add(r);
                            continue;
                        }
                        if (!Job.getDebug()) continue;
                        bottomA = StitchFillJob.getArcInstOverlappingWithArea(pair.cut, ab, horizontal, false);
                        System.out.println("AFG: It couldn't find bottom layer for " + pair.cut);
                    }
                    for (Route r : routeList) {
                        Router.createRouteNoJob(r, theCell, arcsCreatedMap, nodesCreatedMap);
                    }
                }
            }
        }
        Netlist netlist = theCell.getNetlist();
        Iterator<NodeInst> itNi = theCell.getNodes();
        while (itNi.hasNext()) {
            NodeInst ni = itNi.next();
            if (!ni.isCellInstance()) continue;
            ArrayList<String> doneExports = new ArrayList<String>();
            routeList.clear();
            SimpleWirer niRouter = new SimpleWirer();
            Iterator<Export> itE = ni.getExports();
            while (itE.hasNext()) {
                Export export = itE.next();
                String exportName = export.getName();
                String rootName = StitchFillJob.extractRootName(exportName);
                if (doneExports.contains(rootName)) continue;
                PrimitiveNode n2 = export.getBasePort().getParent();
                Layer layer = n2.getLayerIterator().next();
                PortInst pi = export.getOriginalPort();
                PortProto epi = pi.getPortProto();
                EPoint exportCenter = pi.getCenter();
                NodeProto np = epi.getParent();
                if (!(np instanceof Cell)) continue;
                Cell c = (Cell)np;
                Netlist netl = c.getNetlist();
                Network jExp = netl.getNetwork((Export)epi, 0);
                Area expA = new Area();
                Iterator<ArcInst> itA = jExp.getArcs();
                while (itA.hasNext()) {
                    ArcInst ai = itA.next();
                    Layer l3 = ai.getProto().getLayer(0);
                    if (l3 != layer) continue;
                    expA.add(new Area(ai.getBounds()));
                }
                Rectangle2D bestCut = null;
                ArcInst bestArc = null;
                EPoint bestCenter = null;
                double bestDistance = Double.MAX_VALUE;
                List<Network> netList = StitchFillJob.getNetworkFromName(netlist, rootName);
                for (Network jNet : netList) {
                    Iterator<ArcInst> itA2 = jNet.getArcs();
                    while (itA2.hasNext()) {
                        ArcInst ai = itA2.next();
                        Layer l4 = ai.getProto().getLayer(0);
                        if (l4 == layer) {
                            System.out.println("found in same layer");
                            continue;
                        }
                        if (Math.abs(l4.getIndex() - layer.getIndex()) > 1) continue;
                        Area bnd = new Area(ai.getBounds());
                        bnd.intersect(expA);
                        if (bnd.isEmpty()) continue;
                        Rectangle2D cut = bnd.getBounds2D();
                        EPoint center = new EPoint(cut.getCenterX(), cut.getCenterY());
                        double dist = DBMath.distBetweenPoints(center, exportCenter);
                        if (bestCenter != null && !DBMath.isLessThan(dist, bestDistance)) continue;
                        bestCenter = center;
                        bestCut = cut;
                        bestArc = ai;
                        bestDistance = dist;
                    }
                }
                if (bestCut == null) continue;
                Route r = niRouter.planRoute(theCell, bestArc, pi, bestCenter, null, true, true, bestCut);
                routeList.add(r);
                doneExports.add(rootName);
            }
            for (Route route : routeList) {
                Router.createRouteNoJob(route, theCell, arcsCreatedMap, nodesCreatedMap);
            }
        }
        HashSet<Export> toDelete = new HashSet<Export>();
        HashMap<String, Export> inBottomLayer = new HashMap<String, Export>();
        HashMap<Network, Layer> maximumLayer = new HashMap<Network, Layer>();
        Iterator<Export> itE = theCell.getExports();
        while (itE.hasNext()) {
            exp = itE.next();
            PrimitiveNode primitiveNode = exp.getBasePort().getParent();
            Network net = netlist.getNetwork(exp, 0);
            Layer l5 = (Layer)maximumLayer.get(net);
            Iterator<Layer> itL2 = primitiveNode.getLayerIterator();
            while (itL2.hasNext()) {
                Layer lnew = itL2.next();
                if (l5 == null) {
                    l5 = lnew;
                    continue;
                }
                if (lnew.getFunction().getLevel() <= l5.getFunction().getLevel()) continue;
                l5 = lnew;
            }
            maximumLayer.put(net, l5);
        }
        itE = theCell.getExports();
        while (itE.hasNext()) {
            exp = itE.next();
            PrimitiveNode primitiveNode = exp.getBasePort().getParent();
            boolean found = false;
            String rootName = StitchFillJob.extractRootName(exp.getName());
            Layer topLayer = (Layer)maximumLayer.get(netlist.getNetwork(exp, 0));
            int levelMax = topLayer.getFunction().getLevel();
            Iterator<Layer> itL3 = primitiveNode.getLayerIterator();
            while (itL3.hasNext()) {
                l = itL3.next();
                int level = ((Layer)l).getFunction().getLevel();
                if (level == levelMax || level == levelMax - 1) {
                    found = true;
                    continue;
                }
                inBottomLayer.put(rootName, exp);
            }
            if (found) continue;
            toDelete.add(exp);
        }
        if (wideOption) {
            HashMap<String, Serializable> newExports = new HashMap<String, Serializable>();
            for (Map.Entry entry : inBottomLayer.entrySet()) {
                Export exp2 = (Export)entry.getValue();
                String rootName = StitchFillJob.extractRootName(exp2.getName());
                Network net = netlist.getNetwork(exp2, 0);
                List<ArcInst> arcs = StitchFillJob.getArcsInGivenLayer(net.getArcs(), bottomLayer, null, null);
                Area area = (Area)totalAreas.get(rootName);
                l = new ArrayList();
                List<PolyBase> list = PolyBase.getPointsInArea(area, bottomLayer, false, false);
                if (list == null) continue;
                block23: for (PolyBase b : list) {
                    Rectangle2D resultBnd = b.getBounds2D();
                    EPoint insert = new EPoint(resultBnd.getCenterX(), resultBnd.getCenterY());
                    for (ArcInst ai : arcs) {
                        Rectangle2D bnd = ai.getBounds();
                        if (!bnd.contains(insert.getX(), insert.getY())) continue;
                        boolean horizontal = !DBMath.isGreaterThan(bnd.getWidth(), bnd.getHeight());
                        PinsArcPair split = new PinsArcPair(ai, insert, null, horizontal);
                        l.add(split);
                        continue block23;
                    }
                }
                newExports.put(rootName, l);
            }
            for (Map.Entry entry : newExports.entrySet()) {
                List pairs = (List)entry.getValue();
                for (PinsArcPair pair : pairs) {
                    SplitContainter split = StitchFillJob.splitArcAtPoint(pair.topArc, pair.insert);
                    Export.newInstance(theCell, split.splitPin.getPortInst(0), (String)entry.getKey(), PortCharacteristic.UNKNOWN);
                }
            }
        }
        if (topLayers[0] != null || topLayers[1] != null) {
            theCell.killExports(toDelete);
        }
        netlist = theCell.getNetlist();
        Iterator<Network> itN = netlist.getNetworks();
        while (itN.hasNext()) {
            String rootName;
            String string;
            Network net = itN.next();
            if (!net.isExported() || (string = net.getName()).equals(rootName = StitchFillJob.extractRootName(string))) continue;
            Export exp3 = net.getExports().next();
            exp3.rename(rootName);
        }
        return true;
    }

    private static ArcInst getArcInstOverlappingWithArea(Rectangle2D resultBnd, List<ArcInst> at, boolean horizontal, boolean topLayer) {
        Area topArea = new Area(resultBnd);
        for (ArcInst ai : at) {
            Rectangle2D r = ai.getBounds();
            if (!r.intersects(resultBnd)) continue;
            Area rArea = new Area(r);
            rArea.intersect(topArea);
            Rectangle2D rect = rArea.getBounds2D();
            boolean validArc = horizontal && topLayer || !horizontal && !topLayer ? DBMath.areEquals(rect.getWidth(), r.getWidth()) : DBMath.areEquals(rect.getHeight(), r.getHeight());
            if (!validArc) continue;
            return ai;
        }
        return null;
    }

    private static List<Network> getNetworkFromName(Netlist netlist, String rootName) {
        ArrayList<Network> list = new ArrayList<Network>();
        Iterator<Network> it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            if (!net.getName().startsWith(rootName)) continue;
            list.add(net);
        }
        return list;
    }

    private static boolean isLayerHorizontal(Layer layer, boolean evenHorizontal) {
        int metalNumber = layer.getFunction().getLevel();
        return evenHorizontal && metalNumber % 2 == 0 || !evenHorizontal && metalNumber % 2 == 1;
    }

    private static List<ArcInst> getArcsInGivenLayer(Iterator<ArcInst> itAi, Layer layer, String exportName, Netlist netlist) {
        ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
        while (itAi.hasNext()) {
            ArcInst ai = itAi.next();
            Layer l = ai.getProto().getLayer(0);
            if (l != layer) continue;
            if (exportName != null) {
                Network jNet = netlist.getNetwork(ai, 0);
                Iterator<Export> itE = jNet.getExports();
                if (!itE.hasNext()) {
                    if (!Job.getDebug()) continue;
                    System.out.println("AFG: No export name associated to ArcInst '" + ai.getName() + "'");
                    continue;
                }
                Export exp = itE.next();
                String expName = StitchFillJob.extractRootName(exp.getName());
                if (!expName.equals(exportName)) continue;
            }
            arcs.add(ai);
        }
        return arcs;
    }

    private static boolean isArcAligned(ArcInst ai, boolean horizontal) {
        EPoint head = ai.getHeadLocation();
        EPoint tail = ai.getTailLocation();
        if (horizontal) {
            return DBMath.areEquals(head.getY(), tail.getY());
        }
        return DBMath.areEquals(head.getX(), tail.getX());
    }

    private static String extractRootName(String name) {
        int index = name.indexOf("_");
        if (index != -1) {
            name = name.substring(0, index);
        }
        return name;
    }

    private static String getExportRootName(ArcInst ai, Netlist netlist) {
        Network jNet = netlist.getNetwork(ai, 0);
        if (jNet == null) {
            return null;
        }
        assert (jNet != null);
        Iterator<String> exportNames = jNet.getExportedNames();
        if (!exportNames.hasNext()) {
            return null;
        }
        return StitchFillJob.extractRootName(exportNames.next());
    }

    private static SplitContainter splitArcAtPoint(ArcInst ai, EPoint insert) {
        ArcProto ap = ai.getProto();
        PrimitiveNode np = ap.findPinProto();
        if (np == null) {
            return null;
        }
        NodeInst ni = NodeInst.makeInstance(np, insert, np.getDefWidth(), np.getDefHeight(), ai.getParent());
        if (ni == null) {
            System.out.println("Cannot create pin " + np.describe(true));
            return null;
        }
        SplitContainter container = new SplitContainter();
        container.splitPin = ni;
        PortInst pi = ni.getOnlyPortInst();
        PortInst headPort = ai.getHeadPortInst();
        PortInst tailPort = ai.getTailPortInst();
        EPoint headPt = ai.getHeadLocation();
        EPoint tailPt = ai.getTailLocation();
        double width = ai.getLambdaBaseWidth();
        ArcInst newAi1 = ArcInst.makeInstanceBase(ap, width, headPort, pi, headPt, insert, null);
        ArcInst newAi2 = ArcInst.makeInstanceBase(ap, width, pi, tailPort, insert, tailPt, null);
        newAi1.setHeadNegated(ai.isHeadNegated());
        newAi1.setHeadExtended(ai.isHeadExtended());
        newAi1.setHeadArrowed(ai.isHeadArrowed());
        newAi1.setTailNegated(ai.isTailNegated());
        newAi1.setTailExtended(ai.isTailExtended());
        newAi1.setTailArrowed(ai.isTailArrowed());
        newAi2.setHeadNegated(ai.isHeadNegated());
        newAi2.setHeadExtended(ai.isHeadExtended());
        newAi2.setHeadArrowed(ai.isHeadArrowed());
        newAi2.setTailNegated(ai.isTailNegated());
        newAi2.setTailExtended(ai.isTailExtended());
        newAi2.setTailArrowed(ai.isTailArrowed());
        if (StitchFillJob.isLeftTop(headPt, tailPt)) {
            container.leftArc = newAi1;
            container.rightArc = newAi2;
        } else {
            container.leftArc = newAi2;
            container.rightArc = newAi1;
        }
        ai.kill();
        return container;
    }

    private static boolean isLeftTop(Point2D p1, Point2D p2) {
        if (DBMath.areEquals(p1.getX(), p2.getX())) {
            return !DBMath.isGreaterThan(p1.getY(), p2.getY());
        }
        if (DBMath.areEquals(p1.getY(), p2.getY())) {
            return !DBMath.isGreaterThan(p1.getX(), p2.getX());
        }
        System.out.println("Case not considered in FillJob:isLeftTop");
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PinsArcPairSort
    implements Comparator<PinsArcPair> {
        private PinsArcPairSort() {
        }

        @Override
        public int compare(PinsArcPair l1, PinsArcPair l2) {
            EPoint p1 = l1.insert;
            EPoint p2 = l2.insert;
            return StitchFillJob.isLeftTop(p2, p1) ? 1 : -1;
        }
    }

    private static class ExtraArea {
        Area[] areas = new Area[2];

        ExtraArea(Area a, boolean hoz) {
            int pos = hoz ? 0 : 1;
            this.areas[pos] = a;
        }

        Area getArea(boolean hoz) {
            int pos = hoz ? 0 : 1;
            return this.areas[pos];
        }

        void setArea(Area a, boolean hoz) {
            int pos;
            int n = pos = hoz ? 0 : 1;
            assert (this.areas[pos] == null);
            this.areas[pos] = a;
        }
    }

    private static class SplitContainter {
        NodeInst splitPin;
        ArcInst leftArc;
        ArcInst rightArc;

        private SplitContainter() {
        }
    }

    private static class PinsArcPair {
        private ArcInst topArc;
        private EPoint insert;
        private Rectangle2D cut;
        private boolean horizontal;

        PinsArcPair(ArcInst topA, EPoint point, Rectangle2D c, boolean hoz) {
            boolean extra;
            this.topArc = topA;
            this.insert = point;
            this.cut = c;
            this.horizontal = hoz;
            Rectangle2D r = topA.getBounds();
            boolean bl = extra = !DBMath.isGreaterThan(r.getWidth(), r.getHeight());
            assert (extra == hoz);
        }
    }

    private class TileInfo {
        int x;
        int y;

        TileInfo(int a, int b) {
            this.x = a;
            this.y = b;
        }
    }
}

