/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc;

import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import java.util.HashMap;
import java.util.Map;

public class ERC
extends Tool {
    protected static ERC tool = new ERC();
    private static Map<ArcProto, Pref> defaultAntennaRatioPrefs = new HashMap<ArcProto, Pref>();
    private static Pref cachePWellCheck = Pref.makeIntPref("PWellCheck", ERC.tool.prefs, 0);
    private static Pref cacheMustConnectPWellToGround = Pref.makeBooleanPref("MustConnectPWellToGround", ERC.tool.prefs, true);
    private static Pref cacheParallelWellAnalysis = Pref.makeBooleanPref("ParallelWellAnalysis", ERC.tool.prefs, true);
    private static Pref cacheWellAnalysisNumProc = Pref.makeIntPref("WellAnalysisNumProc", ERC.tool.prefs, 0);
    private static Pref cacheNWellCheck = Pref.makeIntPref("NWellCheck", ERC.tool.prefs, 0);
    private static Pref cacheMustConnectNWellToPower = Pref.makeBooleanPref("MustConnectNWellToPower", ERC.tool.prefs, true);
    private static Pref cacheFindWorstCaseWellContact = Pref.makeBooleanPref("FindWorstCaseWell", ERC.tool.prefs, false);
    private static Pref cacheDRCCheck = Pref.makeBooleanPref("DRCCheckInERC", ERC.tool.prefs, false);

    private ERC() {
        super("erc");
    }

    public void init() {
    }

    public static ERC getERCTool() {
        return tool;
    }

    public static int getPWellCheck() {
        return cachePWellCheck.getInt();
    }

    public static void setPWellCheck(int c) {
        cachePWellCheck.setInt(c);
    }

    public static int getFactoryPWellCheck() {
        return cachePWellCheck.getIntFactoryValue();
    }

    public static boolean isMustConnectPWellToGround() {
        return cacheMustConnectPWellToGround.getBoolean();
    }

    public static void setMustConnectPWellToGround(boolean on) {
        cacheMustConnectPWellToGround.setBoolean(on);
    }

    public static boolean isFactoryMustConnectPWellToGround() {
        return cacheMustConnectPWellToGround.getBooleanFactoryValue();
    }

    public static boolean isParallelWellAnalysis() {
        return cacheParallelWellAnalysis.getBoolean();
    }

    public static void setParallelWellAnalysis(boolean on) {
        cacheParallelWellAnalysis.setBoolean(on);
    }

    public static boolean isFactoryParallelWellAnalysis() {
        return cacheParallelWellAnalysis.getBooleanFactoryValue();
    }

    public static int getWellAnalysisNumProc() {
        return cacheWellAnalysisNumProc.getInt();
    }

    public static void setWellAnalysisNumProc(int p) {
        cacheWellAnalysisNumProc.setInt(p);
    }

    public static int getFactoryWellAnalysisNumProc() {
        return cacheWellAnalysisNumProc.getIntFactoryValue();
    }

    public static int getNWellCheck() {
        return cacheNWellCheck.getInt();
    }

    public static void setNWellCheck(int c) {
        cacheNWellCheck.setInt(c);
    }

    public static int getFactoryNWellCheck() {
        return cacheNWellCheck.getIntFactoryValue();
    }

    public static boolean isMustConnectNWellToPower() {
        return cacheMustConnectNWellToPower.getBoolean();
    }

    public static void setMustConnectNWellToPower(boolean on) {
        cacheMustConnectNWellToPower.setBoolean(on);
    }

    public static boolean isFactoryMustConnectNWellToPower() {
        return cacheMustConnectNWellToPower.getBooleanFactoryValue();
    }

    public static boolean isFindWorstCaseWell() {
        return cacheFindWorstCaseWellContact.getBoolean();
    }

    public static void setFindWorstCaseWell(boolean on) {
        cacheFindWorstCaseWellContact.setBoolean(on);
    }

    public static boolean isFactoryFindWorstCaseWell() {
        return cacheFindWorstCaseWellContact.getBooleanFactoryValue();
    }

    public static boolean isDRCCheck() {
        return cacheDRCCheck.getBoolean();
    }

    public static void setDRCCheck(boolean on) {
        cacheDRCCheck.setBoolean(on);
    }

    public static boolean isFactoryDRCCheck() {
        return cacheDRCCheck.getBooleanFactoryValue();
    }

    private Pref getArcProtoAntennaPref(ArcProto ap) {
        Pref pref = defaultAntennaRatioPrefs.get(ap);
        if (pref == null) {
            double factory = 200.0;
            if (ap.getFunction().isMetal()) {
                factory = 400.0;
            }
            Technology tech = ap.getTechnology();
            pref = Pref.makeDoublePref("DefaultAntennaRatioFor" + ap.getName() + "IN" + tech.getTechName(), tech.getTechnologyPreferences(), factory);
            defaultAntennaRatioPrefs.put(ap, pref);
        }
        return pref;
    }

    public void setAntennaRatio(ArcProto ap, double ratio) {
        this.getArcProtoAntennaPref(ap).setDouble(ratio);
    }

    public double getAntennaRatio(ArcProto ap) {
        return this.getArcProtoAntennaPref(ap).getDouble();
    }

    public double getFactoryAntennaRatio(ArcProto ap) {
        return this.getArcProtoAntennaPref(ap).getDoubleFactoryValue();
    }
}

