/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.Main;
import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitiveNodeSize;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.XMLRules;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.EFIDO;
import com.sun.electric.technology.technologies.FPGA;
import com.sun.electric.technology.technologies.GEM;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.technology.xml.Xml807;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.projectSettings.ProjSettings;
import com.sun.electric.tool.user.projectSettings.ProjSettingsNode;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Technology
implements Comparable<Technology>,
Serializable {
    private static final boolean LAZY_TECHNOLOGIES = false;
    public static final Version DISK_VERSION_1 = Version.parseVersion("8.05g");
    public static final Version DISK_VERSION_2 = Version.parseVersion("8.05o");
    public static final Technology[] NULL_ARRAY = new Technology[0];
    public static final ImmutableArrayList<Technology> EMPTY_LIST = new ImmutableArrayList<Technology>(NULL_ARRAY);
    public static final Variable.Key TRANS_CONTACT = Variable.newKey("MOCMOS_transcontacts");
    public static final String SPECIALMENUCELL = "Cell";
    public static final String SPECIALMENUMISC = "Misc.";
    public static final String SPECIALMENUPURE = "Pure";
    public static final String SPECIALMENUSPICE = "Spice";
    public static final String SPECIALMENUEXPORT = "Export";
    public static final String SPECIALMENUTEXT = "Text";
    public static final String SPECIALMENUHIGH = "High";
    public static final String SPECIALMENUPORT = "Port";
    public static DistanceContext EMPTY_CONTEXT = new DistanceContext(){

        public double getRule(String ruleName) {
            throw new UnsupportedOperationException();
        }
    };
    private static final int NONELECTRICAL = 1;
    private static final int NODIRECTIONALARCS = 2;
    private static final int NONEGATEDARCS = 4;
    private static final int NONSTANDARD = 8;
    private static final int STATICTECHNOLOGY = 16;
    private static final int NOPRIMTECHNOLOGY = 32;
    private static Pref.Group prefs = null;
    private static Technology curTech = null;
    private static Technology curLayoutTech = null;
    private static int techNumber = 0;
    final Generic generic;
    private final TechId techId;
    private String techShortName;
    private String techDesc;
    private int userBits;
    private int techIndex;
    private boolean scaleRelevant;
    private int transparentLayers;
    private Pref[] transparentColorPrefs;
    private Color[] colorMap;
    private final List<Layer> layers = new ArrayList<Layer>();
    private final HashMap<String, Layer> layersByName = new HashMap();
    private boolean layersAllocationLocked;
    private final LinkedHashMap<String, PrimitiveNode> nodes = new LinkedHashMap();
    private PrimitiveNode[] nodesByChronIndex = new PrimitiveNode[0];
    protected final HashMap<String, PrimitiveNode> oldNodeNames = new HashMap();
    private int nodeIndex = 0;
    private final LinkedHashMap<String, ArcProto> arcs = new LinkedHashMap();
    private ArcProto[] arcsByChronIndex = new ArcProto[0];
    protected final HashMap<String, ArcProto> oldArcNames = new HashMap();
    private String[] spiceHeaderLevel1;
    private String[] spiceHeaderLevel2;
    private String[] spiceHeaderLevel3;
    private Pref prefResolution;
    protected final List<Foundry> foundries = new ArrayList<Foundry>();
    private final Setting cacheFoundry;
    private Setting cacheScale;
    private final Setting cacheNumMetalLayers;
    private Setting cacheMinResistance;
    private Setting cacheMinCapacitance;
    private final Setting cacheGateLengthSubtraction;
    private final Setting cacheIncludeGate;
    private final Setting cacheIncludeGnd;
    private final Setting cacheMaxSeriesResistance;
    private Setting cacheGateCapacitance;
    private Setting cacheWireRatio;
    private Setting cacheDiffAlpha;
    private static double DEFAULT_GATECAP = 0.4;
    private static double DEFAULT_WIRERATIO = 0.16;
    private static double DEFAULT_DIFFALPHA = 0.7;
    protected Object[][] nodeGroups;
    protected Object[][] factoryNodeGroups;
    public static final int N_TYPE = 1;
    public static final int P_TYPE = 0;
    protected DRCRules cachedRules = null;
    protected Xml.Technology xmlTech;
    private Pref componentMenuPref = null;
    private Pref layerOrderPref = null;
    protected static Generic sysGeneric;
    protected static Artwork sysArtwork;
    protected static FPGA sysFPGA;
    protected static Schematics sysSchematics;
    private static Pref softTechnologyList;
    private static Technology mocmos;
    private static boolean mocmosCached;
    private static Technology tsmc180;
    private static boolean tsmc180Cached;
    private static Technology cmos90;
    private static boolean cmos90Cached;
    public static final LayerHeight LAYERS_BY_HEIGHT;
    public static final LayerHeight LAYERS_BY_HEIGHT_LIFT_CONTACTS;
    public static final LayerZValueSorting LAYERS_BY_ZVALUE;
    private static final Layer.Function.Set diffLayers;
    private static final NodeLayer[] nullPrimLayers;
    public static final Variable.Key TECH_TMPVAR;

    public SizeCorrector getSizeCorrector(Version version, Map<Setting, Object> projectSettings, boolean isJelib, boolean keepExtendOverMin) {
        return new SizeCorrector(version, isJelib);
    }

    protected void setArcCorrection(SizeCorrector sc, String arcName, double lambdaBaseWidth) {
        ArcProto ap = this.findArcProto(arcName);
        Integer correction = sc.arcExtends.get(ap.getId());
        int gridBaseExtend = (int)DBMath.lambdaToGrid(0.5 * lambdaBaseWidth);
        if (gridBaseExtend != ap.getGridBaseExtend()) {
            correction = correction + gridBaseExtend - ap.getGridBaseExtend();
            sc.arcExtends.put(ap.getId(), correction);
        }
    }

    protected Technology(Generic generic, String techName) {
        this(generic, techName, Foundry.Type.NONE, 0);
    }

    protected Technology(Generic generic, String techName, Foundry.Type defaultFoundry, int defaultNumMetals) {
        this(generic.getId().idManager, generic, techName, defaultFoundry, defaultNumMetals);
    }

    protected Technology(IdManager idManager, Generic generic, String techName, Foundry.Type defaultFoundry, int defaultNumMetals) {
        if (this instanceof Generic) {
            assert (generic == null);
            generic = (Generic)this;
        }
        this.generic = generic;
        this.techId = idManager.newTechId(techName);
        this.scaleRelevant = true;
        this.techIndex = techNumber++;
        this.userBits = 0;
        if (prefs == null) {
            prefs = Pref.groupForPackage(Schematics.class);
        }
        this.cacheFoundry = TechSetting.makeStringSetting(this, "SelectedFoundryFor" + techName, "Technology tab", techName + " foundry", this.getProjectSettings(), "Foundry", defaultFoundry.name().toUpperCase());
        this.cacheNumMetalLayers = TechSetting.makeIntSetting(this, techName + "NumberOfMetalLayers", "Technology tab", techName + ": Number of Metal Layers", this.getProjectSettings(), "NumMetalLayers", defaultNumMetals);
        this.cacheMaxSeriesResistance = this.makeParasiticSetting("MaxSeriesResistance", 10.0);
        this.cacheGateLengthSubtraction = this.makeParasiticSetting("GateLengthSubtraction", 0.0);
        this.cacheIncludeGate = this.makeParasiticSetting("Gate Inclusion", false);
        this.cacheIncludeGnd = this.makeParasiticSetting("Ground Net Inclusion", false);
    }

    protected Object writeReplace() {
        return new TechnologyKey(this);
    }

    public Technology(Generic generic, Xml.Technology t) {
        this(generic, t.techName, Foundry.Type.valueOf(t.defaultFoundry), t.defaultNumMetals);
        this.xmlTech = t;
        this.setTechShortName(t.shortTechName);
        this.setTechDesc(t.description);
        this.setFactoryScale(t.scaleValue, t.scaleRelevant);
        this.setFactoryParasitics(t.minResistance, t.minCapacitance);
        if (!t.transparentLayers.isEmpty()) {
            this.setFactoryTransparentLayers(t.transparentLayers.toArray(new Color[t.transparentLayers.size()]));
        }
        HashMap<String, Layer> layers = new HashMap<String, Layer>();
        for (Xml.Layer l : t.layers) {
            Layer layer = Layer.newInstance(this, l.name, l.desc);
            layers.put(l.name, layer);
            layer.setFunction(l.function, l.extraFunction);
            if (l.cif != null) {
                layer.setFactoryCIFLayer(l.cif);
            }
            if (l.skill != null) {
                layer.setFactorySkillLayer(l.skill);
            }
            layer.setFactory3DInfo(l.thick3D, l.height3D, l.mode3D, l.factor3D);
            layer.setFactoryParasitics(l.resistance, l.capacitance, l.edgeCapacitance);
        }
        HashMap<String, ArcProto> arcs = new HashMap<String, ArcProto>();
        for (Xml.ArcProto a : t.arcs) {
            if (this.findArcProto(a.name) != null) {
                System.out.println("Error: technology " + this.getTechName() + " has multiple arcs named " + a.name);
                continue;
            }
            ArcLayer[] arcLayers = new ArcLayer[a.arcLayers.size()];
            for (int i = 0; i < arcLayers.length; ++i) {
                Xml.ArcLayer al = a.arcLayers.get(i);
                Distance d = new Distance();
                d.addLambda(al.extend.value);
                arcLayers[i] = new ArcLayer((Layer)layers.get(al.layer), al.style, d);
            }
            Double diskOffset1 = a.diskOffset.get(1);
            Double diskOffset2 = a.diskOffset.get(2);
            long halfElibWidthOffset = 0L;
            if (diskOffset1 != null && diskOffset2 != null) {
                halfElibWidthOffset = DBMath.lambdaToGrid(diskOffset1 - diskOffset2);
            }
            ArcProto ap = new ArcProto(this, a.name, halfElibWidthOffset, 0L, a.function, arcLayers, arcs.size());
            this.addArcProto(ap);
            if (a.oldName != null) {
                this.oldArcNames.put(a.oldName, ap);
            }
            arcs.put(a.name, ap);
            if (a.wipable) {
                ap.setWipable();
            }
            if (a.curvable) {
                ap.setCurvable();
            }
            if (a.special) {
                ap.setSpecialArc();
            }
            if (a.notUsed) {
                ap.setNotUsed(true);
            }
            if (a.skipSizeInPalette) {
                ap.setSkipSizeInPalette();
            }
            ap.setFactoryExtended(a.extended);
            ap.setFactoryFixedAngle(a.fixedAngle);
            ap.setFactoryAngleIncrement(a.angleIncrement);
            ERC.getERCTool().setAntennaRatio(ap, a.antennaRatio);
        }
        this.setNoNegatedArcs();
        DistanceContext context = EMPTY_CONTEXT;
        for (Xml.PrimitiveNode n : t.nodes) {
            long ly;
            long hy;
            long lx;
            long hx;
            EPoint sizeCorrector1 = n.diskOffset.get(1);
            EPoint sizeCorrector2 = n.diskOffset.get(2);
            if (sizeCorrector2 == null) {
                sizeCorrector2 = EPoint.ORIGIN;
            }
            if (sizeCorrector1 == null) {
                sizeCorrector1 = sizeCorrector2;
            }
            String minSizeRule = null;
            if (n.nodeSizeRule != null) {
                hx = DBMath.lambdaToGrid(0.5 * n.nodeSizeRule.width);
                lx = -hx;
                hy = DBMath.lambdaToGrid(0.5 * n.nodeSizeRule.height);
                ly = -hy;
                minSizeRule = n.nodeSizeRule.rule;
            } else {
                lx = Long.MAX_VALUE;
                hx = Long.MIN_VALUE;
                ly = Long.MAX_VALUE;
                hy = Long.MIN_VALUE;
                for (int i = 0; i < n.nodeLayers.size(); ++i) {
                    long y;
                    long x;
                    Xml.NodeLayer nl = n.nodeLayers.get(i);
                    if (nl.representation == 1 || nl.representation == 3) {
                        x = DBMath.lambdaToGrid(nl.lx.value);
                        lx = Math.min(lx, x);
                        hx = Math.max(hx, x);
                        x = DBMath.lambdaToGrid(nl.hx.value);
                        lx = Math.min(lx, x);
                        hx = Math.max(hx, x);
                        y = DBMath.lambdaToGrid(nl.ly.value);
                        ly = Math.min(ly, y);
                        hy = Math.max(hy, y);
                        y = DBMath.lambdaToGrid(nl.hy.value);
                        ly = Math.min(ly, y);
                        hy = Math.max(hy, y);
                        continue;
                    }
                    for (TechPoint p : nl.techPoints) {
                        x = p.x.getGridAdder();
                        lx = Math.min(lx, x);
                        hx = Math.max(hx, x);
                        y = p.y.getGridAdder();
                        ly = Math.min(ly, y);
                        hy = Math.max(hy, y);
                    }
                }
            }
            ERectangle fullRectangle = ERectangle.fromGrid(lx, ly, hx - lx, hy - ly);
            EPoint fullSize = EPoint.fromGrid((hx - lx + 1L) / 2L, (hy - ly + 1L) / 2L);
            boolean needElectricalLayers = false;
            ArrayList<NodeLayer> nodeLayers = new ArrayList<NodeLayer>();
            ArrayList<NodeLayer> electricalNodeLayers = new ArrayList<NodeLayer>();
            for (int i = 0; i < n.nodeLayers.size(); ++i) {
                TechPoint[] techPoints;
                Xml.NodeLayer nl = n.nodeLayers.get(i);
                if (nl.representation == 1 || nl.representation == 3) {
                    techPoints = new TechPoint[2];
                    if (nl.lx.value > nl.hx.value || nl.lx.k > nl.hx.k || nl.ly.value > nl.hy.value || nl.ly.k > nl.hy.k) {
                        System.out.println("Strange polygon in " + this.getTechName() + ":" + n.name);
                    }
                    techPoints[0] = this.makeTechPoint(nl.lx, nl.ly, context, fullSize);
                    techPoints[1] = this.makeTechPoint(nl.hx, nl.hy, context, fullSize);
                } else {
                    techPoints = nl.techPoints.toArray(new TechPoint[nl.techPoints.size()]);
                    for (int j = 0; j < techPoints.length; ++j) {
                        techPoints[j] = this.makeTechPoint(techPoints[j], fullSize);
                    }
                }
                Layer layer = (Layer)layers.get(nl.layer);
                if (n.shrinkArcs) {
                    if (layer.getPseudoLayer() == null) {
                        layer.makePseudo();
                    }
                    layer = layer.getPseudoLayer();
                }
                NodeLayer nodeLayer = nl.representation == 3 ? NodeLayer.makeMulticut(layer, nl.portNum, nl.style, techPoints, nl.sizex, nl.sizey, nl.sep1d, nl.sep2d) : (n.specialType == 1 ? new NodeLayer(layer, nl.portNum, nl.style, nl.representation, techPoints, nl.lWidth, nl.rWidth, nl.tExtent, nl.bExtent) : new NodeLayer(layer, nl.portNum, nl.style, nl.representation, techPoints));
                if (!nl.inLayers || !nl.inElectricalLayers) {
                    needElectricalLayers = true;
                }
                if (nl.inLayers) {
                    nodeLayers.add(nodeLayer);
                }
                if (!nl.inElectricalLayers) continue;
                electricalNodeLayers.add(nodeLayer);
            }
            if (n.sizeOffset != null) {
                lx += n.sizeOffset.getLowXGridOffset();
                hx -= n.sizeOffset.getHighXGridOffset();
                ly += n.sizeOffset.getLowYGridOffset();
                hy -= n.sizeOffset.getHighYGridOffset();
            }
            ERectangle baseRectangle = ERectangle.fromGrid(lx, ly, hx - lx, hy - ly);
            PrimitiveNode pnp = PrimitiveNode.newInstance(n.name, this, sizeCorrector1, sizeCorrector2, minSizeRule, DBMath.round(n.defaultWidth.value + 2.0 * fullSize.getLambdaX()), DBMath.round(n.defaultHeight.value + 2.0 * fullSize.getLambdaY()), fullRectangle, baseRectangle, nodeLayers.toArray(new NodeLayer[nodeLayers.size()]));
            if (n.oldName != null) {
                this.oldNodeNames.put(n.oldName, pnp);
            }
            pnp.setFunction(n.function);
            if (needElectricalLayers) {
                pnp.setElectricalLayers(electricalNodeLayers.toArray(new NodeLayer[electricalNodeLayers.size()]));
            }
            if (n.shrinkArcs) {
                pnp.setArcsWipe();
                pnp.setArcsShrink();
            }
            if (n.square) {
                pnp.setSquare();
            }
            if (n.canBeZeroSize) {
                pnp.setCanBeZeroSize();
            }
            if (n.wipes) {
                pnp.setWipeOn1or2();
            }
            if (n.lockable) {
                pnp.setLockedPrim();
            }
            if (n.edgeSelect) {
                pnp.setEdgeSelect();
            }
            if (n.skipSizeInPalette) {
                pnp.setSkipSizeInPalette();
            }
            if (n.notUsed) {
                pnp.setNotUsed(true);
            }
            if (n.lowVt) {
                pnp.setNodeBit(8);
            }
            if (n.highVt) {
                pnp.setNodeBit(16);
            }
            if (n.nativeBit) {
                pnp.setNodeBit(32);
            }
            if (n.od18) {
                pnp.setNodeBit(64);
            }
            if (n.od25) {
                pnp.setNodeBit(128);
            }
            if (n.od33) {
                pnp.setNodeBit(256);
            }
            PrimitivePort[] ports = new PrimitivePort[n.ports.size()];
            for (int i = 0; i < ports.length; ++i) {
                Xml.PrimitivePort p = n.ports.get(i);
                if (p.lx.value > p.hx.value || p.lx.k > p.hx.k || p.ly.value > p.hy.value || p.ly.k > p.hy.k) {
                    System.out.println("Strange polygon in " + this.getTechName() + ":" + n.name + ":" + p.name);
                }
                EdgeH elx = this.makeEdgeH(p.lx, context, fullSize);
                EdgeH ehx = this.makeEdgeH(p.hx, context, fullSize);
                EdgeV ely = this.makeEdgeV(p.ly, context, fullSize);
                EdgeV ehy = this.makeEdgeV(p.hy, context, fullSize);
                ports[i] = PrimitivePort.newInstance(this, pnp, this.makeConnections(p.portArcs, arcs), p.name, p.portAngle, p.portRange, p.portTopology, PortCharacteristic.UNKNOWN, elx, ely, ehx, ehy);
            }
            pnp.addPrimitivePorts(ports);
            pnp.setSpecialType(n.specialType);
            switch (n.specialType) {
                case 2: {
                    pnp.setHoldsOutline();
                    break;
                }
                case 1: {
                    pnp.setHoldsOutline();
                    pnp.setCanShrink();
                    pnp.setSpecialValues(n.specialValues);
                    break;
                }
            }
            if (n.function == PrimitiveNode.Function.NODE) {
                assert (pnp.getLayers().length == 1);
                Layer layer = pnp.getLayers()[0].getLayer();
                assert (layer.getPureLayerNode() == null);
                layer.setPureLayerNode(pnp);
            }
            if (n.spiceTemplate == null) continue;
            pnp.setSpiceTemplate(n.spiceTemplate);
        }
        for (Xml.Layer l : t.layers) {
            if (l.pureLayerNode == null) continue;
            Layer layer = (Layer)layers.get(l.name);
            PrimitiveNode pn = layer.makePureLayerNode(l.pureLayerNode.name, l.pureLayerNode.size.value, l.pureLayerNode.style, l.pureLayerNode.port, this.makeConnections(l.pureLayerNode.portArcs, arcs));
            if (l.pureLayerNode.oldName == null) continue;
            this.oldNodeNames.put(l.pureLayerNode.oldName, pn);
        }
        this.convertMenuPalette(t.menuPalette);
        for (Xml.SpiceHeader h : t.spiceHeaders) {
            String[] spiceLines = h.spiceLines.toArray(new String[h.spiceLines.size()]);
            switch (h.level) {
                case 1: {
                    this.setSpiceHeaderLevel1(spiceLines);
                    break;
                }
                case 2: {
                    this.setSpiceHeaderLevel2(spiceLines);
                    break;
                }
                case 3: {
                    this.setSpiceHeaderLevel3(spiceLines);
                }
            }
        }
        for (Xml.Foundry f : t.foundries) {
            ArrayList<String> gdsLayers = new ArrayList<String>();
            for (Layer layer : this.layers) {
                String gds = f.layerGds.get(layer.getName());
                if (gds == null) continue;
                gdsLayers.add(layer.getName() + " " + gds);
            }
            Foundry foundry = new Foundry(this, Foundry.Type.valueOf(f.name), f.rules, gdsLayers.toArray(new String[gdsLayers.size()]));
            this.foundries.add(foundry);
        }
    }

    private ArcProto[] makeConnections(List<String> portArcs, HashMap<String, ArcProto> arcs) {
        ArcProto[] connections = new ArcProto[portArcs.size()];
        for (int j = 0; j < connections.length; ++j) {
            ArcProto ap = arcs.get(portArcs.get(j));
            if (ap == null) {
                throw new NoSuchElementException(portArcs.get(j));
            }
            connections[j] = ap;
        }
        return connections;
    }

    private TechPoint makeTechPoint(TechPoint p, EPoint correction) {
        EdgeH h = p.getX();
        EdgeV v = p.getY();
        h = new EdgeH(h.getMultiplier(), h.getAdder() - correction.getLambdaX() * h.getMultiplier() * 2.0);
        v = new EdgeV(v.getMultiplier(), v.getAdder() - correction.getLambdaY() * v.getMultiplier() * 2.0);
        return new TechPoint(h, v);
    }

    private TechPoint makeTechPoint(Xml.Distance x, Xml.Distance y, DistanceContext context, EPoint correction) {
        return new TechPoint(this.makeEdgeH(x, context, correction), this.makeEdgeV(y, context, correction));
    }

    private EdgeH makeEdgeH(Xml.Distance x, DistanceContext context, EPoint correction) {
        return new EdgeH(x.k * 0.5, x.value - correction.getLambdaX() * x.k);
    }

    private EdgeV makeEdgeV(Xml.Distance y, DistanceContext context, EPoint correction) {
        return new EdgeV(y.k * 0.5, y.value - correction.getLambdaY() * y.k);
    }

    private void convertMenuPalette(Xml.MenuPalette menuPalette) {
        if (menuPalette == null) {
            return;
        }
        int numColumns = menuPalette.numColumns;
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Object[] row = null;
        for (int i = 0; i < menuPalette.menuBoxes.size(); ++i) {
            List<Object> menuBoxList;
            int column = i % numColumns;
            if (column == 0) {
                row = new Object[numColumns];
                rows.add(row);
            }
            if ((menuBoxList = menuPalette.menuBoxes.get(i)) == null || menuBoxList.isEmpty()) continue;
            if (menuBoxList.size() == 1) {
                row[column] = this.convertMenuItem(menuBoxList.get(0));
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : menuBoxList) {
                list.add(this.convertMenuItem(o));
            }
            row[column] = list;
        }
        this.factoryNodeGroups = (Object[][])rows.toArray((T[])new Object[rows.size()][]);
        this.nodeGroups = this.factoryNodeGroups;
    }

    private Object convertMenuItem(Object menuItem) {
        if (menuItem instanceof Xml.ArcProto) {
            return this.findArcProto(((Xml.ArcProto)menuItem).name);
        }
        if (menuItem instanceof Xml.PrimitiveNode) {
            return this.findNodeProto(((Xml.PrimitiveNode)menuItem).name);
        }
        if (menuItem instanceof Xml.MenuNodeInst) {
            Xml.MenuNodeInst n = (Xml.MenuNodeInst)menuItem;
            boolean hasText = n.text != null;
            PrimitiveNode pn = this.findNodeProto(n.protoName);
            if (pn != null) {
                return Technology.makeNodeInst(pn, n.function, n.rotation, hasText, n.text, n.fontSize);
            }
        }
        return menuItem.toString();
    }

    public Xml.Technology getXmlTech() {
        return this.xmlTech;
    }

    protected void resizeXml(XMLRules rules) {
    }

    public static void initAllTechnologies() {
        TreeMap<String, String> lazyClasses = new TreeMap<String, String>();
        TreeMap<String, URL> lazyUrls = new TreeMap<String, URL>();
        Pref.delayPrefFlushing();
        EDatabase database = EDatabase.serverDatabase();
        sysGeneric = new Generic(database.getIdManager());
        sysGeneric.setup(database);
        sysArtwork = new Artwork(sysGeneric);
        sysArtwork.setup(database);
        sysFPGA = new FPGA(sysGeneric);
        sysFPGA.setup(database);
        sysSchematics = new Schematics(sysGeneric);
        sysSchematics.setup(database);
        Pref.resumePrefFlushing();
        lazyUrls.put("bicmos", Technology.class.getResource("technologies/bicmos.xml"));
        lazyUrls.put("bipolar", Technology.class.getResource("technologies/bipolar.xml"));
        lazyUrls.put("cmos", Technology.class.getResource("technologies/cmos.xml"));
        lazyClasses.put("efido", "com.sun.electric.technology.technologies.EFIDO");
        lazyClasses.put("gem", "com.sun.electric.technology.technologies.GEM");
        lazyClasses.put("pcb", "com.sun.electric.technology.technologies.PCB");
        lazyClasses.put("rcmos", "com.sun.electric.technology.technologies.RCMOS");
        lazyClasses.put("mocmos", "com.sun.electric.technology.technologies.MoCMOS");
        lazyUrls.put("mocmosold", Technology.class.getResource("technologies/mocmosold.xml"));
        lazyUrls.put("mocmossub", Technology.class.getResource("technologies/mocmossub.xml"));
        lazyUrls.put("nmos", Technology.class.getResource("technologies/nmos.xml"));
        lazyUrls.put("tft", Technology.class.getResource("technologies/tft.xml"));
        lazyUrls.put("tsmc180", Main.class.getResource("plugins/tsmc/tsmc180.xml"));
        lazyClasses.put("cmos90", "com.sun.electric.plugins.tsmc.CMOS90");
        List<String> softTechnologies = Technology.getSoftTechnologies();
        for (String softTechFile : softTechnologies) {
            URL url = TextUtils.makeURLToFile(softTechFile);
            if (TextUtils.URLExists(url)) {
                String softTechName = TextUtils.getFileNameWithoutExtension(url);
                lazyUrls.put(softTechName, url);
                continue;
            }
            System.out.println("WARNING: could not find added technology: " + softTechFile);
            System.out.println("  (fix this error in the 'Added Technologies' Project Settings)");
        }
        for (String techClassName : lazyClasses.values()) {
            Technology.setupTechnology(database, techClassName);
        }
        for (URL techUrl : lazyUrls.values()) {
            if (techUrl == null) continue;
            Technology.setupTechnology(database, techUrl);
        }
        curLayoutTech = Technology.getMocmosTechnology();
        Technology tech = Technology.findTechnology(User.getDefaultTechnology());
        if (tech == null) {
            tech = curLayoutTech;
        }
        tech.setCurrent();
    }

    public static List<String> getSoftTechnologies() {
        if (softTechnologyList == null) {
            softTechnologyList = Pref.makeStringPref("SoftTechnologies", prefs, "");
        }
        String techString = softTechnologyList.getString();
        ArrayList<String> techList = new ArrayList<String>();
        String[] techArray = techString.split(";");
        for (int i = 0; i < techArray.length; ++i) {
            if (techArray[i].length() <= 0) continue;
            techList.add(techArray[i]);
        }
        return techList;
    }

    public static void setSoftTechnologies(List<String> a) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < a.size(); ++i) {
            if (i != 0) {
                sb.append(";");
            }
            sb.append(a.get(i));
        }
        if (softTechnologyList == null) {
            softTechnologyList = Pref.makeStringPref("SoftTechnologies", prefs, "");
        }
        softTechnologyList.setString(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupTechnology(EDatabase database, String techClassName) {
        Pref.delayPrefFlushing();
        try {
            Class<?> techClass = Class.forName(techClassName);
            Technology tech = (Technology)techClass.getConstructor(Generic.class).newInstance(database.getGeneric());
            tech.setup(database);
        }
        catch (ClassNotFoundException e) {
            if (Job.getDebug()) {
                System.out.println("GNU Release can't find extra technologies");
            }
        }
        catch (Exception e) {
            System.out.println("Exceptions while importing extra technologies");
            ActivityLogger.logException(e);
        }
        finally {
            Pref.resumePrefFlushing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupTechnology(EDatabase database, URL urlXml) {
        Pref.delayPrefFlushing();
        try {
            Xml.Technology t = Xml.parseTechnology(urlXml);
            if (t == null) {
                throw new Exception("Can't load extra technology: " + urlXml);
            }
            if (Technology.findTechnology(t.techName) != null) {
                throw new Exception("Technology with the same name exists: " + t.techName);
            }
            Class techClass = Technology.class;
            if (t.className != null) {
                techClass = Class.forName(t.className);
            }
            Technology tech = (Technology)techClass.getConstructor(Generic.class, Xml.Technology.class).newInstance(database.getGeneric(), t);
            tech.setup(database);
        }
        catch (ClassNotFoundException e) {
            if (Job.getDebug()) {
                System.out.println("GNU Release can't find extra technologies");
            }
        }
        catch (Exception e) {
            System.out.println("Can't load extra technology: " + urlXml);
            ActivityLogger.logException(e.getCause() != null ? e.getCause() : e);
        }
        finally {
            Pref.resumePrefFlushing();
        }
    }

    public static Technology getMocmosTechnology() {
        if (!mocmosCached) {
            mocmosCached = true;
            mocmos = Technology.findTechnology("mocmos");
        }
        return mocmos;
    }

    public static Technology getTSMC180Technology() {
        if (!tsmc180Cached) {
            tsmc180Cached = true;
            tsmc180 = Technology.findTechnology("tsmc180");
            if (tsmc180 == null) {
                tsmc180Cached = false;
            }
        }
        return tsmc180;
    }

    public static Technology getCMOS90Technology() {
        if (!cmos90Cached) {
            cmos90Cached = true;
            cmos90 = Technology.findTechnology("cmos90");
            if (cmos90 == null) {
                cmos90Cached = false;
            }
        }
        return cmos90;
    }

    public void setup(EDatabase database) {
        database.addTech(this);
        this.setState();
        if (this.cacheMinResistance == null || this.cacheMinCapacitance == null) {
            this.setFactoryParasitics(10.0, 0.0);
        }
        if (this.cacheGateCapacitance == null || this.cacheWireRatio == null || this.cacheDiffAlpha == null) {
            this.setFactoryLESettings(DEFAULT_GATECAP, DEFAULT_WIRERATIO, DEFAULT_DIFFALPHA);
        }
        this.layersAllocationLocked = true;
        for (Foundry foundry : this.foundries) {
            foundry.finish();
        }
        for (Layer layer : this.layers) {
            if (layer.isPseudoLayer()) continue;
            layer.finish();
        }
        this.check();
    }

    public void setState() {
        EDatabase.theDatabase.checkChanging();
        if (this.xmlTech != null) {
            this.cachedRules = this.getFactoryDesignRules();
        }
    }

    protected void setNotUsed(int numPolys) {
        boolean isUsed;
        int numMetals = this.getNumMetals();
        for (PrimitiveNode pn : this.nodes.values()) {
            isUsed = true;
            for (NodeLayer nl : pn.getLayers()) {
                isUsed = isUsed && nl.getLayer().getFunction().isUsed(numMetals, numPolys);
            }
            pn.setNotUsed(!isUsed);
        }
        for (ArcProto ap : this.arcs.values()) {
            isUsed = true;
            for (ArcLayer al : ap.layers) {
                isUsed = isUsed && al.getLayer().getFunction().isUsed(numMetals, numPolys);
            }
            ap.setNotUsed(!isUsed);
        }
    }

    public static Technology getCurrent() {
        if (curTech == null) {
            System.out.println("The current technology is null. Check the technology settings.");
            curTech = Technology.findTechnology(User.getDefaultTechnology());
            if (curTech == null) {
                System.out.println("User default technology is not loaded. Check the technology settings");
                curTech = Technology.getMocmosTechnology();
                if (curTech == null) {
                    System.out.println("Major error: MoCMOS technology not loaded. Check the technology settings");
                }
            }
        }
        return curTech;
    }

    public void setCurrent() {
        curTech = this;
        if (this.isLayout()) {
            curLayoutTech = this;
        }
    }

    public static Technology findTechnology(String name) {
        if (name == null) {
            return null;
        }
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology t = it.next();
            if (!t.getTechName().equalsIgnoreCase(name)) continue;
            return t;
        }
        return null;
    }

    public static Technology findTechnology(TechId techId) {
        return EDatabase.theDatabase.getTech(techId);
    }

    public static Iterator<Technology> getTechnologies() {
        return EDatabase.theDatabase.getTechnologies().iterator();
    }

    public Map<Setting, Object> convertOldVariable(String varName, Object value) {
        return null;
    }

    public boolean cleanUnusedNodesInLibrary(NodeInst ni, List<Geometric> list) {
        return false;
    }

    public void dump(PrintWriter out) {
        String[] techBits = new String[]{"NONELECTRICAL", "NODIRECTIONALARCS", "NONEGATEDARCS", "NONSTANDARD", "STATICTECHNOLOGY", "NOPRIMTECHNOLOGY"};
        out.println("Technology " + this.getTechName());
        out.println(this.getClass().toString());
        out.println("shortName=" + this.getTechShortName());
        out.println("techDesc=" + this.getTechDesc());
        out.print("Bits: ");
        Technology.printlnBits(out, techBits, this.userBits);
        out.print("isScaleRelevant=" + this.isScaleRelevant());
        Technology.printlnSetting(out, this.getScaleSetting());
        Technology.printlnSetting(out, this.getPrefFoundrySetting());
        Technology.printlnSetting(out, this.getNumMetalsSetting());
        this.dumpExtraProjectSettings(out);
        Technology.printlnSetting(out, this.getMinResistanceSetting());
        Technology.printlnSetting(out, this.getGateLengthSubtractionSetting());
        Technology.printlnSetting(out, this.getGateIncludedSetting());
        Technology.printlnSetting(out, this.getGroundNetIncludedSetting());
        Technology.printlnSetting(out, this.getMaxSeriesResistanceSetting());
        Technology.printlnSetting(out, this.getGateCapacitanceSetting());
        Technology.printlnSetting(out, this.getWireRatioSetting());
        Technology.printlnSetting(out, this.getDiffAlphaSetting());
        Technology.printlnPref(out, 0, this.prefResolution);
        assert (this.getNumTransparentLayers() == (this.transparentColorPrefs != null ? this.transparentColorPrefs.length : 0));
        for (int i = 0; i < this.getNumTransparentLayers(); ++i) {
            out.println("TRANSPARENT_" + (i + 1) + "=" + Integer.toHexString(this.transparentColorPrefs[i].getIntFactoryValue()));
        }
        for (Layer layer : this.layers) {
            if (layer.isPseudoLayer()) continue;
            layer.dump(out);
        }
        for (ArcProto arcProto : this.arcs.values()) {
            arcProto.dump(out);
        }
        if (!this.oldArcNames.isEmpty()) {
            out.println("OldArcNames:");
            for (Map.Entry entry : this.getOldArcNames().entrySet()) {
                out.println("\t" + (String)entry.getKey() + " --> " + ((ArcProto)entry.getValue()).getFullName());
            }
        }
        for (PrimitiveNode primitiveNode : this.nodes.values()) {
            primitiveNode.dump(out);
        }
        if (!this.oldNodeNames.isEmpty()) {
            out.println("OldNodeNames:");
            for (Map.Entry entry : this.getOldNodeNames().entrySet()) {
                out.println("\t" + (String)entry.getKey() + " --> " + ((PrimitiveNode)entry.getValue()).getFullName());
            }
        }
        for (Foundry foundry : this.foundries) {
            out.println("Foundry " + (Object)((Object)foundry.getType()));
            for (Layer layer : this.layers) {
                if (layer.isPseudoLayer()) continue;
                Setting setting = foundry.getGDSLayerSetting(layer);
                out.print("\t");
                Technology.printlnSetting(out, setting);
            }
        }
        this.printSpiceHeader(out, 1, this.getSpiceHeaderLevel1());
        this.printSpiceHeader(out, 2, this.getSpiceHeaderLevel2());
        this.printSpiceHeader(out, 3, this.getSpiceHeaderLevel3());
        if (this.nodeGroups != null) {
            for (int i = 0; i < this.nodeGroups.length; ++i) {
                Object[] objectArray = this.nodeGroups[i];
                for (int j = 0; j < objectArray.length; ++j) {
                    Object entry = objectArray[j];
                    if (entry == null) continue;
                    out.print(" menu " + i + " " + j);
                    if (entry instanceof List) {
                        List list = (List)entry;
                        for (Object o : list) {
                            Technology.printMenuEntry(out, o);
                        }
                    } else {
                        Technology.printMenuEntry(out, entry);
                    }
                    out.println();
                }
            }
        }
        Iterator<Foundry> it = this.getFoundries();
        while (it.hasNext()) {
            Foundry foundry = it.next();
            out.println("    <Foundry name=\"" + foundry.getType().name() + "\">");
            for (Map.Entry<Layer, String> e : foundry.getGDSLayers().entrySet()) {
                out.println("        <layerGds layer=\"" + e.getKey().getName() + "\" gds=\"" + e.getValue() + "\"/>");
            }
            List<DRCTemplate> rules = foundry.getRules();
            if (rules != null) {
                for (DRCTemplate rule : rules) {
                    DRCTemplate.exportDRCRule(out, rule);
                }
            }
            out.println("    </Foundry>");
        }
    }

    protected void dumpExtraProjectSettings(PrintWriter out) {
    }

    protected static void printlnSetting(PrintWriter out, Setting setting) {
        out.println(setting.getXmlPath() + "=" + setting.getValue() + "(" + setting.getFactoryValue() + ")");
    }

    static void printlnPref(PrintWriter out, int indent, Pref pref) {
        if (pref == null) {
            return;
        }
        while (indent-- > 0) {
            out.print("\t");
        }
        out.println(pref.getPrefName() + "=" + pref.getValue() + "(" + pref.getFactoryValue() + ")");
    }

    private static void printMenuEntry(PrintWriter out, Object entry) {
        if (entry instanceof ArcProto) {
            out.print(" arc " + ((ArcProto)entry).getName());
        } else if (entry instanceof PrimitiveNode) {
            out.print(" node " + ((PrimitiveNode)entry).getName());
        } else if (entry instanceof NodeInst) {
            NodeInst ni = (NodeInst)entry;
            PrimitiveNode pn = (PrimitiveNode)ni.getProto();
            out.print(" nodeInst " + pn.getName() + ":" + (Object)((Object)ni.getFunction()) + ":" + ni.getOrient());
            Iterator<Variable> it = ni.getVariables();
            while (it.hasNext()) {
                Variable var = it.next();
                out.print(":" + var.getObject() + ":" + var.isDisplay() + ":" + var.getSize().getSize());
            }
        } else if (entry instanceof String) {
            out.print(" " + entry);
        } else assert (false);
    }

    protected static void printlnBits(PrintWriter out, String[] bitNames, int bits) {
        for (int i = 0; i < 32; ++i) {
            String bitName;
            if ((bits & 1 << i) == 0) continue;
            String string = bitName = i < bitNames.length ? bitNames[i] : null;
            if (bitName == null) {
                bitName = "BIT" + i;
            }
            out.print(" " + bitName);
        }
        out.println();
    }

    private void printSpiceHeader(PrintWriter out, int level, String[] header) {
        if (header == null) {
            return;
        }
        out.println("SpiceHeader " + level);
        for (String s : header) {
            out.println("\t\"" + s + "\"");
        }
    }

    public Xml.Technology makeXml() {
        int numMetals;
        Xml.Technology t = new Xml.Technology();
        t.techName = this.getTechName();
        if (this.getClass() != Technology.class) {
            t.className = this.getClass().getName();
        }
        Xml.Version version = new Xml.Version();
        version.techVersion = 1;
        version.electricVersion = DISK_VERSION_1;
        t.versions.add(version);
        version = new Xml.Version();
        version.techVersion = 2;
        version.electricVersion = DISK_VERSION_2;
        t.versions.add(version);
        t.shortTechName = this.getTechShortName();
        t.description = this.getTechDesc();
        t.maxNumMetals = t.defaultNumMetals = (numMetals = ((Integer)this.getNumMetalsSetting().getFactoryValue()).intValue());
        t.minNumMetals = t.defaultNumMetals;
        t.scaleValue = this.getScaleSetting().getDoubleFactoryValue();
        t.scaleRelevant = this.isScaleRelevant();
        t.defaultFoundry = (String)this.getPrefFoundrySetting().getFactoryValue();
        t.minResistance = this.getMinResistanceSetting().getDoubleFactoryValue();
        t.minCapacitance = this.getMinCapacitanceSetting().getDoubleFactoryValue();
        Color[] colorMap = this.getFactoryColorMap();
        int numLayers = this.getNumTransparentLayers();
        for (int i = 0; i < numLayers; ++i) {
            Color transparentColor = colorMap[1 << i];
            t.transparentLayers.add(transparentColor);
        }
        Iterator<Object> it = this.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            if (layer.isPseudoLayer()) continue;
            t.layers.add(layer.makeXml());
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            t.arcs.add(ap.makeXml());
        }
        it = this.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pnp = (PrimitiveNode)it.next();
            if (pnp.getFunction() == PrimitiveNode.Function.NODE) continue;
            t.nodes.add(pnp.makeXml());
        }
        Technology.addSpiceHeader(t, 1, this.getSpiceHeaderLevel1());
        Technology.addSpiceHeader(t, 2, this.getSpiceHeaderLevel2());
        Technology.addSpiceHeader(t, 3, this.getSpiceHeaderLevel3());
        Object[][] origPalette = this.getNodesGrouped(null);
        int numRows = origPalette.length;
        int numCols = origPalette[0].length;
        for (Object[] row : origPalette) {
            assert (row.length == numCols);
        }
        t.menuPalette = new Xml.MenuPalette();
        t.menuPalette.numColumns = numCols;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                Object origEntry = origPalette[row][col];
                ArrayList<Object> newBox = new ArrayList<Object>();
                if (origEntry instanceof List) {
                    List list = (List)origEntry;
                    for (Object o : list) {
                        newBox.add(Technology.makeMenuEntry(t, o));
                    }
                } else if (origEntry != null) {
                    newBox.add(Technology.makeMenuEntry(t, origEntry));
                }
                t.menuPalette.menuBoxes.add(newBox);
            }
        }
        Iterator<Foundry> it2 = this.getFoundries();
        while (it2.hasNext()) {
            Foundry foundry = it2.next();
            Xml.Foundry f = new Xml.Foundry();
            f.name = foundry.toString();
            Map<Layer, String> gdsMap = foundry.getGDSLayers();
            for (Map.Entry<Layer, String> e : gdsMap.entrySet()) {
                String gds = e.getValue();
                if (gds.length() == 0) continue;
                f.layerGds.put(e.getKey().getName(), gds);
            }
            List<DRCTemplate> rules = foundry.getRules();
            if (rules != null) {
                f.rules.addAll(rules);
            }
            t.foundries.add(f);
        }
        return t;
    }

    private static void addSpiceHeader(Xml.Technology t, int level, String[] spiceLines) {
        if (spiceLines == null) {
            return;
        }
        Xml.SpiceHeader spiceHeader = new Xml.SpiceHeader();
        spiceHeader.level = level;
        for (String spiceLine : spiceLines) {
            spiceHeader.spiceLines.add(spiceLine);
        }
        t.spiceHeaders.add(spiceHeader);
    }

    private static Object makeMenuEntry(Xml.Technology t, Object entry) {
        if (entry instanceof ArcProto) {
            return t.findArc(((ArcProto)entry).getName());
        }
        if (entry instanceof PrimitiveNode) {
            PrimitiveNode pn = (PrimitiveNode)entry;
            if (pn.getFunction() == PrimitiveNode.Function.PIN) {
                Xml.MenuNodeInst n = new Xml.MenuNodeInst();
                n.protoName = pn.getName();
                n.function = PrimitiveNode.Function.PIN;
                return n;
            }
            return t.findNode(((PrimitiveNode)entry).getName());
        }
        if (entry instanceof NodeInst) {
            NodeInst ni = (NodeInst)entry;
            Xml.MenuNodeInst n = new Xml.MenuNodeInst();
            n.protoName = ni.getProto().getName();
            n.function = ni.getFunction();
            n.rotation = ni.getOrient().getAngle();
            Iterator<Variable> it = ni.getVariables();
            while (it.hasNext()) {
                Variable var = it.next();
                n.text = (String)var.getObject();
                n.fontSize = var.getSize().getSize();
            }
            return n;
        }
        assert (entry instanceof String);
        return entry;
    }

    public Xml807.Technology makeXml807() {
        int numMetals;
        Xml807.Technology t = new Xml807.Technology();
        t.techName = this.getTechName();
        if (this.getClass() != Technology.class) {
            t.className = this.getClass().getName();
        }
        t.shortTechName = this.getTechShortName();
        t.description = this.getTechDesc();
        t.maxNumMetals = t.defaultNumMetals = (numMetals = ((Integer)this.getNumMetalsSetting().getFactoryValue()).intValue());
        t.minNumMetals = t.defaultNumMetals;
        t.scaleValue = this.getScaleSetting().getDoubleFactoryValue();
        t.scaleRelevant = this.isScaleRelevant();
        t.defaultFoundry = (String)this.getPrefFoundrySetting().getFactoryValue();
        t.minResistance = this.getMinResistanceSetting().getDoubleFactoryValue();
        t.minCapacitance = this.getMinCapacitanceSetting().getDoubleFactoryValue();
        Xml807.DisplayStyle displayStyle = new Xml807.DisplayStyle();
        displayStyle.name = "Electric";
        t.displayStyles.add(displayStyle);
        Color[] colorMap = this.getFactoryColorMap();
        int numLayers = this.getNumTransparentLayers();
        for (int i = 0; i < numLayers; ++i) {
            Color transparentColor = colorMap[1 << i];
            displayStyle.transparentLayers.add(transparentColor);
        }
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            assert (!layer.isPseudoLayer());
            layer.makeXml807(t, displayStyle);
        }
        HashSet<PrimitiveNode> arcPins = new HashSet<PrimitiveNode>();
        Iterator<Comparable<ArcProto>> it2 = this.getArcs();
        while (it2.hasNext()) {
            ArcProto ap = it2.next();
            t.arcs.add(ap.makeXml807());
            if (ap.arcPin == null) continue;
            arcPins.add(ap.arcPin);
        }
        it2 = this.getNodes();
        while (it2.hasNext()) {
            PrimitiveNode pnp = (PrimitiveNode)it2.next();
            if (pnp.getFunction() == PrimitiveNode.Function.NODE || arcPins.contains(pnp)) continue;
            t.nodes.add(pnp.makeXml807());
        }
        Technology.addSpiceHeader(t, 1, this.getSpiceHeaderLevel1());
        Technology.addSpiceHeader(t, 2, this.getSpiceHeaderLevel2());
        Technology.addSpiceHeader(t, 3, this.getSpiceHeaderLevel3());
        Object[][] origPalette = this.getNodesGrouped(null);
        int numRows = origPalette.length;
        int numCols = origPalette[0].length;
        for (Object[] row : origPalette) {
            assert (row.length == numCols);
        }
        t.menuPalette = new Xml807.MenuPalette();
        t.menuPalette.numColumns = numCols;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                Object origEntry = origPalette[row][col];
                ArrayList<Object> newBox = new ArrayList<Object>();
                if (origEntry instanceof List) {
                    List list = (List)origEntry;
                    for (Object o : list) {
                        newBox.add(Technology.makeMenuEntry(t, o));
                    }
                } else if (origEntry != null) {
                    newBox.add(Technology.makeMenuEntry(t, origEntry));
                }
                t.menuPalette.menuBoxes.add(newBox);
            }
        }
        this.makeRuleSets(t);
        Iterator<Foundry> it3 = this.getFoundries();
        while (it3.hasNext()) {
            Foundry foundry = it3.next();
            Xml807.Foundry f = new Xml807.Foundry();
            f.name = foundry.toString();
            Map<Layer, String> gdsMap = foundry.getGDSLayers();
            for (Map.Entry<Layer, String> e : gdsMap.entrySet()) {
                String gds = e.getValue();
                if (gds.length() == 0) continue;
                f.layerGds.put(e.getKey().getName(), gds);
            }
            List<DRCTemplate> rules = foundry.getRules();
            if (rules != null) {
                f.rules.addAll(rules);
            }
            t.foundries.add(f);
        }
        return t;
    }

    protected void makeRuleSets(Xml807.Technology t) {
        Xml807.RuleSet common = t.newRuleSet("common");
        this.make3d(t, common);
    }

    protected void make3d(Xml807.Technology t, Xml807.RuleSet ruleSet) {
        Map<Xml807.Layer, Xml807.Distance> thick3d = ruleSet.newLayerRule("thick3d");
        Map<Xml807.Layer, Xml807.Distance> height3d = ruleSet.newLayerRule("height3d");
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            assert (!layer.isPseudoLayer());
            layer.makeXml807(t, thick3d, height3d);
        }
    }

    private static void addSpiceHeader(Xml807.Technology t, int level, String[] spiceLines) {
        if (spiceLines == null) {
            return;
        }
        Xml807.SpiceHeader spiceHeader = new Xml807.SpiceHeader();
        spiceHeader.level = level;
        for (String spiceLine : spiceLines) {
            spiceHeader.spiceLines.add(spiceLine);
        }
        t.spiceHeaders.add(spiceHeader);
    }

    private static Object makeMenuEntry(Xml807.Technology t, Object entry) {
        if (entry instanceof ArcProto) {
            return t.findArc(((ArcProto)entry).getName());
        }
        if (entry instanceof PrimitiveNode) {
            PrimitiveNode pn = (PrimitiveNode)entry;
            if (pn.getFunction() == PrimitiveNode.Function.PIN) {
                Xml807.MenuNodeInst n = new Xml807.MenuNodeInst();
                n.protoName = pn.getName();
                n.function = PrimitiveNode.Function.PIN;
                return n;
            }
            return t.findNode(((PrimitiveNode)entry).getName());
        }
        if (entry instanceof NodeInst) {
            NodeInst ni = (NodeInst)entry;
            Xml807.MenuNodeInst n = new Xml807.MenuNodeInst();
            n.protoName = ni.getProto().getName();
            n.function = ni.getFunction();
            n.rotation = ni.getOrient().getAngle();
            Iterator<Variable> it = ni.getVariables();
            while (it.hasNext()) {
                Variable var = it.next();
                n.text = (String)var.getObject();
                n.fontSize = var.getSize().getSize();
            }
            return n;
        }
        assert (entry instanceof String);
        return entry;
    }

    public Iterator<Layer> getLayers() {
        this.layersAllocationLocked = true;
        return this.layers.iterator();
    }

    public Layer getLayer(int index) {
        return this.layers.get(index);
    }

    public int getNumLayers() {
        this.layersAllocationLocked = true;
        return this.layers.size();
    }

    public Layer findLayer(String layerName) {
        Layer layer = this.layersByName.get(layerName);
        if (layer != null) {
            return layer;
        }
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            layer = it.next();
            if (!layer.getName().equalsIgnoreCase(layerName)) continue;
            return layer;
        }
        it = this.getLayers();
        while (it.hasNext()) {
            layer = it.next().getPseudoLayer();
            if (layer == null || !layer.getName().equalsIgnoreCase(layerName)) continue;
            return layer;
        }
        return null;
    }

    public int getRuleNodeIndex(String name) {
        int count = 0;
        Iterator<PrimitiveNode> it = this.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            if (pn.getName().equalsIgnoreCase(name)) {
                return this.getNumLayers() + count;
            }
            ++count;
        }
        return -1;
    }

    public static Layer getLayerFromOverride(String override, int startPos, char endChr, Technology tech) {
        int endPos = override.indexOf(endChr, startPos);
        if (endPos < 0) {
            return null;
        }
        String layerName = override.substring(startPos, endPos);
        return tech.findLayer(layerName);
    }

    public Layer findLayerFromFunction(Layer.Function fun) {
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            Layer lay = it.next();
            Layer.Function lFun = lay.getFunction();
            if (lFun != fun) continue;
            return lay;
        }
        return null;
    }

    public void addLayer(Layer layer) {
        if (this.layersAllocationLocked) {
            throw new IllegalStateException("layers allocation is locked");
        }
        layer.setIndex(this.layers.size());
        this.layers.add(layer);
        this.layersByName.put(layer.getName(), layer);
    }

    public boolean sameLayer(Layer layer1, Layer layer2) {
        if (layer1 == layer2) {
            return true;
        }
        if (layer1.getFunction() == layer2.getFunction() && layer1.getFunctionExtras() == layer2.getFunctionExtras()) {
            return true;
        }
        if (layer1.getFunction() == Layer.Function.POLY1 && layer2.getFunction() == Layer.Function.GATE) {
            return true;
        }
        return layer2.getFunction() == Layer.Function.POLY1 && layer1.getFunction() == Layer.Function.GATE;
    }

    public List<Layer> getLayersSortedByHeight() {
        ArrayList<Layer> layerList = new ArrayList<Layer>();
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            layerList.add(it.next());
        }
        Collections.sort(layerList, LAYERS_BY_HEIGHT);
        return layerList;
    }

    public List<Layer> getLayersSortedByZValue() {
        ArrayList<Layer> layerList = new ArrayList<Layer>();
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            layerList.add(it.next());
        }
        Collections.sort(layerList, LAYERS_BY_ZVALUE);
        return layerList;
    }

    public List<Layer> getSavedLayerOrder() {
        int end;
        String order;
        if (this.layerOrderPref == null) {
            this.layerOrderPref = Pref.makeStringPref("LayerOrderfor" + this.getTechName(), prefs, "");
        }
        if ((order = this.layerOrderPref.getString()).length() == 0) {
            return null;
        }
        int pos = 0;
        ArrayList<Layer> layers = new ArrayList<Layer>();
        while (pos < order.length() && (end = order.indexOf(44, pos)) >= 0) {
            Layer layer;
            String layerName = order.substring(pos, end);
            pos = end + 1;
            int colonPos = layerName.indexOf(58);
            Technology tech = this;
            if (colonPos >= 0) {
                String techName = layerName.substring(0, colonPos);
                tech = Technology.findTechnology(techName);
                if (tech == null) continue;
                layerName = layerName.substring(colonPos + 1);
            }
            if ((layer = tech.findLayer(layerName)) == null) continue;
            layers.add(layer);
        }
        return layers;
    }

    public void setSavedLayerOrder(List<Layer> layers) {
        if (this.layerOrderPref == null) {
            this.layerOrderPref = Pref.makeStringPref("LayerOrderfor" + this.getTechName(), prefs, "");
        }
        StringBuffer sb = new StringBuffer();
        for (Layer lay : layers) {
            if (lay.getTechnology() != this) {
                sb.append(lay.getTechnology().getTechName() + ":");
            }
            sb.append(lay.getName() + ",");
        }
        this.layerOrderPref.setString(sb.toString());
    }

    public int getNumMetals() {
        return this.cacheNumMetalLayers.getInt();
    }

    public Setting getNumMetalsSetting() {
        return this.cacheNumMetalLayers;
    }

    protected ArcProto newArcProto(String protoName, double lambdaWidthOffset, double defaultWidth, ArcProto.Function function, ArcLayer ... layers) {
        if (this.findArcProto(protoName) != null) {
            System.out.println("Error: technology " + this.getTechName() + " has multiple arcs named " + protoName);
            return null;
        }
        long gridWidthOffset = DBMath.lambdaToSizeGrid(lambdaWidthOffset);
        if (gridWidthOffset < 0L || gridWidthOffset > Integer.MAX_VALUE) {
            System.out.println("ArcProto " + this.getTechName() + ":" + protoName + " has invalid width offset " + lambdaWidthOffset);
            return null;
        }
        if (defaultWidth < DBMath.gridToLambda(gridWidthOffset)) {
            System.out.println("ArcProto " + this.getTechName() + ":" + protoName + " has negative width");
            return null;
        }
        long defaultGridWidth = DBMath.lambdaToSizeGrid(defaultWidth);
        long gridFullExtend = defaultGridWidth / 2L;
        ArcProto ap = new ArcProto(this, protoName, gridFullExtend, (defaultGridWidth - gridWidthOffset) / 2L, function, layers, this.arcs.size());
        this.addArcProto(ap);
        return ap;
    }

    public ArcProto findArcProto(String name) {
        if (name == null) {
            return null;
        }
        ArcProto primArc = this.arcs.get(name);
        if (primArc != null) {
            return primArc;
        }
        Iterator<ArcProto> it = this.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            if (!ap.getName().equalsIgnoreCase(name)) continue;
            return ap;
        }
        return null;
    }

    public ArcProto getArcProto(ArcProtoId arcProtoId) {
        assert (arcProtoId.techId == this.techId);
        int chronIndex = arcProtoId.chronIndex;
        return chronIndex < this.arcsByChronIndex.length ? this.arcsByChronIndex[chronIndex] : null;
    }

    ArcProto getArcProtoByChronIndex(int chronIndex) {
        return chronIndex < this.arcsByChronIndex.length ? this.arcsByChronIndex[chronIndex] : null;
    }

    public Iterator<ArcProto> getArcs() {
        return this.arcs.values().iterator();
    }

    public Collection<ArcProto> getArcsCollection() {
        return this.arcs.values();
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public void addArcProto(ArcProto ap) {
        assert (this.findArcProto(ap.getName()) == null);
        assert (ap.primArcIndex == this.arcs.size());
        this.arcs.put(ap.getName(), ap);
        ArcProtoId arcProtoId = ap.getId();
        if (arcProtoId.chronIndex >= this.arcsByChronIndex.length) {
            ArcProto[] newArcsByChronIndex = new ArcProto[arcProtoId.chronIndex + 1];
            System.arraycopy(this.arcsByChronIndex, 0, newArcsByChronIndex, 0, this.arcsByChronIndex.length);
            this.arcsByChronIndex = newArcsByChronIndex;
        }
        this.arcsByChronIndex[arcProtoId.chronIndex] = ap;
    }

    protected void setNoDirectionalArcs() {
        this.userBits |= 2;
    }

    public boolean isNoDirectionalArcs() {
        return (this.userBits & 2) != 0;
    }

    protected void setNoNegatedArcs() {
        this.userBits |= 4;
    }

    public boolean isNoNegatedArcs() {
        return (this.userBits & 4) != 0;
    }

    public Poly[] getShapeOfArc(ArcInst ai) {
        return this.getShapeOfArc(ai, null);
    }

    public Poly[] getShapeOfArc(ArcInst ai, Layer.Function.Set onlyTheseLayers) {
        Poly.Builder polyBuilder = Poly.threadLocalLambdaBuilder();
        polyBuilder.setOnlyTheseLayers(onlyTheseLayers);
        return polyBuilder.getShapeArray(ai);
    }

    protected void getShapeOfArc(AbstractShapeBuilder b, ImmutableArcInst a) {
        this.getShapeOfArc(b, a, null);
    }

    protected void getShapeOfArc(AbstractShapeBuilder b, ImmutableArcInst a, Layer layerOverride) {
        Layer layer;
        assert (a.protoId.techId == this.techId);
        ArcProto ap = this.getArcProto(a.protoId);
        assert (ap.getTechnology() == this);
        int numArcLayers = ap.getNumArcLayers();
        if (!this.isNoNegatedArcs() && (a.isHeadNegated() || a.isTailNegated())) {
            for (int i = 0; i < numArcLayers; ++i) {
                ArcLayer primLayer = ap.getArcLayer(i);
                layer = primLayer.getLayer();
                if (b.onlyTheseLayers != null && !b.onlyTheseLayers.contains(layer.getFunction(), layer.getFunctionExtras())) continue;
                if (layerOverride != null) {
                    layer = layerOverride;
                }
                int angle = a.getAngle();
                double gridBubbleSize = Schematics.getNegatingBubbleSize() * 400.0;
                double cosDist = DBMath.cos(angle) * gridBubbleSize;
                double sinDist = DBMath.sin(angle) * gridBubbleSize;
                if (a.isTailNegated()) {
                    b.pushPoint(a.tailLocation, cosDist, sinDist);
                } else {
                    b.pushPoint(a.tailLocation);
                }
                if (a.isHeadNegated()) {
                    b.pushPoint(a.headLocation, -cosDist, -sinDist);
                } else {
                    b.pushPoint(a.headLocation);
                }
                b.pushPoly(Poly.Type.OPENED, layer);
            }
        } else {
            for (int i = 0; i < numArcLayers; ++i) {
                ArcLayer primLayer = ap.getArcLayer(i);
                layer = primLayer.getLayer();
                if (b.onlyTheseLayers != null && !b.onlyTheseLayers.contains(layer.getFunction(), layer.getFunctionExtras())) continue;
                if (layerOverride != null) {
                    layer = layerOverride;
                }
                b.makeGridPoly(a, 2L * (a.getGridExtendOverMin() + (long)ap.getLayerGridExtend(i)), primLayer.getStyle(), layer);
            }
        }
        if (!this.isNoDirectionalArcs()) {
            int backAngle2;
            int angleOfArrow;
            double lambdaArrowSize = 400.0;
            int angle = a.getAngle();
            if (a.isBodyArrowed()) {
                b.pushPoint(a.headLocation);
                b.pushPoint(a.tailLocation);
                b.pushPoly(Poly.Type.VECTORS, this.generic.glyphLay);
            }
            if (a.isTailArrowed()) {
                angleOfArrow = 3300;
                int backAngle1 = angle - angleOfArrow;
                backAngle2 = angle + angleOfArrow;
                b.pushPoint(a.tailLocation);
                b.pushPoint(a.tailLocation, DBMath.cos(backAngle1) * 400.0, DBMath.sin(backAngle1) * 400.0);
                b.pushPoint(a.tailLocation);
                b.pushPoint(a.tailLocation, DBMath.cos(backAngle2) * 400.0, DBMath.sin(backAngle2) * 400.0);
                b.pushPoly(Poly.Type.VECTORS, this.generic.glyphLay);
            }
            if (a.isHeadArrowed()) {
                angle = (angle + 1800) % 3600;
                angleOfArrow = 300;
                int backAngle1 = angle - angleOfArrow;
                backAngle2 = angle + angleOfArrow;
                b.pushPoint(a.headLocation);
                b.pushPoint(a.headLocation, DBMath.cos(backAngle1) * 400.0, DBMath.sin(backAngle1) * 400.0);
                b.pushPoint(a.headLocation);
                b.pushPoint(a.headLocation, DBMath.cos(backAngle2) * 400.0, DBMath.sin(backAngle2) * 400.0);
                b.pushPoly(Poly.Type.VECTORS, Generic.tech().glyphLay);
            }
        }
    }

    public boolean isEasyShape(ImmutableArcInst a, boolean explain) {
        if (a.isBodyArrowed() || a.isTailArrowed() || a.isHeadArrowed()) {
            if (explain) {
                System.out.println("ARROWED");
            }
            return false;
        }
        if (a.isTailNegated() || a.isHeadNegated()) {
            if (explain) {
                System.out.println("NEGATED");
            }
            return false;
        }
        ArcProto protoType = this.getArcProto(a.protoId);
        if (protoType.isCurvable() && a.getVar(ImmutableArcInst.ARC_RADIUS) != null) {
            if (explain) {
                System.out.println("CURVABLE");
            }
            return false;
        }
        if (!a.tailLocation.isSmall() || !a.headLocation.isSmall()) {
            if (explain) {
                System.out.println("LARGE " + a.tailLocation + " " + a.headLocation);
            }
            return false;
        }
        int minLayerExtend = (int)a.getGridExtendOverMin() + protoType.getMinLayerGridExtend();
        if (minLayerExtend <= 0) {
            if (minLayerExtend != 0 || protoType.getNumArcLayers() != 1) {
                if (explain) {
                    System.out.println(protoType + " many zero-width layers");
                }
                return false;
            }
            return true;
        }
        int numArcLayers = protoType.getNumArcLayers();
        for (int i = 0; i < numArcLayers; ++i) {
            if (protoType.getLayerStyle(i) == Poly.Type.FILLED) continue;
            if (explain) {
                System.out.println("Wide should be filled");
            }
            return false;
        }
        if (!a.isManhattan()) {
            if (explain) {
                System.out.println("NON-MANHATTAN");
            }
            return false;
        }
        return true;
    }

    public ArcProto convertOldArcName(String name) {
        return this.oldArcNames.get(name);
    }

    public Map<String, ArcProto> getOldArcNames() {
        return new TreeMap<String, ArcProto>(this.oldArcNames);
    }

    public List<PrimitiveNode> getNodesSortedByName() {
        TreeMap<String, PrimitiveNode> sortedMap = new TreeMap<String, PrimitiveNode>(TextUtils.STRING_NUMBER_ORDER);
        Iterator<PrimitiveNode> it = this.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            sortedMap.put(pn.getName(), pn);
        }
        return new ArrayList<PrimitiveNode>(sortedMap.values());
    }

    public PrimitiveNode findNodeProto(String name) {
        if (name == null) {
            return null;
        }
        PrimitiveNode primNode = this.nodes.get(name);
        if (primNode != null) {
            return primNode;
        }
        Iterator<PrimitiveNode> it = this.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            if (!pn.getName().equalsIgnoreCase(name)) continue;
            return pn;
        }
        return null;
    }

    public PrimitiveNode getPrimitiveNode(PrimitiveNodeId primitiveNodeId) {
        assert (primitiveNodeId.techId == this.techId);
        int chronIndex = primitiveNodeId.chronIndex;
        return chronIndex < this.nodesByChronIndex.length ? this.nodesByChronIndex[chronIndex] : null;
    }

    PrimitiveNode getPrimitiveNodeByChronIndex(int chronIndex) {
        return chronIndex < this.nodesByChronIndex.length ? this.nodesByChronIndex[chronIndex] : null;
    }

    public Iterator<PrimitiveNode> getNodes() {
        return this.nodes.values().iterator();
    }

    public Collection<PrimitiveNode> getNodesCollection() {
        return this.nodes.values();
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public void addNodeProto(PrimitiveNode np) {
        assert (this.findNodeProto(np.getName()) == null);
        np.setPrimNodeIndexInTech(this.nodeIndex++);
        this.nodes.put(np.getName(), np);
        PrimitiveNodeId primitiveNodeId = np.getId();
        if (primitiveNodeId.chronIndex >= this.nodesByChronIndex.length) {
            PrimitiveNode[] newNodesByChronIndex = new PrimitiveNode[primitiveNodeId.chronIndex + 1];
            System.arraycopy(this.nodesByChronIndex, 0, newNodesByChronIndex, 0, this.nodesByChronIndex.length);
            this.nodesByChronIndex = newNodesByChronIndex;
        }
        this.nodesByChronIndex[primitiveNodeId.chronIndex] = np;
    }

    public PrimitiveNode.Function getPrimitiveFunction(PrimitiveNode pn, int techBits) {
        return pn.getFunction();
    }

    public PrimitiveNodeSize getResistorSize(NodeInst ni, VarContext context) {
        if (ni.isCellInstance()) {
            return null;
        }
        double length = ni.getLambdaBaseXSize();
        double width = ni.getLambdaBaseYSize();
        PrimitiveNodeSize size = new PrimitiveNodeSize(new Double(width), new Double(length));
        return size;
    }

    public double getTransistorActiveLength(NodeInst ni) {
        Poly[] diffList = this.getShapeOfNode(ni, true, false, diffLayers);
        double activeLen = 0.0;
        if (diffList.length > 0) {
            Poly poly = diffList[0];
            activeLen = poly.getBounds2D().getHeight();
        }
        return activeLen;
    }

    public TransistorSize getTransistorSize(NodeInst ni, VarContext context) {
        double width = ni.getLambdaBaseXSize();
        double height = ni.getLambdaBaseYSize();
        Point2D[] trace = ni.getTrace();
        if (trace != null) {
            width = 0.0;
            for (int i = 1; i < trace.length; ++i) {
                width += trace[i - 1].distance(trace[i]);
            }
            height = 2.0;
            double serpentineLength = ni.getSerpentineTransistorLength();
            if (serpentineLength > 0.0) {
                height = serpentineLength;
            }
            System.out.println("No calculating length for active regions yet");
        }
        double activeLen = this.getTransistorActiveLength(ni);
        TransistorSize size = new TransistorSize(new Double(width), new Double(height), new Double(activeLen));
        return size;
    }

    public void setPrimitiveNodeSize(NodeInst ni, double width, double length) {
        double oldWidth = ni.getLambdaBaseXSize();
        double oldLength = ni.getLambdaBaseYSize();
        double dW = width - oldWidth;
        double dL = length - oldLength;
        ni.resize(dW, dL);
    }

    public PortInst getTransistorGatePort(NodeInst ni) {
        return ni.getPortInst(0);
    }

    public PortInst getTransistorAltGatePort(NodeInst ni) {
        if (ni.getProto().getTechnology() == Schematics.tech()) {
            return ni.getPortInst(0);
        }
        return ni.getPortInst(2);
    }

    public PortInst getTransistorBasePort(NodeInst ni) {
        return ni.getPortInst(0);
    }

    public PortInst getTransistorSourcePort(NodeInst ni) {
        return ni.getPortInst(1);
    }

    public PortInst getTransistorEmitterPort(NodeInst ni) {
        return ni.getPortInst(1);
    }

    public PortInst getTransistorDrainPort(NodeInst ni) {
        if (ni.getProto().getTechnology() == Schematics.tech()) {
            return ni.getPortInst(2);
        }
        return ni.getPortInst(3);
    }

    public PortInst getTransistorCollectorPort(NodeInst ni) {
        return ni.getPortInst(2);
    }

    public PortInst getTransistorBiasPort(NodeInst ni) {
        if (ni.getNumPortInsts() < 4) {
            return null;
        }
        if (ni.getProto().getTechnology() != Schematics.tech()) {
            return null;
        }
        return ni.getPortInst(3);
    }

    public void setPrimitiveFunction(NodeInst ni, PrimitiveNode.Function function) {
    }

    public void setNoPrimitiveNodes() {
        this.userBits |= 0x20;
    }

    public boolean isNoPrimitiveNodes() {
        return (this.userBits & 0x20) != 0;
    }

    public void setDefaultOutline(NodeInst ni) {
    }

    public ERectangle getNodeInstBaseRectangle(NodeInst ni) {
        PrimitiveNode pn = (PrimitiveNode)ni.getProto();
        return pn.getBaseRectangle();
    }

    public Poly[] getShapeOfNode(NodeInst ni) {
        return this.getShapeOfNode(ni, false, false, null);
    }

    public Poly[] getShapeOfNode(NodeInst ni, boolean electrical, boolean reasonable, Layer.Function.Set onlyTheseLayers) {
        NodeLayer[] eLayers;
        if (ni.isCellInstance()) {
            return null;
        }
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        NodeLayer[] primLayers = np.getLayers();
        if (electrical && (eLayers = np.getElectricalLayers()) != null) {
            primLayers = eLayers;
        }
        if (onlyTheseLayers != null) {
            ArrayList<NodeLayer> layerArray = new ArrayList<NodeLayer>();
            for (int i = 0; i < primLayers.length; ++i) {
                NodeLayer primLayer = primLayers[i];
                if (!onlyTheseLayers.contains(primLayer.layer.getFunction(), primLayer.layer.getFunctionExtras())) continue;
                layerArray.add(primLayer);
            }
            primLayers = new NodeLayer[layerArray.size()];
            layerArray.toArray(primLayers);
        }
        if (primLayers.length == 0) {
            return new Poly[0];
        }
        return this.getShapeOfNode(ni, electrical, reasonable, primLayers, null);
    }

    protected Poly[] getShapeOfNode(NodeInst ni, boolean electrical, boolean reasonable, NodeLayer[] primLayers, Layer layerOverride) {
        if (!electrical) {
            if (ni.isWiped()) {
                primLayers = nullPrimLayers;
            } else {
                PrimitiveNode np = (PrimitiveNode)ni.getProto();
                if (np.isWipeOn1or2() && ni.pinUseCount()) {
                    primLayers = nullPrimLayers;
                }
            }
        }
        return this.computeShapeOfNode(ni, electrical, reasonable, primLayers, layerOverride);
    }

    protected Poly[] computeShapeOfNode(NodeInst ni, boolean electrical, boolean reasonable, NodeLayer[] primLayers, Layer layerOverride) {
        int i;
        Point2D[] outline;
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        ERectangle fullRectangle = np.getFullRectangle();
        int specialType = np.getSpecialType();
        if (specialType != 1 && np.isHoldsOutline() && (outline = ni.getTrace()) != null) {
            int numPolys = 1;
            Poly[] polys = new Poly[numPolys];
            Point2D[] pointList = new Point2D.Double[outline.length];
            for (int i2 = 0; i2 < outline.length; ++i2) {
                pointList[i2] = new Point2D.Double(ni.getAnchorCenterX() + outline[i2].getX(), ni.getAnchorCenterY() + outline[i2].getY());
            }
            polys[0] = new Poly(pointList);
            NodeLayer primLayer = primLayers[0];
            polys[0].setStyle(primLayer.getStyle());
            if (layerOverride != null) {
                polys[0].setLayer(layerOverride);
            } else {
                polys[0].setLayer(primLayer.getLayer());
            }
            if (electrical) {
                int portIndex = primLayer.getPortNum();
                assert (portIndex < np.getNumPorts());
                if (portIndex >= 0) {
                    polys[0].setPort(np.getPort(portIndex));
                }
            }
            return polys;
        }
        int numBasicLayers = primLayers.length;
        int numExtraLayers = 0;
        MultiCutData mcd = null;
        SerpentineTrans std = null;
        if (np.hasMultiCuts()) {
            for (NodeLayer nodeLayer : primLayers) {
                if (nodeLayer.representation != 3) continue;
                mcd = new MultiCutData(ni.getD().size, fullRectangle, nodeLayer);
                if (reasonable) {
                    numExtraLayers += mcd.cutsReasonable - 1;
                    continue;
                }
                numExtraLayers += mcd.cutsTotal - 1;
            }
        } else if (specialType == 1 && (std = new SerpentineTrans(ni.getD(), np, primLayers)).layersTotal > 0) {
            numExtraLayers = std.layersTotal;
            numBasicLayers = 0;
        }
        int numNegatingBubbles = 0;
        Iterator<Connection> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            if (!con.isNegated()) continue;
            ++numNegatingBubbles;
        }
        int numPolys = numBasicLayers + numExtraLayers + numNegatingBubbles;
        Poly[] polys = new Poly[numPolys];
        double xCenter = ni.getAnchorCenterX();
        double yCenter = ni.getAnchorCenterY();
        double xSize = ni.getXSize();
        double ySize = ni.getYSize();
        int fillPoly = 0;
        for (i = 0; i < numBasicLayers; ++i) {
            Poly.Type style;
            NodeLayer primLayer = primLayers[i];
            int representation = primLayer.getRepresentation();
            if (representation == 1) {
                EdgeH leftEdge = primLayer.getLeftEdge();
                EdgeH rightEdge = primLayer.getRightEdge();
                EdgeV topEdge = primLayer.getTopEdge();
                EdgeV bottomEdge = primLayer.getBottomEdge();
                double portLowX = xCenter + leftEdge.getMultiplier() * xSize + leftEdge.getAdder();
                double portHighX = xCenter + rightEdge.getMultiplier() * xSize + rightEdge.getAdder();
                double portLowY = yCenter + bottomEdge.getMultiplier() * ySize + bottomEdge.getAdder();
                double portHighY = yCenter + topEdge.getMultiplier() * ySize + topEdge.getAdder();
                Point2D[] pointList = Poly.makePoints(portLowX, portHighX, portLowY, portHighY);
                polys[fillPoly] = new Poly(pointList);
            } else if (representation == 0) {
                TechPoint[] points = primLayer.getPoints();
                Point2D[] pointList = new Point2D.Double[points.length];
                for (int j = 0; j < points.length; ++j) {
                    EdgeH xFactor = points[j].getX();
                    EdgeV yFactor = points[j].getY();
                    double x = 0.0;
                    double y = 0.0;
                    if (xFactor != null && yFactor != null) {
                        x = xCenter + xFactor.getMultiplier() * xSize + xFactor.getAdder();
                        y = yCenter + yFactor.getMultiplier() * ySize + yFactor.getAdder();
                    }
                    pointList[j] = new Point2D.Double(x, y);
                }
                polys[fillPoly] = new Poly(pointList);
            } else if (representation == 3) {
                mcd = new MultiCutData(ni.getD().size, fullRectangle, primLayer);
                style = primLayer.getStyle();
                PrimitivePort port = null;
                if (electrical) {
                    port = np.getPort(0);
                }
                numExtraLayers = reasonable ? mcd.cutsReasonable : mcd.cutsTotal;
                for (int j = 0; j < numExtraLayers; ++j) {
                    polys[fillPoly] = mcd.fillCutPoly(ni.getD(), j);
                    polys[fillPoly].setStyle(style);
                    polys[fillPoly].setLayer(primLayer.getLayer());
                    polys[fillPoly].setPort(port);
                    ++fillPoly;
                }
                continue;
            }
            style = primLayer.getStyle();
            if (style.isText()) {
                polys[fillPoly].setString(primLayer.getMessage());
                polys[fillPoly].setTextDescriptor(primLayer.getDescriptor());
            }
            polys[fillPoly].setStyle(style);
            if (layerOverride != null) {
                polys[fillPoly].setLayer(layerOverride);
            } else {
                polys[fillPoly].setLayer(primLayer.getLayerOrPseudoLayer());
            }
            if (electrical) {
                int portIndex = primLayer.getPortNum();
                assert (portIndex < np.getNumPorts());
                if (portIndex >= 0) {
                    polys[fillPoly].setPort(np.getPort(portIndex));
                }
            }
            ++fillPoly;
        }
        if (numNegatingBubbles > 0) {
            double bubbleRadius = Schematics.getNegatingBubbleSize() / 2.0;
            Iterator<Connection> it2 = ni.getConnections();
            while (it2.hasNext()) {
                Connection con = it2.next();
                if (!con.isNegated()) continue;
                AffineTransform trans = ni.rotateIn();
                Point2D.Double portLocation = new Point2D.Double(con.getLocation().getX(), con.getLocation().getY());
                trans.transform(portLocation, portLocation);
                double x = ((Point2D)portLocation).getX();
                double y = ((Point2D)portLocation).getY();
                PrimitivePort pp = (PrimitivePort)con.getPortInst().getPortProto();
                int angle = pp.getAngle() * 10;
                double dX = DBMath.cos(angle) * bubbleRadius;
                double dY = DBMath.sin(angle) * bubbleRadius;
                Point2D[] points = new Point2D[]{new Point2D.Double(x + dX, y + dY), new Point2D.Double(x, y)};
                polys[fillPoly] = new Poly(points);
                polys[fillPoly].setStyle(Poly.Type.CIRCLE);
                polys[fillPoly].setLayer(Schematics.tech().node_lay);
                ++fillPoly;
            }
        }
        if (std != null) {
            for (i = 0; i < numExtraLayers; ++i) {
                polys[fillPoly] = std.fillTransPoly(i, electrical);
                ++fillPoly;
            }
        }
        assert (fillPoly == polys.length);
        return polys;
    }

    public boolean isMultiCutInTechnology(MultiCutData mcd) {
        if (mcd == null) {
            return false;
        }
        return mcd.numCuts() > 1;
    }

    public MultiCutData getMultiCutData(NodeInst ni) {
        if (ni.isCellInstance()) {
            return null;
        }
        PrimitiveNode pnp = (PrimitiveNode)ni.getProto();
        if (!pnp.isMulticut()) {
            return null;
        }
        return new MultiCutData(ni.getD(), ni.getTechPool());
    }

    public boolean isMultiCutCase(NodeInst ni) {
        MultiCutData data = this.getMultiCutData(ni);
        if (data == null) {
            return false;
        }
        return this.isMultiCutInTechnology(data);
    }

    public PrimitiveNode convertOldNodeName(String name) {
        return this.oldNodeNames.get(name);
    }

    public Map<String, PrimitiveNode> getOldNodeNames() {
        return new TreeMap<String, PrimitiveNode>(this.oldNodeNames);
    }

    public Poly getShapeOfPort(NodeInst ni, PrimitivePort pp) {
        return this.getShapeOfPort(ni, pp, null);
    }

    public Poly getShapeOfPort(NodeInst ni, PrimitivePort pp, Point2D selectPt) {
        Point2D[] outline;
        SerpentineTrans std;
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        if (np.getSpecialType() == 1 && (std = new SerpentineTrans(ni.getD(), np, np.getLayers())).hasValidData()) {
            return std.fillTransPort(pp);
        }
        if (np.isHoldsOutline() && (outline = ni.getTrace()) != null) {
            double cX = ni.getAnchorCenterX();
            double cY = ni.getAnchorCenterY();
            Point2D[] pointList = new Point2D.Double[outline.length];
            for (int i = 0; i < outline.length; ++i) {
                pointList[i] = new Point2D.Double(cX + outline[i].getX(), cY + outline[i].getY());
            }
            Poly portPoly = new Poly(pointList);
            if (ni.getFunction() == PrimitiveNode.Function.NODE) {
                portPoly.setStyle(Poly.Type.FILLED);
            } else {
                portPoly.setStyle(Poly.Type.OPENED);
            }
            portPoly.setTextDescriptor(TextDescriptor.getExportTextDescriptor());
            return portPoly;
        }
        double portLowX = ni.getAnchorCenterX() + pp.getLeft().getMultiplier() * ni.getXSize() + pp.getLeft().getAdder();
        double portHighX = ni.getAnchorCenterX() + pp.getRight().getMultiplier() * ni.getXSize() + pp.getRight().getAdder();
        double portLowY = ni.getAnchorCenterY() + pp.getBottom().getMultiplier() * ni.getYSize() + pp.getBottom().getAdder();
        double portHighY = ni.getAnchorCenterY() + pp.getTop().getMultiplier() * ni.getYSize() + pp.getTop().getAdder();
        double portX = (portLowX + portHighX) / 2.0;
        double portY = (portLowY + portHighY) / 2.0;
        Poly portPoly = new Poly(portX, portY, portHighX - portLowX, portHighY - portLowY);
        portPoly.setStyle(Poly.Type.FILLED);
        portPoly.setTextDescriptor(TextDescriptor.getExportTextDescriptor());
        return portPoly;
    }

    public PrimitivePort convertOldPortName(String portName, PrimitiveNode np) {
        PrimitivePort pp;
        int len = portName.length() - 4;
        if (len > 0 && portName.substring(len).equals("-bot") && (pp = (PrimitivePort)np.findPortProto(portName + "tom")) != null) {
            return pp;
        }
        if (np.getNumPorts() == 1) {
            return np.getPort(0);
        }
        return null;
    }

    protected boolean isUniversalConnectivityPort(PrimitivePort pp) {
        return false;
    }

    private Setting makeParasiticSetting(String what, double factory) {
        String techShortName = this.getTechShortName();
        if (techShortName == null) {
            techShortName = this.getTechName();
        }
        return Setting.makeDoubleSetting(what + "IN" + this.getTechName(), prefs, this.getProjectSettings(), what, "Parasitic tab", techShortName + " " + what, factory);
    }

    private Setting makeParasiticSetting(String what, boolean factory) {
        String techShortName = this.getTechShortName();
        if (techShortName == null) {
            techShortName = this.getTechName();
        }
        return Setting.makeBooleanSetting(what + "IN" + this.getTechName(), prefs, this.getProjectSettings(), what, "Parasitic tab", techShortName + " " + what, factory);
    }

    public static Pref.Group getTechnologyPreferences() {
        return prefs;
    }

    public double getMinResistance() {
        return this.cacheMinResistance.getDouble();
    }

    public Setting getMinResistanceSetting() {
        return this.cacheMinResistance;
    }

    public double getMinCapacitance() {
        return this.cacheMinCapacitance.getDouble();
    }

    public Setting getMinCapacitanceSetting() {
        return this.cacheMinCapacitance;
    }

    public double getMaxSeriesResistance() {
        return this.cacheMaxSeriesResistance.getDouble();
    }

    public Setting getMaxSeriesResistanceSetting() {
        return this.cacheMaxSeriesResistance;
    }

    public boolean isGateIncluded() {
        return this.cacheIncludeGate.getBoolean();
    }

    public Setting getGateIncludedSetting() {
        return this.cacheIncludeGate;
    }

    public boolean isGroundNetIncluded() {
        return this.cacheIncludeGnd.getBoolean();
    }

    public Setting getGroundNetIncludedSetting() {
        return this.cacheIncludeGnd;
    }

    public double getGateLengthSubtraction() {
        return this.cacheGateLengthSubtraction.getDouble();
    }

    public Setting getGateLengthSubtractionSetting() {
        return this.cacheGateLengthSubtraction;
    }

    public void setFactoryParasitics(double minResistance, double minCapacitance) {
        this.cacheMinResistance = this.makeParasiticSetting("MininumResistance", minResistance);
        this.cacheMinCapacitance = this.makeParasiticSetting("MininumCapacitance", minCapacitance);
    }

    private ProjSettingsNode getLESettingsNode() {
        ProjSettingsNode node = this.getProjectSettings().getNode("LogicalEffort");
        return node;
    }

    private Setting makeLESetting(String what, double factory) {
        String techShortName = this.getTechShortName();
        if (techShortName == null) {
            techShortName = this.getTechName();
        }
        return Setting.makeDoubleSetting(what + "IN" + this.getTechName(), prefs, this.getLESettingsNode(), what, "Logical Effort tab", techShortName + " " + what, factory);
    }

    protected void setFactoryLESettings(double gateCapacitance, double wireRation, double diffAlpha) {
        this.cacheGateCapacitance = this.makeLESetting("GateCapacitance", gateCapacitance);
        this.cacheWireRatio = this.makeLESetting("WireRatio", wireRation);
        this.cacheDiffAlpha = this.makeLESetting("DiffAlpha", diffAlpha);
    }

    public double getGateCapacitance() {
        return this.cacheGateCapacitance.getDouble();
    }

    public Setting getGateCapacitanceSetting() {
        return this.cacheGateCapacitance;
    }

    public double getWireRatio() {
        return this.cacheWireRatio.getDouble();
    }

    public Setting getWireRatioSetting() {
        return this.cacheWireRatio;
    }

    public double getDiffAlpha() {
        return this.cacheDiffAlpha.getDouble();
    }

    public Setting getDiffAlphaSetting() {
        return this.cacheDiffAlpha;
    }

    public String[] getSpiceHeaderLevel1() {
        return this.spiceHeaderLevel1;
    }

    public void setSpiceHeaderLevel1(String[] lines) {
        this.spiceHeaderLevel1 = lines;
    }

    public String[] getSpiceHeaderLevel2() {
        return this.spiceHeaderLevel2;
    }

    public void setSpiceHeaderLevel2(String[] lines) {
        this.spiceHeaderLevel2 = lines;
    }

    public String[] getSpiceHeaderLevel3() {
        return this.spiceHeaderLevel3;
    }

    public void setSpiceHeaderLevel3(String[] lines) {
        this.spiceHeaderLevel3 = lines;
    }

    protected void setNonElectrical() {
        this.userBits |= 1;
    }

    public boolean isNonElectrical() {
        return (this.userBits & 1) != 0;
    }

    protected void setNonStandard() {
        this.userBits |= 8;
    }

    public boolean isNonStandard() {
        return (this.userBits & 8) != 0;
    }

    protected void setStaticTechnology() {
        this.userBits |= 0x10;
    }

    public boolean isStaticTechnology() {
        return (this.userBits & 0x10) != 0;
    }

    public TechId getId() {
        return this.techId;
    }

    public String getTechName() {
        return this.techId.techName;
    }

    public void setTechName(String techName) {
        throw new UnsupportedOperationException();
    }

    static boolean jelibSafeName(String str) {
        return TechId.jelibSafeName(str);
    }

    public String getTechShortName() {
        return this.techShortName;
    }

    protected void setTechShortName(String techShortName) {
        this.techShortName = techShortName;
    }

    public String getTechDesc() {
        return this.techDesc;
    }

    public void setTechDesc(String techDesc) {
        this.techDesc = techDesc;
    }

    public double getScale() {
        return this.cacheScale.getDouble();
    }

    public String getScaleVariableName() {
        return "ScaleFOR" + this.getTechName();
    }

    protected void setFactoryScale(double factory, boolean scaleRelevant) {
        this.scaleRelevant = scaleRelevant;
        String techShortName = this.getTechShortName();
        if (techShortName == null) {
            techShortName = this.getTechName();
        }
        this.cacheScale = Setting.makeDoubleSetting(this.getScaleVariableName(), prefs, this.getProjectSettings(), "Scale", "Scale tab", techShortName + " scale", factory);
        this.cacheScale.setValidOption(this.isScaleRelevant());
    }

    public Setting getScaleSetting() {
        return this.cacheScale;
    }

    public boolean isScaleRelevant() {
        return this.scaleRelevant;
    }

    protected void setFactoryResolution(double factory) {
        this.prefResolution = Pref.makeDoublePref("ResolutionValueFor" + this.getTechName(), prefs, factory);
    }

    public void setResolution(double resolution) {
        if (this.prefResolution == null) {
            this.setFactoryResolution(0.0);
        }
        this.prefResolution.setDouble(resolution);
    }

    public double getResolution() {
        if (this.prefResolution == null) {
            this.setFactoryResolution(0.0);
        }
        return this.prefResolution.getDouble();
    }

    public String getPrefFoundry() {
        return this.cacheFoundry.getString().toUpperCase();
    }

    public Setting getPrefFoundrySetting() {
        return this.cacheFoundry;
    }

    protected Foundry findFoundry(String name) {
        if (name == null) {
            return null;
        }
        for (Foundry f : this.foundries) {
            Foundry.Type t = f.getType();
            if (!t.name().equalsIgnoreCase(name)) continue;
            return f;
        }
        return null;
    }

    public Iterator<Foundry> getFoundries() {
        return this.foundries.iterator();
    }

    protected void newFoundry(Foundry.Type mode, URL fileURL, String ... gdsLayers) {
        Foundry foundry = new Foundry(this, mode, fileURL, gdsLayers);
        this.foundries.add(foundry);
    }

    public Foundry getSelectedFoundry() {
        String foundryName = this.getPrefFoundry();
        Foundry f = this.findFoundry(foundryName);
        if (f != null) {
            return f;
        }
        if (this.foundries.size() > 0) {
            f = this.foundries.get(0);
            System.out.println("Foundry '" + foundryName + "' not available in Technology '" + this.getTechName() + "'. Setting '" + f.toString() + "' as foundry.");
            return f;
        }
        return f;
    }

    public Map<Layer, String> getGDSLayers() {
        Foundry foundry = this.getSelectedFoundry();
        Map<Layer, String> gdsLayers = Collections.emptyMap();
        if (foundry != null) {
            gdsLayers = foundry.getGDSLayers();
        }
        return gdsLayers;
    }

    protected void setFactoryTransparentLayers(Color[] layers) {
        this.transparentLayers = layers.length;
        this.transparentColorPrefs = new Pref[this.transparentLayers];
        for (int i = 0; i < layers.length; ++i) {
            this.transparentColorPrefs[i] = Pref.makeIntPref("TransparentLayer" + (i + 1) + "For" + this.getTechName(), prefs, layers[i].getRGB());
            layers[i] = new Color(this.transparentColorPrefs[i].getInt());
        }
        this.setColorMapFromLayers(layers);
    }

    public static void cacheTransparentLayerColors() {
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                layer.getGraphics().recachePrefs();
            }
            if (tech.transparentColorPrefs == null || tech.transparentColorPrefs.length <= 0) continue;
            Color[] layers = new Color[tech.transparentColorPrefs.length];
            for (int i = 0; i < tech.transparentColorPrefs.length; ++i) {
                layers[i] = new Color(tech.transparentColorPrefs[i].getInt());
            }
            tech.setColorMapFromLayers(layers);
        }
    }

    public Color[] getFactoryColorMap() {
        if (this.transparentColorPrefs == null || this.transparentColorPrefs.length <= 0) {
            return null;
        }
        Color[] layers = new Color[this.transparentColorPrefs.length];
        for (int i = 0; i < this.transparentColorPrefs.length; ++i) {
            layers[i] = new Color(this.transparentColorPrefs[i].getIntFactoryValue());
        }
        Color[] map = Technology.getColorMap(layers, this.transparentColorPrefs.length);
        return map;
    }

    public int getNumTransparentLayers() {
        return this.transparentLayers;
    }

    public void setNumTransparentLayers(int nl) {
        this.transparentLayers = nl;
    }

    public void setColorMap(Color[] map) {
        this.colorMap = map;
    }

    public void setColorMapFromLayers(Color[] layers) {
        if (this.transparentColorPrefs != null) {
            for (int i = 0; i < layers.length; ++i) {
                Pref pref = this.transparentColorPrefs[i];
                if (layers[i] == null) continue;
                pref.setInt(layers[i].getRGB());
            }
        }
        Color[] map = Technology.getColorMap(layers, this.transparentLayers);
        this.setColorMap(map);
    }

    public static Color[] getColorMap(Color[] layers, int numLayers) {
        int numEntries = 1 << numLayers;
        Color[] map = new Color[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            int r = 200;
            int g = 200;
            int b = 200;
            boolean hasPrevious = false;
            for (int j = 0; j < numLayers; ++j) {
                if ((i & 1 << j) == 0) continue;
                if (hasPrevious) {
                    double[] lastColor = new double[]{(double)r / 255.0, (double)g / 255.0, (double)b / 255.0};
                    Technology.normalizeColor(lastColor);
                    double[] curColor = new double[]{(double)layers[j].getRed() / 255.0, (double)layers[j].getGreen() / 255.0, (double)layers[j].getBlue() / 255.0};
                    Technology.normalizeColor(curColor);
                    for (int k = 0; k < 3; ++k) {
                        int n = k;
                        curColor[n] = curColor[n] + lastColor[k];
                    }
                    Technology.normalizeColor(curColor);
                    r = (int)(curColor[0] * 255.0);
                    g = (int)(curColor[1] * 255.0);
                    b = (int)(curColor[2] * 255.0);
                    continue;
                }
                r = layers[j].getRed();
                g = layers[j].getGreen();
                b = layers[j].getBlue();
                hasPrevious = true;
            }
            map[i] = new Color(r, g, b);
        }
        return map;
    }

    private static void normalizeColor(double[] a) {
        double mag = Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
        if (mag > (double)1.0E-11f) {
            a[0] = a[0] / mag;
            a[1] = a[1] / mag;
            a[2] = a[2] / mag;
        }
    }

    public XMLRules getFactoryDesignRules() {
        XMLRules rules = new XMLRules(this);
        Foundry foundry = this.getSelectedFoundry();
        List<DRCTemplate> rulesList = foundry.getRules();
        boolean pWellProcess = User.isPWellProcessLayoutTechnology();
        if (rulesList != null) {
            for (DRCTemplate rule : rulesList) {
                if (rule.ruleType == DRCTemplate.DRCRuleType.NODSIZ) continue;
                rules.loadDRCRules(this, foundry, rule, pWellProcess);
            }
            for (DRCTemplate rule : rulesList) {
                if (rule.ruleType != DRCTemplate.DRCRuleType.NODSIZ) continue;
                rules.loadDRCRules(this, foundry, rule, pWellProcess);
            }
        }
        this.resizeArcs(rules);
        if (this.xmlTech != null) {
            this.resizeXml(rules);
        }
        return rules;
    }

    protected void resizeArcs(XMLRules rules) {
        TechDistanceContext context = new TechDistanceContext(rules);
        for (ArcProto ap : this.arcs.values()) {
            ap.resize(context);
        }
        for (Layer layer : this.layers) {
            layer.resizePureLayerNode(context);
        }
        for (PrimitiveNode pn : this.nodes.values()) {
            pn.resize(context);
        }
    }

    protected String getRuleSuffix() {
        return "";
    }

    protected Map<String, String> getRuleAliases() {
        return Collections.EMPTY_MAP;
    }

    public static StringBuffer getRuleDifferences(DRCRules origRules, DRCRules newRules) {
        return new StringBuffer("");
    }

    public void setRuleVariables(DRCRules newRules) {
    }

    public Color[] getColorMap() {
        return this.colorMap;
    }

    public int getIndex() {
        return this.techIndex;
    }

    public static Technology whatTechnology(NodeProto cell) {
        Technology tech = Technology.whatTechnology(cell, null, 0, 0, null);
        return tech;
    }

    public static Technology whatTechnology(NodeProto cellOrPrim, NodeProto[] nodeProtoList, int startNodeProto, int endNodeProto, ArcProto[] arcProtoList) {
        int i;
        if (cellOrPrim instanceof PrimitiveNode) {
            return ((PrimitiveNode)cellOrPrim).getTechnology();
        }
        Cell cell = (Cell)cellOrPrim;
        int maxTech = 0;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (tech.getIndex() <= maxTech) continue;
            maxTech = tech.getIndex();
        }
        int[] useCount = new int[++maxTech];
        for (i = 0; i < maxTech; ++i) {
            useCount[i] = 0;
        }
        if (nodeProtoList != null) {
            for (i = startNodeProto; i < endNodeProto; ++i) {
                Cell subCell;
                NodeProto np = nodeProtoList[i];
                if (np == null) continue;
                Technology nodeTech = np.getTechnology();
                if (np instanceof Cell && (subCell = (Cell)np).isIcon()) {
                    nodeTech = Schematics.tech();
                }
                if (nodeTech == null) continue;
                int n = nodeTech.getIndex();
                useCount[n] = useCount[n] + 1;
            }
        } else {
            Iterator<NodeInst> it2 = cell.getNodes();
            while (it2.hasNext()) {
                Cell subCell;
                NodeInst ni = it2.next();
                NodeProto np = ni.getProto();
                Technology nodeTech = np.getTechnology();
                if (ni.isCellInstance() && (subCell = (Cell)np).isIcon()) {
                    nodeTech = Schematics.tech();
                }
                if (nodeTech == null) continue;
                int n = nodeTech.getIndex();
                useCount[n] = useCount[n] + 1;
            }
        }
        if (arcProtoList != null) {
            for (ArcProto ap : arcProtoList) {
                if (ap == null) continue;
                int n = ap.getTechnology().getIndex();
                useCount[n] = useCount[n] + 1;
            }
        } else {
            Iterator<ArcInst> it3 = cell.getArcs();
            while (it3.hasNext()) {
                ArcInst ai = it3.next();
                ArcProto ap = ai.getProto();
                int n = ap.getTechnology().getIndex();
                useCount[n] = useCount[n] + 1;
            }
        }
        int best = 0;
        Technology bestTech = null;
        int bestLayout = 0;
        Technology bestLayoutTech = null;
        Iterator<Technology> it4 = Technology.getTechnologies();
        while (it4.hasNext()) {
            Technology tech = it4.next();
            if (tech instanceof Generic) continue;
            if (useCount[tech.getIndex()] > best) {
                best = useCount[tech.getIndex()];
                bestTech = tech;
            }
            if (!tech.isLayout() || useCount[tech.getIndex()] <= bestLayout) continue;
            bestLayout = useCount[tech.getIndex()];
            bestLayoutTech = tech;
        }
        Technology retTech = null;
        if (cell.isIcon() || cell.getView().isTextView()) {
            if (useCount[Artwork.tech().getIndex()] > 0) {
                return Artwork.tech();
            }
            if (bestTech == null) {
                return Artwork.tech();
            }
            retTech = Artwork.tech();
        } else if (cell.isSchematic()) {
            if (useCount[Schematics.tech().getIndex()] > 0) {
                return Schematics.tech();
            }
            if (bestTech == null) {
                return Schematics.tech();
            }
            retTech = Schematics.tech();
        } else {
            retTech = curLayoutTech;
        }
        if (bestLayoutTech != null) {
            retTech = bestLayoutTech;
        } else if (bestTech != null) {
            retTech = bestTech;
        }
        return retTech;
    }

    public boolean isLayout() {
        return !(this instanceof Artwork) && !(this instanceof EFIDO) && !(this instanceof GEM) && !(this instanceof Generic) && !(this instanceof Schematics);
    }

    public boolean isSchematics() {
        return this instanceof Schematics || this instanceof EFIDO || this instanceof GEM;
    }

    @Override
    public int compareTo(Technology that) {
        return TextUtils.STRING_NUMBER_ORDER.compare(this.getTechName(), that.getTechName());
    }

    public String toString() {
        return "Technology " + this.getTechName();
    }

    private void check() {
        for (ArcProto ap : this.arcs.values()) {
            ap.check();
        }
    }

    public void setNodesGrouped(Object[][] ng, String xml) {
        this.nodeGroups = ng;
        if (this.componentMenuPref == null) {
            this.componentMenuPref = Pref.makeStringPref("ComponentMenuXMLfor" + this.getTechName(), prefs, "");
        }
        this.componentMenuPref.setString(xml);
    }

    public String getNodesGroupedXML() {
        if (this.componentMenuPref == null) {
            this.componentMenuPref = Pref.makeStringPref("ComponentMenuXMLfor" + this.getTechName(), prefs, "");
        }
        return this.componentMenuPref.getString();
    }

    public void getPrefComponentMenu() {
        if (this.nodeGroups != null) {
            return;
        }
        String nodeGroupXML = this.getNodesGroupedXML();
        if (nodeGroupXML == null) {
            return;
        }
        if (nodeGroupXML.length() == 0) {
            return;
        }
        ArrayList<Xml.PrimitiveNode> xmlNodes = new ArrayList<Xml.PrimitiveNode>();
        for (PrimitiveNode pn : this.nodes.values()) {
            Xml.PrimitiveNode xpn = new Xml.PrimitiveNode();
            xpn.name = pn.getName();
            xmlNodes.add(xpn);
        }
        ArrayList<Xml.ArcProto> xmlArcs = new ArrayList<Xml.ArcProto>();
        for (ArcProto ap : this.arcs.values()) {
            Xml.ArcProto xap = new Xml.ArcProto();
            xap.name = ap.getName();
            xmlArcs.add(xap);
        }
        Xml.MenuPalette xx = Xml.parseComponentMenuXMLTechEdit(nodeGroupXML, xmlNodes, xmlArcs);
        this.convertMenuPalette(xx);
    }

    public Object[][] getDefaultNodesGrouped() {
        if (this.factoryNodeGroups != null) {
            return this.factoryNodeGroups;
        }
        ArrayList<Object> things = new ArrayList<Object>();
        Iterator<Comparable<ArcProto>> it = this.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            if (ap.isNotUsed()) continue;
            things.add(ap);
        }
        it = this.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it.next();
            if (np.isNotUsed() || np.getFunction() == PrimitiveNode.Function.NODE) continue;
            things.add(np);
        }
        things.add(SPECIALMENUPURE);
        things.add(SPECIALMENUMISC);
        things.add(SPECIALMENUCELL);
        int columns = (things.size() + 13) / 14;
        int rows = (things.size() + columns - 1) / columns;
        this.factoryNodeGroups = new Object[rows][columns];
        int rowPos = 0;
        int colPos = 0;
        for (Object e : things) {
            this.factoryNodeGroups[rowPos][colPos] = e;
            if (++rowPos < rows) continue;
            rowPos = 0;
            ++colPos;
        }
        return this.factoryNodeGroups;
    }

    public Object[][] getNodesGrouped(Cell curCell) {
        this.getPrefComponentMenu();
        if (this.nodeGroups == null) {
            this.nodeGroups = this.getDefaultNodesGrouped();
        }
        return this.filterNodeGroups(this.nodeGroups);
    }

    public Object[][] filterNodeGroups(Object[][] oldNG) {
        ArrayList<Object[]> list = new ArrayList<Object[]>(oldNG.length);
        for (int i = 0; i < oldNG.length; ++i) {
            Object[] objs = oldNG[i];
            if (objs == null) continue;
            Object obj = objs[0];
            boolean valid = true;
            if (obj instanceof ArcProto) {
                ArcProto ap = (ArcProto)obj;
                boolean bl = valid = !ap.isNotUsed();
            }
            if (!valid) continue;
            list.add(objs);
        }
        Object[][] newMatrix = new Object[list.size()][oldNG[0].length];
        for (int i = 0; i < list.size(); ++i) {
            Object[] objs = (Object[])list.get(i);
            for (int j = 0; j < objs.length; ++j) {
                Object obj = objs[j];
                if (obj instanceof PrimitiveNode && ((PrimitiveNode)obj).isNotUsed()) {
                    obj = null;
                } else if (obj instanceof List) {
                    List l = (List)obj;
                    Object o = l.get(0);
                    if (o instanceof NodeInst) {
                        NodeInst ni = (NodeInst)o;
                        if (!ni.isCellInstance() && ((PrimitiveNode)ni.getProto()).isNotUsed()) {
                            obj = null;
                        }
                    } else if (o instanceof PrimitiveNode && ((PrimitiveNode)o).isNotUsed()) {
                        obj = null;
                    }
                }
                newMatrix[i][j] = obj;
            }
        }
        return newMatrix;
    }

    public static NodeInst makeNodeInst(NodeProto np) {
        return Technology.makeNodeInst(np, np.getFunction(), 0, false, null, 0.0);
    }

    public static NodeInst makeNodeInst(NodeProto np, PrimitiveNode.Function func, int angle, boolean display, String varName, double fontSize) {
        SizeOffset so = np.getProtoSizeOffset();
        Point2D.Double pt = new Point2D.Double((so.getHighXOffset() - so.getLowXOffset()) / 2.0, (so.getHighYOffset() - so.getLowYOffset()) / 2.0);
        Orientation orient = Orientation.fromAngle(angle);
        AffineTransform trans = orient.pureRotate();
        trans.transform(pt, pt);
        NodeInst ni = NodeInst.makeDummyInstance(np, new EPoint(((Point2D)pt).getX(), ((Point2D)pt).getY()), np.getDefWidth(), np.getDefHeight(), orient);
        np.getTechnology().setPrimitiveFunction(ni, func);
        np.getTechnology().setDefaultOutline(ni);
        if (varName != null) {
            TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withDisplay(display).withRelSize(fontSize);
            td = td.withOff(0.0, -Math.max(ni.getXSize(), ni.getYSize()) / 2.0 - 2.0).withPos(AbstractTextDescriptor.Position.UP);
            if (angle != 0) {
                td = td.withRotation(AbstractTextDescriptor.Rotation.getRotation(360 - angle / 10));
            }
            ni.newVar(TECH_TMPVAR, (Object)varName, td);
        }
        return ni;
    }

    public double[] getSpacingDistances(Poly poly1, Poly poly2) {
        double size1 = poly1.getMinSize();
        double size2 = poly1.getMinSize();
        double length = 0.0;
        double wideS = size1 > size2 ? size1 : size2;
        double[] results = new double[]{wideS, length};
        return results;
    }

    public DRCRules getCachedRules() {
        return this.cachedRules;
    }

    public void setCachedRules(DRCRules rules) {
        this.cachedRules = rules;
    }

    public boolean isValidVTPolyRule(DRCTemplate theRule) {
        return false;
    }

    public ProjSettingsNode getProjectSettings() {
        ProjSettingsNode node = ProjSettings.getSettings().getNode(this.getTechName());
        return node;
    }

    static {
        mocmos = null;
        mocmosCached = false;
        tsmc180 = null;
        tsmc180Cached = false;
        cmos90 = null;
        cmos90Cached = false;
        LAYERS_BY_HEIGHT = new LayerHeight(false);
        LAYERS_BY_HEIGHT_LIFT_CONTACTS = new LayerHeight(true);
        LAYERS_BY_ZVALUE = new LayerZValueSorting();
        diffLayers = new Layer.Function.Set(Layer.Function.DIFFP, Layer.Function.DIFFN);
        nullPrimLayers = new NodeLayer[0];
        TECH_TMPVAR = Variable.newKey("TECH_TMPVAR");
    }

    public static class TechSetting
    extends Setting {
        private Technology tech;

        private TechSetting(String prefName, Pref.Group group, Technology tech, ProjSettingsNode xmlNode, String xmlName, String location, String description, Object factoryObj) {
            super(prefName, prefs, xmlNode, xmlName, location, description, factoryObj);
            if (tech == null) {
                throw new NullPointerException();
            }
            this.tech = tech;
        }

        protected void setSideEffect() {
            if (this.tech == null) {
                return;
            }
            if (this.isUsed(this.tech)) {
                Job.getUserInterface().showInformationMessage("There is now inconsistent use of this technology parameter:\n               " + this.getDescription() + "\n" + "Electric cannot handle this situation and errors may result.\n" + "It is recommended that you restart Electric to avoid this instability.\n" + "In the future, when the 'Project Settings Reconciliation' dialog appears,\n" + "Click 'Use All Current Settings' or select the CURRENT VALUE of this parameter.", "Technology Parameter Changed");
            }
            this.tech.setState();
            TechSetting.reloadUIData();
        }

        private boolean isUsed(Technology tech) {
            Iterator<Library> lit = Library.getLibraries();
            while (lit.hasNext()) {
                Library lib = lit.next();
                Iterator<Cell> cit = lib.getCells();
                while (cit.hasNext()) {
                    Cell cell = cit.next();
                    if (cell.getTechnology() != tech) continue;
                    Iterator<NodeInst> nit = cell.getNodes();
                    while (nit.hasNext()) {
                        NodeInst ni = nit.next();
                        if (ni.isCellInstance() || ((PrimitiveNode)ni.getProto()).getTechnology() != tech) continue;
                        return true;
                    }
                    Iterator<ArcInst> ait = cell.getArcs();
                    while (ait.hasNext()) {
                        ArcInst ai = ait.next();
                        if (ai.getProto().getTechnology() != tech) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private static void reloadUIData() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    User.technologyChanged();
                    UserInterface ui = Job.getUserInterface();
                    ui.loadComponentMenuForTechnology();
                    ui.repaintAllEditWindows();
                }
            });
        }

        public static Setting makeBooleanSetting(Technology tech, String name, String location, String description, ProjSettingsNode xmlNode, String xmlName, boolean factory) {
            Setting setting = Setting.getSetting(xmlNode.getPath() + xmlName);
            if (setting != null) {
                return setting;
            }
            return new TechSetting(name, prefs, tech, xmlNode, xmlName, location, description, factory);
        }

        public static Setting makeIntSetting(Technology tech, String name, String location, String description, ProjSettingsNode xmlNode, String xmlName, int factory) {
            Setting setting = Setting.getSetting(xmlNode.getPath() + xmlName);
            if (setting != null) {
                return setting;
            }
            return new TechSetting(name, prefs, tech, xmlNode, xmlName, location, description, factory);
        }

        public static Setting makeStringSetting(Technology tech, String name, String location, String description, ProjSettingsNode xmlNode, String xmlName, String factory) {
            Setting setting = Setting.getSetting(xmlNode.getPath() + xmlName);
            if (setting != null) {
                return setting;
            }
            return new TechSetting(name, prefs, tech, xmlNode, xmlName, location, description, factory);
        }
    }

    private class TechDistanceContext
    implements DistanceContext {
        private final Map<String, String> ruleAliases;
        private final XMLRules rules;

        TechDistanceContext(XMLRules rules) {
            this.ruleAliases = Technology.this.getRuleAliases();
            this.rules = rules;
        }

        public double getRule(String ruleName) {
            String alias = this.ruleAliases.get(ruleName);
            if (alias != null) {
                ruleName = alias;
            }
            for (HashMap<XMLRules.XMLRule, XMLRules.XMLRule> map : this.rules.matrix) {
                if (map == null) continue;
                for (XMLRules.XMLRule rule : map.values()) {
                    if (rule.ruleType == DRCTemplate.DRCRuleType.NODSIZ || rule.ruleType == DRCTemplate.DRCRuleType.MINWIDCOND || !rule.ruleName.startsWith(ruleName + " ") && !rule.ruleName.equals(ruleName)) continue;
                    return rule.getValue(0);
                }
            }
            return Double.NaN;
        }
    }

    private static class SerpentineTrans {
        private ImmutableNodeInst theNode;
        private PrimitiveNode theProto;
        private int layersTotal;
        private int numSegments;
        private double extraScale;
        private NodeLayer[] primLayers;
        private Point2D[] points;
        private double[] specialValues;
        private static final int LEFTANGLE = 900;
        private static final int RIGHTANGLE = 2700;

        public SerpentineTrans(ImmutableNodeInst niD, PrimitiveNode protoType, NodeLayer[] pLayers) {
            this.theNode = niD;
            this.layersTotal = 0;
            this.points = niD.getTrace();
            if (this.points != null && this.points.length < 2) {
                this.points = null;
            }
            if (this.points != null) {
                this.theProto = protoType;
                this.specialValues = this.theProto.getSpecialValues();
                this.primLayers = pLayers;
                int count = this.primLayers.length;
                this.numSegments = this.points.length - 1;
                this.layersTotal = count * this.numSegments;
                this.extraScale = 0.0;
                double length = niD.getSerpentineTransistorLength();
                if (length > 0.0) {
                    this.extraScale = (length - this.specialValues[3]) / 2.0;
                }
            }
        }

        public boolean hasValidData() {
            return this.points != null;
        }

        private Poly fillTransPoly(int box, boolean electrical) {
            int portIndex;
            Point2D otherPt;
            int otherang;
            int ang;
            int segment = box % this.numSegments;
            int element = box / this.numSegments;
            double lwid = this.primLayers[element].getSerpentineLWidth();
            double rwid = this.primLayers[element].getSerpentineRWidth();
            double extendt = this.primLayers[element].getSerpentineExtentT();
            double extendb = this.primLayers[element].getSerpentineExtentB();
            lwid += this.extraScale;
            rwid += this.extraScale;
            double xoff = this.theNode.anchor.getX();
            double yoff = this.theNode.anchor.getY();
            int thissg = segment;
            int next = segment + 1;
            Point2D thisPt = this.points[thissg];
            Point2D nextPt = this.points[next];
            int angle = DBMath.figureAngle(thisPt, nextPt);
            if (thissg == 0) {
                ang = angle + 1800;
                thisPt = DBMath.addPoints(thisPt, DBMath.cos(ang) * extendt, DBMath.sin(ang) * extendt);
            }
            if (next == this.numSegments) {
                nextPt = DBMath.addPoints(nextPt, DBMath.cos(angle) * extendb, DBMath.sin(angle) * extendb);
            }
            ang = angle + 900;
            double sin = DBMath.sin(ang) * lwid;
            double cos = DBMath.cos(ang) * lwid;
            Point2D thisL = DBMath.addPoints(thisPt, cos, sin);
            Point2D nextL = DBMath.addPoints(nextPt, cos, sin);
            ang = angle + 2700;
            sin = DBMath.sin(ang) * rwid;
            cos = DBMath.cos(ang) * rwid;
            Point2D thisR = DBMath.addPoints(thisPt, cos, sin);
            Point2D nextR = DBMath.addPoints(nextPt, cos, sin);
            if (thissg != 0 && (otherang = DBMath.figureAngle(otherPt = this.points[thissg - 1], thisPt)) != angle) {
                ang = otherang + 900;
                thisL = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid), otherang, thisL, angle);
                ang = otherang + 2700;
                thisR = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid), otherang, thisR, angle);
            }
            if (next != this.numSegments && (otherang = DBMath.figureAngle(nextPt, otherPt = this.points[next + 1])) != angle) {
                ang = otherang + 900;
                Point2D newPtL = DBMath.addPoints(nextPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid);
                nextL = DBMath.intersect(newPtL, otherang, nextL, angle);
                ang = otherang + 2700;
                Point2D newPtR = DBMath.addPoints(nextPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid);
                nextR = DBMath.intersect(newPtR, otherang, nextR, angle);
            }
            Point2D[] points = new Point2D.Double[]{DBMath.addPoints(thisL, xoff, yoff), DBMath.addPoints(thisR, xoff, yoff), DBMath.addPoints(nextR, xoff, yoff), DBMath.addPoints(nextL, xoff, yoff)};
            Poly retPoly = new Poly(points);
            NodeLayer primLayer = this.primLayers[element];
            retPoly.setStyle(primLayer.getStyle());
            retPoly.setLayer(primLayer.getLayer());
            if (electrical && (portIndex = primLayer.getPortNum()) >= 0) {
                assert (this.theProto.getId() == this.theNode.protoId);
                PrimitivePort port = this.theProto.getPort(portIndex);
                retPoly.setPort(port);
            }
            return retPoly;
        }

        private Poly fillTransPort(PortProto pp) {
            Point2D.Double nextPt;
            Point2D.Double thisPt;
            PortProto lpp;
            double diffInset = this.specialValues[1];
            double diffExtend = this.specialValues[2];
            double defWid = this.specialValues[3] + this.extraScale;
            double polyInset = this.specialValues[4];
            double polyExtend = this.specialValues[5];
            double xOff = this.theNode.anchor.getX();
            double yOff = this.theNode.anchor.getY();
            int total = this.points.length;
            AffineTransform trans = this.theNode.orient.rotateAbout(this.theNode.anchor.getX(), this.theNode.anchor.getY());
            int which = 0;
            Iterator<PortProto> it = this.theProto.getPorts();
            while (it.hasNext() && (lpp = it.next()) != pp) {
                ++which;
            }
            if (which == 0) {
                thisPt = new Point2D.Double(this.points[0].getX(), this.points[0].getY());
                nextPt = new Point2D.Double(this.points[1].getX(), this.points[1].getY());
                int angle = DBMath.figureAngle(thisPt, nextPt);
                int ang = (angle + 1800) % 3600;
                ((Point2D)thisPt).setLocation(((Point2D)thisPt).getX() + DBMath.cos(ang) * polyExtend + xOff, ((Point2D)thisPt).getY() + DBMath.sin(ang) * polyExtend + yOff);
                ang = (angle + 900) % 3600;
                Point2D.Double end1 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                ang = (angle + 2700) % 3600;
                Point2D.Double end2 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                Point2D[] portPoints = new Point2D.Double[]{end1, end2};
                trans.transform(portPoints, 0, portPoints, 0, 2);
                Poly retPoly = new Poly(portPoints);
                retPoly.setStyle(Poly.Type.OPENED);
                return retPoly;
            }
            if (which == 2) {
                thisPt = new Point2D.Double(this.points[total - 1].getX(), this.points[total - 1].getY());
                nextPt = new Point2D.Double(this.points[total - 2].getX(), this.points[total - 2].getY());
                int angle = DBMath.figureAngle(thisPt, nextPt);
                int ang = (angle + 1800) % 3600;
                ((Point2D)thisPt).setLocation(((Point2D)thisPt).getX() + DBMath.cos(ang) * polyExtend + xOff, ((Point2D)thisPt).getY() + DBMath.sin(ang) * polyExtend + yOff);
                ang = (angle + 900) % 3600;
                Point2D.Double end1 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                ang = (angle + 2700) % 3600;
                Point2D.Double end2 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                Point2D[] portPoints = new Point2D.Double[]{end1, end2};
                trans.transform(portPoints, 0, portPoints, 0, 2);
                Poly retPoly = new Poly(portPoints);
                retPoly.setStyle(Poly.Type.OPENED);
                return retPoly;
            }
            if (which == 3) {
                diffExtend = -diffExtend;
                defWid = -defWid;
            }
            if (which == 4) {
                defWid = 0.0;
                diffExtend = 0.0;
            }
            Point2D[] portPoints = new Point2D.Double[total];
            Point2D.Double lastPoint = null;
            int lastAngle = 0;
            for (int nextIndex = 1; nextIndex < total; ++nextIndex) {
                int thisIndex = nextIndex - 1;
                Point2D thisPt2 = new Point2D.Double(this.points[thisIndex].getX() + xOff, this.points[thisIndex].getY() + yOff);
                Point2D.Double nextPt2 = new Point2D.Double(this.points[nextIndex].getX() + xOff, this.points[nextIndex].getY() + yOff);
                int angle = DBMath.figureAngle(thisPt2, nextPt2);
                if (thisIndex == 0) {
                    ((Point2D)thisPt2).setLocation(((Point2D)thisPt2).getX() + DBMath.cos(angle) * diffInset, ((Point2D)thisPt2).getY() + DBMath.sin(angle) * diffInset);
                }
                if (nextIndex == total - 1) {
                    int backAng = (angle + 1800) % 3600;
                    ((Point2D)nextPt2).setLocation(((Point2D)nextPt2).getX() + DBMath.cos(backAng) * diffInset, ((Point2D)nextPt2).getY() + DBMath.sin(backAng) * diffInset);
                }
                int ang = (angle + 900) % 3600;
                double sine = DBMath.sin(ang);
                double cosine = DBMath.cos(ang);
                ((Point2D)thisPt2).setLocation(((Point2D)thisPt2).getX() + cosine * (defWid / 2.0 + diffExtend), ((Point2D)thisPt2).getY() + sine * (defWid / 2.0 + diffExtend));
                ((Point2D)nextPt2).setLocation(((Point2D)nextPt2).getX() + cosine * (defWid / 2.0 + diffExtend), ((Point2D)nextPt2).getY() + sine * (defWid / 2.0 + diffExtend));
                if (thisIndex != 0) {
                    thisPt2 = DBMath.intersect(lastPoint, lastAngle, thisPt2, angle);
                }
                portPoints[thisIndex] = thisPt2;
                lastPoint = thisPt2;
                lastAngle = angle;
                if (nextIndex != total - 1) continue;
                portPoints[nextIndex] = nextPt2;
            }
            if (total > 0) {
                trans.transform(portPoints, 0, portPoints, 0, total);
            }
            Poly retPoly = new Poly(portPoints);
            retPoly.setStyle(Poly.Type.OPENED);
            return retPoly;
        }
    }

    public static class MultiCutData {
        private long cutSizeX;
        private long cutSizeY;
        private long cutSep;
        private long cutSep1D;
        private long cutSep2D;
        private int cutsX;
        private int cutsY;
        private int cutsTotal;
        private int cutsReasonable;
        private long cutBaseX;
        private long cutBaseY;
        private double cutTopEdge;
        private double cutLeftEdge;
        private double cutRightEdge;

        private void calculateInternalData(EPoint size, ERectangle fullRectangle, NodeLayer cutLayer) {
            assert (cutLayer.representation == 3);
            long gridWidth = size.getGridX() + fullRectangle.getGridWidth();
            long gridHeight = size.getGridY() + fullRectangle.getGridHeight();
            TechPoint[] techPoints = cutLayer.points;
            long lx = techPoints[0].getX().getGridAdder() + (long)((double)gridWidth * techPoints[0].getX().getMultiplier());
            long hx = techPoints[1].getX().getGridAdder() + (long)((double)gridWidth * techPoints[1].getX().getMultiplier());
            long ly = techPoints[0].getY().getGridAdder() + (long)((double)gridHeight * techPoints[0].getY().getMultiplier());
            long hy = techPoints[1].getY().getGridAdder() + (long)((double)gridHeight * techPoints[1].getY().getMultiplier());
            this.cutSizeX = cutLayer.cutGridSizeX;
            this.cutSizeY = cutLayer.cutGridSizeY;
            this.cutSep1D = cutLayer.cutGridSep1D;
            this.cutSep2D = cutLayer.cutGridSep2D;
            this.calculateInternalData(lx, hx, ly, hy);
        }

        private void calculateInternalData(long lx, long hx, long ly, long hy) {
            this.cutBaseX = lx + hx >> 1;
            this.cutBaseY = ly + hy >> 1;
            long cutAreaWidth = hx - lx;
            long cutAreaHeight = hy - ly;
            int oneDcutsX = 1 + (int)(cutAreaWidth / (this.cutSizeX + this.cutSep1D));
            int oneDcutsY = 1 + (int)(cutAreaHeight / (this.cutSizeY + this.cutSep1D));
            int twoDcutsX = 1 + (int)(cutAreaWidth / (this.cutSizeX + this.cutSep2D));
            int twoDcutsY = 1 + (int)(cutAreaHeight / (this.cutSizeY + this.cutSep2D));
            this.cutSep = this.cutSep1D;
            this.cutsX = oneDcutsX;
            this.cutsY = oneDcutsY;
            if (this.cutsX > 1 && this.cutsY > 1) {
                this.cutSep = this.cutSep2D;
                this.cutsX = twoDcutsX;
                this.cutsY = twoDcutsY;
                if (this.cutsX == 1 || this.cutsY == 1) {
                    this.cutSep = this.cutSep1D;
                    if (cutAreaWidth > cutAreaHeight) {
                        this.cutsX = oneDcutsX;
                    } else {
                        this.cutsY = oneDcutsY;
                    }
                }
            }
            if (this.cutsX <= 0) {
                this.cutsX = 1;
            }
            if (this.cutsY <= 0) {
                this.cutsY = 1;
            }
            this.cutsReasonable = this.cutsTotal = this.cutsX * this.cutsY;
            if (this.cutsTotal != 1 && this.cutsX > 2 && this.cutsY > 2) {
                this.cutsReasonable = this.cutsX * 2 + (this.cutsY - 2) * 2;
                this.cutTopEdge = this.cutsX * 2;
                this.cutLeftEdge = this.cutsX * 2 + this.cutsY - 2;
                this.cutRightEdge = this.cutsX * 2 + (this.cutsY - 2) * 2;
            }
        }

        private MultiCutData(EPoint size, ERectangle fullRectangle, NodeLayer cutLayer) {
            this.calculateInternalData(size, fullRectangle, cutLayer);
        }

        public MultiCutData(ImmutableNodeInst niD, TechPool techPool) {
            this(niD.size, techPool.getPrimitiveNode((PrimitiveNodeId)niD.protoId).getFullRectangle(), techPool.getPrimitiveNode((PrimitiveNodeId)niD.protoId).findMulticut());
        }

        public int numCuts() {
            return this.cutsTotal;
        }

        public int numCutsX() {
            return this.cutsX;
        }

        public int numCutsY() {
            return this.cutsY;
        }

        public double getCutSizeX() {
            return this.cutSizeX;
        }

        public double getCutSizeY() {
            return this.cutSizeY;
        }

        protected Poly fillCutPoly(ImmutableNodeInst ni, int cut) {
            return this.fillCutPoly(ni.anchor, cut);
        }

        public Poly fillCutPoly(EPoint anchor, int cut) {
            long cX = anchor.getGridX() + this.cutBaseX;
            long cY = anchor.getGridY() + this.cutBaseY;
            if (this.cutsX > 1 || this.cutsY > 1) {
                if (this.cutsX > 2 && this.cutsY > 2 && cut >= this.cutsX) {
                    if ((double)cut < this.cutTopEdge) {
                        cut += this.cutsX * (this.cutsY - 2);
                    } else if ((double)cut < this.cutLeftEdge) {
                        cut = (int)(((double)cut - this.cutTopEdge) * (double)this.cutsX + (double)this.cutsX);
                    } else if ((double)cut < this.cutRightEdge) {
                        cut = (int)(((double)cut - this.cutLeftEdge) * (double)this.cutsX + (double)(this.cutsX * 2) - 1.0);
                    } else {
                        int cutx = (cut -= (int)this.cutRightEdge) % (this.cutsX - 2);
                        int cuty = cut / (this.cutsX - 2);
                        cut = cuty * this.cutsX + cutx + this.cutsX + 1;
                    }
                }
                if (this.cutsX != 1) {
                    cX = (long)((double)cX + (double)((long)(cut % this.cutsX * 2 - (this.cutsX - 1)) * (this.cutSizeX + this.cutSep)) * 0.5);
                }
                if (this.cutsY != 1) {
                    cY = (long)((double)cY + (double)((long)(cut / this.cutsX * 2 - (this.cutsY - 1)) * (this.cutSizeY + this.cutSep)) * 0.5);
                }
            }
            double lX = DBMath.gridToLambda(cX - (this.cutSizeX >> 1));
            double hX = DBMath.gridToLambda(cX + (this.cutSizeX >> 1));
            double lY = DBMath.gridToLambda(cY - (this.cutSizeY >> 1));
            double hY = DBMath.gridToLambda(cY + (this.cutSizeY >> 1));
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(lX, lY), new Point2D.Double(hX, lY), new Point2D.Double(hX, hY), new Point2D.Double(lX, hY)};
            return new Poly(points);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LayerZValueSorting
    implements Comparator<Layer> {
        private LayerZValueSorting() {
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            double z2;
            double z1 = l1.getDistance();
            if (z1 < (z2 = l2.getDistance())) {
                return -1;
            }
            if (z1 > z2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LayerHeight
    implements Comparator<Layer> {
        final boolean liftContacts;

        private LayerHeight(boolean liftContacts) {
            this.liftContacts = liftContacts;
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            Technology tech2;
            int cmp;
            Layer.Function f1 = l1.getFunction();
            Layer.Function f2 = l2.getFunction();
            int h1 = f1.getHeight();
            int h2 = f2.getHeight();
            if (this.liftContacts) {
                if (f1.isContact()) {
                    ++h1;
                } else if (f1.isMetal()) {
                    --h1;
                }
                if (f2.isContact()) {
                    ++h2;
                } else if (f2.isMetal()) {
                    --h2;
                }
            }
            if ((cmp = h1 - h2) != 0) {
                return cmp;
            }
            Technology tech1 = l1.getTechnology();
            if (tech1 != (tech2 = l2.getTechnology())) {
                int techIndex1 = tech1 != null ? tech1.getIndex() : -1;
                int techIndex2 = tech2 != null ? tech2.getIndex() : -1;
                return techIndex1 - techIndex2;
            }
            return l1.getIndex() - l2.getIndex();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TechnologyKey
    extends EObjectInputStream.Key<Technology> {
        public TechnologyKey() {
        }

        private TechnologyKey(Technology tech) {
            super(tech);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, Technology tech) throws IOException {
            TechId techId = tech.getId();
            if (techId.idManager != out.getIdManager()) {
                throw new NotSerializableException(tech + " from other IdManager");
            }
            if (out.getDatabase().getTechPool().getTech(techId) != tech) {
                throw new NotSerializableException(tech + " not linked");
            }
            out.writeInt(techId.techIndex);
        }

        @Override
        public Technology readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int techIndex = in.readInt();
            TechId techId = in.getIdManager().getTechId(techIndex);
            Technology tech = in.getDatabase().getTech(techId);
            if (tech == null) {
                throw new InvalidObjectException(techId + " not linked");
            }
            return tech;
        }
    }

    public class SizeCorrector {
        public final HashMap<ArcProtoId, Integer> arcExtends = new HashMap();
        public final HashMap<PrimitiveNodeId, EPoint> nodeExtends = new HashMap();

        private SizeCorrector(Version version, boolean isJelib) {
            int techVersion = 0;
            if (isJelib) {
                if (version.compareTo(DISK_VERSION_2) >= 0) {
                    techVersion = 2;
                } else if (version.compareTo(DISK_VERSION_1) >= 0) {
                    techVersion = 1;
                }
            }
            for (ArcProto ap : Technology.this.arcs.values()) {
                int correction = 0;
                switch (techVersion) {
                    case 0: {
                        correction = ap.getGridBaseExtend() + (int)DBMath.lambdaToGrid(0.5 * ap.getLambdaElibWidthOffset());
                        break;
                    }
                    case 1: {
                        correction = ap.getGridBaseExtend();
                    }
                }
                this.arcExtends.put(ap.getId(), correction);
            }
            for (PrimitiveNode pn : Technology.this.nodes.values()) {
                EPoint correction = techVersion == 2 ? EPoint.ORIGIN : pn.getSizeCorrector(techVersion);
                this.nodeExtends.put(pn.getId(), correction);
            }
        }

        public boolean isIdentity() {
            for (Integer arcExtend : this.arcExtends.values()) {
                if (arcExtend == 0) continue;
                return false;
            }
            for (EPoint nodeExtend : this.nodeExtends.values()) {
                if (nodeExtend.getX() == 0.0 && nodeExtend.getY() == 0.0) continue;
                return false;
            }
            return true;
        }

        public long getExtendFromDisk(ArcProto ap, double width) {
            return DBMath.lambdaToGrid(0.5 * width) - this.arcExtends.get(ap.getId()).longValue();
        }

        public long getExtendToDisk(ImmutableArcInst a) {
            return a.getGridExtendOverMin() + (long)this.arcExtends.get(a.protoId).intValue();
        }

        public long getWidthToDisk(ImmutableArcInst a) {
            return 2L * this.getExtendToDisk(a);
        }

        public EPoint getSizeFromDisk(PrimitiveNode pn, double width, double height) {
            EPoint correction = this.nodeExtends.get(pn.getId());
            return EPoint.fromLambda(width - 2.0 * correction.getLambdaX(), height - 2.0 * correction.getLambdaY());
        }

        public EPoint getSizeToDisk(ImmutableNodeInst n) {
            EPoint size = n.size;
            EPoint correction = this.nodeExtends.get(n.protoId);
            if (!correction.equals(EPoint.ORIGIN)) {
                size = EPoint.fromLambda(size.getLambdaX() + 2.0 * correction.getLambdaX(), size.getLambdaY() + 2.0 * correction.getLambdaY());
            }
            return size;
        }
    }

    public static class NodeLayer {
        private Layer layer;
        private int portNum;
        private Poly.Type style;
        private int representation;
        private TechPoint[] points;
        private String message;
        private TextDescriptor descriptor;
        private double lWidth;
        private double rWidth;
        private double extentT;
        private double extendB;
        private long cutGridSizeX;
        private long cutGridSizeY;
        private long cutGridSep1D;
        private long cutGridSep2D;
        String sizeRule;
        String cutSep1DRule;
        String cutSep2DRule;
        public static final int POINTS = 0;
        public static final int BOX = 1;
        public static final int MULTICUTBOX = 3;

        public NodeLayer(Layer layer, int portNum, Poly.Type style, int representation, TechPoint[] points) {
            this.layer = layer;
            this.portNum = portNum;
            this.style = style;
            this.representation = representation;
            this.points = points;
            this.descriptor = TextDescriptor.EMPTY;
            this.extendB = 0.0;
            this.extentT = 0.0;
            this.rWidth = 0.0;
            this.lWidth = 0.0;
        }

        public NodeLayer(Layer layer, int portNum, Poly.Type style, int representation, TechPoint[] points, double lWidth, double rWidth, double extentT, double extendB) {
            this.layer = layer;
            this.portNum = portNum;
            this.style = style;
            this.representation = representation;
            this.points = points;
            this.descriptor = TextDescriptor.EMPTY;
            this.lWidth = lWidth;
            this.rWidth = rWidth;
            this.extentT = extentT;
            this.extendB = extendB;
        }

        public NodeLayer(NodeLayer node) {
            this.layer = node.getLayerOrPseudoLayer();
            this.portNum = node.getPortNum();
            this.style = node.getStyle();
            this.representation = node.getRepresentation();
            this.descriptor = TextDescriptor.EMPTY;
            TechPoint[] oldPoints = node.getPoints();
            this.points = new TechPoint[oldPoints.length];
            for (int i = 0; i < oldPoints.length; ++i) {
                this.points[i] = oldPoints[i].duplicate();
            }
            this.extendB = 0.0;
            this.extentT = 0.0;
            this.rWidth = 0.0;
            this.lWidth = 0.0;
        }

        public static NodeLayer makeMulticut(Layer layer, int portNum, Poly.Type style, TechPoint[] techPoints, String sizeRule, String cutSep1DRule, String cutSep2DRule) {
            NodeLayer nl = new NodeLayer(layer, portNum, style, 3, techPoints);
            nl.sizeRule = sizeRule;
            nl.cutSep1DRule = cutSep1DRule;
            nl.cutSep2DRule = cutSep2DRule;
            return nl;
        }

        public static NodeLayer makeMulticut(Layer layer, int portNum, Poly.Type style, TechPoint[] techPoints, double sizeX, double sizeY, double sep1d, double sep2d) {
            NodeLayer nl = new NodeLayer(layer, portNum, style, 3, techPoints);
            nl.cutGridSizeX = DBMath.lambdaToGrid(sizeX);
            nl.cutGridSizeY = DBMath.lambdaToGrid(sizeY);
            nl.cutGridSep1D = DBMath.lambdaToGrid(sep1d);
            nl.cutGridSep2D = DBMath.lambdaToGrid(sep2d);
            return nl;
        }

        public Layer getLayer() {
            return this.layer.getNonPseudoLayer();
        }

        public boolean isPseudoLayer() {
            return this.layer.isPseudoLayer();
        }

        public Layer getLayerOrPseudoLayer() {
            return this.layer;
        }

        public int getPortNum() {
            return this.portNum;
        }

        public Poly.Type getStyle() {
            return this.style;
        }

        public int getRepresentation() {
            return this.representation;
        }

        public static String getRepresentationName(int rep) {
            if (rep == 0) {
                return "points";
            }
            if (rep == 1) {
                return "box";
            }
            if (rep == 3) {
                return "multi-cut-box";
            }
            return "?";
        }

        public TechPoint[] getPoints() {
            return this.points;
        }

        public void setPoints(TechPoint[] pts) {
            this.points = pts;
        }

        public EdgeH getLeftEdge() {
            return this.points[0].getX();
        }

        public EdgeV getBottomEdge() {
            return this.points[0].getY();
        }

        public EdgeH getRightEdge() {
            return this.points[1].getX();
        }

        public EdgeV getTopEdge() {
            return this.points[1].getY();
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public TextDescriptor getDescriptor() {
            return this.descriptor;
        }

        public void setDescriptor(TextDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public double getSerpentineLWidth() {
            return this.lWidth;
        }

        public void setSerpentineLWidth(double lWidth) {
            this.lWidth = lWidth;
        }

        public double getSerpentineRWidth() {
            return this.rWidth;
        }

        public void setSerpentineRWidth(double rWidth) {
            this.rWidth = rWidth;
        }

        public double getSerpentineExtentT() {
            return this.extentT;
        }

        public void setSerpentineExtentT(double extentT) {
            this.extentT = extentT;
        }

        public double getSerpentineExtentB() {
            return this.extendB;
        }

        public void setSerpentineExtentB(double extendB) {
            this.extendB = extendB;
        }

        public double getMulticutSizeX() {
            return DBMath.gridToLambda(this.cutGridSizeX);
        }

        public double getMulticutSizeY() {
            return DBMath.gridToLambda(this.cutGridSizeY);
        }

        public double getMulticutSep1D() {
            return DBMath.gridToLambda(this.cutGridSep1D);
        }

        public double getMulticutSep2D() {
            return DBMath.gridToLambda(this.cutGridSep2D);
        }

        void dump(PrintWriter out, boolean isSerp) {
            out.println("\tlayer=" + this.getLayerOrPseudoLayer().getName() + " port=" + this.getPortNum() + " style=" + this.getStyle().name() + " repr=" + this.getRepresentation());
            if (this.getMessage() != null) {
                TextDescriptor td = this.getDescriptor();
                out.println("\t\tmessage=\"" + this.getMessage() + "\" td=" + Long.toHexString(td.lowLevelGet()) + " colorIndex=" + td.getColorIndex() + " disp=" + td.isDisplay());
            }
            if (this.getMulticutSizeX() != 0.0 || this.getMulticutSizeY() != 0.0 || this.getMulticutSep1D() != 0.0 || this.getMulticutSep2D() != 0.0) {
                out.println("\t\tmultiSizeX=" + this.getMulticutSizeX() + " multiSizeY=" + this.getMulticutSizeY() + " multiSep=" + this.getMulticutSep1D() + " multiSpe2D=" + this.getMulticutSep2D());
            }
            if (isSerp) {
                out.println("\t\tLWidth=" + this.getSerpentineLWidth() + " rWidth=" + this.getSerpentineRWidth() + " bExtend=" + this.getSerpentineExtentB() + " tExtend=" + this.getSerpentineExtentT());
            }
            for (TechPoint p : this.getPoints()) {
                out.println("\t\tpoint xm=" + p.getX().getMultiplier() + " xa=" + p.getX().getAdder() + " ym=" + p.getY().getMultiplier() + " ya=" + p.getY().getAdder());
            }
        }

        Xml.NodeLayer makeXml(boolean isSerp, EPoint correction, boolean inLayers, boolean inElectricalLayers) {
            Xml.NodeLayer nld = new Xml.NodeLayer();
            nld.layer = this.getLayer().getNonPseudoLayer().getName();
            nld.style = this.getStyle();
            nld.portNum = this.getPortNum();
            nld.inLayers = inLayers;
            nld.inElectricalLayers = inElectricalLayers;
            nld.representation = this.getRepresentation();
            TechPoint[] points = this.getPoints();
            if (nld.representation == 1 || nld.representation == 3) {
                nld.lx.k = points[0].getX().getMultiplier() * 2.0;
                nld.lx.addLambda(DBMath.round(points[0].getX().getAdder() + correction.getLambdaX() * points[0].getX().getMultiplier() * 2.0));
                nld.hx.k = points[1].getX().getMultiplier() * 2.0;
                nld.hx.addLambda(DBMath.round(points[1].getX().getAdder() + correction.getLambdaX() * points[1].getX().getMultiplier() * 2.0));
                nld.ly.k = points[0].getY().getMultiplier() * 2.0;
                nld.ly.addLambda(DBMath.round(points[0].getY().getAdder() + correction.getLambdaY() * points[0].getY().getMultiplier() * 2.0));
                nld.hy.k = points[1].getY().getMultiplier() * 2.0;
                nld.hy.addLambda(DBMath.round(points[1].getY().getAdder() + correction.getLambdaY() * points[1].getY().getMultiplier() * 2.0));
            } else {
                for (TechPoint p : points) {
                    nld.techPoints.add(p.makeCorrection(correction));
                }
            }
            if (nld.representation == 3) {
                nld.sizex = DBMath.round(this.getMulticutSizeX());
                nld.sizey = DBMath.round(this.getMulticutSizeY());
                nld.sep1d = DBMath.round(this.getMulticutSep1D());
                nld.sep2d = DBMath.round(this.getMulticutSep2D());
            }
            if (isSerp) {
                nld.lWidth = DBMath.round(this.getSerpentineLWidth());
                nld.rWidth = DBMath.round(this.getSerpentineRWidth());
                nld.tExtent = DBMath.round(this.getSerpentineExtentT());
                nld.bExtent = DBMath.round(this.getSerpentineExtentB());
            }
            return nld;
        }

        Xml807.NodeLayer makeXml807(boolean isSerp, EPoint correction, boolean inLayers, boolean inElectricalLayers) {
            Xml807.NodeLayer nld = new Xml807.NodeLayer();
            nld.layer = this.getLayer().getNonPseudoLayer().getName();
            nld.style = this.getStyle();
            nld.portNum = this.getPortNum();
            nld.inLayers = inLayers;
            nld.inElectricalLayers = inElectricalLayers;
            nld.representation = this.getRepresentation();
            TechPoint[] points = this.getPoints();
            if (nld.representation == 1 || nld.representation == 3) {
                nld.lx.k = points[0].getX().getMultiplier() * 2.0;
                nld.lx.addLambda(DBMath.round(points[0].getX().getAdder() + correction.getLambdaX() * points[0].getX().getMultiplier() * 2.0));
                nld.hx.k = points[1].getX().getMultiplier() * 2.0;
                nld.hx.addLambda(DBMath.round(points[1].getX().getAdder() + correction.getLambdaX() * points[1].getX().getMultiplier() * 2.0));
                nld.ly.k = points[0].getY().getMultiplier() * 2.0;
                nld.ly.addLambda(DBMath.round(points[0].getY().getAdder() + correction.getLambdaY() * points[0].getY().getMultiplier() * 2.0));
                nld.hy.k = points[1].getY().getMultiplier() * 2.0;
                nld.hy.addLambda(DBMath.round(points[1].getY().getAdder() + correction.getLambdaY() * points[1].getY().getMultiplier() * 2.0));
            } else {
                for (TechPoint p : points) {
                    nld.techPoints.add(p.makeCorrection(correction));
                }
            }
            nld.sizeRule = this.sizeRule;
            nld.sepRule = this.cutSep1DRule;
            nld.sepRule2D = this.cutSep2DRule;
            if (isSerp) {
                nld.lWidth = DBMath.round(this.getSerpentineLWidth());
                nld.rWidth = DBMath.round(this.getSerpentineRWidth());
                nld.tExtent = DBMath.round(this.getSerpentineExtentT());
                nld.bExtent = DBMath.round(this.getSerpentineExtentB());
            }
            return nld;
        }

        void resize(DistanceContext context) {
            if (this.sizeRule != null) {
                double lambdaSize = context.getRule(this.sizeRule);
                this.cutGridSizeX = this.cutGridSizeY = (long)((int)DBMath.lambdaToGrid(lambdaSize));
                double lambdaCutSep1D = context.getRule(this.cutSep1DRule);
                this.cutGridSep1D = (int)DBMath.lambdaToGrid(lambdaCutSep1D);
                if (this.cutSep2DRule != null) {
                    double lambdaCutSep2D = context.getRule(this.cutSep2DRule);
                    this.cutGridSep2D = (int)DBMath.lambdaToGrid(lambdaCutSep2D);
                } else {
                    this.cutGridSep2D = this.cutGridSep1D;
                }
            }
        }
    }

    public static class TechPoint
    implements Serializable {
        private EdgeH x;
        private EdgeV y;

        public TechPoint(EdgeH x, EdgeV y) {
            this.x = x;
            this.y = y;
        }

        public TechPoint duplicate() {
            TechPoint newTP = new TechPoint(new EdgeH(this.x.getMultiplier(), this.x.getAdder()), new EdgeV(this.y.getMultiplier(), this.y.getAdder()));
            return newTP;
        }

        public static TechPoint[] makeCenterBox() {
            return new TechPoint[]{new TechPoint(EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0)), new TechPoint(EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0))};
        }

        public static TechPoint[] makeFullBox() {
            return TechPoint.makeIndented(0.0);
        }

        public static TechPoint[] makeIndented(double amount) {
            return new TechPoint[]{new TechPoint(EdgeH.fromLeft(amount), EdgeV.fromBottom(amount)), new TechPoint(EdgeH.fromRight(amount), EdgeV.fromTop(amount))};
        }

        public static TechPoint[] makeIndented(double amountX, double amountY) {
            return new TechPoint[]{new TechPoint(EdgeH.fromLeft(amountX), EdgeV.fromBottom(amountY)), new TechPoint(EdgeH.fromRight(amountX), EdgeV.fromTop(amountY))};
        }

        public static TechPoint[] makeIndentedFromCenter(double amountX, double amountY) {
            return new TechPoint[]{new TechPoint(EdgeH.fromCenter(-amountX), EdgeV.fromCenter(-amountY)), new TechPoint(EdgeH.fromCenter(amountX), EdgeV.fromCenter(amountY))};
        }

        public EdgeH getX() {
            return this.x;
        }

        public EdgeV getY() {
            return this.y;
        }

        TechPoint makeCorrection(EPoint correction) {
            EdgeH h = new EdgeH(this.x.getMultiplier(), this.x.getAdder() + correction.getLambdaX() * this.x.getMultiplier() * 2.0);
            EdgeV v = new EdgeV(this.y.getMultiplier(), this.y.getAdder() + correction.getLambdaY() * this.y.getMultiplier() * 2.0);
            return new TechPoint(h, v);
        }
    }

    protected static class ArcLayer {
        private final Layer layer;
        private final Poly.Type style;
        private final Distance xmlExtend;
        private int gridExtend;

        public ArcLayer(Layer layer, double arcLayerWidth, Poly.Type style) {
            this(layer, style, arcLayerWidth * 0.5, new String[0]);
            this.gridExtend = (int)DBMath.lambdaToGrid(arcLayerWidth * 0.5);
        }

        public ArcLayer(Layer layer, Poly.Type style, String ... ruleNames) {
            this(layer, style, 0.0, ruleNames);
        }

        public ArcLayer(Layer layer, Poly.Type style, double lambdaExtend, String ... ruleNames) {
            this(layer, style, new Distance());
            if (ruleNames.length > 0) {
                this.xmlExtend.addRule(ruleNames[0], 0.5);
            }
            for (int i = 1; i < ruleNames.length; ++i) {
                this.xmlExtend.addRule(ruleNames[i], 1.0);
            }
            this.xmlExtend.addLambda(DBMath.round(lambdaExtend));
        }

        public ArcLayer(Layer layer, Poly.Type style, Distance xmlExtend) {
            this(layer, style, 0L, xmlExtend);
        }

        private ArcLayer(Layer layer, Poly.Type style, long gridExtend, Distance xmlExtend) {
            if (gridExtend < 0L || gridExtend >= 0xFFFFFFFL) {
                throw new IllegalArgumentException("gridExtend=" + gridExtend);
            }
            this.layer = layer;
            this.gridExtend = (int)gridExtend;
            this.style = style;
            this.xmlExtend = xmlExtend;
        }

        Layer getLayer() {
            return this.layer;
        }

        int getGridExtend() {
            return this.gridExtend;
        }

        ArcLayer withGridExtend(long gridExtend) {
            if ((long)this.gridExtend == gridExtend) {
                return this;
            }
            return new ArcLayer(this.layer, this.style, gridExtend, this.xmlExtend);
        }

        Poly.Type getStyle() {
            return this.style;
        }

        void dump(PrintWriter out) {
            out.println("\t\tarcLayer layer=" + this.layer.getName() + " style=" + this.style.name() + " extend=" + DBMath.gridToLambda(this.gridExtend));
        }

        Xml.ArcLayer makeXml() {
            Xml.ArcLayer al = new Xml.ArcLayer();
            al.layer = this.layer.getName();
            al.style = this.style;
            al.extend.addLambda(DBMath.gridToLambda(this.gridExtend));
            return al;
        }

        Xml807.ArcLayer makeXml807() {
            Xml807.ArcLayer al = new Xml807.ArcLayer();
            al.layer = this.layer.getName();
            al.style = this.style;
            al.extend.assign(this.xmlExtend);
            return al;
        }

        void resize(DistanceContext context, ArcProto ap) {
            long gridExtend;
            double lambdaExtend = this.xmlExtend.getLambda(context);
            if (Double.isNaN(lambdaExtend) && !ap.isNotUsed()) {
                System.out.println("Can't resize arc layer " + this.layer + " of " + ap.getFullName());
            }
            if ((gridExtend = DBMath.lambdaToGrid(lambdaExtend)) < 0L || gridExtend >= 0xFFFFFFFL) {
                throw new IllegalArgumentException("gridExtend=" + gridExtend);
            }
            this.gridExtend = (int)gridExtend;
        }
    }

    public static class DistanceRule
    implements Serializable,
    Cloneable {
        public String ruleName;
        public double k;

        public DistanceRule clone() {
            try {
                return (DistanceRule)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        private double getLambda(DistanceContext context) {
            return context.getRule(this.ruleName) * this.k;
        }
    }

    public static interface DistanceContext {
        public double getRule(String var1);
    }

    public static class Distance
    implements Serializable {
        public double k;
        public double lambdaValue;
        public final List<DistanceRule> terms = new ArrayList<DistanceRule>();

        public void assign(Distance d) {
            this.k = d.k;
            this.lambdaValue = d.lambdaValue;
            for (DistanceRule term : d.terms) {
                this.terms.add(term.clone());
            }
        }

        public Distance clone() {
            Distance d = new Distance();
            d.assign(this);
            return d;
        }

        public double getLambda(DistanceContext context) {
            double value = this.lambdaValue;
            for (DistanceRule term : this.terms) {
                value += term.getLambda(context);
            }
            return value;
        }

        public void addLambda(double value) {
            this.lambdaValue += value;
        }

        public void addRule(String ruleName, double k) {
            DistanceRule term = new DistanceRule();
            term.ruleName = ruleName;
            term.k = k;
            this.terms.add(term);
        }

        public boolean isEmpty() {
            return this.lambdaValue == 0.0 && this.terms.isEmpty();
        }
    }
}

