/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.ViaStack;

public class TrackRouterH
extends TrackRouter {
    public TrackRouterH(ArcProto lay, double wid, Cell parnt) {
        super(lay, wid, parnt);
    }

    public TrackRouterH(ArcProto lay, double wid, double centerVal, Cell parnt) {
        super(lay, wid, centerVal, parnt);
    }

    public void connect(PortInst newPort, double viaOffset, double wireOffset) {
        ViaStack closeVia;
        TrackRouterH.error(newPort == null, "can't connect to null port");
        EPoint centerP = newPort.getCenter();
        if (this.center == null) {
            this.center = new Double(centerP.getY());
        }
        ArcProto portLyr = Tech.closestLayer(newPort.getPortProto(), this.layer);
        double newWid = LayoutLib.widestWireWidth(newPort);
        if (newWid == Double.POSITIVE_INFINITY) {
            newWid = portLyr.getWidth();
        }
        double x = centerP.getX() + viaOffset;
        PortInst lastPort = null;
        ViaStack viaStack = closeVia = portLyr == this.layer ? null : this.findClosestVia(x, portLyr);
        if (closeVia != null) {
            lastPort = closeVia.getPort2();
        } else {
            ViaStack vs = new ViaStack(this.layer, portLyr, x, this.center, newWid, this.width, this.parent);
            this.insertVia(vs);
            lastPort = vs.getPort2();
        }
        if (wireOffset != 0.0) {
            PrimitiveNode pin = portLyr.findOverridablePinProto();
            double defSz = Double.POSITIVE_INFINITY;
            NodeInst pinInst = LayoutLib.newNodeInst(pin, LayoutLib.roundCenterX(lastPort), this.center + wireOffset, defSz, defSz, 0.0, this.parent);
            PortInst jog = pinInst.getOnlyPortInst();
            LayoutLib.newArcInst(portLyr, newWid, lastPort, jog);
            lastPort = jog;
        }
        LayoutLib.newArcInst(portLyr, newWid, lastPort, newPort);
    }
}

