/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.WindowFrame;
import javax.swing.JPanel;

public abstract class WindowContextClass
extends JPanel
implements HighlightListener {
    protected Cell cell;
    protected Highlighter highlighter;
    protected WindowFrame wf;

    public WindowContextClass(Cell c, WindowFrame wf) {
        this.cell = c;
        this.wf = wf;
        this.highlighter = new Highlighter(0, wf);
        this.highlighter.addHighlightListener(this);
    }

    public Cell getCell() {
        return this.cell;
    }

    public void setCell(Cell cell) {
        this.cell = cell;
    }

    public String composeTitle(String prefix, int pageNo) {
        StringBuffer title = new StringBuffer();
        if (this.cell != null) {
            title.append(prefix + this.cell.libDescribe());
            if (this.cell.isMultiPage()) {
                title.append(" - Page " + (pageNo + 1));
            }
            if (this.cell.getLibrary() != Library.getCurrent()) {
                title.append(" - Current library: " + Library.getCurrent().getName());
            }
        } else {
            title.append("***NONE***");
        }
        return title.toString();
    }
}

