/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.tool.user.ui.KeyBindings;
import com.sun.electric.tool.user.ui.KeyStrokePair;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class KeyBindingManager {
    private HashMap inputMap = new HashMap();
    private HashMap actionMap = new HashMap();
    private KeyStroke lastPrefix = null;
    private HashMap prefixedInputMapMaps = new HashMap();
    private PrefixAction prefixAction = new PrefixAction(this);
    private Preferences prefs;
    private String prefPrefix;
    private static List allManagers = new ArrayList();
    private static final boolean debugPrefs = false;
    private static final boolean DEBUG = false;
    private boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyBindingManager(String prefPrefix, Preferences prefs) {
        this.prefs = prefs;
        this.prefPrefix = prefPrefix;
        this.actionMap.put("KeyBindingManager prefix action", this.prefixAction);
        List list = allManagers;
        synchronized (list) {
            allManagers.add(this);
        }
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        List list = allManagers;
        synchronized (list) {
            allManagers.remove(this);
        }
    }

    private synchronized void initialize() {
    }

    private synchronized void setPrefixKey(KeyStroke prefix) {
        this.lastPrefix = prefix;
    }

    public static boolean validKeyEvent(KeyEvent e) {
        if (e.getID() != 401 && e.getID() != 400) {
            return false;
        }
        if (e.getKeyCode() == 17) {
            return false;
        }
        if (e.getKeyCode() == 16) {
            return false;
        }
        if (e.getKeyCode() == 18) {
            return false;
        }
        return e.getKeyCode() != 157;
    }

    public synchronized boolean processKeyEvent(KeyEvent e) {
        if (!KeyBindingManager.validKeyEvent(e)) {
            return false;
        }
        KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
        if (stroke.getKeyCode() == 0) {
            stroke = KeyStroke.getKeyStroke(stroke.getKeyChar());
        }
        if (e.isConsumed()) {
            this.lastPrefix = null;
            return false;
        }
        HashMap inputMapToUse = this.inputMap;
        if (this.lastPrefix != null && (inputMapToUse = (HashMap)this.prefixedInputMapMaps.get(this.lastPrefix)) == null) {
            this.lastPrefix = null;
            return false;
        }
        ActionListener action = null;
        ActionEvent evt = new ActionEvent(e, 1001, stroke.toString(), stroke.getModifiers());
        boolean actionPerformed = false;
        boolean prefixActionPerformed = false;
        Set keyBindingList = (Set)inputMapToUse.get(stroke);
        if (keyBindingList != null) {
            Iterator it = keyBindingList.iterator();
            while (it.hasNext()) {
                String actionDesc = (String)it.next();
                action = (ActionListener)this.actionMap.get(actionDesc);
                if (action instanceof PrefixAction) {
                    if (!prefixActionPerformed) {
                        action.actionPerformed(evt);
                        prefixActionPerformed = true;
                    }
                } else {
                    action.actionPerformed(evt);
                    this.lastPrefix = null;
                }
                actionPerformed = true;
            }
        }
        if (!actionPerformed) {
            HashMap prefixMap = (HashMap)this.prefixedInputMapMaps.get(stroke);
            if (prefixMap != null) {
                this.prefixAction.actionPerformed(evt);
                actionPerformed = true;
            } else {
                this.lastPrefix = null;
            }
        }
        if (actionPerformed) {
            e.consume();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getConflictsAllManagers(KeyStrokePair pair) {
        ArrayList conflicts = new ArrayList();
        List list = allManagers;
        synchronized (list) {
            Iterator it = allManagers.iterator();
            while (it.hasNext()) {
                KeyBindingManager m = (KeyBindingManager)it.next();
                conflicts.addAll(m.getConflictingKeyBindings(pair));
            }
        }
        return conflicts;
    }

    public synchronized void addDefaultKeyBinding(String actionDesc, KeyStrokePair pair) {
        if (pair == null) {
            return;
        }
        KeyBindings keys = (KeyBindings)this.actionMap.get(actionDesc);
        if (keys == null) {
            keys = new KeyBindings(actionDesc);
            this.actionMap.put(actionDesc, keys);
        }
        keys.addDefaultKeyBinding(pair);
    }

    public synchronized void addUserKeyBinding(String actionDesc, KeyStrokePair pair) {
        if (pair == null) {
            return;
        }
        KeyBindings keys = this.addKeyBinding(actionDesc, pair);
        keys.setUsingDefaultKeys(false);
        this.setBindingsToPrefs(keys.getActionDesc());
    }

    public synchronized void addActionListener(String actionDesc, ActionListener action) {
        KeyBindings keys = (KeyBindings)this.actionMap.get(actionDesc);
        if (keys == null) {
            keys = new KeyBindings(actionDesc);
            this.actionMap.put(actionDesc, keys);
        }
        keys.addActionListener(action);
    }

    public synchronized void removeKeyBinding(String actionDesc, KeyStrokePair k) {
        Set set;
        HashMap inputMapToUse = this.inputMap;
        if (k.getPrefixStroke() != null) {
            List list = (List)this.inputMap.get(k.getPrefixStroke());
            if (list != null) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    String str = (String)it.next();
                    if (!str.equals("KeyBindingManager prefix action")) continue;
                    list.remove(str);
                    break;
                }
            }
            inputMapToUse = (HashMap)this.prefixedInputMapMaps.get(k.getPrefixStroke());
        }
        if (inputMapToUse != null && (set = (Set)inputMapToUse.get(k.getStroke())) != null) {
            set.remove(actionDesc);
        }
        KeyBindings bindings = (KeyBindings)this.actionMap.get(actionDesc);
        bindings.removeKeyBinding(k);
        bindings.setUsingDefaultKeys(false);
        this.setBindingsToPrefs(actionDesc);
    }

    public synchronized void resetKeyBindings(String actionDesc) {
        Iterator it;
        KeyBindings keys = (KeyBindings)this.actionMap.get(actionDesc);
        if (keys != null) {
            while ((it = keys.getKeyStrokePairs()).hasNext()) {
                KeyStrokePair pair = (KeyStrokePair)it.next();
                this.removeKeyBinding(actionDesc, pair);
            }
        }
        this.prefs.remove(this.prefPrefix + actionDesc);
        it = keys.getDefaultKeyStrokePairs();
        while (it.hasNext()) {
            KeyStrokePair k = (KeyStrokePair)it.next();
            this.addKeyBinding(actionDesc, k);
        }
        keys.setUsingDefaultKeys(true);
    }

    public synchronized KeyBindings getKeyBindings(String actionDesc) {
        return (KeyBindings)this.actionMap.get(actionDesc);
    }

    public synchronized void setEventSource(String actionDesc, Object source) {
        KeyBindings keys = (KeyBindings)this.actionMap.get(actionDesc);
        keys.setEventSource(source);
    }

    public synchronized List getConflictingKeyBindings(KeyStrokePair pair) {
        Iterator it2;
        String str;
        Iterator it;
        Set set;
        ArrayList<KeyBindings> conflicts = new ArrayList<KeyBindings>();
        ArrayList<String> conflictsStrings = new ArrayList<String>();
        HashMap inputMapToUse = this.inputMap;
        if (pair.getPrefixStroke() != null) {
            set = (Set)this.inputMap.get(pair.getPrefixStroke());
            if (set != null) {
                it = set.iterator();
                while (it.hasNext()) {
                    str = (String)it.next();
                    if (str.equals("KeyBindingManager prefix action")) continue;
                    conflictsStrings.add(str);
                }
            }
            inputMapToUse = (HashMap)this.prefixedInputMapMaps.get(pair.getPrefixStroke());
        }
        if (inputMapToUse != null && (set = (Set)inputMapToUse.get(pair.getStroke())) != null) {
            it = set.iterator();
            while (it.hasNext()) {
                str = (String)it.next();
                if (str.equals("KeyBindingManager prefix action")) {
                    HashMap prefixMap = (HashMap)this.prefixedInputMapMaps.get(pair.getStroke());
                    if (prefixMap == null) continue;
                    it2 = prefixMap.values().iterator();
                    while (it2.hasNext()) {
                        List prefixList = (List)it2.next();
                        conflictsStrings.addAll(prefixList);
                    }
                    continue;
                }
                conflictsStrings.add(str);
            }
        }
        Iterator it3 = conflictsStrings.iterator();
        while (it3.hasNext()) {
            ActionListener action = (ActionListener)this.actionMap.get((String)it3.next());
            if (action == null || action instanceof PrefixAction) continue;
            KeyBindings keys = (KeyBindings)action;
            KeyBindings conflicting = new KeyBindings(keys.getActionDesc());
            it2 = keys.getKeyStrokePairs();
            while (it2.hasNext()) {
                KeyStrokePair pair2 = (KeyStrokePair)it2.next();
                if (pair.getPrefixStroke() != null) {
                    if (pair2.getPrefixStroke() != null) {
                        if (pair.getStroke() != pair2.getStroke()) continue;
                        conflicting.addKeyBinding(pair2);
                        continue;
                    }
                    if (pair.getPrefixStroke() != pair2.getStroke()) continue;
                    conflicting.addKeyBinding(pair2);
                    continue;
                }
                if (pair2.getPrefixStroke() != null) {
                    if (pair.getStroke() != pair2.getPrefixStroke()) continue;
                    conflicting.addKeyBinding(pair2);
                    continue;
                }
                if (pair.getStroke() != pair2.getStroke()) continue;
                conflicting.addKeyBinding(pair2);
            }
            Iterator conflictingIt = conflicting.getKeyStrokePairs();
            if (!conflictingIt.hasNext()) continue;
            conflicts.add(conflicting);
        }
        return conflicts;
    }

    public synchronized void setEnabled(String actionDesc, boolean b) {
        ActionListener action = (ActionListener)this.actionMap.get(actionDesc);
        if (action == null) {
            return;
        }
        if (action instanceof PrefixAction) {
            return;
        }
        KeyBindings k = (KeyBindings)action;
        k.setEnabled(b);
    }

    public synchronized boolean getEnabled(String actionDesc) {
        ActionListener action = (ActionListener)this.actionMap.get(actionDesc);
        if (action == null) {
            return false;
        }
        if (action instanceof PrefixAction) {
            return false;
        }
        KeyBindings k = (KeyBindings)action;
        return k.getEnabled();
    }

    public synchronized void deleteEmptyBindings() {
        Set keys = this.actionMap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            KeyBindings bindings;
            Iterator listenersIt;
            String key = (String)it.next();
            ActionListener action = (ActionListener)this.actionMap.get(key);
            if (!(action instanceof KeyBindings) || (listenersIt = (bindings = (KeyBindings)action).getActionListeners()).hasNext()) continue;
            System.out.println("Warning: Deleting defunct binding for " + key + " [ " + bindings.bindingsToString() + " ]...action does not exist anymore");
            this.removeBindingsFromPrefs(key);
        }
    }

    private synchronized KeyBindings addKeyBinding(String actionDesc, KeyStrokePair pair) {
        Set<String> set;
        if (pair == null) {
            return null;
        }
        List conflicts = this.getConflictingKeyBindings(pair);
        if (conflicts.size() > 0) {
            System.out.println("WARNING: Key binding for " + actionDesc + " [ " + pair.toString() + " ] conflicts with:");
            Iterator it = conflicts.iterator();
            while (it.hasNext()) {
                KeyBindings k = (KeyBindings)it.next();
                System.out.println("  > " + k.getActionDesc() + " [ " + k.bindingsToString() + " ]");
            }
        }
        KeyStroke prefixStroke = pair.getPrefixStroke();
        KeyStroke stroke = pair.getStroke();
        HashMap inputMapToUse = this.inputMap;
        if (prefixStroke != null) {
            inputMapToUse = (HashMap)this.prefixedInputMapMaps.get(prefixStroke);
            if (inputMapToUse == null) {
                inputMapToUse = new HashMap();
                this.prefixedInputMapMaps.put(prefixStroke, inputMapToUse);
            }
            if ((set = (Set)this.inputMap.get(prefixStroke)) == null) {
                set = new HashSet();
                this.inputMap.put(prefixStroke, set);
            }
            set.add("KeyBindingManager prefix action");
        }
        if ((set = (HashSet<String>)inputMapToUse.get(stroke)) == null) {
            set = new HashSet<String>();
            inputMapToUse.put(stroke, set);
        }
        set.add(actionDesc);
        KeyBindings keys = (KeyBindings)this.actionMap.get(actionDesc);
        if (keys == null) {
            keys = new KeyBindings(actionDesc);
            this.actionMap.put(actionDesc, keys);
        }
        keys.addKeyBinding(pair);
        return keys;
    }

    private synchronized void setBindingsToPrefs(String actionDesc) {
        if (this.prefs == null) {
            return;
        }
        if (actionDesc == null || actionDesc.equals("")) {
            return;
        }
        KeyBindings keyBindings = (KeyBindings)this.actionMap.get(actionDesc);
        if (keyBindings == null) {
            return;
        }
        String actionDescAbbrev = actionDesc;
        if (actionDesc.length() + this.prefPrefix.length() > 80) {
            int start = actionDesc.length() + this.prefPrefix.length() - 80;
            actionDescAbbrev = actionDesc.substring(start, actionDesc.length());
        }
        this.prefs.put(this.prefPrefix + actionDescAbbrev, keyBindings.bindingsToString());
    }

    private synchronized List getBindingsFromPrefs(String actionDesc) {
        String keys;
        if (this.prefs == null) {
            return null;
        }
        if (actionDesc == null || actionDesc.equals("")) {
            return null;
        }
        String actionDescAbbrev = actionDesc;
        if (actionDesc.length() + this.prefPrefix.length() > 80) {
            int start = actionDesc.length() + this.prefPrefix.length() - 80;
            actionDescAbbrev = actionDesc.substring(start, actionDesc.length());
        }
        if ((keys = this.prefs.get(this.prefPrefix + actionDescAbbrev, null)) == null) {
            return null;
        }
        KeyBindings k = new KeyBindings(actionDesc);
        k.addKeyBindings(keys);
        ArrayList<KeyStrokePair> bindings = new ArrayList<KeyStrokePair>();
        Iterator it = k.getKeyStrokePairs();
        while (it.hasNext()) {
            bindings.add((KeyStrokePair)it.next());
        }
        return bindings;
    }

    public synchronized void restoreSavedBindings(boolean initialCall) {
        if (initialCall && this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.prefs == null) {
            return;
        }
        Iterator it = this.actionMap.entrySet().iterator();
        while (it.hasNext()) {
            KeyStrokePair pair;
            Iterator it2;
            Map.Entry entry = it.next();
            String actionDesc = (String)entry.getKey();
            if (actionDesc == null || actionDesc.equals("") || entry.getValue() instanceof PrefixAction) continue;
            KeyBindings bindings = (KeyBindings)entry.getValue();
            bindings.clearKeyBindings();
            List keyPairs = this.getBindingsFromPrefs(bindings.getActionDesc());
            if (keyPairs == null) {
                bindings.setUsingDefaultKeys(true);
                it2 = bindings.getDefaultKeyStrokePairs();
                while (it2.hasNext()) {
                    pair = (KeyStrokePair)it2.next();
                    this.addKeyBinding(actionDesc, pair);
                }
                continue;
            }
            bindings.setUsingDefaultKeys(false);
            it2 = keyPairs.iterator();
            while (it2.hasNext()) {
                pair = (KeyStrokePair)it2.next();
                this.addKeyBinding(actionDesc, pair);
            }
        }
    }

    private synchronized void removeBindingsFromPrefs(String actionDesc) {
        if (this.prefs == null) {
            return;
        }
        if (actionDesc == null || actionDesc.equals("")) {
            return;
        }
        this.prefs.remove(this.prefPrefix + actionDesc);
    }

    private static class PrefixAction
    extends AbstractAction {
        public static final String actionDesc = "KeyBindingManager prefix action";
        private KeyBindingManager manager;

        public PrefixAction(KeyBindingManager manager) {
            this.manager = manager;
        }

        public void actionPerformed(ActionEvent e) {
            KeyEvent keyEvent = (KeyEvent)e.getSource();
            KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            this.manager.setPrefixKey(stroke);
            System.out.println("prefix key '" + KeyStrokePair.keyStrokeToString(stroke) + "' hit...");
        }
    }
}

