/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.ArchSimOut;
import com.sun.electric.tool.io.input.EpicOut;
import com.sun.electric.tool.io.input.HSpiceOut;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.PSpiceOut;
import com.sun.electric.tool.io.input.RawSpiceOut;
import com.sun.electric.tool.io.input.SmartSpiceOut;
import com.sun.electric.tool.io.input.SpiceOut;
import com.sun.electric.tool.io.input.VerilogOut;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.dialogs.CellBrowser;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;

public class Simulate
extends Input {
    Simulate() {
    }

    public static void plotSpiceResults() {
        FileType type = Simulate.getCurrentSpiceOutputType();
        if (type == null) {
            return;
        }
        Simulate.plotSimulationResults(type, null, null, null);
    }

    public static void plotSpiceResultsThisCell() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        FileType type = Simulate.getCurrentSpiceOutputType();
        if (type == null) {
            return;
        }
        Simulate.plotSimulationResults(type, cell, null, null);
    }

    public static void plotVerilogResults() {
        Simulate.plotSimulationResults(FileType.VERILOGOUT, null, null, null);
    }

    public static void plotVerilogResultsThisCell() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Simulate.plotSimulationResults(FileType.VERILOGOUT, cell, null, null);
    }

    public static void plotArchSimResults() {
        Simulate.plotSimulationResults(FileType.ARCHSIMOUT, null, null, null);
    }

    public static void plotSimulationResults(FileType type, Cell cell, URL fileURL, WaveformWindow ww) {
        Simulate is = null;
        if (type == FileType.ARCHSIMOUT) {
            is = new ArchSimOut();
        } else if (type == FileType.HSPICEOUT) {
            is = new HSpiceOut();
        } else if (type == FileType.PSPICEOUT) {
            is = new PSpiceOut();
        } else if (type == FileType.RAWSPICEOUT) {
            is = new RawSpiceOut();
        } else if (type == FileType.RAWSSPICEOUT) {
            is = new SmartSpiceOut();
        } else if (type == FileType.SPICEOUT) {
            is = new SpiceOut();
        } else if (type == FileType.EPIC) {
            is = new EpicOut();
        } else if (type == FileType.VERILOGOUT) {
            is = new VerilogOut();
        }
        if (is == null) {
            System.out.println("Cannot handle " + type.getName() + " files yet");
            return;
        }
        if (cell == null) {
            if (fileURL == null) {
                String fileName = OpenFile.chooseInputFile(type, null);
                if (fileName == null) {
                    return;
                }
                fileURL = TextUtils.makeURLToFile(fileName);
            }
            String cellName = TextUtils.getFileNameWithoutExtension(fileURL);
            Library curLib = Library.getCurrent();
            cell = curLib.findNodeProto(cellName);
            if (cell == null) {
                CellBrowser dialog = new CellBrowser((Frame)TopLevel.getCurrentJFrame(), true, CellBrowser.DoAction.selectCell);
                dialog.setVisible(true);
                cell = dialog.getSelectedCell();
                if (cell == null) {
                    return;
                }
            }
        } else if (fileURL == null) {
            String[] extensions = type.getExtensions();
            String filePath = TextUtils.getFilePath(cell.getLibrary().getLibFile());
            String fileName = cell.getName() + "." + extensions[0];
            fileURL = TextUtils.makeURLToFile(filePath + fileName);
        }
        ReadSimulationOutput job = new ReadSimulationOutput(type, is, fileURL, cell, ww);
    }

    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        return null;
    }

    public static FileType getCurrentSpiceOutputType() {
        String format = Simulation.getSpiceOutputFormat();
        int engine = Simulation.getSpiceEngine();
        if (format.equalsIgnoreCase("Standard")) {
            if (engine == 2) {
                return FileType.HSPICEOUT;
            }
            if (engine == 1 || engine == 3) {
                return FileType.PSPICEOUT;
            }
            return FileType.SPICEOUT;
        }
        if (format.equalsIgnoreCase("Raw")) {
            return FileType.RAWSPICEOUT;
        }
        if (format.equalsIgnoreCase("Raw/Smart")) {
            return FileType.RAWSSPICEOUT;
        }
        if (format.equalsIgnoreCase("Epic")) {
            return FileType.EPIC;
        }
        return null;
    }

    protected String getLineFromSimulator() throws IOException {
        StringBuffer sb = new StringBuffer();
        int bytesRead = 0;
        while (true) {
            int ch;
            if ((ch = this.lineReader.read()) == -1) {
                return null;
            }
            ++bytesRead;
            if (ch == 10 || ch == 13) break;
            sb.append((char)ch);
        }
        this.updateProgressDialog(bytesRead);
        return sb.toString();
    }

    static String removeLeadingX(String name) {
        int xPos;
        int dotPos = -1;
        do {
            xPos = dotPos + 1;
            if (name.length() <= xPos || name.charAt(xPos) != 'x') continue;
            name = name.substring(0, xPos) + name.substring(xPos + 1);
        } while ((dotPos = name.indexOf(46, xPos)) >= 0);
        return name;
    }

    private static class ReadSimulationOutput
    extends Job {
        FileType type;
        Simulate is;
        URL fileURL;
        Cell cell;
        WaveformWindow ww;

        protected ReadSimulationOutput(FileType type, Simulate is, URL fileURL, Cell cell, WaveformWindow ww) {
            super("Read Simulation Output for " + cell, IOTool.getIOTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.type = type;
            this.is = is;
            this.fileURL = fileURL;
            this.cell = cell;
            this.ww = ww;
            this.startJob();
        }

        public boolean doIt() {
            try {
                Stimuli sd = this.is.readSimulationOutput(this.fileURL, this.cell);
                if (sd != null) {
                    sd.setDataType(this.type);
                    sd.setFileURL(this.fileURL);
                    Simulation.showSimulationData(sd, this.ww);
                }
            }
            catch (IOException e) {
                System.out.println("End of file reached while reading " + this.fileURL);
            }
            return true;
        }
    }
}

