/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.CellId;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutableVariable;
import com.sun.electric.database.LibId;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.ncc.basic.TransitiveRelation;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class JELIB
extends LibraryFiles {
    private static String[] revisions;
    private static int defaultArcFlags;
    private LinkedHashMap allCells = new LinkedHashMap();
    private HashMap externalCells;
    private HashMap externalExports;
    private HashMap parsedDescriptorsF = new HashMap();
    private HashMap parsedDescriptorsT = new HashMap();
    private Version version;
    private int revision;
    private char escapeChar = (char)92;
    private String curLibName;
    static final /* synthetic */ boolean $assertionsDisabled;

    JELIB() {
    }

    protected boolean readLib() {
        try {
            if (this.readTheLibrary()) {
                return true;
            }
            this.nodeProtoCount = this.allCells.size();
            this.nodeProtoList = new Cell[this.nodeProtoCount];
            this.cellLambda = new double[this.nodeProtoCount];
            int i = 0;
            Iterator it = this.allCells.keySet().iterator();
            while (it.hasNext()) {
                this.nodeProtoList[i++] = (Cell)it.next();
            }
            return false;
        }
        catch (IOException e) {
            Input.errorLogger.logError("End of file reached while reading " + this.filePath, null, -1);
            return true;
        }
    }

    private boolean readTheLibrary() throws IOException {
        Cell firstCell;
        String line;
        this.lib.erase();
        this.curLibName = null;
        this.version = null;
        this.revision = revisions.length;
        String curExternalLibName = "";
        String curExternalCellName = "";
        Technology curTech = null;
        PrimitiveNode curPrim = null;
        this.externalCells = new HashMap();
        this.externalExports = new HashMap();
        ArrayList<Cell[]> groupLines = new ArrayList<Cell[]>();
        while ((line = this.lineReader.readLine()) != null) {
            List pieces;
            char first;
            if (line.length() == 0 || (first = line.charAt(0)) == '#') continue;
            if (first == 'C') {
                String nextLine;
                int numPieces;
                pieces = this.parseLine(line);
                int n = numPieces = this.revision >= 1 ? 5 : 7;
                if (pieces.size() < numPieces) {
                    Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Cell declaration needs " + numPieces + " fields: " + line, null, -1);
                    continue;
                }
                String name = this.revision >= 1 ? this.unQuote((String)pieces.get(0)) : this.unQuote((String)pieces.get(0)) + ";" + pieces.get(2) + "{" + pieces.get(1) + "}";
                Cell newCell = Cell.newInstance(this.lib, name);
                if (newCell == null) {
                    Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Unable to create cell " + name, null, -1);
                    continue;
                }
                Technology tech = Technology.findTechnology(this.unQuote((String)pieces.get(numPieces - 4)));
                newCell.setTechnology(tech);
                long cDate = Long.parseLong((String)pieces.get(numPieces - 3));
                long rDate = Long.parseLong((String)pieces.get(numPieces - 2));
                newCell.lowLevelSetCreationDate(new Date(cDate));
                newCell.lowLevelSetRevisionDate(new Date(rDate));
                String stateInfo = (String)pieces.get(numPieces - 1);
                boolean expanded = false;
                boolean allLocked = false;
                boolean instLocked = false;
                boolean cellLib = false;
                boolean techLib = false;
                for (int i = 0; i < stateInfo.length(); ++i) {
                    char chr = stateInfo.charAt(i);
                    if (chr == 'E') {
                        expanded = true;
                        continue;
                    }
                    if (chr == 'L') {
                        allLocked = true;
                        continue;
                    }
                    if (chr == 'I') {
                        instLocked = true;
                        continue;
                    }
                    if (chr == 'C') {
                        cellLib = true;
                        continue;
                    }
                    if (chr != 'T') continue;
                    techLib = true;
                }
                if (expanded) {
                    newCell.setWantExpanded();
                } else {
                    newCell.clearWantExpanded();
                }
                if (allLocked) {
                    newCell.setAllLocked();
                } else {
                    newCell.clearAllLocked();
                }
                if (instLocked) {
                    newCell.setInstancesLocked();
                } else {
                    newCell.clearInstancesLocked();
                }
                if (cellLib) {
                    newCell.setInCellLibrary();
                } else {
                    newCell.clearInCellLibrary();
                }
                if (techLib) {
                    newCell.setInTechnologyLibrary();
                } else {
                    newCell.clearInTechnologyLibrary();
                }
                ImmutableVariable[] vars = this.readVariables(pieces, numPieces, this.filePath, this.lineReader.getLineNumber());
                this.realizeVariables(newCell, vars);
                CellContents cc = new CellContents();
                cc.fileName = this.filePath;
                cc.lineNumber = this.lineReader.getLineNumber() + 1;
                while ((nextLine = this.lineReader.readLine()) != null) {
                    char nextFirst;
                    if (nextLine.length() == 0 || (nextFirst = nextLine.charAt(0)) == '#') continue;
                    if (nextFirst == 'X') break;
                    cc.cellStrings.add(nextLine);
                }
                this.allCells.put(newCell, cc);
                continue;
            }
            if (first == 'L') {
                pieces = this.parseLine(line);
                if (pieces.size() != 2) {
                    Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", External library declaration needs 2 fields: " + line, null, -1);
                    continue;
                }
                curExternalLibName = this.unQuote((String)pieces.get(0));
                if (Library.findLibrary(curExternalLibName) != null) continue;
                this.readExternalLibraryFromFilename(this.unQuote((String)pieces.get(1)), FileType.JELIB);
                continue;
            }
            if (first == 'R') {
                pieces = this.parseLine(line);
                if (pieces.size() != 5 && pieces.size() != 7) {
                    Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", External cell declaration needs 5 or 7 fields: " + line, null, -1);
                    continue;
                }
                double lowX = TextUtils.atof((String)pieces.get(1));
                double highX = TextUtils.atof((String)pieces.get(2));
                double lowY = TextUtils.atof((String)pieces.get(3));
                double highY = TextUtils.atof((String)pieces.get(4));
                if (pieces.size() > 5) {
                    long cDate = Long.parseLong((String)pieces.get(5));
                    long rDate = Long.parseLong((String)pieces.get(6));
                }
                Rectangle2D.Double bounds = new Rectangle2D.Double(lowX, lowY, highX - lowX, highY - lowY);
                curExternalCellName = curExternalLibName + ":" + this.unQuote((String)pieces.get(0));
                this.externalCells.put(curExternalCellName, bounds);
                continue;
            }
            if (first == 'F') {
                pieces = this.parseLine(line);
                if (pieces.size() != 3) {
                    Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", External export declaration needs 3 fields: " + line, null, -1);
                    continue;
                }
                String exportName = this.unQuote((String)pieces.get(0));
                double posX = TextUtils.atof((String)pieces.get(1));
                double posY = TextUtils.atof((String)pieces.get(1));
                this.externalExports.put(curExternalCellName + ":" + exportName, new Point2D.Double(posX, posY));
                continue;
            }
            if (first == 'H') {
                pieces = this.parseLine(line);
                if (pieces.size() < 2) {
                    Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Library declaration needs 2 fields: " + line, null, -1);
                    continue;
                }
                this.version = Version.parseVersion((String)pieces.get(1));
                if (this.version == null) {
                    Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Badly formed version: " + pieces.get(1), null, -1);
                    continue;
                }
                this.revision = 0;
                while (this.revision < revisions.length && this.version.compareTo(Version.parseVersion(revisions[this.revision])) >= 0) {
                    ++this.revision;
                }
                if (this.revision < 1) {
                    this.escapeChar = (char)94;
                    pieces = this.parseLine(line);
                }
                this.curLibName = this.unQuote((String)pieces.get(0));
                if (this.version.compareTo(Version.getVersion()) > 0) {
                    Input.errorLogger.logWarning(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Library " + this.curLibName + " comes from a NEWER version of Electric (" + this.version + ")", null, -1);
                }
                ImmutableVariable[] vars = this.readVariables(pieces, 2, this.filePath, this.lineReader.getLineNumber());
                this.realizeVariables(this.lib, vars);
                this.lib.setVersion(this.version);
                continue;
            }
            if (first == 'O') {
                pieces = this.parseLine(line);
                String toolName = this.unQuote((String)pieces.get(0));
                Tool tool = Tool.findTool(toolName);
                if (tool == null) {
                    Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Cannot identify tool " + toolName, null, -1);
                    continue;
                }
                ImmutableVariable[] vars = this.readVariables(pieces, 1, this.filePath, this.lineReader.getLineNumber());
                if (!this.topLevelLibrary) continue;
                this.realizeMeaningPrefs(tool, vars);
                continue;
            }
            if (first == 'V') {
                String viewAbbr;
                pieces = this.parseLine(line);
                String viewName = this.unQuote((String)pieces.get(0));
                View view = View.findView(viewName);
                if (view != null || (view = View.newInstance(viewName, viewAbbr = this.unQuote((String)pieces.get(1)))) != null) continue;
                Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Cannot create view " + viewName, null, -1);
                continue;
            }
            if (first == 'T') {
                pieces = this.parseLine(line);
                String techName = this.unQuote((String)pieces.get(0));
                curTech = Technology.findTechnology(techName);
                if (curTech == null) {
                    Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Cannot identify technology " + techName, null, -1);
                    continue;
                }
                curPrim = null;
                ImmutableVariable[] vars = this.readVariables(pieces, 1, this.filePath, this.lineReader.getLineNumber());
                if (!this.topLevelLibrary) continue;
                this.realizeMeaningPrefs(curTech, vars);
                continue;
            }
            if (first == 'D') {
                pieces = this.parseLine(line);
                String primName = this.unQuote((String)pieces.get(0));
                if (curTech == null) {
                    Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Primitive node " + primName + " has no technology before it", null, -1);
                    continue;
                }
                curPrim = this.findPrimitiveNode(curTech, primName);
                if (curPrim != null) continue;
                Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Cannot identify primitive node " + primName, null, -1);
                continue;
            }
            if (first == 'P') {
                pieces = this.parseLine(line);
                String primPortName = this.unQuote((String)pieces.get(0));
                if (curPrim == null) {
                    Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Primitive port " + primPortName + " has no primitive node before it", null, -1);
                    continue;
                }
                PrimitivePort pp = (PrimitivePort)curPrim.findPortProto(primPortName);
                if (pp == null) {
                    pp = curTech.convertOldPortName(primPortName, curPrim);
                }
                if (pp != null) continue;
                Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Cannot identify primitive port " + primPortName, null, -1);
                continue;
            }
            if (first == 'W') {
                pieces = this.parseLine(line);
                String arcName = this.unQuote((String)pieces.get(0));
                if (curTech == null) {
                    Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Primitive arc " + arcName + " has no technology before it", null, -1);
                    continue;
                }
                ArcProto ap = curTech.findArcProto(arcName);
                if (ap != null) continue;
                Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Cannot identify primitive arc " + arcName, null, -1);
                continue;
            }
            if (first == 'G') {
                pieces = this.parseLine(line);
                Cell[] groupLine = new Cell[pieces.size()];
                firstCell = null;
                for (int i = 0; i < pieces.size(); ++i) {
                    Cell cell;
                    String cellName = this.unQuote((String)pieces.get(i));
                    if (cellName.length() == 0) continue;
                    int colonPos = cellName.indexOf(58);
                    if (colonPos >= 0) {
                        cellName = cellName.substring(colonPos + 1);
                    }
                    if ((cell = this.lib.findNodeProto(cellName)) == null) {
                        Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Cannot find cell " + cellName, null, -1);
                        break;
                    }
                    groupLine[i] = cell;
                }
                groupLines.add(groupLine);
                continue;
            }
            Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Unrecognized line: " + line, null, -1);
        }
        TransitiveRelation transitive = new TransitiveRelation();
        HashMap<String, String> protoNames = new HashMap<String, String>();
        Iterator cit = this.lib.getCells();
        while (cit.hasNext()) {
            Cell cell = (Cell)cit.next();
            String protoName = (String)protoNames.get(cell.getName());
            if (protoName == null) {
                protoName = cell.getName();
                protoNames.put(protoName, protoName);
            }
            transitive.theseAreRelated(cell, protoName);
        }
        Iterator git = groupLines.iterator();
        while (git.hasNext()) {
            Cell[] groupLine = (Cell[])git.next();
            firstCell = null;
            for (int i = 0; i < groupLine.length; ++i) {
                if (groupLine[i] == null) continue;
                if (firstCell == null) {
                    firstCell = groupLine[i];
                    continue;
                }
                transitive.theseAreRelated(firstCell, groupLine[i]);
            }
        }
        git = transitive.getSetsOfRelatives();
        while (git.hasNext()) {
            Set group = (Set)git.next();
            firstCell = null;
            Iterator it = group.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof Cell)) continue;
                Cell cell = (Cell)o;
                if (firstCell == null) {
                    firstCell = cell;
                    continue;
                }
                cell.joinGroup(firstCell);
            }
        }
        git = groupLines.iterator();
        while (git.hasNext()) {
            Cell[] groupLine = (Cell[])git.next();
            firstCell = groupLine[0];
            if (firstCell == null || !firstCell.isSchematic() || firstCell.getNewestVersion() != firstCell) continue;
            firstCell.getCellGroup().setMainSchematics(firstCell);
        }
        HashMap<String, Cell.CellGroup> cellGroups = new HashMap<String, Cell.CellGroup>();
        Iterator it = this.lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            String canonicName = TextUtils.canonicString(cell.getName());
            Cell.CellGroup group = cell.getCellGroup();
            Cell.CellGroup groupOfName = (Cell.CellGroup)cellGroups.get(canonicName);
            if (groupOfName == null) {
                cellGroups.put(canonicName, group);
                continue;
            }
            if (groupOfName == group) continue;
            Input.errorLogger.logError(this.filePath + ", Library has multiple cells named '" + canonicName + "' that are not in the same group", null, -1);
        }
        this.lib.clearChanged();
        this.lib.setFromDisk();
        return false;
    }

    protected void realizeCellsRecursively(Cell cell, HashSet recursiveSetupFlag, String scaledCellName, double scale) {
        if (scaledCellName != null) {
            return;
        }
        CellContents cc = (CellContents)this.allCells.get(cell);
        if (cc == null || cc.filledIn) {
            return;
        }
        this.instantiateCellContent(cell, cc, recursiveSetupFlag);
        progress.setProgress(++cellsConstructed * 100 / totalCells);
        recursiveSetupFlag.add(cell);
        cell.loadExpandStatus();
    }

    private void instantiateCellContent(Cell cell, CellContents cc, HashSet recursiveSetupFlag) {
        String cellString;
        int line;
        int numStrings = cc.cellStrings.size();
        HashMap<String, NodeInst> diskName = new HashMap<String, NodeInst>();
        for (line = 0; line < numStrings; ++line) {
            String stateInfo;
            String orientString;
            Cell subCell;
            int lastQuote;
            int numPieces;
            cellString = (String)cc.cellStrings.get(line);
            char firstChar = cellString.charAt(0);
            if (firstChar != 'N' && firstChar != 'I') continue;
            List pieces = this.parseLine(cellString);
            int n = this.revision < 1 ? 10 : (numPieces = firstChar == 'N' ? 9 : 8);
            if (pieces.size() < numPieces) {
                String lineNumber = "";
                if (this.lineReader != null) {
                    lineNumber = ", line " + this.lineReader.getLineNumber();
                }
                Input.errorLogger.logError(cc.fileName + lineNumber + ", Node instance needs " + numPieces + " fields: " + cellString, cell, -1);
                continue;
            }
            String protoName = this.unQuote((String)pieces.get(0));
            String diskNodeName = this.revision >= 1 ? (String)pieces.get(1) : this.unQuote((String)pieces.get(1));
            int duplicate = 0;
            String nodeName = diskNodeName;
            if (nodeName.charAt(0) == '\"' && (lastQuote = nodeName.lastIndexOf(34)) > 1) {
                nodeName = nodeName.substring(1, lastQuote);
                if (this.revision >= 1) {
                    nodeName = this.unQuote(nodeName);
                }
                duplicate = TextUtils.atoi(nodeName, lastQuote + 1);
            }
            String nameTextDescriptorInfo = (String)pieces.get(2);
            double x = TextUtils.atof((String)pieces.get(3));
            double y = TextUtils.atof((String)pieces.get(4));
            String prefixName = this.lib.getName();
            Comparable np = null;
            Library cellLib = this.lib;
            int colonPos = protoName.indexOf(58);
            if (colonPos < 0) {
                if (firstChar == 'I' || this.revision < 1) {
                    np = this.lib.findNodeProto(protoName);
                } else if (cell.getTechnology() != null) {
                    np = this.findPrimitiveNode(cell.getTechnology(), protoName);
                }
            } else {
                Technology tech;
                prefixName = protoName.substring(0, colonPos);
                protoName = protoName.substring(colonPos + 1);
                if (firstChar == 'N' && (tech = Technology.findTechnology(prefixName)) != null) {
                    np = this.findPrimitiveNode(tech, protoName);
                }
                if (firstChar == 'I' || this.revision < 1 && np == null) {
                    if (prefixName.equalsIgnoreCase(this.curLibName)) {
                        np = this.lib.findNodeProto(protoName);
                    } else {
                        cellLib = Library.findLibrary(prefixName);
                        if (cellLib != null) {
                            np = cellLib.findNodeProto(protoName);
                        }
                    }
                }
            }
            if (np != null && np instanceof Cell && !recursiveSetupFlag.contains(subCell = np)) {
                LibraryFiles reader = this;
                if (subCell.getLibrary() != cell.getLibrary()) {
                    reader = this.getReaderForLib(subCell.getLibrary());
                }
                if (reader != null) {
                    ((LibraryFiles)reader).realizeCellsRecursively(subCell, recursiveSetupFlag, null, 0.0);
                }
            }
            double wid = 0.0;
            double hei = 0.0;
            boolean flipX = false;
            boolean flipY = false;
            String textDescriptorInfo = "";
            if (firstChar == 'N' || this.revision < 1) {
                wid = TextUtils.atof((String)pieces.get(5));
                if (wid < 0.0 || wid == 0.0 && 1.0 / wid < 0.0) {
                    if (this.revision >= 1) {
                        Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + ", Negative width " + (String)pieces.get(5) + " of cell instance", cell, -1);
                    }
                    flipX = true;
                    wid = -wid;
                }
                if ((hei = TextUtils.atof((String)pieces.get(6))) < 0.0 || hei == 0.0 && 1.0 / hei < 0.0) {
                    if (this.revision >= 1) {
                        Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + ", Negative height " + (String)pieces.get(5) + " of cell instance", cell, -1);
                    }
                    flipY = true;
                    hei = -hei;
                }
                orientString = (String)pieces.get(7);
                stateInfo = (String)pieces.get(8);
                if (this.revision < 1) {
                    textDescriptorInfo = (String)pieces.get(9);
                }
            } else {
                if (np != null) {
                    Rectangle2D bounds = ((Cell)np).getBounds();
                    wid = bounds.getWidth();
                    hei = bounds.getHeight();
                }
                orientString = (String)pieces.get(5);
                stateInfo = (String)pieces.get(6);
                textDescriptorInfo = (String)pieces.get(7);
            }
            int angle = 0;
            for (int i = 0; i < orientString.length(); ++i) {
                char ch = orientString.charAt(i);
                if (ch == 'X') {
                    flipX = !flipX;
                    continue;
                }
                if (ch == 'Y') {
                    flipY = !flipY;
                    continue;
                }
                if (ch == 'R') {
                    angle += 900;
                    continue;
                }
                angle += TextUtils.atoi(orientString.substring(i));
                break;
            }
            if (np == null) {
                Cell dummyCell;
                if (cellLib == null) {
                    Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + ", Creating dummy library " + prefixName, cell, -1);
                    cellLib = Library.newInstance(prefixName, null);
                }
                if ((dummyCell = Cell.makeInstance(cellLib, protoName)) == null) {
                    Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + ", Unable to create dummy cell " + protoName + " in " + cellLib, cell, -1);
                    continue;
                }
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + ", Creating dummy cell " + protoName + " in " + cellLib, cell, -1);
                Rectangle2D bounds = (Rectangle2D)this.externalCells.get(pieces.get(0));
                if (bounds == null) {
                    Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + ", Warning: cannot find information about external cell " + pieces.get(0), cell, -1);
                    NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(0.0, 0.0), wid, hei, dummyCell);
                } else {
                    NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), dummyCell);
                }
                dummyCell.newVar(IO_TRUE_LIBRARY, (Object)prefixName);
                dummyCell.newVar(IO_DUMMY_OBJECT, (Object)protoName);
                np = dummyCell;
            }
            ImmutableTextDescriptor nameTextDescriptor = this.loadTextDescriptor(nameTextDescriptorInfo, false, cc.fileName, cc.lineNumber + line);
            int flags = 0;
            int techBits = 0;
            block30: for (int i = 0; i < stateInfo.length(); ++i) {
                char chr = stateInfo.charAt(i);
                switch (chr) {
                    case 'E': {
                        continue block30;
                    }
                    case 'L': {
                        flags = ImmutableNodeInst.LOCKED.set(flags, true);
                        continue block30;
                    }
                    case 'S': {
                        continue block30;
                    }
                    case 'V': {
                        flags = ImmutableNodeInst.VIS_INSIDE.set(flags, true);
                        continue block30;
                    }
                    case 'W': {
                        continue block30;
                    }
                    case 'A': {
                        flags = ImmutableNodeInst.HARD_SELECT.set(flags, true);
                        continue block30;
                    }
                    default: {
                        if (!Character.isDigit(chr)) continue block30;
                        stateInfo = stateInfo.substring(i);
                        try {
                            techBits = Integer.parseInt(stateInfo);
                        }
                        catch (NumberFormatException e) {
                            Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + " (" + cell + ") bad node bits" + stateInfo, cell, -1);
                        }
                        break block30;
                    }
                }
            }
            ImmutableTextDescriptor protoTextDescriptor = this.loadTextDescriptor(textDescriptorInfo, false, cc.fileName, cc.lineNumber + line);
            Orientation orient = Orientation.fromJava(angle, flipX, flipY);
            NodeInst ni = NodeInst.newInstance(cell, (NodeProto)((Object)np), nodeName, duplicate, nameTextDescriptor, new EPoint(x, y), wid, hei, orient, flags, techBits, protoTextDescriptor);
            if (ni == null) {
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + " (" + cell + ") cannot create node " + protoName, cell, -1);
                continue;
            }
            diskName.put(diskNodeName, ni);
            ImmutableVariable[] vars = this.readVariables(pieces, numPieces, cc.fileName, cc.lineNumber + line);
            this.realizeVariables(ni, vars);
        }
        for (line = 0; line < numStrings; ++line) {
            int userBits;
            PortInst pi;
            int numPieces;
            cellString = (String)cc.cellStrings.get(line);
            if (cellString.charAt(0) != 'E') continue;
            List pieces = this.parseLine(cellString);
            int n = numPieces = this.revision >= 1 ? 5 : 7;
            if (pieces.size() < numPieces) {
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + ", Export needs " + numPieces + " fields, has " + pieces.size() + ": " + cellString, cell, -1);
                continue;
            }
            String exportName = this.unQuote((String)pieces.get(0));
            String nodeName = this.revision >= 1 ? (String)pieces.get(2) : this.unQuote((String)pieces.get(2));
            String portName = this.unQuote((String)pieces.get(3));
            Point2D.Double pos = null;
            if (this.revision < 1) {
                double x = TextUtils.atof((String)pieces.get(4));
                double y = TextUtils.atof((String)pieces.get(5));
                pos = new Point2D.Double(x, y);
            }
            if ((pi = this.figureOutPortInst(cell, portName, nodeName, pos, diskName, cc.fileName, cc.lineNumber + line)) == null) continue;
            String textDescriptorInfo = (String)pieces.get(1);
            ImmutableTextDescriptor nameTextDescriptor = this.loadTextDescriptor(textDescriptorInfo, false, cc.fileName, cc.lineNumber + line);
            Export pp = Export.newInstance(cell, exportName, nameTextDescriptor, pi, userBits = Export.parseJelibUserBits((String)pieces.get(numPieces - 1)));
            if (pp == null) {
                ErrorLogger.MessageLog log = Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + " (" + cell + ") cannot create export " + exportName, cell, -1);
                log.addGeom(pi.getNodeInst(), true, cell, null);
                continue;
            }
            ImmutableVariable[] vars = this.readVariables(pieces, numPieces, cc.fileName, cc.lineNumber + line);
            this.realizeVariables(pp, vars);
        }
        for (line = 0; line < numStrings; ++line) {
            double tailY;
            double tailX;
            double headY;
            double headX;
            int lastQuote;
            cellString = (String)cc.cellStrings.get(line);
            if (cellString.charAt(0) != 'A') continue;
            List pieces = this.parseLine(cellString);
            if (pieces.size() < 13) {
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + ", Arc instance needs 13 fields: " + cellString, cell, -1);
                continue;
            }
            String protoName = this.unQuote((String)pieces.get(0));
            ArcProto ap = null;
            if (protoName.indexOf(58) >= 0) {
                ap = ArcProto.findArcProto(protoName);
            } else if (cell.getTechnology() != null) {
                ap = cell.getTechnology().findArcProto(protoName);
            }
            if (ap == null) {
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + " (" + cell + ") cannot find arc " + protoName, cell, -1);
                continue;
            }
            String diskArcName = this.revision >= 1 ? (String)pieces.get(1) : this.unQuote((String)pieces.get(1));
            String arcName = diskArcName;
            if (arcName.charAt(0) == '\"' && (lastQuote = arcName.lastIndexOf(34)) > 1) {
                arcName = arcName.substring(1, lastQuote);
                if (this.revision >= 1) {
                    arcName = this.unQuote(arcName);
                }
            }
            double wid = TextUtils.atof((String)pieces.get(3));
            String headNodeName = this.revision >= 1 ? (String)pieces.get(5) : this.unQuote((String)pieces.get(5));
            String headPortName = this.unQuote((String)pieces.get(6));
            PortInst headPI = this.figureOutPortInst(cell, headPortName, headNodeName, new Point2D.Double(headX = TextUtils.atof((String)pieces.get(7)), headY = TextUtils.atof((String)pieces.get(8))), diskName, cc.fileName, cc.lineNumber + line);
            if (headPI == null) continue;
            String tailNodeName = this.revision >= 1 ? (String)pieces.get(9) : this.unQuote((String)pieces.get(9));
            String tailPortName = this.unQuote((String)pieces.get(10));
            PortInst tailPI = this.figureOutPortInst(cell, tailPortName, tailNodeName, new Point2D.Double(tailX = TextUtils.atof((String)pieces.get(11)), tailY = TextUtils.atof((String)pieces.get(12))), diskName, cc.fileName, cc.lineNumber + line);
            if (tailPI == null) continue;
            String stateInfo = (String)pieces.get(4);
            boolean extended = true;
            boolean directional = false;
            boolean reverseEnds = false;
            boolean skipHead = false;
            boolean skipTail = false;
            boolean tailNotExtended = false;
            boolean headNotExtended = false;
            boolean tailArrowed = false;
            boolean headArrowed = false;
            boolean bodyArrowed = false;
            int flags = defaultArcFlags;
            int angle = 0;
            block33: for (int i = 0; i < stateInfo.length(); ++i) {
                char chr = stateInfo.charAt(i);
                switch (chr) {
                    case 'R': {
                        flags = ImmutableArcInst.RIGID.set(flags, true);
                        continue block33;
                    }
                    case 'F': {
                        flags = ImmutableArcInst.FIXED_ANGLE.set(flags, false);
                        continue block33;
                    }
                    case 'S': {
                        flags = ImmutableArcInst.SLIDABLE.set(flags, true);
                        continue block33;
                    }
                    case 'A': {
                        flags = ImmutableArcInst.HARD_SELECT.set(flags, true);
                        continue block33;
                    }
                    case 'N': {
                        flags = ImmutableArcInst.TAIL_NEGATED.set(flags, true);
                        continue block33;
                    }
                    case 'G': {
                        flags = ImmutableArcInst.HEAD_NEGATED.set(flags, true);
                        continue block33;
                    }
                    case 'X': {
                        headArrowed = true;
                        continue block33;
                    }
                    case 'Y': {
                        tailArrowed = true;
                        continue block33;
                    }
                    case 'B': {
                        bodyArrowed = true;
                        continue block33;
                    }
                    case 'I': {
                        headNotExtended = true;
                        continue block33;
                    }
                    case 'J': {
                        tailNotExtended = true;
                        continue block33;
                    }
                    case 'E': {
                        extended = false;
                        continue block33;
                    }
                    case 'D': {
                        directional = true;
                        continue block33;
                    }
                    case 'V': {
                        reverseEnds = true;
                        continue block33;
                    }
                    case 'H': {
                        skipHead = true;
                        continue block33;
                    }
                    case 'T': {
                        skipTail = true;
                        continue block33;
                    }
                    default: {
                        if (!TextUtils.isDigit(chr)) continue block33;
                        angle = TextUtils.atoi(stateInfo.substring(i));
                        break block33;
                    }
                }
            }
            if (!extended || directional) {
                if (!extended) {
                    tailNotExtended = true;
                    headNotExtended = true;
                }
                if (directional) {
                    if (reverseEnds) {
                        tailArrowed = true;
                    } else {
                        headArrowed = true;
                    }
                    bodyArrowed = true;
                }
                if (skipHead) {
                    headNotExtended = false;
                    headArrowed = false;
                }
                if (skipTail) {
                    tailNotExtended = false;
                    tailArrowed = false;
                }
            }
            flags = ImmutableArcInst.HEAD_EXTENDED.set(flags, !headNotExtended);
            flags = ImmutableArcInst.TAIL_EXTENDED.set(flags, !tailNotExtended);
            flags = ImmutableArcInst.HEAD_ARROWED.set(flags, headArrowed);
            flags = ImmutableArcInst.TAIL_ARROWED.set(flags, tailArrowed);
            flags = ImmutableArcInst.BODY_ARROWED.set(flags, bodyArrowed);
            String nameTextDescriptorInfo = (String)pieces.get(2);
            ImmutableTextDescriptor nameTextDescriptor = this.loadTextDescriptor(nameTextDescriptorInfo, false, cc.fileName, cc.lineNumber + line);
            ArcInst ai = ArcInst.newInstance(cell, ap, arcName, -1, nameTextDescriptor, headPI, tailPI, new EPoint(headX, headY), new EPoint(tailX, tailY), wid, angle, flags);
            if (ai == null) {
                ErrorLogger.MessageLog log = Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + " (" + cell + ") cannot create arc " + protoName, cell, -1);
                log.addGeom(headPI.getNodeInst(), true, cell, null);
                log.addGeom(tailPI.getNodeInst(), true, cell, null);
                continue;
            }
            ImmutableVariable[] vars = this.readVariables(pieces, 13, cc.fileName, cc.lineNumber + line);
            this.realizeVariables(ai, vars);
        }
        cc.filledIn = true;
        cc.cellStrings = null;
    }

    private PortInst figureOutPortInst(Cell cell, String portName, String nodeName, Point2D pos, HashMap diskName, String fileName, int lineNumber) {
        NodeInst portNI;
        Poly poly;
        NodeInst ni = (NodeInst)diskName.get(nodeName);
        if (ni == null) {
            Input.errorLogger.logError(fileName + ", line " + lineNumber + " (" + cell + ") cannot find node " + nodeName, cell, -1);
            return null;
        }
        PortInst pi = null;
        if (portName.length() == 0) {
            if (ni.getNumPortInsts() > 0) {
                pi = ni.getPortInst(0);
            }
        } else {
            PrimitiveNode primNode;
            PrimitivePort primPort;
            pi = ni.findPortInst(portName);
            if (pi == null && ni.getProto() instanceof PrimitiveNode && (primPort = (primNode = (PrimitiveNode)ni.getProto()).getTechnology().convertOldPortName(portName, primNode)) != null) {
                pi = ni.findPortInstFromProto(primPort);
            }
        }
        if (pi != null && pos != null && !(poly = pi.getPoly()).isInside(pos) && !(poly.polyDistance(pos.getX(), pos.getY()) < TINYDISTANCE)) {
            NodeProto np = ni.getProto();
            ErrorLogger.MessageLog log = Input.errorLogger.logError(fileName + ", line " + lineNumber + " (" + cell + ") point (" + pos.getX() + "," + pos.getY() + ") does not fit in " + pi + " which is centered at (" + poly.getCenterX() + "," + poly.getCenterY() + ")", cell, -1);
            log.addPoint(pos.getX(), pos.getY(), cell);
            if (np instanceof Cell) {
                pi = null;
            }
        }
        if (pi != null) {
            return pi;
        }
        Cell subCell = (Cell)ni.getProto();
        Variable var = subCell.getVar(IO_TRUE_LIBRARY);
        if (var == null) {
            NodeInst portNI2 = null;
            if (pos != null) {
                portNI2 = NodeInst.newInstance(Generic.tech.universalPinNode, pos, 0.0, 0.0, cell);
            }
            if (portNI2 == null) {
                Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unable to create dummy node in " + cell + " (cannot create source node)", cell, -1);
                return null;
            }
            ErrorLogger.MessageLog log = Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Arc end and port discrepancy at (" + pos.getX() + "," + pos.getY() + "), port " + portName + " on node " + nodeName + " in " + cell, cell, -1);
            log.addGeom(portNI2, true, cell, null);
            return portNI2.getOnlyPortInst();
        }
        if (pos == null && (pos = (Point2D)this.externalExports.get(subCell.getCellName().toString() + ":" + portName)) == null) {
            return null;
        }
        String name = portName;
        if (name.length() == 0) {
            name = "X";
        }
        if ((portNI = NodeInst.newInstance(Generic.tech.universalPinNode, pos, 0.0, 0.0, subCell)) == null) {
            Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unable to create export " + name + " on dummy " + subCell + " (cannot create source node)", cell, -1);
            return null;
        }
        PortInst portPI = portNI.getOnlyPortInst();
        Export pp = Export.newInstance(subCell, portPI, name, false);
        if (pp == null) {
            Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unable to create export " + name + " on dummy " + subCell, cell, -1);
            return null;
        }
        pi = ni.findPortInstFromProto(pp);
        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Creating export " + name + " on dummy " + subCell, cell, -1);
        return pi;
    }

    private List parseLine(String line) {
        ArrayList<String> stringPieces = new ArrayList<String>();
        int len = line.length();
        int pos = 1;
        int startPos = 1;
        boolean inQuote = false;
        while (pos < len) {
            char chr;
            if ((chr = line.charAt(pos++)) == this.escapeChar) {
                ++pos;
                continue;
            }
            if (chr == '\"') {
                boolean bl = inQuote = !inQuote;
            }
            if (chr != '|' || inQuote) continue;
            stringPieces.add(line.substring(startPos, pos - 1));
            startPos = pos;
        }
        if (pos > len) {
            pos = len;
        }
        stringPieces.add(line.substring(startPos, pos));
        return stringPieces;
    }

    private String unQuote(String line) {
        int len = line.length();
        if (this.revision >= 1) {
            if (len < 2 || line.charAt(0) != '\"') {
                return line;
            }
            int lastQuote = line.lastIndexOf(34);
            if (lastQuote != len - 1) {
                return this.unQuote(line.substring(0, lastQuote + 1)) + line.substring(lastQuote + 1);
            }
            line = line.substring(1, len - 1);
            len -= 2;
        } else if (line.indexOf(this.escapeChar) < 0) {
            return line;
        }
        StringBuffer sb = new StringBuffer();
        if (!$assertionsDisabled && len != line.length()) {
            throw new AssertionError();
        }
        for (int i = 0; i < len; ++i) {
            char chr = line.charAt(i);
            if (chr == this.escapeChar) {
                if (++i >= len) break;
                chr = line.charAt(i);
                if (chr == 'n' && this.revision >= 1) {
                    chr = '\n';
                }
                if (chr == 'r' && this.revision >= 1) {
                    chr = '\r';
                }
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    private ImmutableVariable[] readVariables(List pieces, int position, String fileName, int lineNumber) {
        this.variablesBuf.clear();
        int total = pieces.size();
        block21: for (int i = position; i < total; ++i) {
            int openPos;
            String piece = (String)pieces.get(i);
            boolean inQuote = false;
            for (openPos = 0; openPos < piece.length(); ++openPos) {
                char chr = piece.charAt(openPos);
                if (chr == this.escapeChar) {
                    ++openPos;
                    continue;
                }
                if (chr == '\"') {
                    boolean bl = inQuote = !inQuote;
                }
                if (chr == '(' && !inQuote) break;
            }
            if (openPos >= piece.length()) {
                Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed variable (no open parenthesis): " + piece, null, -1);
                continue;
            }
            String varName = this.unQuote(piece.substring(0, openPos));
            Variable.Key varKey = Variable.newKey(varName);
            int closePos = piece.indexOf(41, openPos);
            if (closePos < 0) {
                Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed variable (no close parenthesis): " + piece, null, -1);
                continue;
            }
            String varBits = piece.substring(openPos + 1, closePos);
            int objectPos = closePos + 1;
            if (objectPos >= piece.length()) {
                Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Variable type missing: " + piece, null, -1);
                continue;
            }
            char varType = piece.charAt(objectPos++);
            switch (varType) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'L': 
                case 'O': 
                case 'P': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'V': 
                case 'Y': {
                    break;
                }
                default: {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Variable type invalid: " + piece, null, -1);
                    continue block21;
                }
            }
            Object[] obj = null;
            if (objectPos >= piece.length()) {
                if (varType != 'X') {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Variable value missing: " + piece, null, -1);
                    continue;
                }
            } else if (piece.charAt(objectPos) == '[') {
                ArrayList<Object> objList = new ArrayList<Object>();
                ++objectPos;
                while (objectPos < piece.length()) {
                    int start = objectPos;
                    inQuote = false;
                    while (objectPos < piece.length()) {
                        if (inQuote) {
                            if (piece.charAt(objectPos) == this.escapeChar) {
                                ++objectPos;
                            } else if (piece.charAt(objectPos) == '\"') {
                                inQuote = false;
                            }
                            ++objectPos;
                            continue;
                        }
                        if (piece.charAt(objectPos) == ',' || piece.charAt(objectPos) == ']') break;
                        if (piece.charAt(objectPos) == '\"') {
                            inQuote = true;
                        }
                        ++objectPos;
                    }
                    Object oneObj = this.getVariableValue(piece.substring(start, objectPos), varType, fileName, lineNumber);
                    objList.add(oneObj);
                    if (piece.charAt(objectPos) == ']') break;
                    ++objectPos;
                }
                if (objectPos >= piece.length()) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed array (no closed bracket): " + piece, null, -1);
                    continue;
                }
                if (objectPos < piece.length() - 1) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed array (extra characters after closed bracket): " + piece, null, -1);
                    continue;
                }
                int limit = objList.size();
                Object[] objArray = null;
                switch (varType) {
                    case 'B': {
                        objArray = new Boolean[limit];
                        break;
                    }
                    case 'C': {
                        objArray = new CellId[limit];
                        break;
                    }
                    case 'D': {
                        objArray = new Double[limit];
                        break;
                    }
                    case 'E': {
                        objArray = new ExportId[limit];
                        break;
                    }
                    case 'F': {
                        objArray = new Float[limit];
                        break;
                    }
                    case 'G': {
                        objArray = new Long[limit];
                        break;
                    }
                    case 'H': {
                        objArray = new Short[limit];
                        break;
                    }
                    case 'I': {
                        objArray = new Integer[limit];
                        break;
                    }
                    case 'L': {
                        objArray = new LibId[limit];
                        break;
                    }
                    case 'O': {
                        objArray = new Tool[limit];
                        break;
                    }
                    case 'P': {
                        objArray = new PrimitiveNode[limit];
                        break;
                    }
                    case 'R': {
                        objArray = new ArcProto[limit];
                        break;
                    }
                    case 'S': {
                        objArray = new String[limit];
                        break;
                    }
                    case 'T': {
                        objArray = new Technology[limit];
                        break;
                    }
                    case 'V': {
                        objArray = new EPoint[limit];
                        break;
                    }
                    case 'Y': {
                        objArray = new Byte[limit];
                    }
                }
                if (objArray == null && limit > 0) {
                    System.out.println("HHEY, vartype=" + varType + " on line " + lineNumber);
                }
                for (int j = 0; j < limit; ++j) {
                    objArray[j] = objList.get(j);
                }
                obj = objArray;
            } else {
                obj = this.getVariableValue(piece.substring(objectPos), varType, fileName, lineNumber);
                if (obj == null) continue;
            }
            ImmutableTextDescriptor td = this.loadTextDescriptor(varBits, true, fileName, lineNumber);
            ImmutableVariable d = ImmutableVariable.newInstance(varKey, td, obj);
            this.variablesBuf.add(d);
        }
        return this.variablesBuf.toArray(ImmutableVariable.NULL_ARRAY);
    }

    private ImmutableTextDescriptor loadTextDescriptor(String varBits, boolean onVar, String fileName, int lineNumber) {
        HashMap parsedDescriptors = onVar ? this.parsedDescriptorsT : this.parsedDescriptorsF;
        ImmutableTextDescriptor td = (ImmutableTextDescriptor)parsedDescriptors.get(varBits);
        if (td != null) {
            return td;
        }
        boolean error = false;
        this.mtd.setCBits(0, 0, 0);
        if (!onVar) {
            this.mtd.setDisplay(true);
        }
        double xoff = 0.0;
        double yoff = 0.0;
        block31: for (int j = 0; j < varBits.length(); ++j) {
            char varBit = varBits.charAt(j);
            switch (varBit) {
                case 'D': {
                    this.mtd.setDisplay(true);
                    if (++j >= varBits.length()) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Incorrect display specification: " + varBits, null, -1);
                        error = true;
                        continue block31;
                    }
                    switch (varBits.charAt(j)) {
                        case '5': {
                            this.mtd.setPos(TextDescriptor.Position.CENT);
                            break;
                        }
                        case '8': {
                            this.mtd.setPos(TextDescriptor.Position.UP);
                            break;
                        }
                        case '2': {
                            this.mtd.setPos(TextDescriptor.Position.DOWN);
                            break;
                        }
                        case '4': {
                            this.mtd.setPos(TextDescriptor.Position.LEFT);
                            break;
                        }
                        case '6': {
                            this.mtd.setPos(TextDescriptor.Position.RIGHT);
                            break;
                        }
                        case '7': {
                            this.mtd.setPos(TextDescriptor.Position.UPLEFT);
                            break;
                        }
                        case '9': {
                            this.mtd.setPos(TextDescriptor.Position.UPRIGHT);
                            break;
                        }
                        case '1': {
                            this.mtd.setPos(TextDescriptor.Position.DOWNLEFT);
                            break;
                        }
                        case '3': {
                            this.mtd.setPos(TextDescriptor.Position.DOWNRIGHT);
                            break;
                        }
                        case '0': {
                            this.mtd.setPos(TextDescriptor.Position.BOXED);
                        }
                    }
                    continue block31;
                }
                case 'N': {
                    this.mtd.setDispPart(TextDescriptor.DispPos.NAMEVALUE);
                    continue block31;
                }
                case 'A': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad absolute size (semicolon missing): " + varBits, null, -1);
                        error = true;
                        continue block31;
                    }
                    this.mtd.setAbsSize(TextUtils.atoi(varBits.substring(j + 1, semiPos)));
                    j = semiPos;
                    continue block31;
                }
                case 'G': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad relative size (semicolon missing): " + varBits, null, -1);
                        error = true;
                        continue block31;
                    }
                    this.mtd.setRelSize(TextUtils.atof(varBits.substring(j + 1, semiPos)));
                    j = semiPos;
                    continue block31;
                }
                case 'X': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad X offset (semicolon missing): " + varBits, null, -1);
                        error = true;
                        continue block31;
                    }
                    xoff = TextUtils.atof(varBits.substring(j + 1, semiPos));
                    j = semiPos;
                    continue block31;
                }
                case 'Y': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad Y offset (semicolon missing): " + varBits, null, -1);
                        error = true;
                        continue block31;
                    }
                    yoff = TextUtils.atof(varBits.substring(j + 1, semiPos));
                    j = semiPos;
                    continue block31;
                }
                case 'B': {
                    this.mtd.setBold(true);
                    continue block31;
                }
                case 'I': {
                    this.mtd.setItalic(true);
                    continue block31;
                }
                case 'L': {
                    this.mtd.setUnderline(true);
                    continue block31;
                }
                case 'F': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad font (semicolon missing): " + varBits, null, -1);
                        error = true;
                        continue block31;
                    }
                    TextDescriptor.ActiveFont af = TextDescriptor.ActiveFont.findActiveFont(varBits.substring(j + 1, semiPos));
                    if (af != null) {
                        this.mtd.setFace(af.getIndex());
                    }
                    j = semiPos;
                    continue block31;
                }
                case 'C': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad color (semicolon missing): " + varBits, null, -1);
                        error = true;
                        continue block31;
                    }
                    this.mtd.setColorIndex(TextUtils.atoi(varBits.substring(j + 1, semiPos)));
                    j = semiPos;
                    continue block31;
                }
                case 'R': {
                    TextDescriptor.Rotation rot = TextDescriptor.Rotation.ROT90;
                    if (j + 1 < varBits.length() && varBits.charAt(j + 1) == 'R') {
                        rot = TextDescriptor.Rotation.ROT180;
                        ++j;
                    }
                    if (j + 1 < varBits.length() && varBits.charAt(j + 1) == 'R') {
                        rot = TextDescriptor.Rotation.ROT270;
                        ++j;
                    }
                    this.mtd.setRotation(rot);
                    continue block31;
                }
                case 'H': {
                    this.mtd.setInherit(true);
                    continue block31;
                }
                case 'T': {
                    this.mtd.setInterior(true);
                    continue block31;
                }
                case 'P': {
                    this.mtd.setParam(true);
                    continue block31;
                }
                case 'O': {
                    if (++j >= varBits.length()) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad language specification: " + varBits, null, -1);
                        error = true;
                        continue block31;
                    }
                    char codeLetter = varBits.charAt(j);
                    if (!onVar) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Illegal use of language specification: " + varBits, null, -1);
                        error = true;
                        continue block31;
                    }
                    if (codeLetter == 'J') {
                        this.mtd.setCode(TextDescriptor.Code.JAVA);
                        continue block31;
                    }
                    if (codeLetter == 'L') {
                        this.mtd.setCode(TextDescriptor.Code.LISP);
                        continue block31;
                    }
                    if (codeLetter == 'T') {
                        this.mtd.setCode(TextDescriptor.Code.TCL);
                        continue block31;
                    }
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown language specification: " + varBits, null, -1);
                    error = true;
                    continue block31;
                }
                case 'U': {
                    if (++j >= varBits.length()) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad units specification: " + varBits, null, -1);
                        error = true;
                        continue block31;
                    }
                    char unitsLetter = varBits.charAt(j);
                    if (unitsLetter == 'R') {
                        this.mtd.setUnit(TextDescriptor.Unit.RESISTANCE);
                        continue block31;
                    }
                    if (unitsLetter == 'C') {
                        this.mtd.setUnit(TextDescriptor.Unit.CAPACITANCE);
                        continue block31;
                    }
                    if (unitsLetter == 'I') {
                        this.mtd.setUnit(TextDescriptor.Unit.INDUCTANCE);
                        continue block31;
                    }
                    if (unitsLetter == 'A') {
                        this.mtd.setUnit(TextDescriptor.Unit.CURRENT);
                        continue block31;
                    }
                    if (unitsLetter == 'V') {
                        this.mtd.setUnit(TextDescriptor.Unit.VOLTAGE);
                        continue block31;
                    }
                    if (unitsLetter == 'D') {
                        this.mtd.setUnit(TextDescriptor.Unit.DISTANCE);
                        continue block31;
                    }
                    if (unitsLetter == 'T') {
                        this.mtd.setUnit(TextDescriptor.Unit.TIME);
                        continue block31;
                    }
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown units specification: " + varBits, null, -1);
                    error = true;
                }
            }
        }
        this.mtd.setOff(xoff, yoff);
        td = ImmutableTextDescriptor.newImmutableTextDescriptor(this.mtd);
        if (!error) {
            parsedDescriptors.put(varBits, td);
        }
        return td;
    }

    private Object getVariableValue(String piece, char varType, String fileName, int lineNumber) {
        if (this.revision >= 1) {
            piece = this.unQuote(piece);
        }
        switch (varType) {
            case 'B': {
                return new Boolean(piece.charAt(0) == 'T');
            }
            case 'C': {
                Cell cell;
                if (piece.length() == 0) {
                    return null;
                }
                int colonPos = piece.indexOf(58);
                if (colonPos < 0) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed Cell (missing colon): " + piece, null, -1);
                    break;
                }
                String libName = piece.substring(0, colonPos);
                Library lib = Library.findLibrary(libName);
                if (lib == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown library: " + libName, null, -1);
                    break;
                }
                String cellName = piece.substring(colonPos + 1);
                int commaPos = cellName.indexOf(44);
                if (commaPos >= 0) {
                    cellName = cellName.substring(0, commaPos);
                }
                if ((cell = lib.findNodeProto(cellName)) == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown Cell: " + piece, null, -1);
                    break;
                }
                return cell.getId();
            }
            case 'D': {
                return new Double(TextUtils.atof(piece));
            }
            case 'E': {
                Export pp;
                int colonPos = piece.indexOf(58);
                if (colonPos < 0) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed Export (missing library colon): " + piece, null, -1);
                    break;
                }
                String libName = piece.substring(0, colonPos);
                Library lib = Library.findLibrary(libName);
                if (lib == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown library: " + libName, null, -1);
                    break;
                }
                int secondColonPos = piece.indexOf(58, colonPos + 1);
                if (secondColonPos < 0) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed Export (missing cell colon): " + piece, null, -1);
                    break;
                }
                String cellName = piece.substring(colonPos + 1, secondColonPos);
                Cell cell = lib.findNodeProto(cellName);
                if (cell == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown Cell: " + piece, null, -1);
                    break;
                }
                String exportName = piece.substring(secondColonPos + 1);
                int commaPos = exportName.indexOf(44);
                if (commaPos >= 0) {
                    exportName = exportName.substring(0, commaPos);
                }
                if ((pp = cell.findExport(exportName)) == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown Export: " + piece, null, -1);
                    break;
                }
                return pp;
            }
            case 'F': {
                return new Float((float)TextUtils.atof(piece));
            }
            case 'G': {
                return new Long(TextUtils.atoi(piece));
            }
            case 'H': {
                return new Short((short)TextUtils.atoi(piece));
            }
            case 'I': {
                return new Integer(TextUtils.atoi(piece));
            }
            case 'L': {
                Library lib;
                String libName = piece;
                int commaPos = libName.indexOf(44);
                if (commaPos >= 0) {
                    libName = libName.substring(0, commaPos);
                }
                if ((lib = Library.findLibrary(libName)) == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown Library: " + piece, null, -1);
                    break;
                }
                return lib;
            }
            case 'O': {
                Tool tool;
                String toolName = piece;
                int commaPos = toolName.indexOf(44);
                if (commaPos >= 0) {
                    toolName = toolName.substring(0, commaPos);
                }
                if ((tool = Tool.findTool(toolName)) == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown Tool: " + piece, null, -1);
                }
                return tool;
            }
            case 'P': {
                PrimitiveNode np;
                int colonPos = piece.indexOf(58);
                if (colonPos < 0) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed PrimitiveNode (missing colon): " + piece, null, -1);
                    break;
                }
                String techName = piece.substring(0, colonPos);
                Technology tech = Technology.findTechnology(techName);
                if (tech == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown technology: " + techName, null, -1);
                    break;
                }
                String nodeName = piece.substring(colonPos + 1);
                int commaPos = nodeName.indexOf(44);
                if (commaPos >= 0) {
                    nodeName = nodeName.substring(0, commaPos);
                }
                if ((np = this.findPrimitiveNode(tech, nodeName)) == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown PrimitiveNode: " + piece, null, -1);
                }
                return np;
            }
            case 'R': {
                ArcProto ap;
                int colonPos = piece.indexOf(58);
                if (colonPos < 0) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed ArcProto (missing colon): " + piece, null, -1);
                    break;
                }
                String techName = piece.substring(0, colonPos);
                Technology tech = Technology.findTechnology(techName);
                if (tech == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown technology: " + techName, null, -1);
                    break;
                }
                String arcName = piece.substring(colonPos + 1);
                int commaPos = arcName.indexOf(44);
                if (commaPos >= 0) {
                    arcName = arcName.substring(0, commaPos);
                }
                if ((ap = tech.findArcProto(arcName)) == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown ArcProto: " + piece, null, -1);
                }
                return ap;
            }
            case 'S': {
                if (this.revision >= 1) {
                    return piece;
                }
                if (piece.charAt(0) != '\"') {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed string variable (missing open quote): " + piece, null, -1);
                    break;
                }
                StringBuffer sb = new StringBuffer();
                int len = piece.length();
                int objectPos = 0;
                while (objectPos < len && piece.charAt(++objectPos) != '\"') {
                    if (piece.charAt(objectPos) == '^' && ++objectPos <= len - 2 && piece.charAt(objectPos) == '\\' && piece.charAt(objectPos + 1) == 'n') {
                        sb.append('\n');
                        ++objectPos;
                        continue;
                    }
                    sb.append(piece.charAt(objectPos));
                }
                return sb.toString();
            }
            case 'T': {
                Technology tech;
                String techName = piece;
                int commaPos = techName.indexOf(44);
                if (commaPos >= 0) {
                    techName = techName.substring(0, commaPos);
                }
                if ((tech = Technology.findTechnology(techName)) == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown Technology: " + piece, null, -1);
                }
                return tech;
            }
            case 'V': {
                double x = TextUtils.atof(piece);
                int slashPos = piece.indexOf(47);
                if (slashPos < 0) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed Point2D variable (missing slash): " + piece, null, -1);
                    break;
                }
                double y = TextUtils.atof(piece.substring(slashPos + 1));
                return new EPoint(x, y);
            }
            case 'X': {
                return null;
            }
            case 'Y': {
                return new Byte((byte)TextUtils.atoi(piece));
            }
        }
        return null;
    }

    PrimitiveNode findPrimitiveNode(Technology tech, String name) {
        PrimitiveNode pn = tech.findNodeProto(name);
        if (pn != null) {
            return pn;
        }
        return tech.convertOldNodeName(name);
    }

    static {
        $assertionsDisabled = !JELIB.class.desiredAssertionStatus();
        revisions = new String[]{"8.01aw"};
        defaultArcFlags = 0;
        defaultArcFlags = ImmutableArcInst.HARD_SELECT.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.BODY_ARROWED.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.FIXED_ANGLE.set(defaultArcFlags, true);
        defaultArcFlags = ImmutableArcInst.HEAD_NEGATED.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.HEAD_EXTENDED.set(defaultArcFlags, true);
        defaultArcFlags = ImmutableArcInst.TAIL_EXTENDED.set(defaultArcFlags, true);
        defaultArcFlags = ImmutableArcInst.TAIL_NEGATED.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.RIGID.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.SLIDABLE.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.HEAD_ARROWED.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.TAIL_ARROWED.set(defaultArcFlags, false);
    }

    private static class CellContents {
        boolean filledIn = false;
        int lineNumber;
        List cellStrings = new ArrayList();
        String fileName;

        CellContents() {
        }
    }
}

