/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.CellId;
import com.sun.electric.database.LibId;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.ui.TopLevel;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class Library
extends ElectricObject
implements Comparable {
    public static final Variable.Key FONT_ASSOCIATIONS;
    private static final int LIBCHANGEDMAJOR = 1;
    private static final int READFROMDISK = 4;
    private static final int LIBCHANGEDMINOR = 64;
    private static final int HIDDENLIBRARY = 128;
    private final LibId libId;
    private String libName;
    private URL libFile;
    private Version version;
    final TreeMap cells = new TreeMap();
    private Pref curCellPref;
    private int userBits;
    private final List referencedLibs = new ArrayList();
    Preferences prefs;
    private static Preferences allPrefs;
    private static final ArrayList linkedLibs;
    private static final TreeMap libraries;
    private static Library curLib;
    private static boolean invariantsFailed;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Library(LibId libId, String libName, URL libFile) {
        this.libId = libId;
        this.libName = libName;
        this.libFile = libFile;
        if (allPrefs == null) {
            allPrefs = Preferences.userNodeForPackage(this.getClass());
        }
        this.prefs = allPrefs.node(libName);
        this.prefs.put("LIB", libName);
    }

    public static Library newInstance(String libName, URL libFile) {
        Library existingLibrary;
        String legalName = Library.legalLibraryName(libName);
        if (legalName == null) {
            return null;
        }
        if (legalName != libName) {
            System.out.println("Warning: library '" + libName + "' renamed to '" + legalName + "'");
        }
        if ((existingLibrary = Library.findLibrary(legalName)) != null) {
            System.out.println("Error: library '" + legalName + "' already exists");
            return existingLibrary;
        }
        return Library.newInstance(new LibId(), legalName, libFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Library newInstance(LibId libId, String legalName, URL libFile) {
        if (legalName == null) {
            throw new NullPointerException();
        }
        if (legalName != Library.legalLibraryName(legalName)) {
            throw new IllegalArgumentException(legalName);
        }
        Library lib = new Library(libId, legalName, libFile);
        TreeMap treeMap = libraries;
        synchronized (treeMap) {
            while (linkedLibs.size() <= lib.libId.libIndex) {
                linkedLibs.add(null);
            }
            if (linkedLibs.get(libId.libIndex) != null) {
                throw new IllegalArgumentException();
            }
            linkedLibs.set(lib.libId.libIndex, lib);
            libraries.put(legalName, lib);
        }
        Undo.newObject(lib);
        return lib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean kill(String reason) {
        if (!this.isLinked()) {
            System.out.println("Library already killed");
            return false;
        }
        Library newCurLib = null;
        if (curLib == this) {
            Iterator it = libraries.values().iterator();
            while (it.hasNext()) {
                Library lib = (Library)it.next();
                if (lib == curLib || lib.isHidden()) continue;
                newCurLib = lib;
                break;
            }
            if (newCurLib == null) {
                System.out.println("Cannot delete the last library");
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot delete the last " + this.toString(), "Close library", 1);
                return false;
            }
        }
        if (libraries.get(this.libName) != this) {
            System.out.println("Cannot delete library " + this);
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot delete " + this.toString(), "Close library", 0);
            return false;
        }
        boolean referenced = false;
        Iterator it = libraries.values().iterator();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib == this) continue;
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                Iterator nIt = cell.getNodes();
                while (nIt.hasNext()) {
                    Cell subCell;
                    NodeInst ni = (NodeInst)nIt.next();
                    if (!(ni.getProto() instanceof Cell) || (subCell = (Cell)ni.getProto()).getLibrary() != this) continue;
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Reopening " + this.toString() + " failed. Cannot " + reason + " " + this.toString() + " because one of its cells (" + subCell.describe(true) + ") is being used (by " + cell.libDescribe() + ")", "Close library", 0);
                    referenced = true;
                    break;
                }
                if (!referenced) continue;
                break;
            }
            if (!referenced) continue;
            break;
        }
        if (referenced) {
            return false;
        }
        this.erase();
        TreeMap treeMap = libraries;
        synchronized (treeMap) {
            libraries.remove(this.libName);
            linkedLibs.set(this.libId.libIndex, null);
        }
        if (newCurLib != null) {
            newCurLib.setCurrent();
        }
        Undo.killObject(this);
        return true;
    }

    public void erase() {
        Iterator it = this.getCells();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            c.kill();
        }
        this.cells.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCell(Cell c) {
        CellName cn = c.getCellName();
        TreeMap treeMap = this.cells;
        synchronized (treeMap) {
            if (this.cells.containsKey(cn)) {
                System.out.println("Tried to re-add a cell to a library: " + c);
                return;
            }
            this.cells.put(cn, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCell(Cell c) {
        CellName cn = c.getCellName();
        TreeMap treeMap = this.cells;
        synchronized (treeMap) {
            if (this.cells.get(cn) != c) {
                System.out.println("Tried to remove a non-existant Cell from a library: " + c);
                return;
            }
            this.cells.remove(cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LibraryDependency addReferencedLib(Library lib) {
        List list = this.referencedLibs;
        synchronized (list) {
            if (this.referencedLibs.contains(lib)) {
                return null;
            }
        }
        ArrayList libDependencies = new ArrayList();
        if (lib.isReferencedLib(this, libDependencies)) {
            LibraryDependency d = new LibraryDependency();
            d.startLib = lib;
            d.finalRefLib = this;
            Library startLib = lib;
            Iterator itLib = libDependencies.iterator();
            while (itLib.hasNext()) {
                Library refLib = (Library)itLib.next();
                boolean found = false;
                Iterator itCell = startLib.getCells();
                while (itCell.hasNext()) {
                    Cell c = (Cell)itCell.next();
                    Iterator it = c.getNodes();
                    while (it.hasNext()) {
                        Cell cc;
                        NodeInst ni = (NodeInst)it.next();
                        NodeProto np = ni.getProto();
                        if (!(np instanceof Cell) || (cc = (Cell)np).getLibrary() != refLib) continue;
                        d.dependencies.add(c);
                        d.dependencies.add(cc);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) {
                    System.out.println("ERROR: Library.addReferencedLib dependency trace failed inexplicably");
                }
                startLib = refLib;
            }
            return d;
        }
        List list2 = this.referencedLibs;
        synchronized (list2) {
            this.referencedLibs.add(lib);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReferencedLib(Library lib) {
        if (lib == this) {
            return;
        }
        List list = this.referencedLibs;
        synchronized (list) {
            if (!this.referencedLibs.contains(lib)) {
                return;
            }
        }
        boolean refFound = false;
        Iterator itCell = this.getCells();
        while (itCell.hasNext()) {
            Cell c = (Cell)itCell.next();
            Iterator it = c.getNodes();
            while (it.hasNext()) {
                Cell cc;
                NodeInst ni = (NodeInst)it.next();
                NodeProto np = ni.getProto();
                if (!(np instanceof Cell) || (cc = (Cell)np).getLibrary() != lib) continue;
                refFound = true;
                break;
            }
            if (!refFound) continue;
            break;
        }
        if (!refFound) {
            List list2 = this.referencedLibs;
            synchronized (list2) {
                this.referencedLibs.remove(lib);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean referencesLib(Library lib) {
        List list = this.referencedLibs;
        synchronized (list) {
            if (this.referencedLibs.contains(lib)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReferencedLib(Library lib, List libDepedencies) {
        ArrayList reflibsCopy = new ArrayList();
        List list = this.referencedLibs;
        synchronized (list) {
            if (this.referencedLibs.contains(lib)) {
                libDepedencies.add(lib);
                return true;
            }
            reflibsCopy.addAll(this.referencedLibs);
        }
        Iterator it = reflibsCopy.iterator();
        while (it.hasNext()) {
            Library reflib = (Library)it.next();
            if (libDepedencies.contains(reflib)) continue;
            libDepedencies.add(reflib);
            if (reflib.isReferencedLib(lib, libDepedencies)) {
                return true;
            }
            libDepedencies.remove(reflib);
        }
        return false;
    }

    public LibId getId() {
        return this.libId;
    }

    public static Library inCurrentThread(LibId libId) {
        try {
            return (Library)linkedLibs.get(libId.libIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public boolean isLinked() {
        return Library.inCurrentThread(this.libId) == this;
    }

    public int checkAndRepair(boolean repair, ErrorLogger errorLogger) {
        boolean verbose;
        int errorCount = 0;
        boolean bl = verbose = !this.isHidden();
        if (verbose) {
            System.out.print("Checking " + this);
            if (repair) {
                System.out.print(" for repair");
            }
        }
        Iterator it = this.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            errorCount += cell.checkAndRepair(repair, errorLogger);
        }
        if (errorCount != 0) {
            if (repair) {
                if (verbose) {
                    System.out.println("... library repaired");
                }
                this.setChanged();
            } else if (verbose) {
                System.out.println("... library has to be repaired");
            }
        } else if (verbose) {
            System.out.println("... library checked");
        }
        return errorCount;
    }

    private void check() {
        if (!$assertionsDisabled && this.libName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.libName.length() <= 0) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.libName.indexOf(32) == -1 && this.libName.indexOf(58) == -1)) {
            throw new AssertionError((Object)this.libName);
        }
        HashSet<Cell.CellGroup> cellGroups = new HashSet<Cell.CellGroup>();
        String protoName = null;
        Cell.CellGroup cellGroup = null;
        Iterator it = this.cells.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            CellName cn = (CellName)e.getKey();
            Cell cell = (Cell)e.getValue();
            if (!$assertionsDisabled && !cell.getCellName().equals(cn)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && cell.getLibrary() != this) {
                throw new AssertionError();
            }
            if (protoName == null || !cell.getName().equals(protoName)) {
                protoName = cell.getName();
                cellGroup = cell.getCellGroup();
                if (!$assertionsDisabled && cellGroup == null) {
                    throw new AssertionError(cell);
                }
                cellGroups.add(cellGroup);
            }
            if (!$assertionsDisabled && cell.getCellGroup() != cellGroup) {
                throw new AssertionError(cell);
            }
            cell.check();
        }
        it = cellGroups.iterator();
        while (it.hasNext()) {
            cellGroup = (Cell.CellGroup)((Object)it.next());
            cellGroup.check();
        }
    }

    public static boolean checkInvariants() {
        try {
            CellId.checkInvariants();
            TreeSet<String> libNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            Iterator it = libraries.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String libName = (String)e.getKey();
                Library lib = (Library)e.getValue();
                if (!$assertionsDisabled && !libName.equals(lib.libName)) {
                    throw new AssertionError((Object)(libName + " " + lib));
                }
                if (!$assertionsDisabled && libNames.contains(libName)) {
                    throw new AssertionError((Object)("case insensitive " + libName));
                }
                libNames.add(libName);
                lib.check();
            }
            return true;
        }
        catch (Throwable e) {
            if (!invariantsFailed) {
                System.out.println("Exception checking database invariants");
                e.printStackTrace();
                ActivityLogger.logException(e);
                invariantsFailed = true;
            }
            return false;
        }
    }

    public void setChangedMajor() {
        this.userBits |= 1;
    }

    private void clearChangedMajor() {
        this.clearCellChanges();
        this.userBits &= 0xFFFFFFFE;
    }

    public boolean isChangedMajor() {
        return (this.userBits & 1) != 0;
    }

    public void setChangedMinor() {
        this.userBits |= 0x40;
    }

    private void clearChangedMinor() {
        this.clearCellChanges();
        this.userBits &= 0xFFFFFFBF;
    }

    public boolean isChangedMinor() {
        return (this.userBits & 0x40) != 0;
    }

    public void setChanged() {
        this.setChangedMinor();
        this.setChangedMajor();
    }

    public void clearChanged() {
        this.clearCellChanges();
        this.clearChangedMinor();
        this.clearChangedMajor();
    }

    public boolean isChanged() {
        return this.isChangedMinor() || this.isChangedMajor();
    }

    private void clearCellChanges() {
        Iterator it = this.cells.values().iterator();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            c.clearModified();
        }
    }

    public void setFromDisk() {
        this.userBits |= 4;
    }

    public void clearFromDisk() {
        this.userBits &= 0xFFFFFFFB;
    }

    public boolean isFromDisk() {
        return (this.userBits & 4) != 0;
    }

    public void setHidden() {
        this.userBits |= 0x80;
    }

    public void clearHidden() {
        this.userBits &= 0xFFFFFF7F;
    }

    public boolean isHidden() {
        return (this.userBits & 0x80) != 0;
    }

    public static Library getCurrent() {
        return curLib;
    }

    public void setCurrent() {
        curLib = this;
    }

    public Preferences getPrefs() {
        return this.prefs;
    }

    public int lowLevelGetUserBits() {
        return this.userBits;
    }

    public void lowLevelSetUserBits(int userBits) {
        this.userBits = userBits;
    }

    public static Set findReferenceInCell(Library elib) {
        TreeSet list = new TreeSet();
        Iterator it = libraries.values().iterator();
        while (it.hasNext()) {
            Library l = (Library)it.next();
            if (l == elib) continue;
            Iterator cIt = l.cells.values().iterator();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                cell.findReferenceInCell(elib, list);
            }
        }
        return list;
    }

    public static Library findLibrary(String libName) {
        if (libName == null) {
            return null;
        }
        Library lib = (Library)libraries.get(libName);
        if (lib != null) {
            return lib;
        }
        Iterator it = libraries.values().iterator();
        while (it.hasNext()) {
            Library l = (Library)it.next();
            if (!l.getName().equalsIgnoreCase(libName)) continue;
            return l;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getLibraries() {
        TreeMap treeMap = libraries;
        synchronized (treeMap) {
            ArrayList librariesCopy = new ArrayList(libraries.values());
            return librariesCopy.iterator();
        }
    }

    public static int getNumLibraries() {
        return libraries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getVisibleLibraries() {
        TreeMap treeMap = libraries;
        synchronized (treeMap) {
            ArrayList<Library> visibleLibraries = new ArrayList<Library>();
            Iterator it = libraries.values().iterator();
            while (it.hasNext()) {
                Library lib = (Library)it.next();
                if (lib.isHidden()) continue;
                visibleLibraries.add(lib);
            }
            return visibleLibraries;
        }
    }

    public String getName() {
        return this.libName;
    }

    public boolean setName(String libName) {
        if (this.libName.equals(libName)) {
            return true;
        }
        if (Library.legalLibraryName(libName) != libName) {
            System.out.println("Error: '" + libName + "' is not a valid name");
            return true;
        }
        Library already = Library.findLibrary(libName);
        if (already != null) {
            System.out.println("Already a library called " + already.getName());
            return true;
        }
        String oldName = this.libName;
        this.lowLevelRename(libName);
        Undo.renameObject(this, oldName);
        return false;
    }

    public void lowLevelRename(String libName) {
        libraries.remove(this.libName);
        this.libName = libName;
        libraries.put(libName, this);
        String newLibFile = TextUtils.getFilePath(this.libFile) + libName;
        String extension = TextUtils.getExtension(this.libFile);
        if (extension.length() > 0) {
            newLibFile = newLibFile + "." + extension;
        }
        this.libFile = TextUtils.makeURLToFile(newLibFile);
        Cell curCell = this.getCurCell();
        this.prefs = allPrefs.node(libName);
        this.prefs.put("LIB", libName);
        this.curCellPref = null;
        this.setCurCell(curCell);
        Iterator it = this.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            cell.expandStatusChanged();
        }
    }

    public static String legalLibraryName(String libName) {
        char ch;
        int i;
        if (libName == null || libName.length() == 0) {
            return null;
        }
        for (i = 0; i < libName.length() && !Character.isWhitespace(ch = libName.charAt(i)) && ch != ':'; ++i) {
        }
        if (i == libName.length()) {
            return libName;
        }
        char[] chars = libName.toCharArray();
        while (i < libName.length()) {
            int ch2 = chars[i];
            chars[i] = Character.isWhitespace((char)ch2) || ch2 == 58 ? 45 : ch2;
            ++i;
        }
        return new String(chars);
    }

    public URL getLibFile() {
        return this.libFile;
    }

    public void setLibFile(URL libFile) {
        this.libFile = libFile;
    }

    public int compareTo(Object o) {
        Library that = (Library)o;
        return TextUtils.STRING_NUMBER_ORDER.compare(this.libName, that.libName);
    }

    public String toString() {
        return "library '" + this.libName + "'";
    }

    private void getCurCellPref() {
        if (this.curCellPref == null) {
            this.curCellPref = Pref.makeStringPref("CurrentCell", this.prefs, "");
        }
    }

    public Cell getCurCell() {
        this.getCurCellPref();
        String cellName = this.curCellPref.getString();
        if (cellName.length() == 0) {
            return null;
        }
        Cell cell = this.findNodeProto(cellName);
        if (cell == null) {
            this.curCellPref.setString("");
        }
        return cell;
    }

    public void setCurCell(Cell curCell) {
        this.getCurCellPref();
        String cellName = "";
        if (curCell != null) {
            cellName = curCell.noLibDescribe();
        }
        this.curCellPref.setString(cellName);
    }

    public static boolean saveExpandStatus(boolean quitCommand) {
        boolean okQuit = true;
        try {
            Iterator lit = Library.getLibraries();
            while (lit.hasNext()) {
                Library lib = (Library)lit.next();
                Iterator it = lib.getCells();
                while (it.hasNext()) {
                    Cell cell = (Cell)it.next();
                    cell.saveExpandStatus();
                }
                lib.prefs.flush();
            }
        }
        catch (BackingStoreException e) {
            if (quitCommand) {
                int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Cannot save cell expand status. Do you still want to quit?", "Cell Status Error", 0, 2);
                if (response != 0) {
                    okQuit = false;
                }
            }
            okQuit = false;
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot save cell expand status.Check user preferences setup.", "Error", 0);
        }
        return okQuit;
    }

    public Cell findNodeProto(String name) {
        if (name == null) {
            return null;
        }
        CellName n = CellName.parseName(name);
        if (n == null) {
            return null;
        }
        Cell cell = (Cell)this.cells.get(n);
        if (cell != null) {
            return cell;
        }
        Cell onlyWithName = null;
        Iterator it = this.cells.values().iterator();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            if (!n.getName().equalsIgnoreCase(c.getName())) continue;
            onlyWithName = c;
            if (n.getView() != c.getView() || n.getVersion() > 0 && n.getVersion() != c.getVersion() || n.getVersion() == 0 && c.getNewestVersion() != c) continue;
            return c;
        }
        if (n.getView() == View.UNKNOWN && onlyWithName != null) {
            return onlyWithName;
        }
        return null;
    }

    boolean contains(Cell cell) {
        return this.cells.get(cell.getCellName()) == cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getCells() {
        TreeMap treeMap = this.cells;
        synchronized (treeMap) {
            ArrayList cellsCopy = new ArrayList(this.cells.values());
            return cellsCopy.iterator();
        }
    }

    Iterator getCellsTail(CellName cn) {
        return this.cells.tailMap(cn).values().iterator();
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    static {
        $assertionsDisabled = !Library.class.desiredAssertionStatus();
        FONT_ASSOCIATIONS = Variable.newKey("LIB_font_associations");
        allPrefs = null;
        linkedLibs = new ArrayList();
        libraries = new TreeMap(TextUtils.STRING_NUMBER_ORDER);
        curLib = null;
        invariantsFailed = false;
    }

    static class LibraryDependency {
        private List dependencies = new ArrayList();
        private Library startLib;
        private Library finalRefLib;

        private LibraryDependency() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.startLib + " depends on " + this.finalRefLib + " through the following references:\n");
            Iterator it = this.dependencies.iterator();
            while (it.hasNext()) {
                Cell libCell = (Cell)it.next();
                Cell instance = (Cell)it.next();
                buf.append("   " + libCell.libDescribe() + " instantiates " + instance.libDescribe() + "\n");
            }
            return buf.toString();
        }
    }
}

