/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ScanChainXML {
    private static final boolean DEBUG = false;
    private static final boolean FLAT = false;
    private static final boolean REDUCE = true;
    private String outputFile = null;
    private PrintWriter out;
    private JtagController jtagController = null;
    private HashMap scanChainElements = new HashMap();
    private HashMap passThroughCells = new HashMap();
    private HashMap cellsToFlatten = new HashMap();
    private String chipName = "?";
    private Cell jtagCell = null;
    private Map entities;
    private List chains;
    private SubChain endChain;

    public ScanChainXML() {
        this.out = new PrintWriter(System.out);
        this.entities = new HashMap();
        this.chains = new ArrayList();
    }

    public void addScanChainElement(String name, String access, String clears, String inport, String outport) {
        ScanChainElement e = new ScanChainElement(name, access, clears, inport, outport);
        this.scanChainElements.put(name + "_" + inport, e);
    }

    public void addPassThroughCell(String cellName, String inport, String outport) {
        PassThroughCell p = new PassThroughCell(cellName, inport, outport);
        this.passThroughCells.put(cellName + "_" + inport, p);
    }

    public void addCellToFlatten(String libName, String cellName) {
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            System.out.println("Did not find library " + libName + " for flattening cell " + cellName);
            return;
        }
        Cell cell = lib.findNodeProto(cellName);
        if (cell == null) {
            System.out.println("Did not find cell " + cellName + " to flatten, in library " + libName);
            return;
        }
        this.cellsToFlatten.put(cell, cell);
    }

    public void setJtagController(String jtagLib, String jtagCellName, int lengthIR) {
        Library lib = Library.findLibrary(jtagLib);
        if (lib == null) {
            System.out.println("Did not find jtag library " + jtagLib);
            return;
        }
        Cell cell = lib.findNodeProto(jtagCellName);
        if (cell == null) {
            System.out.println("Did not find jtag cell " + jtagCellName + " in library " + jtagLib);
            return;
        }
        this.jtagCell = cell;
        this.jtagController = new JtagController(jtagCellName, lengthIR);
        this.endChain = new SubChain("end:jtagController", -1, null, null);
    }

    public void addJtagPort(int opcode, String soutPortName, String chainName) {
        if (this.jtagController == null) {
            System.out.println("Can't add port " + soutPortName + " because the jtag controller has not been defined yet");
            return;
        }
        this.jtagController.addPort(opcode, soutPortName, chainName);
    }

    public void setChipName(String name) {
        this.chipName = name;
    }

    public void setOutput(String file) {
        this.outputFile = file;
        try {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(this.outputFile)));
        }
        catch (IOException e) {
            System.out.println(e.getMessage() + "\nWriting XML to console");
        }
    }

    public void start(String libName, String cellName) {
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            System.out.println("Did not find library " + libName + " for starting chain analysis in cell " + cellName);
            return;
        }
        Cell cell = lib.findNodeProto(cellName);
        if (cell == null) {
            System.out.println("Did not find cell " + cellName + " for starting chain analysis, in library " + libName);
            return;
        }
        int usages = 0;
        Netlist netlist = cell.getNetlist(true);
        Iterator it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = (Nodable)it.next();
            if (!no.getProto().getName().equals(this.jtagCell.getName())) continue;
            System.out.println("*** Generating chains starting from jtag controller " + no.getName() + " in " + no.getParent());
            this.start(no);
            ++usages;
        }
        if (usages == 0) {
            System.out.println("Did not find any usages of the jtag controller: " + this.jtagCell.getName());
        }
    }

    private void start(Nodable no) {
        if (no == null) {
            return;
        }
        if (!no.getProto().getName().equals(this.jtagCell.getName())) {
            System.out.println("Node instance of cell " + no.getProto().getName() + " does not match jtag controller, " + this.jtagCell.getName());
            return;
        }
        Iterator it = this.jtagController.getPorts();
        while (it.hasNext()) {
            JtagController.Port jtagPort = (JtagController.Port)it.next();
            if (jtagPort.soutPort == null) continue;
            Port startPort = this.getPort(no, jtagPort.soutPort);
            if (startPort == null) {
                System.out.println("Can't find specified start port " + jtagPort.soutPort + " on jtag controller " + this.jtagController.name);
                continue;
            }
            String chainName = jtagPort.chainName;
            if (chainName == null) {
                chainName = "chain_" + jtagPort.soutPort;
            }
            Chain chain = new Chain(chainName, jtagPort.opcode, -1, null, null);
            this.appendChain(chain, this.getOtherPorts(startPort));
            int found = chain.numScanElements();
            System.out.println("Info: chain " + chainName + " had " + found + " scan chain elements");
            SubChain last = chain.getLastSubChain();
            if (last != this.endChain) {
                System.out.println("Error! Chain " + chainName + " did not end at the jtag controller. Possible error in parsing or schematics.");
                if (last != null) {
                    System.out.println("     Last sub chain is " + last.name + ", length=" + last.length);
                }
            }
            this.chains.add(chain);
        }
        this.postProcessEntitiesRemovePassThroughs();
        this.postProcessEntitiesPhase1();
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.out.println("\n<!--");
        this.out.println("    Document      : " + this.outputFile);
        this.out.println("    Author        : automatically generated by Electric");
        this.out.println("    Description   : none");
        this.out.println("-->\n");
        this.out.println();
        this.out.println("<!DOCTYPE ChainG SYSTEM \"file:./ChainG.dtd\" [");
        it = this.entities.values().iterator();
        while (it.hasNext()) {
            Entity ent = (Entity)it.next();
            ent.writeDefinition(this.out, new StringBuffer(), this.cellsToFlatten);
        }
        this.out.println("]>");
        this.out.println();
        StringBuffer indent = new StringBuffer();
        this.out.println("<ChainG>");
        indent.append("\t");
        this.out.println(indent + "<system>");
        indent.append("\t");
        this.out.println(indent + "<chip name=\"" + this.chipName + "\" lengthIR=\"" + this.jtagController.lengthIR + "\">");
        indent.append("\t");
        Iterator it2 = this.chains.iterator();
        while (it2.hasNext()) {
            Chain chain = (Chain)it2.next();
            if (chain.numScanElements() == 0) continue;
            chain.write(this.out, indent, null, this.cellsToFlatten);
        }
        indent.setLength(indent.length() - 1);
        this.out.println(indent + "</chip>");
        indent.setLength(indent.length() - 1);
        this.out.println(indent + "</system>");
        indent.setLength(indent.length() - 1);
        this.out.println("</ChainG>");
        this.out.flush();
    }

    private ScanChainElement getScanChainElement(String name, String sin) {
        ScanChainElement e = (ScanChainElement)this.scanChainElements.get(name + "_" + sin);
        return e;
    }

    private PassThroughCell getPassThroughCell(String name, String sin) {
        PassThroughCell p = (PassThroughCell)this.passThroughCells.get(name + "_" + sin);
        return p;
    }

    private SubChainInst getSubChain(Port inport) {
        Nodable no = inport.no;
        NodeProto np = no.getProto();
        PassThroughCell p = this.getPassThroughCell(np.getName(), inport.name.toString());
        if (p != null) {
            Port outport = this.getPort(no, p.outport);
            SubChain sub = new SubChain(p.cellName, -1, null, null);
            sub.setPassThrough(true);
            SubChainInst inst = new SubChainInst(inport, outport, no, sub);
            return inst;
        }
        if (np instanceof Cell) {
            ScanChainElement e = this.getScanChainElement(np.getName(), inport.name.toString());
            if (e != null) {
                SubChain sub = new SubChain(no.getName(), 1, e.access, e.clears);
                Port outport = this.getPort(no, e.outport);
                SubChainInst inst = new SubChainInst(inport, outport, no, sub);
                return inst;
            }
            if (np.getName().equals(this.jtagCell.getName())) {
                SubChainInst inst = new SubChainInst(inport, null, no, this.endChain);
                return inst;
            }
            Cell sch = ((Cell)np).contentsView();
            if (sch == null) {
                sch = (Cell)np;
            }
            SubChainInst inst = this.getSubChain(sch, inport);
            return inst;
        }
        return null;
    }

    private SubChainInst getSubChain(Cell cell, Port inport) {
        Nodable no = inport.no;
        Export inputEx = cell.findExport(inport.pp.getNameKey());
        ExPort schInPort = new ExPort(inport.name, inputEx, inport.index);
        String key = cell.describe(false) + schInPort.name.toString();
        Entity ent = (Entity)this.entities.get(key);
        Port outport = null;
        if (ent == null) {
            Port lastOutport;
            if (inputEx == null) {
                System.out.println("Error! In " + cell + ", scan data input Export " + inport.name + " not found.");
                return null;
            }
            ent = new Entity(cell);
            ent.setInExPort(schInPort);
            this.entities.put(key, ent);
            ArrayList nextPorts = this.getOtherPorts(schInPort);
            SubChainInst lastInst = this.appendChain(ent, nextPorts);
            if (lastInst != null && (lastOutport = lastInst.getOutport()) != null) {
                ExPort outEx = this.getExportedPort(lastOutport);
                if (outEx == null) {
                    System.out.println("Error! In " + cell + ", last element \"" + lastOutport.no.getName() + "\", output port \"" + lastOutport + "\"" + " does not connect to another scan element, is not exported from cell, and does not terminate at the JTAG Controller");
                } else {
                    ent.setOutExPort(outEx);
                    outport = this.getPort(no, outEx.name.toString());
                }
            }
        } else {
            ExPort outEx = ent.getOutExPort();
            if (outEx != null) {
                outport = this.getPort(no, outEx.name.toString());
            }
        }
        return new SubChainInst(inport, outport, no, ent);
    }

    private SubChainInst appendChain(Chain chain, List ports) {
        SubChainInst inst;
        Port p;
        ArrayList<Chain> possibleChains = new ArrayList<Chain>();
        ArrayList<SubChainInst> chainLastInstances = new ArrayList<SubChainInst>();
        Iterator it = ports.iterator();
        while (it.hasNext()) {
            Port outport;
            p = (Port)it.next();
            inst = this.getSubChain(p);
            if (inst == null) continue;
            Chain tempChain = new Chain("temp", -1, -1, null, null);
            SubChain sub = inst.content;
            if (sub == this.endChain) {
                tempChain.addSubChainInst(inst);
                if (tempChain.getSubChainSize() <= 0) continue;
                possibleChains.add(tempChain);
                chainLastInstances.add(inst);
                continue;
            }
            if (sub != null && (sub.getLength() > 0 || sub.getSubChainSize() > 0 || sub.isPassThrough())) {
                tempChain.addSubChainInst(inst);
            }
            if ((outport = inst.getOutport()) == null) continue;
            SubChainInst last = inst;
            ArrayList nextPorts = this.getOtherPorts(outport);
            SubChainInst appendLast = this.appendChain(tempChain, nextPorts);
            if (appendLast != null) {
                last = appendLast;
            }
            if (tempChain.getSubChainSize() <= 0) continue;
            possibleChains.add(tempChain);
            chainLastInstances.add(last);
        }
        if (possibleChains.size() == 0) {
            return null;
        }
        if (possibleChains.size() > 1) {
            System.out.print("Error! Found more than one chain branching from port set: ");
            it = ports.iterator();
            while (it.hasNext()) {
                p = (Port)it.next();
                System.out.print(p.name + ", ");
            }
            System.out.println();
        }
        Chain temp = (Chain)possibleChains.get(0);
        Iterator it2 = temp.getSubChainInsts();
        while (it2.hasNext()) {
            inst = (SubChainInst)it2.next();
            chain.addSubChainInst(inst);
        }
        return (SubChainInst)chainLastInstances.get(0);
    }

    private void postProcessEntitiesRemovePassThroughs() {
        Iterator it = this.entities.values().iterator();
        while (it.hasNext()) {
            Entity ent = (Entity)it.next();
            ent.removePassThroughs();
        }
    }

    private void postProcessEntitiesPhase1() {
        int reduced = 1;
        while (reduced > 0) {
            Entity ent;
            reduced = 0;
            Iterator it = this.entities.values().iterator();
            while (it.hasNext()) {
                ent = (Entity)it.next();
                if (ent.getSubChainSize() <= 1) continue;
                SubChainInst consolidated = null;
                ArrayList<SubChainInst> newList = new ArrayList<SubChainInst>();
                Iterator it2 = ent.getSubChainInsts();
                while (it2.hasNext()) {
                    SubChainInst inst = (SubChainInst)it2.next();
                    SubChain sub = inst.getSubChain();
                    if (sub.access == null || sub.clears == null || sub.length <= 0 || sub.getSubChainSize() > 0) {
                        consolidated = null;
                        newList.add(inst);
                        continue;
                    }
                    if (consolidated != null && consolidated.getSubChain().access.equals(sub.access) && consolidated.getSubChain().clears.equals(sub.clears) && this.isMergable(inst)) {
                        consolidated.getSubChain().length += sub.length;
                        consolidated.setOutport(inst.getOutport());
                        ++reduced;
                        continue;
                    }
                    consolidated = new SubChainInst(inst.getInport(), inst.getOutport(), inst.no, (SubChain)inst.getSubChain().clone());
                    newList.add(consolidated);
                }
                ent.replaceSubChainInsts(newList);
            }
            it = this.entities.values().iterator();
            while (it.hasNext()) {
                SubChain sub;
                ent = (Entity)it.next();
                if (ent.length <= 0 && ent.getSubChainSize() == 1) {
                    SubChainInst inst = (SubChainInst)ent.getSubChainInsts().next();
                    sub = inst.getSubChain();
                    if (sub.length > 0 && sub.getSubChainSize() == 0 && this.isFlattenable(inst)) {
                        ent.length = sub.length;
                        ent.access = sub.access;
                        ent.clears = sub.clears;
                        ent.remove(inst);
                        ++reduced;
                    }
                }
                if (ent.length > 0) continue;
                for (int i = 0; i < ent.getSubChainSize(); ++i) {
                    Entity subEnt;
                    sub = ent.getSubChain(i);
                    SubChainInst inst = ent.getSubChainInst(i);
                    if (!(sub instanceof Entity) || this.cellsToFlatten.get((subEnt = (Entity)sub).cell) == null || !this.isFlattenable(inst) || sub.length >= 0 || sub.getSubChainSize() <= 0) continue;
                    ent.remove(ent.getSubChainInst(i));
                    ent.addAllSubChainInsts(i, sub.getSubChainsInsts());
                    ++reduced;
                }
            }
        }
    }

    private boolean isMergable(SubChainInst inst) {
        return inst.getName().matches(".*?@.*");
    }

    private boolean isFlattenable(SubChainInst inst) {
        return inst.getName().matches(".*?@.*");
    }

    private ExPort getExportedPort(Port port) {
        if (port == null) {
            return null;
        }
        Cell cell = port.no.getParent();
        Netlist netlist = cell.getNetlist(true);
        Network net = netlist.getNetwork(port.no, port.pp, port.index);
        Iterator it = cell.getPorts();
        while (it.hasNext()) {
            Export ex = (Export)it.next();
            Name name = ex.getNameKey();
            for (int i = 0; i < name.busWidth(); ++i) {
                if (netlist.getNetwork(ex, i) != net) continue;
                return new ExPort(name.subname(i), ex, i);
            }
        }
        return null;
    }

    private ArrayList getOtherPorts(ExPort inport) {
        PortInst pi = inport.ex.getOriginalPort();
        NodeInst ni = pi.getNodeInst();
        Netlist netlist = ni.getParent().getNetlist(true);
        Network net = netlist.getNetwork(inport.ex, inport.index);
        Port port = null;
        Iterator it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = (Nodable)it.next();
            if (no.getNodeInst() != ni || net != netlist.getNetwork(no, pi.getPortProto(), inport.index)) continue;
            port = new Port(inport.name, no, pi.getPortProto(), inport.index);
            break;
        }
        if (port == null) {
            return null;
        }
        return this.getOtherPorts(port);
    }

    private ArrayList getOtherPorts(Port inport) {
        if (inport == null) {
            return null;
        }
        ArrayList<Port> ports = new ArrayList<Port>();
        Cell cell = inport.no.getParent();
        Netlist netlist = cell.getNetlist(true);
        Network net = netlist.getNetwork(inport.no, inport.pp, inport.index);
        Iterator it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = (Nodable)it.next();
            Iterator it2 = no.getProto().getPorts();
            while (it2.hasNext()) {
                PortProto pp = (PortProto)it2.next();
                Name name = pp.getNameKey();
                for (int i = 0; i < name.busWidth(); ++i) {
                    if (no == inport.no && pp == inport.pp && i == inport.index || netlist.getNetwork(no, pp, i) != net) continue;
                    Name subname = name;
                    if (name.busWidth() > 1) {
                        subname = name.subname(i);
                    }
                    Port p = new Port(subname, no, pp, i);
                    ports.add(p);
                }
            }
        }
        if (ports.size() == 0) {
            System.out.println("Error, no other ports connected to " + inport.name);
        }
        return ports;
    }

    private Port getPort(Nodable no, String portName) {
        Iterator it = no.getProto().getPorts();
        while (it.hasNext()) {
            PortProto pp = (PortProto)it.next();
            Name name = pp.getNameKey();
            for (int i = 0; i < name.busWidth(); ++i) {
                Name subname = name.subname(i);
                if (!subname.toString().equals(portName)) continue;
                return new Port(subname, no, pp, i);
            }
        }
        System.out.println("Could not find " + portName + " on " + no.getName());
        return null;
    }

    private static class ExPort {
        private Export ex;
        private int index;
        private Name name;

        private ExPort(Name name, Export ex, int index) {
            this.name = name;
            this.ex = ex;
            this.index = index;
        }

        public String toString() {
            if (this.name == null) {
                return null;
            }
            return this.name.toString();
        }

        public void print() {
            System.out.println("  Name: " + this.name);
            System.out.println("  Ex: " + this.ex);
            System.out.println("  int: " + this.index);
        }
    }

    private static class Port {
        private PortProto pp;
        private int index;
        private Name name;
        private Nodable no;

        private Port(Name name, Nodable no, PortProto pp, int index) {
            this.name = name;
            this.no = no;
            this.pp = pp;
            this.index = index;
        }

        public String toString() {
            if (this.name == null) {
                return null;
            }
            return this.no.getName() + ":" + this.name.toString();
        }

        public void print() {
            System.out.println("  Name: " + this.name);
            System.out.println("  No: " + this.no);
            System.out.println("  int: " + this.index);
            System.out.println("  pp: " + this.pp);
        }
    }

    private static class Entity
    extends SubChain {
        private static final String deftag = "!ENTITY";
        private Cell cell;
        private ExPort inExport;
        private ExPort outExport;

        private Entity(Cell cell) {
            super(cell.getName(), -1, null, null);
            this.cell = cell;
        }

        private void setInExPort(ExPort port) {
            this.inExport = port;
        }

        private ExPort getInExPort() {
            return this.inExport;
        }

        private void setOutExPort(ExPort port) {
            this.outExport = port;
        }

        private ExPort getOutExPort() {
            return this.outExport;
        }

        protected void writeDefinition(PrintWriter out, StringBuffer indent, Map cellsToFlatten) {
            if (this.numScanElements() < 3 || this.getSubChainSize() == 0) {
                return;
            }
            out.println(indent + "<" + deftag + " " + this.getKey() + " '");
            indent.append("\t");
            Iterator it = this.getSubChainInsts();
            while (it.hasNext()) {
                SubChainInst inst = (SubChainInst)it.next();
                SubChain subChain = inst.getSubChain();
                subChain.write(out, indent, inst.getName(), cellsToFlatten);
            }
            indent.setLength(indent.length() - 1);
            out.println(indent + "'>");
        }

        protected void write(PrintWriter out, StringBuffer indent, String instName, Map cellsToFlatten) {
            if (this.numScanElements() < 3 || this.getSubChainSize() == 0) {
                super.write(out, indent, instName, cellsToFlatten);
            } else {
                out.println(indent + "<subchain name=\"" + instName + "\"> &" + this.getKey() + "; </subchain>");
            }
        }

        private Object getKey() {
            String key = this.name + "_" + this.inExport.name.toString();
            key = key.replaceAll("[\\[\\]]", "_");
            return key;
        }

        public Object clone() {
            Entity ent = new Entity(this.cell);
            this.copyTo(ent);
            ent.inExport = this.inExport;
            ent.outExport = this.outExport;
            return ent;
        }
    }

    private static class SubChain
    extends Chain {
        private boolean passThrough = false;

        private SubChain(String name, int length, String access, String clears) {
            super(name, -1, length, access, clears);
        }

        protected String getTag() {
            return "subchain";
        }

        private void setPassThrough(boolean b) {
            this.passThrough = b;
        }

        private boolean isPassThrough() {
            return this.passThrough;
        }

        protected SubChain getLastSubChain() {
            if (this.getSubChainSize() == 0) {
                return this;
            }
            return super.getLastSubChain();
        }

        public Object clone() {
            SubChain sub = new SubChain(this.name, this.length, this.access, this.clears);
            this.copyTo(sub);
            sub.passThrough = this.passThrough;
            return sub;
        }
    }

    private static class Chain {
        protected String name;
        private int opcode;
        protected int length;
        protected String access;
        protected String clears;
        private List subchains;

        private Chain(String name, int opcode, int length, String access, String clears) {
            this.name = name;
            this.opcode = opcode;
            this.length = length;
            this.access = access;
            this.clears = clears;
            this.subchains = new ArrayList();
        }

        protected void addSubChainInst(SubChainInst subChain) {
            this.subchains.add(subChain);
        }

        protected int getSubChainSize() {
            return this.subchains.size();
        }

        protected SubChainInst getSubChainInst(int i) {
            return (SubChainInst)this.subchains.get(i);
        }

        protected SubChain getSubChain(int i) {
            SubChainInst inst = (SubChainInst)this.subchains.get(i);
            if (inst == null) {
                return null;
            }
            return inst.getSubChain();
        }

        protected Iterator getSubChainInsts() {
            return this.subchains.iterator();
        }

        protected Iterator getSubChains() {
            ArrayList<SubChain> subs = new ArrayList<SubChain>();
            Iterator it = this.subchains.iterator();
            while (it.hasNext()) {
                SubChainInst inst = (SubChainInst)it.next();
                subs.add(inst.getSubChain());
            }
            return subs.iterator();
        }

        protected int getLength() {
            return this.length;
        }

        protected String getAccess() {
            return this.access;
        }

        protected String getClears() {
            return this.clears;
        }

        protected void write(PrintWriter out, StringBuffer indent, String instName, Map cellsToFlatten) {
            if (this.numScanElements() == 0) {
                return;
            }
            String n = instName == null ? this.name : instName;
            out.print(indent + "<" + this.getTag() + " name=\"" + n + "\"");
            if (this.opcode > -1) {
                out.print(" opcode=\"" + Integer.toBinaryString(this.opcode) + "\"");
            }
            if (this.length > 0) {
                out.print(" length=\"" + this.length + "\"");
            }
            if (this.access != null) {
                out.print(" access=\"" + this.access + "\"");
            }
            if (this.clears != null) {
                out.print(" clears=\"" + this.clears + "\"");
            }
            if (this.subchains.size() == 0) {
                out.println(" />");
                return;
            }
            out.println(">");
            indent.append("\t");
            Iterator it = this.getSubChainInsts();
            while (it.hasNext()) {
                SubChainInst inst = (SubChainInst)it.next();
                SubChain subChain = inst.getSubChain();
                subChain.write(out, indent, inst.getName(), cellsToFlatten);
            }
            indent.setLength(indent.length() - 1);
            out.println(indent + "</" + this.getTag() + ">");
        }

        protected String getTag() {
            return "chain";
        }

        protected int numScanElements() {
            int num = 0;
            if (this.length > 0) {
                num += this.length;
            }
            Iterator it = this.subchains.iterator();
            while (it.hasNext()) {
                SubChainInst inst = (SubChainInst)it.next();
                SubChain sub = inst.getSubChain();
                num += sub.numScanElements();
            }
            return num;
        }

        protected SubChain getLastSubChain() {
            if (this.subchains.size() == 0) {
                return null;
            }
            SubChainInst last = (SubChainInst)this.subchains.get(this.subchains.size() - 1);
            return last.getSubChain().getLastSubChain();
        }

        protected void copyTo(Chain dest) {
            dest.name = this.name;
            dest.length = this.length;
            dest.access = this.access;
            dest.clears = this.clears;
            dest.subchains.clear();
            dest.subchains.addAll(this.subchains);
        }

        protected void removePassThroughs() {
            ArrayList<SubChainInst> toRemove = new ArrayList<SubChainInst>();
            Iterator it2 = this.getSubChainInsts();
            while (it2.hasNext()) {
                SubChainInst inst = (SubChainInst)it2.next();
                SubChain sub = inst.getSubChain();
                if (!sub.isPassThrough()) continue;
                toRemove.add(inst);
            }
            it2 = toRemove.iterator();
            while (it2.hasNext()) {
                this.subchains.remove(it2.next());
            }
        }

        protected void replaceSubChainInsts(List newSubChainInsts) {
            this.subchains.clear();
            this.subchains.addAll(newSubChainInsts);
        }

        protected void remove(SubChainInst inst) {
            this.subchains.remove(inst);
        }

        protected List getSubChainsInsts() {
            ArrayList copy = new ArrayList();
            Iterator it = this.getSubChainInsts();
            while (it.hasNext()) {
                copy.add(it.next());
            }
            return copy;
        }

        protected void addAllSubChainInsts(int i, List list) {
            this.subchains.addAll(i, list);
        }
    }

    private static class SubChainInst {
        private Port inport;
        private Port outport;
        private Nodable no;
        private SubChain content;

        private SubChainInst(Port inport, Port outport, Nodable no, SubChain content) {
            this.inport = inport;
            this.outport = outport;
            this.no = no;
            this.content = content;
        }

        protected void setInport(Port port) {
            this.inport = port;
        }

        protected Port getInport() {
            return this.inport;
        }

        protected void setOutport(Port port) {
            this.outport = port;
        }

        protected Port getOutport() {
            return this.outport;
        }

        public String toString() {
            return "SubChainInst " + this.no.getName() + "; in: " + this.inport + ", out: " + this.outport;
        }

        protected SubChain getSubChain() {
            return this.content;
        }

        protected String getName() {
            return this.no.getName();
        }
    }

    private static class PassThroughCell {
        public final String cellName;
        public final String inport;
        public final String outport;

        public PassThroughCell(String cellName, String inport, String outport) {
            this.cellName = cellName;
            this.inport = inport;
            this.outport = outport;
        }
    }

    private static class JtagController {
        public final String name;
        public final int lengthIR;
        private List ports;

        private JtagController(String name, int lengthIR) {
            this.name = name;
            this.lengthIR = lengthIR;
            this.ports = new ArrayList();
        }

        private void addPort(int opcode, String soutPort, String chainName) {
            Port p = new Port(opcode, soutPort, chainName);
            this.ports.add(p);
        }

        private Iterator getPorts() {
            return this.ports.iterator();
        }

        protected static class Port {
            public final int opcode;
            public final String soutPort;
            public final String chainName;

            public Port(int opcode, String soutPort, String chainName) {
                this.opcode = opcode;
                this.soutPort = soutPort;
                this.chainName = chainName;
            }
        }
    }

    private static class ScanChainElement {
        public final String name;
        public final String access;
        public final String clears;
        public final String inport;
        public final String outport;

        private ScanChainElement(String name, String access, String clears, String inport, String outport) {
            this.name = name;
            this.access = access;
            this.clears = clears;
            this.inport = inport;
            this.outport = outport;
        }
    }
}

