/*
 * Electric(tm) VLSI Design System
 *
 * File: sc1err.c
 * Contains error messages for the Silicon Compiler aid
 * Written by: Andrew R. Kostiuk, Queen's University
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#include "config.h"
#if SCAID

char *sc_errmsg;

char *sc_standard_errmsg[] =
{
	"",
	"Unknown command '%s'",
	"No keyword for CREATE command",
	"No name for CREATE CELL command",
	"Cell '%s' already exists in current library",
	"Cannot create cell '%s'",
	"Unknown CREATE command '%s'",
	"No keyword for LIBRARY command",
	"Unknown LIBRARY command '%s'",
	"No name for LIBRARY USE command",
	"Library '%s' not selected",
	"No name for LIBRARY READ command",
	"Cannot create library '%s'",
	"No memory",
	"Cannot set library style",
	"Cannot read library '%s'",
	"No instance name for CREATE INSTANCE command",
	"No type name for CREATE INSTANCE command",
	"Library '%s' not found",
	"There is no '%s' in the standard cell library",
	"No cell selected",
	"Cannot create instance '%s'",
	"Cannot set instance name '%s'",
	"Instance '%s' already exists",
	"No SHOW option selected",
	"Invalid option '%s' for SHOW command",
	"No cell name for SHOW PORTS command",
	"Cannot find cell '%s'",
	"Not enough parameters for CONNECT command",
	"Cannot find port '%s' on instance '%s'",
	"Cannot find universal arc",
	"Cannot make arc",
	"No file name for COMPILE command",
	"Cannot open file '%s' for COMPILE command",
	"Error creating connection list for '%s' to '%s'",
	"Error moving instance",
	"Error with edge routines",
	"No option for SIMULATION command",
	"Incorrect option '%s' for SIMULATION command",
	"No cell name specified for SIMULATION SET command",
	"Error setting simulation variable",
	"No cell name specified for SIMULATION SHOW command",
	"No simulation variable for cell '%s'",
	"Cannot create sc_nitree variable",
	"Not enough parameters for SIMULATION WRITE command",
	"Error opening output simulation file '%s'",
	"Cannot find sc_sim variable for cell '%s'",
	"No option for SET command",
	"Unknown option '%s' for SET command",
	"Cannot find cell '%s'",
	"Cannot find port '%s' on cell '%s'",
	"Unknown port direction specifier '%s'",
	"No instance specified for EXPORT command",
	"Cannot find instance '%s' for EXPORT command",
	"No port specified for EXPORT command",
	"Cannot find port '%s' on instance '%s' for EXPORT command",
	"Unknown port type '%s' for EXPORT command",
	"No export name specified for EXPORT command",
	"Export name '%s' is not unique",
	"File error with SIM SET temp file",
	"Error status from VHDL Compiler for file '%s'",
	"Cannot find instance '%s'",
	"No leaf cell specified for ORDER command",
	"No options specified for the SELECT command",
	"No cell name specified for the SELECT CELL command",
	"Invalid SELECT option '%s'",
	"Error opening file '%s' for SET OUTPUT-DEVICE command",
	"No connections found to allow PLACEing",
	"Unknown command option '%s' for PLACE command",
	"No command for PLACE SET-CONTROL command",
	"Unknown command option '%s' for PLACE SET-CONTROL command",
	"No PLACEMENT structure for cell '%s'",
	"Unknown command option '%s' for ROUTE command",
	"Unknown command option '%s' for ROUTE SET-CONTROL command",
	"No command specified for ROUTE SET-CONTROL command",
	"No ROUTE structure for cell '%s'",
	"Unknown command option '%s' for MAKE command",
	"No command for MAKE SET-CONTROL command",
	"Unknown command option '%s' for MAKE SET-CONTROL command",
	"Cannot create leaf cell '%s' in MAKER",
	"Cannot create leaf instance '%s' in MAKER",
	"Cannot create leaf feed in MAKER",
	"Cannot create via in MAKER",
	"Cannot create layer2 track in MAKER",
	"Cannot create layer1 track in MAKER",
	"Cannot create export port '%s' in MAKER",
	"Cannot set cell numbers structure",
	"Unknown option '%s' for SET LEAF-CELL-NUMBERS command",
	"Unable to get LAYER1-NODE for MAKER",
	"Unable to get LAYER2-NODE for MAKER",
	"Unable to get VIA for MAKER",
	"Unable to get LAYER1-ARC for MAKER",
	"Unable to get LAYER2-ARC for MAKER",
	"Unable to get LAYER P-WELL for MAKER",
	"Unable to create P-WELL in MAKER",
	"No ALS program specified for system",
	"No VHDL Compiler program specified for system",
	"Error openning file '%s' in ORDER command",
	"No cells to check in VERIFY command",
	"Insufficent parameters for SET NODE-NAME command",
	"Cannot find instance '%s' in SET NODE-NAME command",
	"Cannot find port '%s' on instance '%s' in SET NODE-NAME command",
	"Cannot find extracted node to set name in SET NODE-NAME command",
	0
};

#endif  /* SCAID - at top */
