/*
  Graphical IDF Wizard
  Copyright (C) 1998,1999,2002,2005,2010,2013 David Martnez Oliveira

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
 */
/* Revisions:
 * November, 17th, 2001
 * Compile warnning removal and code cleanup
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
//#include <gnome.h>
#include <gtk/gtk.h>
#include <edma.h>

#include "prefform.h"
#include "filemake.h"

extern int TestFile(EPChar);

void 
destroy1 (GtkWidget *widget, GtkWidget *fs)
{
  g_print ("\n Destroying File Selector");
  g_print ("\n");
  gtk_widget_destroy (widget);
}

void 
file_ok_sel1 (GtkWidget *w, GtkWidget *fs)
{
  PrefWidgets *gw;
  OBJID       id, id1;
  const gchar       *fname;
  const EChar       *aux;
  EUint32     i;
  EChar       err_str[256];

  gw = (PrefWidgets*) fs;
  fname = gtk_file_selection_get_filename (GTK_FILE_SELECTION (gw->fs));
  if (TestFile ((EPChar)fname)) 
    {
      gtk_widget_destroy (gw->fs);
      return;
    }

  aux = gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->builder_des)->entry));
  g_print (" File: %s\n%s\n", fname, aux);

  /* Look for object to build file */
  for (i = 0; i < gw->n; i++)
    if (strcmp (gw->des[i], aux) == 0)
      break;
  if (i == gw->n)
    g_print ("Opps!... There is a problem with Builders Descriptions");

  g_print ("\nUssing class %s for building file", gw->cn[i]);
  if ((id = edma_new_obj ("CLASS_METADATA")) == -1) 
    {
      g_print ("[ERROR] Can't create CLASS_METADA Object");
      //gnome_error_dialog ("Can't Create CLASS_METADA Object. Aborting");
      _error_dialog ("Can't Create CLASS_METADA Object. Aborting");
      gtk_widget_destroy (gw->fs);
      return;
  }
  
  build_metada_obj (id);
  if ((id1 = edma_new_obj(gw->cn[i])) == -1) 
    {
      g_print ("[ERROR] Can't create %s Object", gw->cn[i]);
      sprintf (err_str,"Can't create %s Object\nOperation Failed!", gw->cn[i]);
      //gnome_error_dialog (err_str);
      _error_dialog (err_str);
      gtk_widget_destroy (gw->fs);
      edma_free_obj (id);
      return;
  }
  edma_met3 (id1, "build", id, fname);
  edma_free_obj (id1);
  edma_free_obj (id);  
  gtk_widget_destroy (gw->fs);

}

void 
open_callback1 (GtkWidget *widget, gpointer data)
{
  GtkWidget   *fs;
  PrefWidgets *gw;

  gw = (PrefWidgets*) data;
  
  fs = gtk_file_selection_new ("Open IDF File");
  gw->fs = fs;
  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", (GtkSignalFunc) file_ok_sel1, gw );
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", (GtkSignalFunc) destroy1,
			     GTK_OBJECT (gw));
  gtk_widget_show (fs);
}

ESint32 
InitPrefForm (PrefWidgets *gw)
{
  OBJID      id;
  EUint32    i,n;
  EChar      temp[80];
  EChar      fname[1024], *aux;

  gw->build_form = BuildPrefForm;

  gw->builders = NULL;
  
  id = edma_new_obj ("ID");
  aux = edma_get_system_path ();
  strcpy (fname, aux);
  free (aux);

  g_print ("System Path : %s",fname);
  strcat (fname, "/share/edma/builders.db");
  edma_met3 (id, "SetDB", fname);
  edma_rprop3 (id, "nElems", &gw->n);
  for (i = 0; i < gw->n; i++)
    {
      edma_met3 (id, "GetItem", i, gw->cn[i], temp, gw->des[i]);
      gw->builders = g_list_append (gw->builders, gw->des[i]);
    }
  edma_free_obj (id);
  
}

ESint32 
BuildPrefForm (PrefWidgets *gw, GtkWidget *note)
{   
  GtkWidget *label, *aux;

  /* General Info Page */
  gw->table = gtk_table_new (12, 4, TRUE);

  label = gtk_label_new ("File Builder");
  gtk_widget_show (label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 1, 2);

  gw->builder_des = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO(gw->builder_des), gw->builders);
  gtk_widget_show (gw->builder_des);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->builder_des, 1, 3, 1, 2);

  gw->but = gtk_button_new_with_label ("Build");
  gtk_widget_show (gw->but);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->but, 3, 4, 1, 2);  

  gtk_signal_connect (GTK_OBJECT (gw->but), "clicked",
		      GTK_SIGNAL_FUNC (open_callback1), (gpointer) gw);

  gtk_widget_show (gw->table);
  label = gtk_label_new ("Preferences");
  gtk_notebook_append_page (GTK_NOTEBOOK (note), gw->table, label);
  
  return 0;
}
