/* exp_main.h - defn's for main and its subroutines */

#include <stdio.h>
#include "tcl.h"

#ifdef __cplusplus
extern "C" {
#endif

extern int exp_cmdlinecmds;
extern int exp_interactive;
extern int exp_is_debugging;
extern FILE *exp_cmdfile;
extern char *exp_cmdfilename;

#ifdef TCL_DEBUGGER
extern int exp_tcl_debugger_available;
#endif

extern int exp_pid;

/* support for Standard C and C++ prototypes */
#ifdef __cplusplus
#define EXP_PROTOTYPES
#define EXP_VARARGS	...
#else
#define EXP_VARARGS	, ...
#ifdef __STDC__
#define EXP_PROTOTYPES
#endif
#endif

#ifdef EXP_PROTOTYPES
#define EXP_PROTO(x)	x
#ifdef EXP_DEFINE_FNS
/* when functions are really being defined, we have to use va_alist as arg */
#define EXP_PROTOV(x)	va_alist
#else
#define EXP_PROTOV(x)	x
#endif
#else
#define EXP_PROTO(x)	()
#define EXP_PROTOV(x)	()
#endif

/* Put double parens around macro args so they all look like a single arg */
/* to preprocessor.  That way, don't need a different macro for functions */
/* with a different number of arguments. */

void exp_init EXP_PROTO((Tcl_Interp *));
void exp_parse_argv EXP_PROTO((Tcl_Interp *,int argc,char **argv));
int  exp_interpreter EXP_PROTO((Tcl_Interp *));
void exp_interpret_cmdfile EXP_PROTO((Tcl_Interp *,FILE *));
void	exp_interpret_cmdfilename EXP_PROTO((Tcl_Interp *,char *));
void exp_interpret_rcfiles EXP_PROTO((Tcl_Interp *,int my_rc,int sys_rc));

char *exp_cook EXP_PROTO((char *s,int *len));
			/* app-specific exit handler */
extern void  (*exp_app_exit)EXP_PROTO((Tcl_Interp *));

void exp_exit EXP_PROTO((Tcl_Interp *,int status));

#ifdef __cplusplus
}
#endif
