;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;; 
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1991 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;

#|
==================================================================
Change log:
    4/14/91 Brad Myers - created
==================================================================
|#

(in-package "USER" :use '("LISP"))

(format t "Compiling C32...~%")

;; check first to see if place is set
(unless (boundp 'Garnet-C32-PathName)
  (error "Load 'Garnet-Loader' first to set Garnet-C32-PathName before loading this file."))

;; Load files that C32 depends on, only if not compiling the rest of Garnet
;; already

(unless (or (get :garnet-modules :multifont)
	    (and (boundp 'user::compile-opal-p) user::compile-opal-p
		 (boundp 'user::compile-inter-p) user::compile-inter-p))
  (load (merge-pathnames "multifont-loader"
			 #+cmu "opal:"
			 #+(not cmu) user::Garnet-Opal-PathName)))

(unless (get :garnet-modules :gilt-functions)
  (load (merge-pathnames "gilt-functions-loader"
			 user::Garnet-Gilt-PathName)))

(dolist (gadget '(
		  "labeled-box-loader"
		  "x-buttons-loader"
		  "arrow-line-loader"
		  "text-buttons-loader"
		  "scrolling-window-loader"
		  "scrolling-input-string-loader"
		  "scrolling-menu-loader"  ; for pop-up-functions
		  "error-gadget-loader"	  		; for C32error
		  "scrolling-labeled-box-loader"	; for package name
		  "motif-scrolling-window-loader"
		  ))
  (load (merge-pathnames gadget
			 #+cmu "gadgets:"
			 #+(not cmu) user::Garnet-Gadgets-PathName)))

(defvar C32-files '(
		    "kr-extra"
		    "c32"
		    "c32formula"
		    "c32ref"
		    "pop-up-generalize"
		    "pop-up-copy-formula"
		    "pop-up-ask-object"
		    "pop-up-functions"
		    "c32dialog"
		    "c32-lapidary"
		    ))

(dolist (file c32-files)
  (compile-file (merge-pathnames file
			 #+cmu "c32-src:"
			 #+(not cmu) user::Garnet-C32-Src))
  (load (merge-pathnames file user::Garnet-C32-Src))
  )


#+(or allegro explorer lispworks lucid)
(setf (get :garnet-modules :C32) t)

(format t "... Done Compiling C32~%")
