// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "module.h"

namespace binder {
using namespace ost;
using namespace std;

const char *Checks::chkAccept(Line *line, ScriptImage *img)
{
	Name *scr = img->getCurrent();
        unsigned idx = 0;
	const char *cp = scr->name;

        if(getMember(line))
                return "accept no members used";

        if(!useKeywords(line, "=timeout=id"))
                return "invalid keyword for accept";

	if(cp && !strnicmp(cp, "routing:", 8))
		return NULL;

	if(cp && !strnicmp(cp, "dialing:", 8))
		return NULL;

	return "accept only usable in routing or dialing"; 
}  

const char *Checks::chkCDR(Line *line, ScriptImage *img)
{
	char var[65];
	char *p;
	unsigned idx = 0;
	const char *cp;

	Name *scr = img->getCurrent();
	snprintf(var, sizeof(var), "cdr.%s", scr->name);
	p = strchr(var, ':');
	if(p)
		*p = 0;

	if(img->getPointer(var))
		return "cdr already assigned for this script file";

	if(getMember(line))
		return "cdr uses no members";

	if(hasKeywords(line))
		return "cdr has no keywords";

	while(NULL != (cp = getOption(line, &idx)))
	{
		if(!isalpha(*cp) && *cp != '%')
			return "invalid cdr entry used";
	}

	img->setPointer(var, line);
	return "";
}

const char *Checks::chkRegister(Line *line, ScriptImage *img)
{
	Name *scr = img->getCurrent();
	BayonneDriver *driver;
	char nbuf[32];
	char *p;

	if(scr->access != ScriptInterp::scrPUBLIC)
		return "cannot register non-public script";


	setString(nbuf, sizeof(nbuf), scr->name);
	p = strchr(nbuf, ':');
	if(p)
		*p = 0;
	else
		return "cannot use register in this context";

	driver = BayonneDriver::get(nbuf);
		
	if(!driver)
	{
		slog.warn("cannot register from %s", scr->name);
		return "";
	}
	return driver->registerScript(img, line);
}
	
} // end namespace
