#include <stdio.h>
#include <rpc/rpc.h>
#include <sys/time.h>
#include "bayonne_rpc.h"

int main( int argc, char *argv[] )
{
	CLIENT*			pcliConnection;
	struct timeval		stvTimeout;
	bayonne_port*		pbpResult;
	int			iCount;

	stvTimeout.tv_sec =  23;
	stvTimeout.tv_usec = 0;
	pcliConnection = NULL;
	pcliConnection = clnt_create( "localhost", BAYONNE_PROGRAM, BAYONNE_VERSION, "udp" );

	if ( pcliConnection == NULL )
	{
		printf( "CLNT_CREATE %s\n", clnt_spcreateerror( "" ) );
		exit( 1 );
	}

	if ( !clnt_control( pcliConnection, CLSET_TIMEOUT, ( char *) &stvTimeout ) )
	{
		printf( "CLNT_CONTROL: %s\n", clnt_sperror( pcliConnection, "" ) );
		clnt_destroy( pcliConnection );
		exit( 1 );
	}

	printf( "%-4.4s %-16.16s %-16.16s %-8.8s %-8.8s %-8.8s %-8.8s %-16.16s %-6.6s %-12.12s %-8.8s\n",
	       	"Port",
		"ANI",
		"DNIS",
		"Name",
		"User",
		"Info",
		"Language",
		"GUID",
		"Policy",
		"Capabilities",
		"Duration" );
	printf( "%-4.4s %-16.16s %-16.16s %-8.8s %-8.8s %-8.8s %-8.8s %-16.16s %-6.6s %-12.12s %-8.8s\n",
	       	"----",
		"---",
		"----",
		"----",
		"----",
		"----",
		"--------",
		"----",
		"------",
		"------------",
		"--------" );
	for ( iCount = 0; iCount < 60; iCount ++ )
	{
		pbpResult = bayonne_port_1( &iCount, pcliConnection );
		if ( pbpResult == NULL )
		{
			printf( "RPC CALL: %s\n", clnt_sperror( pcliConnection, "" ) );
			clnt_destroy( pcliConnection );
			exit( 1 );
		}

		printf( "%-4.1i %-16.16s %-16.16s %-8.8s %-8.8s %-8.8s %-8.8s %-16.16s %-6.6s %12.1li %8.1li\n",
			iCount,
			pbpResult->port_caller,
			pbpResult->port_dialed,
			pbpResult->port_name,
			pbpResult->port_user,
			pbpResult->port_info,
			pbpResult->port_lang,
			pbpResult->port_gid,
			pbpResult->port_policy,
			pbpResult->port_caps,
			pbpResult->port_duration );
	}

	printf( "%s", "\n" );

	clnt_destroy( pcliConnection );
	exit( 0 );
}
