/*
 *  Ball And Paddle
 *
 *  Copyright (C) 2007,2008 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#include <string>
#include <vector>
#include <iostream>
#include <sstream>
using namespace std;

#include <sys/stat.h>

#include "SDL.h"
#include "SDL_image.h"

#include "config.h"
#include "globals.h"
#include "splash.h"
#include "game.h"
#include "gamestatemanager.h"

int FONT_INACTIVE = 0;
int FONT_ACTIVE = 0;
int FONT_WHITE = 0;
int FONT_SMALL_WHITE = 0;

GameStateManager gameStateManager;

int
main (int argc, char *args[])
{

  bool direct = false;

  string levelsetName;
  string levelsetFilename;

  int level = 1;

  stringstream version_ss;
  version_ss << "ballandpaddle (Ball and Paddle) " << VERSION << endl;
  version_ss << "Copyright (C) 2007,2008 Eric Hutchins" << endl;
  version_ss << "This is free software.  You may redistribute copies of it under the terms of" << endl;
  version_ss << "the GNU General Public License <http://www.gnu.org/licenses/gpl.html>." << endl;
  version_ss << "There is NO WARRANTY, to the extent permitted by law." << endl;
  version_ss << endl;
  version_ss << "Written by Eric Hutchins." << endl;

  stringstream help_ss;
  help_ss << "Usage:" << endl;
  help_ss << "  ballandpaddle [ --levelsetname LEVELSETNAME --levelsetfilename LEVELSETFILENAME --level LEVEL]" << endl;
  help_ss << endl;
  help_ss << "  --level \t\tuse LEVEL as the level and go straight to the game" << endl;
  help_ss << "  --levelsetname \tuse LEVELSETNAME as the levelset name and go straight" << endl;
  help_ss << "   \t\t\t  to the game" << endl;
  help_ss << "  --levelsetfilename \tuse LEVELSETFILENAME as the levelset filename and go" << endl;
  help_ss << "   \t\t\t  straight to the game" << endl;
  help_ss << "  --help \t\tdisplay this help and exit" << endl;
  help_ss << "  --version \t\toutput version information and exit" << endl;

  bool levelsetname_set = false;
  bool levelsetfilename_set = false;
  bool level_set = false;

  string try_help = "Try `ballandpaddle --help' for more information.";

  for (int i = 0; i < argc; i++)
    {
      if (string (args[i]).compare ("--levelsetname") == 0)
        {
          if (argc <= i + 1)
            {
              cout << "ballandpaddle: option requires argument -- levelsetname" << endl;
              cout << try_help << endl;
              exit(0);
            }
          levelsetName = args[i + 1];
          levelsetname_set = true;
          direct = true;
        }
      if (string (args[i]).compare ("--levelsetfilename") == 0)
        {
          if (argc <= i + 1)
            {
              cout << "ballandpaddle: option requires argument -- levelsetfilename" << endl;
              cout << try_help << endl;
              exit(0);
            }
          levelsetFilename = args[i + 1];
          levelsetfilename_set = true;
          direct = true;
        }
      if (string (args[i]).compare ("--level") == 0)
        {
          if (argc <= i + 1)
            {
              cout << "ballandpaddle: option requires argument -- level" << endl;
              cout << try_help << endl;
              exit(0);
            }
          stringstream ss (stringstream::in | stringstream::out);
          ss << args[i + 1];
          ss >> level;
          level_set = true;
          direct = true;
        }
      if (string (args[i]).compare ("--version") == 0)
        {
          cout << version_ss.str();
          exit(0);
        }
      if (string (args[i]).compare ("--help") == 0)
        {
          cout << help_ss.str();
          exit(0);
        }
    }

  if (level_set + levelsetfilename_set + levelsetname_set > 0)
    {
      if (!level_set)
        {
          cout << "ballandpaddle: missing level" << endl;
          cout << try_help << endl;
          exit(0);
        }
      if (!levelsetfilename_set)
        {
          cout << "ballandpaddle: missing levelsetfilename" << endl;
          cout << try_help << endl;
          exit(0);
        }
      if (!levelsetname_set)
        {
          cout << "ballandpaddle: missing levelsetname" << endl;
          cout << try_help << endl;
          exit(0);
        }
    }

  gameStateManager.init ();

  if (direct)
    {
      gameStateManager.setLevelset (levelsetName, levelsetFilename);
      gameStateManager.setStartLevel (level);
      gameStateManager.changeState (Game::instance ());
 	    gameStateManager.loadSounds ();
      Game::instance ()->loadImages (&gameStateManager);
      SDL_ShowCursor (false);
    }
  else
    {
      gameStateManager.changeState (Splash::instance ());
    }

  while (gameStateManager.running ())
    {
      gameStateManager.handleEvents ();
      gameStateManager.update ();
      gameStateManager.draw ();
    }

  gameStateManager.cleanup ();
  return 0;
}
