/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/

#line 1 "env.opt"
/* -*- c -*-
   This file is part of GNU Anubis.
   Copyright (C) 2001-2024 The Anubis Team.

   GNU Anubis is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   GNU Anubis is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Anubis.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "headers.h"
#include <grp.h>
#include <getopt.h>
#include "extern.h"
#include "rcfile.h"

#ifdef HAVE_PAM
# define USE_PAM 1
pam_handle_t *pamh;
static struct pam_conv conv = {
  misc_conv,
  NULL
};
#else
# define USE_PAM 0
#endif /* HAVE_PAM */
int use_pam = USE_PAM;

static char *pidfile;

#line 39 "env.opt"

#line 39
void print_help(void);
#line 39
void print_usage(void);
#line 183 "env.opt"

#line 183
/* Option codes */
#line 183
enum {
#line 183
	_OPTION_INIT=255,
#line 183
	#line 98 "env.opt"

#line 98
	OPTION_FROM,
#line 139 "env.opt"

#line 139
	OPTION_ALTRC,
#line 146 "env.opt"

#line 146
	OPTION_NORC,
#line 159 "env.opt"

#line 159
	OPTION_SHOW_CONFIG_OPTIONS,
#line 165 "env.opt"

#line 165
	OPTION_LOCATION_COLUMN,
#line 171 "env.opt"

#line 171
	OPTION_RELAX_PERM_CHECK,
#line 177 "env.opt"

#line 177
	OPTION_PID_FILE,
#line 183 "env.opt"

#line 183
	OPTION_USAGE,
#line 183 "env.opt"

#line 183
	OPTION_VERSION,

#line 183 "env.opt"
	MAX_OPTION
#line 183
};
#line 183
static struct option long_options[] = {
#line 183
	#line 41 "env.opt"

#line 41
	{ "bind", required_argument, 0, 'b' },
#line 52 "env.opt"

#line 52
	{ "remote-mta", required_argument, 0, 'r' },
#line 59 "env.opt"

#line 59
	{ "local-mta", required_argument, 0, 'l' },
#line 83 "env.opt"

#line 83
	{ "mode", required_argument, 0, 'm' },
#line 92 "env.opt"

#line 92
	{ "foreground", no_argument, 0, 'f' },
#line 98 "env.opt"

#line 98
	{ "from", required_argument, 0, OPTION_FROM },
#line 104 "env.opt"

#line 104
	{ "stdio", no_argument, 0, 'i' },
#line 119 "env.opt"

#line 119
	{ "silent", no_argument, 0, 's' },
#line 125 "env.opt"

#line 125
	{ "verbose", no_argument, 0, 'v' },
#line 131 "env.opt"

#line 131
	{ "debug", no_argument, 0, 'D' },
#line 139 "env.opt"

#line 139
	{ "altrc", required_argument, 0, OPTION_ALTRC },
#line 146 "env.opt"

#line 146
	{ "norc", no_argument, 0, OPTION_NORC },
#line 152 "env.opt"

#line 152
	{ "check-config", required_argument, 0, 'c' },
#line 159 "env.opt"

#line 159
	{ "show-config-options", no_argument, 0, OPTION_SHOW_CONFIG_OPTIONS },
#line 165 "env.opt"

#line 165
	{ "location-column", no_argument, 0, OPTION_LOCATION_COLUMN },
#line 171 "env.opt"

#line 171
	{ "relax-perm-check", no_argument, 0, OPTION_RELAX_PERM_CHECK },
#line 177 "env.opt"

#line 177
	{ "pid-file", required_argument, 0, OPTION_PID_FILE },
#line 183 "env.opt"

#line 183
	{ "help", no_argument, 0, 'h' },
#line 183 "env.opt"

#line 183
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 183 "env.opt"

#line 183
	{ "version", no_argument, 0, OPTION_VERSION },

#line 183 "env.opt"
	{0, 0, 0, 0}
#line 183
};
#line 183
static struct opthelp {
#line 183
        const char *opt;
#line 183
        const char *arg;
#line 183
        int is_optional;
#line 183
        const char *descr;
#line 183
} opthelp[] = {
#line 183
	#line 45 "env.opt"

#line 45
	{ "-b, --bind", N_("[HOST:]PORT"), 0, N_("Specify the TCP port on which GNU Anubis listens for connections; the default HOST is INADDR_ANY, and default PORT is 24 (private mail system)") },
#line 55 "env.opt"

#line 55
	{ "-r, --remote-mta", N_("[HOST:]PORT"), 0, N_("Specify a remote SMTP host name or IP address; the default is 25") },
#line 63 "env.opt"

#line 63
	{ "-l, --local-mta", N_("FILE"), 0, N_("Execute a local SMTP server, which works on standard input and output (inetd-type program); this option excludes the `--remote-mta' option") },
#line 86 "env.opt"

#line 86
	{ "-m, --mode", N_("MODE"), 0, N_("Select operation mode; MODE is one of \"transparent\", \"auth\" or \"mda\"") },
#line 94 "env.opt"

#line 94
	{ "-f, --foreground", NULL, 0, N_("Foreground mode") },
#line 100 "env.opt"

#line 100
	{ "--from", N_("EMAIL"), 0, N_("Specify sender address (implies MDA mode)") },
#line 107 "env.opt"

#line 107
	{ "-i, --stdio", NULL, 0, N_("Use the SMTP protocol (OMP/Tunnel) as described in RFC 821 on standard input and output") },
#line 113 "env.opt"

#line 113
	{ "-S", NULL, 0, N_("listen on file descriptor 3") },
#line 117 "env.opt"

#line 117
	{ NULL, NULL, 0, N_("Output options") },
#line 120 "env.opt"

#line 120
	{ "-s, --silent", NULL, 0, N_("Work silently") },
#line 126 "env.opt"

#line 126
	{ "-v, --verbose", NULL, 0, N_("Work noisily") },
#line 132 "env.opt"

#line 132
	{ "-D, --debug", NULL, 0, N_("Debug mode") },
#line 137 "env.opt"

#line 137
	{ NULL, NULL, 0, N_("Miscellaneous options") },
#line 141 "env.opt"

#line 141
	{ "--altrc", N_("FILE"), 0, N_("Specify alternate system configuration file") },
#line 148 "env.opt"

#line 148
	{ "--norc", NULL, 0, N_("Ignore system configuration file") },
#line 154 "env.opt"

#line 154
	{ "-c, --check-config", N_("DEBUG-LEVEL"), 0, N_("Run the configuration file syntax checker") },
#line 161 "env.opt"

#line 161
	{ "--show-config-options", NULL, 0, N_("Print a list of configuration options used to build GNU Anubis") },
#line 167 "env.opt"

#line 167
	{ "--location-column", NULL, 0, N_("Print location column numbers in parser diagnostics") },
#line 173 "env.opt"

#line 173
	{ "--relax-perm-check", NULL, 0, N_("Do not check user configuration file permissions") },
#line 179 "env.opt"

#line 179
	{ "--pid-file", N_("FILE"), 0, N_("Store the PID of the running daemon in FILE") },
#line 183 "env.opt"

#line 183
	{ NULL, NULL, 0, N_("Other options") },
#line 183 "env.opt"

#line 183
	{ "-h, --help", NULL, 0, N_("Give this help list") },
#line 183 "env.opt"

#line 183
	{ "--usage", NULL, 0, N_("Give a short usage message") },
#line 183 "env.opt"

#line 183
	{ "--version", NULL, 0, N_("Print program version") },

#line 183 "env.opt"
};
#line 39 "env.opt"

#line 39
const char *program_version = "anubis" " (" PACKAGE_STRING ")";
#line 39
static char doc[] = N_("SMTP message submission daemon.");
#line 39
static char args_doc[] = N_("");
#line 39
static char *after_desc = NULL;
#line 39
const char *program_bug_address = "<" PACKAGE_BUGREPORT ">";
#line 39
		    
#line 39
#define DESCRCOLUMN 30
#line 39
#define RMARGIN 79
#line 39
#define GROUPCOLUMN 2
#line 39
#define USAGECOLUMN 13
#line 39
		    
#line 39
static void
#line 39
indent (size_t start, size_t col)
#line 39
{
#line 39
  for (; start < col; start++)
#line 39
    putchar (' ');
#line 39
}
#line 39
		    
#line 39
static void
#line 39
print_option_descr (const char *descr, size_t lmargin, size_t rmargin)
#line 39
{
#line 39
  while (*descr)
#line 39
    {
#line 39
      int s = 0;
#line 39
      size_t i;
#line 39
      size_t width = rmargin - lmargin;
#line 39
      
#line 39
      while (*descr && (*descr == ' ' || *descr == '\t'))
#line 39
	descr++;
#line 39
      for (i = 0; ; i++)
#line 39
	{
#line 39
	  if (descr[i] == '\n')
#line 39
	    {
#line 39
	      s = i;
#line 39
	      break;
#line 39
	    }
#line 39
	  if (descr[i] == 0 || (descr[i] == ' ' || descr[i] == '\t'))
#line 39
	    {
#line 39
	      if (i > width)
#line 39
		break;
#line 39
	      s = i;
#line 39
	      if (descr[i] == 0)
#line 39
		break;
#line 39
	    }
#line 39
	}
#line 39
      if (s > width)
#line 39
	while (!(descr[s] == ' ' || descr[s] == '\t'))
#line 39
	  s--;
#line 39
      printf ("%*.*s\n", s, s, descr);
#line 39
      descr += s;
#line 39
      if (*descr)
#line 39
	{
#line 39
	  indent (0, lmargin);
#line 39
	  descr++;
#line 39
	}
#line 39
    }
#line 39
}
#line 39

#line 39
void
#line 39
print_help(void)
#line 39
{
#line 39
  unsigned i;
#line 39
  
#line 39
  printf ("%s %s [%s]... %s\n", _("Usage:"), "anubis", _("OPTION"),
#line 39
	  gettext (args_doc)); 
#line 39
  if (doc[0])
#line 39
    print_option_descr(gettext (doc), 0, RMARGIN);
#line 39
  putchar ('\n');
#line 39

#line 39
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 39
    {
#line 39
      unsigned n;
#line 39
      if (opthelp[i].opt)
#line 39
	{
#line 39
	  n = printf ("  %s", opthelp[i].opt);
#line 39
	  if (opthelp[i].arg)
#line 39
	    {
#line 39
	      char *cb, *ce;
#line 39
	      if (strlen (opthelp[i].opt) == 2)
#line 39
		{
#line 39
		  if (!opthelp[i].is_optional)
#line 39
		    {
#line 39
		      putchar (' ');
#line 39
		      n++;
#line 39
		    }
#line 39
		}
#line 39
	      else
#line 39
		{
#line 39
		  putchar ('=');
#line 39
		  n++;
#line 39
		}
#line 39
	      if (opthelp[i].is_optional)
#line 39
		{
#line 39
		  cb = "[";
#line 39
		  ce = "]";
#line 39
		}
#line 39
	      else
#line 39
		cb = ce = "";
#line 39
	      n += printf ("%s%s%s", cb, gettext (opthelp[i].arg), ce);
#line 39
	    }
#line 39
	  if (n >= DESCRCOLUMN)
#line 39
	    {
#line 39
	      putchar ('\n');
#line 39
	      n = 0;
#line 39
	    }
#line 39
	  indent (n, DESCRCOLUMN);
#line 39
	  print_option_descr (gettext (opthelp[i].descr), DESCRCOLUMN, RMARGIN);
#line 39
	}
#line 39
      else
#line 39
	{
#line 39
	  if (i)
#line 39
	    putchar ('\n');
#line 39
	  indent (0, GROUPCOLUMN);
#line 39
	  print_option_descr (gettext (opthelp[i].descr),
#line 39
			      GROUPCOLUMN, RMARGIN);
#line 39
	  putchar ('\n');
#line 39
	}
#line 39
    }
#line 39
  
#line 39
  putchar ('\n');
#line 39
  print_option_descr (_("Mandatory or optional arguments to long options are also mandatory or optional for any corresponding short options."), 0, RMARGIN);
#line 39
  putchar ('\n');
#line 39

#line 39
  if (after_desc)
#line 39
    {
#line 39
      print_option_descr (gettext (after_desc), 0, RMARGIN);
#line 39
    }	
#line 39
  printf (_("Report bugs to %s.\n"), program_bug_address);
#line 39
}
#line 39

#line 39
void
#line 39
print_usage(void)
#line 39
{
#line 39
  unsigned i;
#line 39
  int f = 0;
#line 39
  unsigned n;
#line 39
  char buf[RMARGIN+1];
#line 39

#line 39
#define FLUSH                        do                                   {                              	  buf[n] = 0;              	  printf ("%s\n", buf);    	  n = USAGECOLUMN;         	  memset (buf, ' ', n);        }                                while (0)
#line 39
#define ADDC(c)   do { if (n == RMARGIN) FLUSH; buf[n++] = c; } while (0)
#line 39

#line 39
  n = snprintf (buf, sizeof buf, "%s %s ", _("Usage:"), "anubis");
#line 39

#line 39
  /* Print a list of short options without arguments. */
#line 39
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 39
    {
#line 39
      if (opthelp[i].opt && opthelp[i].descr && opthelp[i].opt[1] != '-'
#line 39
	  && opthelp[i].arg == NULL)
#line 39
	{
#line 39
	  if (f == 0)
#line 39
	    {
#line 39
	      ADDC('[');
#line 39
	      ADDC('-');
#line 39
	      f = 1;
#line 39
	    }
#line 39
	  ADDC(opthelp[i].opt[1]);
#line 39
	}
#line 39
    }
#line 39
  if (f)
#line 39
    ADDC(']');
#line 39

#line 39
  /* Print a list of short options with arguments. */
#line 39
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 39
    {
#line 39
      if (opthelp[i].opt && opthelp[i].descr && opthelp[i].opt[1] != '-'
#line 39
	  && opthelp[i].arg)
#line 39
	{
#line 39
	  size_t len = 5 
#line 39
	                + strlen (opthelp[i].arg)
#line 39
			   + (opthelp[i].is_optional ? 2 : 1);
#line 39
	  if (n + len > RMARGIN) FLUSH;
#line 39
	  buf[n++] = ' '; 
#line 39
	  buf[n++] = '['; 
#line 39
	  buf[n++] = '-';
#line 39
	  buf[n++] = opthelp[i].opt[1];
#line 39
	  if (opthelp[i].is_optional)
#line 39
	    {
#line 39
	      buf[n++] = '[';
#line 39
	      strcpy (&buf[n], opthelp[i].arg);
#line 39
	      n += strlen (opthelp[i].arg);
#line 39
	      buf[n++] = ']';
#line 39
	    }
#line 39
	  else
#line 39
	    {
#line 39
	      buf[n++] = ' ';
#line 39
	      strcpy (&buf[n], opthelp[i].arg);
#line 39
	      n += strlen (opthelp[i].arg);
#line 39
	    }
#line 39
	  buf[n++] = ']';
#line 39
	}
#line 39
    }
#line 39

#line 39
  /* Print a list of long options */
#line 39
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 39
    {
#line 39
      if (opthelp[i].opt && opthelp[i].descr)
#line 39
	{
#line 39
	  size_t len;
#line 39
	  const char *longopt;
#line 39

#line 39
	  if (opthelp[i].opt[1] == '-')
#line 39
	    longopt = opthelp[i].opt;
#line 39
	  else if (opthelp[i].opt[2] == ',')
#line 39
	    longopt = opthelp[i].opt + 4;
#line 39
	  else
#line 39
	    continue;
#line 39

#line 39
	  len = 3 + strlen (longopt)
#line 39
	          + (opthelp[i].arg ? 1 + strlen (opthelp[i].arg)
#line 39
		      + (opthelp[i].is_optional ? 2 : 0) : 0);
#line 39
	  if (n + len > RMARGIN) FLUSH;
#line 39
	  buf[n++] = ' '; 
#line 39
	  buf[n++] = '['; 
#line 39
	  strcpy (&buf[n], longopt);
#line 39
	  n += strlen (longopt);
#line 39
	  if (opthelp[i].arg)
#line 39
	    {
#line 39
	      buf[n++] = '=';
#line 39
	      if (opthelp[i].is_optional)
#line 39
		{
#line 39
		  buf[n++] = '[';
#line 39
		  strcpy (&buf[n], opthelp[i].arg);
#line 39
		  n += strlen (opthelp[i].arg);
#line 39
		  buf[n++] = ']';
#line 39
		}
#line 39
	      else
#line 39
		{
#line 39
		  strcpy (&buf[n], opthelp[i].arg);
#line 39
		  n += strlen (opthelp[i].arg);
#line 39
		}
#line 39
	    }
#line 39
	  buf[n++] = ']';
#line 39
	}
#line 39
    }
#line 39
  FLUSH;
#line 39
  
#line 39
}
#line 39

#line 39
const char version_etc_copyright[] =
#line 39
  /* Do *not* mark this string for translation.  %s is a copyright
     symbol suitable for this locale. */
#line 39
  "Copyright %s 2001-2014 The Anubis Team.";
#line 39

#line 39
void
#line 39
print_version_only(const char *program_version, FILE *stream)
#line 39
{
#line 39
  fprintf (stream, "%s\n", program_version);
#line 39
  /* TRANSLATORS: Translate "(C)" to the copyright symbol
     (C-in-a-circle), if this symbol is available in the user's
     locale.  Otherwise, do not translate "(C)"; leave it as-is.  */
#line 39
  fprintf (stream, version_etc_copyright, _("(C)"));
#line 39
  fputc ('\n', stream);
#line 39
}
#line 39

#line 39
void
#line 39
print_version(const char *program_version, FILE *stream)
#line 39
{
#line 39
  print_version_only(program_version, stream);
#line 39
	
#line 39
  fputs (_("License GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>\nThis is free software: you are free to change and redistribute it.\nThere is NO WARRANTY, to the extent permitted by law.\n\n"),
#line 39
	 stream);
#line 39
}
#line 39

#line 183 "env.opt"

#line 183


int x_argc;
char **x_argv;

void
get_options (int argc, char *argv[])
{
  
#line 191
 {
#line 191
  int c;
#line 191

#line 191
  while ((c = getopt_long(argc, argv, "b:r:l:m:fiSsvDc:h",
#line 191
                          long_options, NULL)) != EOF)
#line 191
    {
#line 191
      switch (c)
#line 191
        {
#line 191
        default:
#line 191
	   exit(1);
#line 191
	#line 45 "env.opt"
	 case 'b':
#line 45
          {
#line 45

	  parse_mtahost (optarg, &session.anubis, &session.anubis_port);
	  if (session.anubis && strlen (session.anubis) != 0)
	    topt |= T_NAMES;
	  rc_disable_keyword (CF_INIT | CF_SUPERVISOR, "bind");

#line 50
             break;
#line 50
          }
#line 55 "env.opt"
	 case 'r':
#line 55
          {
#line 55

	  parse_mtaport (optarg, &session.mta, &session.mta_port);

#line 57
             break;
#line 57
          }
#line 63 "env.opt"
	 case 'l':
#line 63
          {
#line 63

          wordsplit_t ws;

          if (wordsplit (optarg, &ws,
		         WRDSF_NOVAR | WRDSF_NOCMD | WRDSF_SQUEEZE_DELIMS))
            {
 	       anubis_error (EX_SOFTWARE, 0, _("wordsplit failed: %s"),
                             wordsplit_strerror (&ws));
            }
          else
            {
               size_t n;
               wordsplit_get_words (&ws, &n, &session.execargs);
               wordsplit_free (&ws);
	       session.execpath = strdup (session.execargs[0]);
	       topt |= T_LOCAL_MTA;
	       rc_disable_keyword (CF_INIT | CF_SUPERVISOR, "local-mta");
            }

#line 81
             break;
#line 81
          }
#line 86 "env.opt"
	 case 'm':
#line 86
          {
#line 86

	  if (anubis_set_mode (optarg))
            anubis_error (1, 0, _("invalid mode: %s"), optarg);
	  rc_disable_keyword (CF_INIT | CF_SUPERVISOR, "mode");

#line 90
             break;
#line 90
          }
#line 94 "env.opt"
	 case 'f':
#line 94
          {
#line 94

	  topt |= T_FOREGROUND_INIT;

#line 96
             break;
#line 96
          }
#line 100 "env.opt"
	 case OPTION_FROM:
#line 100
          {
#line 100

	  assign_string (&from_address, optarg);

#line 102
             break;
#line 102
          }
#line 107 "env.opt"
	 case 'i':
#line 107
          {
#line 107

	  topt |= T_STDINOUT;

#line 109
             break;
#line 109
          }
#line 113 "env.opt"
	 case 'S':
#line 113
          {
#line 113

       topt |= T_PASSFD;

#line 115
             break;
#line 115
          }
#line 120 "env.opt"
	 case 's':
#line 120
          {
#line 120

	  options.termlevel = SILENT;
	  rc_disable_keyword (CF_INIT | CF_SUPERVISOR, "termlevel");

#line 123
             break;
#line 123
          }
#line 126 "env.opt"
	 case 'v':
#line 126
          {
#line 126

	  options.termlevel = VERBOSE;
	  rc_disable_keyword (CF_INIT | CF_SUPERVISOR, "termlevel");

#line 129
             break;
#line 129
          }
#line 132 "env.opt"
	 case 'D':
#line 132
          {
#line 132

	  options.termlevel = DEBUG;
	  rc_disable_keyword (CF_INIT | CF_SUPERVISOR, "termlevel");

#line 135
             break;
#line 135
          }
#line 141 "env.opt"
	 case OPTION_ALTRC:
#line 141
          {
#line 141

	  options.altrc = optarg;
	  topt |= T_ALTRC;

#line 144
             break;
#line 144
          }
#line 148 "env.opt"
	 case OPTION_NORC:
#line 148
          {
#line 148

	  topt |= T_NORC;

#line 150
             break;
#line 150
          }
#line 154 "env.opt"
	 case 'c':
#line 154
          {
#line 154

	  rc_set_debug_level (optarg);
	  topt |= T_CHECK_CONFIG;

#line 157
             break;
#line 157
          }
#line 161 "env.opt"
	 case OPTION_SHOW_CONFIG_OPTIONS:
#line 161
          {
#line 161

	  print_config_options ();

#line 163
             break;
#line 163
          }
#line 167 "env.opt"
	 case OPTION_LOCATION_COLUMN:
#line 167
          {
#line 167

	  topt |= T_LOCATION_COLUMN;

#line 169
             break;
#line 169
          }
#line 173 "env.opt"
	 case OPTION_RELAX_PERM_CHECK:
#line 173
          {
#line 173

	  topt |= T_RELAX_PERM_CHECK;

#line 175
             break;
#line 175
          }
#line 179 "env.opt"
	 case OPTION_PID_FILE:
#line 179
          {
#line 179

	  pidfile = optarg;

#line 181
             break;
#line 181
          }
#line 183 "env.opt"
	 case 'h':
#line 183
          {
#line 183

#line 183
		print_help ();
#line 183
                exit (0);
#line 183
	 
#line 183
             break;
#line 183
          }
#line 183 "env.opt"
	 case OPTION_USAGE:
#line 183
          {
#line 183

#line 183
		print_usage ();
#line 183
		exit (0);
#line 183
	 
#line 183
             break;
#line 183
          }
#line 183 "env.opt"
	 case OPTION_VERSION:
#line 183
          {
#line 183

#line 183
		/* Give version */
#line 183
		print_version(program_version, stdout);
#line 183
		exit (0);
#line 183
         
#line 183
             break;
#line 183
          }

#line 191 "env.opt"
        }
#line 191
    }
#line 191
  
#line 191
 }   
#line 191

  x_argc = argc - optind;
  x_argv = argv + optind;

  if (from_address)  /* Force MDA mode */
    anubis_mode = anubis_mda;
}

/*********************
 Get a home directory
**********************/

void
get_homedir (char *user, char *buf, int maxsize)
{
  struct passwd *pwd;
  memset (buf, 0, maxsize);

  if (user == 0)
    return;

  pwd = getpwnam (user);
  if (pwd)
    strncpy (buf, (char *) pwd->pw_dir, maxsize - 1);
  else
    {
      char *p = getenv ("HOME");
      if (p)
	strncpy (buf, p, maxsize - 1);
      else
	strncpy (buf, "", 1);
    }
  return;
}

/*****************************
 Get a real user name (login)
******************************/

void
anubis_getlogin (char **buf)
{
  struct passwd *pwd;

  pwd = getpwuid (getuid ());
  assign_string (buf, pwd ? pwd->pw_name : getlogin ());
}

/*******************
 Check current RUID
********************/

int
check_superuser (void)
{
  if (getuid () == 0)
    return 1;			/* a super-user */
  return 0;
}

/*******************************************
 Set USER's RGID, RUID, and home directory.
********************************************/

/* Change to the given uid/gid. Clear the supplementary group list.
   On success returns 0.
   On failure returns 1 (or exits, depending on topt settings. See
   anubis_error) */
static int
change_privs (uid_t uid, gid_t gid)
{
  int rc = 0;
  gid_t emptygidset[1];

  /* Reset group permissions */
  emptygidset[0] = gid ? gid : getegid();
  if (geteuid() == 0 && setgroups(1, emptygidset))
    {
      anubis_error (0, errno,
		    _("setgroups(1, %lu) failed"),
		    (u_long) emptygidset[0]);
      rc = 1;
    }

  /* Switch to the user's gid. On some OSes the effective gid must
     be reset first */

#if defined(HAVE_SETEGID)
  if ((rc = setegid(gid)) < 0)
    anubis_error (0, errno, _("setegid(%lu) failed"), (u_long) gid);
#elif defined(HAVE_SETREGID)
  if ((rc = setregid(gid, gid)) < 0)
    anubis_error (0, errno, _("setregid(%lu,%lu) failed"),
		  (u_long) gid, (u_long) gid);
#elif defined(HAVE_SETRESGID)
  if ((rc = setresgid(gid, gid, gid)) < 0)
    anubis_error (0, errno, _("setresgid(%lu,%lu,%lu) failed"),
		  (u_long) gid,
		  (u_long) gid,
		  (u_long) gid);
#endif

  if (rc == 0 && gid != 0)
    {
      if ((rc = setgid(gid)) < 0 && getegid() != gid) 
	anubis_error (0, errno, _("setgid(%lu) failed"), (u_long) gid);
      if (rc == 0 && getegid() != gid)
	{
	  anubis_error (0, errno, _("cannot set effective gid to %lu"),
			(u_long) gid);
	  rc = 1;
	}
    }

  /* Now reset uid */
  if (rc == 0 && uid != 0)
    {
      uid_t euid;

      if (setuid(uid)
	  || geteuid() != uid
	  || (getuid() != uid
	      && (geteuid() == 0 || getuid() == 0)))
	{
			
#if defined(HAVE_SETREUID)
	  if (geteuid() != uid)
	    {
	      if (setreuid(uid, -1) < 0)
		{
		  anubis_error (0, errno, _("setreuid(%lu,-1) failed"),
				(u_long) uid);
		  rc = 1;
		}
	      if (setuid(uid) < 0)
		{
		  anubis_error (0, errno, _("second setuid(%lu) failed"),
				(u_long) uid);
		  rc = 1;
		}
	    }
	  else
#endif
	    {
	      anubis_error (0, errno, _("setuid(%lu) failed"), (u_long) uid);
	      rc = 1;
	    }
	}
	

      euid = geteuid();
      if (uid != 0 && setuid(0) == 0)
	{
	  anubis_error (0, 0, _("seteuid(0) succeeded when it should not"));
	  rc = 1;
	}
      else if (uid != euid && setuid(euid) == 0)
	{
	  anubis_error (0, 0, _("cannot drop non-root setuid privileges"));
	  rc = 1;
	}
    }
  return rc;
}

void
anubis_changeowner (const char *user)
{
  struct passwd *pwd;

  if (user == NULL || check_superuser () == 0)
    return;

#ifdef HAVE_PAM
  if (use_pam)
    {
      int pam_retval = pam_start ("anubis", user, &conv, &pamh);
      if (pam_retval == PAM_SUCCESS)
	pam_retval = pam_authenticate (pamh, 0);
      if (pam_retval == PAM_SUCCESS)
	pam_retval = pam_acct_mgmt (pamh, 0);
      if (pam_retval == PAM_SUCCESS)
	pam_retval = pam_open_session (pamh, 0);
      if (pam_retval == PAM_SUCCESS)
	info (VERBOSE, _("PAM: Session opened (restrictions applied)."));
      else
	{
	  info (NORMAL, _("PAM: Not authenticated to use GNU Anubis."));
	  quit (EXIT_FAILURE);
	}
    }
#endif /* HAVE_PAM */

  pwd = getpwnam (user);
  if (pwd)
    {
      if (change_privs (pwd->pw_uid, pwd->pw_gid))
	quit (EXIT_FAILURE);
	
      chdir (pwd->pw_dir);
      info (VERBOSE, _("UID:%d (%s), GID:%d, EUID:%d, EGID:%d"),
	    (int) getuid (), pwd->pw_name, (int) getgid (),
	    (int) geteuid (), (int) getegid ());
    }
  return;
}

int
check_username (char *user)
{
  struct passwd *pwd;

  if (user == NULL)
    return 0;

  pwd = getpwnam (user);
  if (pwd == 0)
    {
      int i = 0;
      int digits = 0;
      int len = strlen (user);

      for (i = len - 1; i >= 0; i--)
	{
	  if (isdigit ((u_char) user[i]))
	    digits++;
	}
      if (digits == len)
	{
	  int uid = atoi (user);
	  pwd = getpwuid (uid);
	  if (pwd != 0)
	    strncpy (user, (char *) pwd->pw_name, 64);
	  else
	    {
	      info (NORMAL, _("Invalid user ID: %s"), user);
	      return 0;		/* FALSE */
	    }
	}
      else
	{
	  info (NORMAL, _("Invalid user name: %s"), user);
	  return 0;		/* FALSE */
	}
    }
  return 1;			/* TRUE */
}

/*************************
 Check a file permissions
**************************/

int
check_filemode (char *path)
{
  struct stat st;

  if (path == 0)
    return 0;

  if (stat (path, &st) == -1)
    return 0;
  if ((st.st_mode & S_IRWXG) || (st.st_mode & S_IRWXO))
    {
      anubis_error (0, 0, _("Wrong permissions on %s. Set 0600."), path);
      return 0;			/* FALSE */
    }
  return 1;			/* TRUE */
}

/*************************
 Check does a file exist?
**************************/

int
check_filename (char *path, time_t *timep)
{
  struct stat st;

  if (path == NULL)
    return 0;

  if (stat (path, &st) == -1)
    {
      anubis_error (0, errno, "%s", path);
      return 0;			/* FALSE */
    }
  if (!(st.st_mode & S_IFREG) || !(st.st_mode & S_IFLNK))
    {
      anubis_error (0, 0,
		    _("%s is not a regular file or a symbolic link."), path);
      return 0;			/* FALSE */
    }

  if (timep)
    {
      time_t mtime = *timep;
      *timep = st.st_mtime;
      return st.st_mtime > mtime;
    }
  return 1;			/* TRUE */
}

/* Select working mode */
int
anubis_set_mode (char *modename)
{
  if (strcmp (modename, "transparent") == 0)
    anubis_mode = anubis_transparent;
  else if (strcmp (modename, "proxy") == 0)
    anubis_mode = anubis_proxy; 
#if WITH_GSASL
  else if (strcmp (modename, "auth") == 0)
    anubis_mode = anubis_authenticate;
#endif
  else if (strcmp (modename, "mda") == 0)
    anubis_mode = anubis_mda;
  else
    return 1;
  return 0;
}

void
write_pid_file (void)
{
  FILE *fp;
  
  if (!pidfile)
    pidfile = "/var/run/" DEFAULT_PIDFILE;
  fp = fopen (pidfile, "w");
  if (!fp)
    anubis_error (0, errno, _("Cannot open pid file '%s'"), pidfile);
  else 
    {
      fprintf (fp, "%ld\n", (unsigned long) getpid ());
      fclose (fp);
    }
}
/* EOF */
