#! /bin/sh
# -*- ksh -*-

# This program checks that a2ps correctly backups only when needed

: ${SRCDIR=.}

# failure?
fail=0

# Set up other vars
. $SRCDIR/defs || exit 1

# The output test file
out=/tmp/_bkp$$_

# The options to run with
OPT="--version-control=simple"

# It should first save a backup and then make the new file
/bin/rm -f $out $out~
: > $out
echo 1 | $CHK $OPT -o $out 2> /dev/null
test $? = 0 || fail=1
test -f $out~ || fail=1

# It should not backup /dev/null (what is not possible, hence raises an error)
echo 2 | $CHK $OPT -o /dev/null 2> /dev/null
test $? = 0 || fail=1

# It should not succeed in backuping up a file which permissions
# would have made output impossible.  Hence, it should fail, not
# create the backup file, nor remove the original
/bin/rm -f $out $out~
: > $out
chmod 077 $out
echo 3 | $CHK $OPT -o $out 2> /dev/null
test $? = 0 && fail=1
test -f $out || fail=1
test -f $out~ && fail=1

# It should not backup when not required :), but succeed
/bin/rm -f $out $out~
: > $out
echo 4 | $CHK --version-control=none -o $out 2> /dev/null
test $? = 0 || fail=1
test -f $out || fail=1
test -f $out~ && fail=1

# End of the tests: clean up, and report status
/bin/rm -f $out $out~
exit $fail
