/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.exif.CanonMakernoteDirectory;
import com.drew.metadata.exif.CasioType1MakernoteDirectory;
import com.drew.metadata.exif.CasioType2MakernoteDirectory;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifInteropDirectory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import com.drew.metadata.exif.FujifilmMakernoteDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.exif.KodakMakernoteDirectory;
import com.drew.metadata.exif.KyoceraMakernoteDirectory;
import com.drew.metadata.exif.NikonType1MakernoteDirectory;
import com.drew.metadata.exif.NikonType2MakernoteDirectory;
import com.drew.metadata.exif.OlympusMakernoteDirectory;
import com.drew.metadata.exif.PanasonicMakernoteDirectory;
import com.drew.metadata.exif.PentaxMakernoteDirectory;
import com.drew.metadata.exif.SigmaMakernoteDirectory;
import com.drew.metadata.exif.SonyType1MakernoteDirectory;
import com.drew.metadata.exif.SonyType6MakernoteDirectory;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifReader
implements MetadataReader {
    @NotNull
    private static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int MAX_FORMAT_CODE = 12;
    private static final int FMT_BYTE = 1;
    private static final int FMT_STRING = 2;
    private static final int FMT_USHORT = 3;
    private static final int FMT_ULONG = 4;
    private static final int FMT_URATIONAL = 5;
    private static final int FMT_SBYTE = 6;
    private static final int FMT_UNDEFINED = 7;
    private static final int FMT_SSHORT = 8;
    private static final int FMT_SLONG = 9;
    private static final int FMT_SRATIONAL = 10;
    private static final int FMT_SINGLE = 11;
    private static final int FMT_DOUBLE = 12;
    public static final int TAG_EXIF_SUB_IFD_OFFSET = 34665;
    public static final int TAG_INTEROP_OFFSET = 40965;
    public static final int TAG_GPS_INFO_OFFSET = 34853;
    public static final int TAG_MAKER_NOTE_OFFSET = 37500;
    public static final int TIFF_HEADER_START_OFFSET = 6;

    @Override
    public void extract(@NotNull BufferReader reader, @NotNull Metadata metadata) {
        ExifSubIFDDirectory directory = metadata.getOrCreateDirectory(ExifSubIFDDirectory.class);
        if (reader.getLength() <= 14L) {
            directory.addError("Exif data segment must contain at least 14 bytes");
            return;
        }
        try {
            if (!reader.getString(0, 6).equals("Exif\u0000\u0000")) {
                directory.addError("Exif data segment doesn't begin with 'Exif'");
                return;
            }
            this.extractIFD(metadata, metadata.getOrCreateDirectory(ExifIFD0Directory.class), 6, reader);
        }
        catch (BufferBoundsException e) {
            directory.addError("Exif data segment ended prematurely");
        }
    }

    public void extractTiff(@NotNull BufferReader reader, @NotNull Metadata metadata) {
        ExifIFD0Directory directory = metadata.getOrCreateDirectory(ExifIFD0Directory.class);
        try {
            this.extractIFD(metadata, directory, 0, reader);
        }
        catch (BufferBoundsException e) {
            directory.addError("Exif data segment ended prematurely");
        }
    }

    private void extractIFD(@NotNull Metadata metadata, @NotNull ExifIFD0Directory directory, int tiffHeaderOffset, @NotNull BufferReader reader) throws BufferBoundsException {
        String byteOrderIdentifier = reader.getString(tiffHeaderOffset, 2);
        if ("MM".equals(byteOrderIdentifier)) {
            reader.setMotorolaByteOrder(true);
        } else if ("II".equals(byteOrderIdentifier)) {
            reader.setMotorolaByteOrder(false);
        } else {
            directory.addError("Unclear distinction between Motorola/Intel byte ordering: " + byteOrderIdentifier);
            return;
        }
        if (reader.getUInt16(2 + tiffHeaderOffset) != 42) {
            directory.addError("Invalid Exif start - should have 0x2A at offset 8 in Exif header");
            return;
        }
        int firstDirectoryOffset = reader.getInt32(4 + tiffHeaderOffset) + tiffHeaderOffset;
        if ((long)firstDirectoryOffset >= reader.getLength() - 1L) {
            directory.addError("First exif directory offset is beyond end of Exif data segment");
            firstDirectoryOffset = 14;
        }
        HashSet<Integer> processedDirectoryOffsets = new HashSet<Integer>();
        this.processDirectory(directory, processedDirectoryOffsets, firstDirectoryOffset, tiffHeaderOffset, metadata, reader);
        ExifThumbnailDirectory thumbnailDirectory = metadata.getDirectory(ExifThumbnailDirectory.class);
        if (thumbnailDirectory != null && thumbnailDirectory.containsTag(259)) {
            Integer offset = thumbnailDirectory.getInteger(513);
            Integer length = thumbnailDirectory.getInteger(514);
            if (offset != null && length != null) {
                try {
                    byte[] thumbnailData = reader.getBytes(tiffHeaderOffset + offset, length);
                    thumbnailDirectory.setThumbnailData(thumbnailData);
                }
                catch (BufferBoundsException ex) {
                    directory.addError("Invalid thumbnail data specification: " + ex.getMessage());
                }
            }
        }
    }

    private void processDirectory(@NotNull Directory directory, @NotNull Set<Integer> processedDirectoryOffsets, int dirStartOffset, int tiffHeaderOffset, @NotNull Metadata metadata, @NotNull BufferReader reader) throws BufferBoundsException {
        if (processedDirectoryOffsets.contains(dirStartOffset)) {
            return;
        }
        processedDirectoryOffsets.add(dirStartOffset);
        if ((long)dirStartOffset >= reader.getLength() || dirStartOffset < 0) {
            directory.addError("Ignored directory marked to start outside data segment");
            return;
        }
        int dirTagCount = reader.getUInt16(dirStartOffset);
        int dirLength = 2 + 12 * dirTagCount + 4;
        if ((long)(dirLength + dirStartOffset) > reader.getLength()) {
            directory.addError("Illegally sized directory");
            return;
        }
        block6: for (int tagNumber = 0; tagNumber < dirTagCount; ++tagNumber) {
            int tagValueOffset;
            int tagOffset = this.calculateTagOffset(dirStartOffset, tagNumber);
            int tagType = reader.getUInt16(tagOffset);
            int formatCode = reader.getUInt16(tagOffset + 2);
            if (formatCode < 1 || formatCode > 12) {
                directory.addError("Invalid TIFF tag format code: " + formatCode);
                return;
            }
            int componentCount = reader.getInt32(tagOffset + 4);
            if (componentCount < 0) {
                directory.addError("Negative TIFF tag component count");
                continue;
            }
            int byteCount = componentCount * BYTES_PER_FORMAT[formatCode];
            if (byteCount > 4) {
                int offsetVal = reader.getInt32(tagOffset + 8);
                if ((long)(offsetVal + byteCount) > reader.getLength()) {
                    directory.addError("Illegal TIFF tag pointer offset");
                    continue;
                }
                tagValueOffset = tiffHeaderOffset + offsetVal;
            } else {
                tagValueOffset = tagOffset + 8;
            }
            if (tagValueOffset < 0 || (long)tagValueOffset > reader.getLength()) {
                directory.addError("Illegal TIFF tag pointer offset");
                continue;
            }
            if (byteCount < 0 || (long)(tagValueOffset + byteCount) > reader.getLength()) {
                directory.addError("Illegal number of bytes: " + byteCount);
                continue;
            }
            switch (tagType) {
                case 34665: {
                    int subdirOffset = tiffHeaderOffset + reader.getInt32(tagValueOffset);
                    this.processDirectory(metadata.getOrCreateDirectory(ExifSubIFDDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset, metadata, reader);
                    continue block6;
                }
                case 40965: {
                    int subdirOffset = tiffHeaderOffset + reader.getInt32(tagValueOffset);
                    this.processDirectory(metadata.getOrCreateDirectory(ExifInteropDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset, metadata, reader);
                    continue block6;
                }
                case 34853: {
                    int subdirOffset = tiffHeaderOffset + reader.getInt32(tagValueOffset);
                    this.processDirectory(metadata.getOrCreateDirectory(GpsDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset, metadata, reader);
                    continue block6;
                }
                case 37500: {
                    this.processMakerNote(tagValueOffset, processedDirectoryOffsets, tiffHeaderOffset, metadata, reader);
                    continue block6;
                }
                default: {
                    this.processTag(directory, tagType, tagValueOffset, componentCount, formatCode, reader);
                }
            }
        }
        int finalTagOffset = this.calculateTagOffset(dirStartOffset, dirTagCount);
        int nextDirectoryOffset = reader.getInt32(finalTagOffset);
        if (nextDirectoryOffset != 0) {
            if ((long)(nextDirectoryOffset += tiffHeaderOffset) >= reader.getLength()) {
                return;
            }
            if (nextDirectoryOffset < dirStartOffset) {
                return;
            }
            ExifThumbnailDirectory nextDirectory = metadata.getOrCreateDirectory(ExifThumbnailDirectory.class);
            this.processDirectory(nextDirectory, processedDirectoryOffsets, nextDirectoryOffset, tiffHeaderOffset, metadata, reader);
        }
    }

    private void processMakerNote(int subdirOffset, @NotNull Set<Integer> processedDirectoryOffsets, int tiffHeaderOffset, @NotNull Metadata metadata, @NotNull BufferReader reader) throws BufferBoundsException {
        ExifIFD0Directory ifd0Directory = metadata.getDirectory(ExifIFD0Directory.class);
        if (ifd0Directory == null) {
            return;
        }
        String cameraModel = ifd0Directory.getString(271);
        String firstThreeChars = reader.getString(subdirOffset, 3);
        String firstFourChars = reader.getString(subdirOffset, 4);
        String firstFiveChars = reader.getString(subdirOffset, 5);
        String firstSixChars = reader.getString(subdirOffset, 6);
        String firstSevenChars = reader.getString(subdirOffset, 7);
        String firstEightChars = reader.getString(subdirOffset, 8);
        String firstTwelveChars = reader.getString(subdirOffset, 12);
        if ("OLYMP".equals(firstFiveChars) || "EPSON".equals(firstFiveChars) || "AGFA".equals(firstFourChars)) {
            this.processDirectory(metadata.getOrCreateDirectory(OlympusMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 8, tiffHeaderOffset, metadata, reader);
        } else if (cameraModel != null && cameraModel.trim().toUpperCase().startsWith("NIKON")) {
            if ("Nikon".equals(firstFiveChars)) {
                switch (reader.getUInt8(subdirOffset + 6)) {
                    case 1: {
                        this.processDirectory(metadata.getOrCreateDirectory(NikonType1MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 8, tiffHeaderOffset, metadata, reader);
                        break;
                    }
                    case 2: {
                        this.processDirectory(metadata.getOrCreateDirectory(NikonType2MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 18, subdirOffset + 10, metadata, reader);
                        break;
                    }
                    default: {
                        ifd0Directory.addError("Unsupported Nikon makernote data ignored.");
                        break;
                    }
                }
            } else {
                this.processDirectory(metadata.getOrCreateDirectory(NikonType2MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset, metadata, reader);
            }
        } else if ("SONY CAM".equals(firstEightChars) || "SONY DSC".equals(firstEightChars)) {
            this.processDirectory(metadata.getOrCreateDirectory(SonyType1MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 12, tiffHeaderOffset, metadata, reader);
        } else if ("SIGMA\u0000\u0000\u0000".equals(firstEightChars) || "FOVEON\u0000\u0000".equals(firstEightChars)) {
            this.processDirectory(metadata.getOrCreateDirectory(SigmaMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 10, tiffHeaderOffset, metadata, reader);
        } else if ("SEMC MS\u0000\u0000\u0000\u0000\u0000".equals(firstTwelveChars)) {
            boolean isMotorola = reader.isMotorolaByteOrder();
            reader.setMotorolaByteOrder(true);
            this.processDirectory(metadata.getOrCreateDirectory(SonyType6MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 20, tiffHeaderOffset, metadata, reader);
            reader.setMotorolaByteOrder(isMotorola);
        } else if ("KDK".equals(firstThreeChars)) {
            this.processDirectory(metadata.getOrCreateDirectory(KodakMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 20, tiffHeaderOffset, metadata, reader);
        } else if ("Canon".equalsIgnoreCase(cameraModel)) {
            this.processDirectory(metadata.getOrCreateDirectory(CanonMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset, metadata, reader);
        } else if (cameraModel != null && cameraModel.toUpperCase().startsWith("CASIO")) {
            if ("QVC\u0000\u0000\u0000".equals(firstSixChars)) {
                this.processDirectory(metadata.getOrCreateDirectory(CasioType2MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 6, tiffHeaderOffset, metadata, reader);
            } else {
                this.processDirectory(metadata.getOrCreateDirectory(CasioType1MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset, metadata, reader);
            }
        } else if ("FUJIFILM".equals(firstEightChars) || "Fujifilm".equalsIgnoreCase(cameraModel)) {
            boolean byteOrderBefore = reader.isMotorolaByteOrder();
            reader.setMotorolaByteOrder(false);
            int ifdStart = subdirOffset + reader.getInt32(subdirOffset + 8);
            this.processDirectory(metadata.getOrCreateDirectory(FujifilmMakernoteDirectory.class), processedDirectoryOffsets, ifdStart, tiffHeaderOffset, metadata, reader);
            reader.setMotorolaByteOrder(byteOrderBefore);
        } else if (cameraModel != null && cameraModel.toUpperCase().startsWith("MINOLTA")) {
            this.processDirectory(metadata.getOrCreateDirectory(OlympusMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset, metadata, reader);
        } else if ("KYOCERA".equals(firstSevenChars)) {
            this.processDirectory(metadata.getOrCreateDirectory(KyoceraMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 22, tiffHeaderOffset, metadata, reader);
        } else if ("Panasonic\u0000\u0000\u0000".equals(reader.getString(subdirOffset, 12))) {
            this.processDirectory(metadata.getOrCreateDirectory(PanasonicMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 12, tiffHeaderOffset, metadata, reader);
        } else if ("AOC\u0000".equals(firstFourChars)) {
            this.processDirectory(metadata.getOrCreateDirectory(CasioType2MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 6, subdirOffset, metadata, reader);
        } else if (cameraModel != null && (cameraModel.toUpperCase().startsWith("PENTAX") || cameraModel.toUpperCase().startsWith("ASAHI"))) {
            this.processDirectory(metadata.getOrCreateDirectory(PentaxMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset, subdirOffset, metadata, reader);
        }
    }

    private void processTag(@NotNull Directory directory, int tagType, int tagValueOffset, int componentCount, int formatCode, @NotNull BufferReader reader) throws BufferBoundsException {
        switch (formatCode) {
            case 7: {
                directory.setByteArray(tagType, reader.getBytes(tagValueOffset, componentCount));
                break;
            }
            case 2: {
                String string = reader.getNullTerminatedString(tagValueOffset, componentCount);
                directory.setString(tagType, string);
                break;
            }
            case 10: {
                if (componentCount == 1) {
                    directory.setRational(tagType, new Rational(reader.getInt32(tagValueOffset), reader.getInt32(tagValueOffset + 4)));
                    break;
                }
                if (componentCount <= 1) break;
                Rational[] rationals = new Rational[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    rationals[i] = new Rational(reader.getInt32(tagValueOffset + 8 * i), reader.getInt32(tagValueOffset + 4 + 8 * i));
                }
                directory.setRationalArray(tagType, rationals);
                break;
            }
            case 5: {
                if (componentCount == 1) {
                    directory.setRational(tagType, new Rational(reader.getUInt32(tagValueOffset), reader.getUInt32(tagValueOffset + 4)));
                    break;
                }
                if (componentCount <= 1) break;
                Rational[] rationals = new Rational[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    rationals[i] = new Rational(reader.getUInt32(tagValueOffset + 8 * i), reader.getUInt32(tagValueOffset + 4 + 8 * i));
                }
                directory.setRationalArray(tagType, rationals);
                break;
            }
            case 11: {
                if (componentCount == 1) {
                    directory.setFloat(tagType, reader.getFloat32(tagValueOffset));
                    break;
                }
                float[] floats = new float[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    floats[i] = reader.getFloat32(tagValueOffset + i * 4);
                }
                directory.setFloatArray(tagType, floats);
                break;
            }
            case 12: {
                if (componentCount == 1) {
                    directory.setDouble(tagType, reader.getDouble64(tagValueOffset));
                    break;
                }
                double[] doubles = new double[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    doubles[i] = reader.getDouble64(tagValueOffset + i * 4);
                }
                directory.setDoubleArray(tagType, doubles);
                break;
            }
            case 6: {
                if (componentCount == 1) {
                    directory.setInt(tagType, reader.getInt8(tagValueOffset));
                    break;
                }
                int[] bytes = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    bytes[i] = reader.getInt8(tagValueOffset + i);
                }
                directory.setIntArray(tagType, bytes);
                break;
            }
            case 1: {
                if (componentCount == 1) {
                    directory.setInt(tagType, reader.getUInt8(tagValueOffset));
                    break;
                }
                int[] bytes = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    bytes[i] = reader.getUInt8(tagValueOffset + i);
                }
                directory.setIntArray(tagType, bytes);
                break;
            }
            case 3: {
                if (componentCount == 1) {
                    int i = reader.getUInt16(tagValueOffset);
                    directory.setInt(tagType, i);
                    break;
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = reader.getUInt16(tagValueOffset + i * 2);
                }
                directory.setIntArray(tagType, ints);
                break;
            }
            case 8: {
                if (componentCount == 1) {
                    short i = reader.getInt16(tagValueOffset);
                    directory.setInt(tagType, i);
                    break;
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = reader.getInt16(tagValueOffset + i * 2);
                }
                directory.setIntArray(tagType, ints);
                break;
            }
            case 4: 
            case 9: {
                if (componentCount == 1) {
                    int i = reader.getInt32(tagValueOffset);
                    directory.setInt(tagType, i);
                    break;
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = reader.getInt32(tagValueOffset + i * 4);
                }
                directory.setIntArray(tagType, ints);
                break;
            }
            default: {
                directory.addError("Unknown format code " + formatCode + " for tag " + tagType);
            }
        }
    }

    private int calculateTagOffset(int dirStartOffset, int entryNumber) {
        return dirStartOffset + 2 + 12 * entryNumber;
    }
}

