#!/usr/bin/perl

package eBay::API::XML::DataType::SellerPaymentType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SellerPaymentType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SellerPaymentType

=head1 DESCRIPTION

A payment between Half.com and a seller. The financial value of a payment is
typically based on an amount that a buyer paid to Half.com for a transaction, plus
the shipping cost the buyer paid for the item, minus Half.com's commission. Each
payment is for one transaction for one item in one order.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SellerPaymentType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::ExternalProductIDType;
use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::OrderIDType;
use eBay::API::XML::DataType::Enum::PaymentTypeCodeType;


my @gaProperties = ( [ 'AmountPaid', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'Commission', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ExternalProductID', 'ns:ExternalProductIDType', ''
	     ,'eBay::API::XML::DataType::ExternalProductIDType', '1' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'OrderID', 'ns:OrderIDType', ''
	     ,'eBay::API::XML::DataType::OrderIDType', '1' ]
	, [ 'PaidTime', 'xs:dateTime', '', '', '' ]
	, [ 'PaymentType', 'ns:PaymentTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PaymentTypeCodeType', '' ]
	, [ 'PrivateNotes', 'xs:string', '', '', '' ]
	, [ 'SellerInventoryID', 'xs:string', '', '', '' ]
	, [ 'ShippingReimbursement', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'Title', 'xs:string', '', '', '' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
	, [ 'TransactionPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAmountPaid()

Payment amount made by buyer for the Half.com transaction.

#    Argument: 'ns:AmountType'

=cut

sub setAmountPaid {
  my $self = shift;
  $self->{'AmountPaid'} = shift
}

=head2 getAmountPaid()

  Calls: GetSellerPayments
  Returned: Always

#    Returns: 'ns:AmountType'

=cut

sub getAmountPaid {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AmountPaid'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setCommission()

Amount of commission charged by Half.com.

#    Argument: 'ns:AmountType'

=cut

sub setCommission {
  my $self = shift;
  $self->{'Commission'} = shift
}

=head2 getCommission()

  Calls: GetSellerPayments
  Returned: Always

#    Returns: 'ns:AmountType'

=cut

sub getCommission {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Commission'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setExternalProductID()

Contains an ISBN, UPC, or EAN value from the catalog product associated with
the Half.com item. All Half.com items are listed with Pre-filled Item
Information.

#    Argument: 'ns:ExternalProductIDType'

=cut

sub setExternalProductID {
  my $self = shift;
  $self->{'ExternalProductID'} = shift
}

=head2 getExternalProductID()

  Calls: GetSellerPayments
  Returned: Always

#    Returns: 'ns:ExternalProductIDType'

=cut

sub getExternalProductID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ExternalProductID'
		,'eBay::API::XML::DataType::ExternalProductIDType');
}


=head2 setItemID()

ID of the Half.com item associated with the payment.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

  Calls: GetSellerPayments
  Returned: Always

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setOrderID()

ID of the Half.com order associated with the payment.
Returns 0 for single-transaction orders.

#    Argument: 'ns:OrderIDType'

=cut

sub setOrderID {
  my $self = shift;
  $self->{'OrderID'} = shift
}

=head2 getOrderID()

  Calls: GetSellerPayments
  Returned: Always

#    Returns: 'ns:OrderIDType'

=cut

sub getOrderID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'OrderID'
		,'eBay::API::XML::DataType::OrderIDType');
}


=head2 setPaidTime()

The time and date when Half.com created the payment. (A payment is created
when the buyer pays for an order.) This time is specified in GMT (not Pacific
time). See "Time Values" in the eBay Web Services guide for information about
converting between GMT and other time zones.

#    Argument: 'xs:dateTime'

=cut

sub setPaidTime {
  my $self = shift;
  $self->{'PaidTime'} = shift
}

=head2 getPaidTime()

  Calls: GetSellerPayments
  Returned: Always

#    Returns: 'xs:dateTime'

=cut

sub getPaidTime {
  my $self = shift;
  return $self->{'PaidTime'};
}


=head2 setPaymentType()

Indicates whether the payment is for a Half.com sale or a refund.

#    Argument: 'ns:PaymentTypeCodeType'

=cut

sub setPaymentType {
  my $self = shift;
  $self->{'PaymentType'} = shift
}

=head2 getPaymentType()

  Calls: GetSellerPayments
  Returned: Always
  OnlyTheseValues: Sale, Refund

#    Returns: 'ns:PaymentTypeCodeType'

=cut

sub getPaymentType {
  my $self = shift;
  return $self->{'PaymentType'};
}


=head2 setPrivateNotes()

A text note that the seller specified for the Half.com item, if any. Only
visible to the seller. Not returned if the seller specified no notes.

#    Argument: 'xs:string'

=cut

sub setPrivateNotes {
  my $self = shift;
  $self->{'PrivateNotes'} = shift
}

=head2 getPrivateNotes()

  Calls: GetSellerPayments
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getPrivateNotes {
  my $self = shift;
  return $self->{'PrivateNotes'};
}


=head2 setSellerInventoryID()

An ID that the seller specified when they listed the Half.com item, if any. It
can be used for the seller's SKU. Note that SellerInventoryID is not returned
if no ID was specified. (Note: The SKU field used for eBay.com listings is not
applicable to Half.com listings.)

#    Argument: 'xs:string'

=cut

sub setSellerInventoryID {
  my $self = shift;
  $self->{'SellerInventoryID'} = shift
}

=head2 getSellerInventoryID()

  Calls: GetSellerPayments
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getSellerInventoryID {
  my $self = shift;
  return $self->{'SellerInventoryID'};
}


=head2 setShippingReimbursement()

The adjusted shipping cost that Half.com pays the seller. If multiple items
from the same seller are in the same order, this amount may be less than the
rate for shipping the item individually. This amount may also be adjusted due
to Half.com handling charges. (Due to the way shipping costs are calculated,
this value may be different for identical items in different orders.)

#    Argument: 'ns:AmountType'

=cut

sub setShippingReimbursement {
  my $self = shift;
  $self->{'ShippingReimbursement'} = shift
}

=head2 getShippingReimbursement()

  Calls: GetSellerPayments
  Returned: Always

#    Returns: 'ns:AmountType'

=cut

sub getShippingReimbursement {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingReimbursement'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setTitle()

The title of the listing, as it appears on Half.com.

#    Argument: 'xs:string'

=cut

sub setTitle {
  my $self = shift;
  $self->{'Title'} = shift
}

=head2 getTitle()

  Calls: GetSellerPayments
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getTitle {
  my $self = shift;
  return $self->{'Title'};
}


=head2 setTransactionID()

ID of the Half.com transaction associated with the payment.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

  Calls: GetSellerPayments
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}


=head2 setTransactionPrice()

Price of the transaction specified by TransactionID (before shipping and other
costs).

#    Argument: 'ns:AmountType'

=cut

sub setTransactionPrice {
  my $self = shift;
  $self->{'TransactionPrice'} = shift
}

=head2 getTransactionPrice()

  Calls: GetSellerPayments
  Returned: Always

#    Returns: 'ns:AmountType'

=cut

sub getTransactionPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TransactionPrice'
		,'eBay::API::XML::DataType::AmountType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
