/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.File;
import java.io.Serializable;
import java.util.Formatter;
import thredds.filesystem.CacheFile;
import ucar.unidata.util.StringUtil;

public class CacheDirectory
extends CacheFile
implements Serializable {
    private String parentDirName;
    private CacheFile[] children;

    public CacheDirectory(File dir) {
        super(dir);
        this.parentDirName = StringUtil.replace(dir.getParent(), '\\', "/");
        File[] subs = dir.listFiles();
        if (subs == null) {
            subs = new File[]{};
        }
        this.children = new CacheFile[subs.length];
        int count = 0;
        for (File f : subs) {
            this.children[count++] = new CacheFile(f);
        }
    }

    public String getPath() {
        return this.parentDirName + "/" + this.getShortName();
    }

    public CacheFile[] getChildren() {
        return this.children;
    }

    public String toString() {
        Formatter p = new Formatter();
        p.format("CacheDirector path=%s num=%d %n", this.getPath(), this.children.length);
        for (CacheFile f : this.children) {
            p.format("  %s%n", f);
        }
        return p.toString();
    }
}

