/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.control.handlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.control.CommandStatus;
import org.couchbase.mock.control.MockCommand;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.protocol.ErrorCode;
import org.jetbrains.annotations.NotNull;

public class OpfailCommandHandler
extends MockCommand {
    @Override
    public CommandStatus execute(@NotNull CouchbaseMock mock, @NotNull MockCommand.Command command, @NotNull JsonObject payload) {
        ErrorCode eCode = ErrorCode.SUCCESS;
        boolean eCodeFound = false;
        JsonElement eServerList = null;
        if (payload.has("servers")) {
            eServerList = payload.get("servers");
        }
        LinkedList<Integer> serverList = new LinkedList<Integer>();
        if (eServerList != null) {
            for (JsonElement ix : eServerList.getAsJsonArray()) {
                serverList.add(ix.getAsInt());
            }
        }
        int count = payload.get("count").getAsInt();
        int iCode = payload.get("code").getAsInt();
        for (ErrorCode rc : ErrorCode.values()) {
            if (iCode != rc.value()) continue;
            eCode = rc;
            eCodeFound = true;
            break;
        }
        if (!eCodeFound) {
            return new CommandStatus().fail("Invalid error code");
        }
        for (Bucket bucket : mock.getBuckets().values()) {
            MemcachedServer[] servers = bucket.getServers();
            for (int ii = 0; ii < servers.length; ++ii) {
                if (serverList.size() > 0 && !serverList.contains(ii)) continue;
                servers[ii].updateFailMakerContext(eCode, count);
            }
        }
        return new CommandStatus();
    }
}

