#!/usr/bin/perl

package eBay::API::XML::Call::GetUserContactDetails::GetUserContactDetailsResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetUserContactDetailsResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetUserContactDetails::GetUserContactDetailsResponseType

=head1 DESCRIPTION

Returns contact information to a seller for both bidders
and users who have made offers (via Best Offer) during
an active listing.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetUserContactDetails::GetUserContactDetailsResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::AddressType;


my @gaProperties = ( [ 'ContactAddress', 'ns:AddressType', ''
	     ,'eBay::API::XML::DataType::AddressType', '1' ]
	, [ 'RegistrationDate', 'xs:dateTime', '', '', '' ]
	, [ 'UserID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setContactAddress()

Contact information for the requested contact.
Note that the email address is NOT returned.

#    Argument: 'ns:AddressType'

=cut

sub setContactAddress {
  my $self = shift;
  $self->{'ContactAddress'} = shift
}

=head2 getContactAddress()

  Returned: Always
#    Returns: 'ns:AddressType'

=cut

sub getContactAddress {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ContactAddress'
		,'eBay::API::XML::DataType::AddressType');
}


=head2 setRegistrationDate()

The date and time that the requested contact
registered with eBay.

#    Argument: 'xs:dateTime'

=cut

sub setRegistrationDate {
  my $self = shift;
  $self->{'RegistrationDate'} = shift
}

=head2 getRegistrationDate()

  Returned: Always
#    Returns: 'xs:dateTime'

=cut

sub getRegistrationDate {
  my $self = shift;
  return $self->{'RegistrationDate'};
}


=head2 setUserID()

An eBay ID that uniquely identifies a given
user. The eBay username of the requested
contact.

#    Argument: 'xs:string'

=cut

sub setUserID {
  my $self = shift;
  $self->{'UserID'} = shift
}

=head2 getUserID()

  Returned: Always
#    Returns: 'xs:string'

=cut

sub getUserID {
  my $self = shift;
  return $self->{'UserID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
