use strict;
use warnings;
use ExtUtils::MakeMaker;

# buffering will ruin your day!
select STDERR; $|=1;
select STDOUT; $|=1;

# prereqs
my $EX_version   = 0;      # Exporter
my $DL_version   = 0;      # DynaLoader
my $EUMM_version = '6.64'; # ExtUtils::MakeMaker
my $TM_version   = 0;      # Test::More

my $UUID_version = get_uuidpm_version();

sub get_uuidpm_version {
    open my $fh, '<', 'UUID.pm' or die "open: UUID.pm: $!";
    while (<$fh>) {
        # $VERSION = '0.30_02';
        return $1
            if /^\$VERSION = '([\d\.\_]+)';$/;
    }
    return undef;
}

WriteMakefile1(
    'NAME'             => 'UUID',
    'AUTHOR'           => 'Rick Myers <jrm@cpan.org>',
    'VERSION_FROM'     => 'UUID.pm',
    'ABSTRACT_FROM'    => 'UUID.pm',
    'LICENSE'          => 'artistic_2',
    'MIN_PERL_VERSION' => '5.005',
    'LIBS'             => '',
    'NO_MYMETA'        => 1,
    'OBJECT'           => '$(O_FILES)',
    'LDFROM'           => join( ' ', qw{
        src/clear.o src/compare.o src/copy.o src/gen_uuid.o src/isnull.o
        src/pack.o src/parse.o src/unpack.o src/unparse.o
        src/uuid_time.o UUID.o
    }),
    'C' => [qw{
        src/clear.c src/compare.c src/copy.c src/gen_uuid.c src/isnull.c
        src/pack.c src/parse.c src/unpack.c src/unparse.c src/uuid_time.c
        UUID.c
    }],
    'H' => [qw{
        src/config.h
        src/uuid.h
        src/uuid_types.h
    }],
    'PREREQ_PM'          => {
        'DynaLoader' => $DL_version,
        'Exporter'   => $EX_version,
    },
    'CONFIGURE_REQUIRES' => {
        'ExtUtils::MakeMaker' => $EUMM_version,
    },
    'BUILD_REQUIRES' => {
        'ExtUtils::MakeMaker' => $EUMM_version,
    },
    'TEST_REQUIRES' => {
        'DynaLoader'         => $DL_version,
        'Exporter'           => $EX_version,
        'Test::More'         => $TM_version,
        'warnings'           => 0,
        'strict'             => 0,
        'CPAN::Meta'         => 0,
        'ExtUtils::Manifest' => 0,
        'lib'                => 0,
    },
    'META_MERGE' => {
        'dynamic_config' => 0,
        'provides' => {
            'UUID' => {
                'file'    => 'UUID.pm',
                'version' => $UUID_version,
            },
        },
    },
    'realclean' => {
        'FILES' => join( ' ', qw{
            perl.exe.stackdump src/config.h src/uuid.h src/uuid_types.h
        }),
    },
);

sub WriteMakefile1 {  #Written by Alexandr Ciornii, version 0.21. Added by eumm-upgrade.
    my %params=@_;
    my $eumm_version=$ExtUtils::MakeMaker::VERSION;
    $eumm_version=eval $eumm_version;
    die "EXTRA_META is deprecated" if exists $params{EXTRA_META};
    die "LICENSE not specified" if not exists $params{LICENSE};
    if ($params{BUILD_REQUIRES} and $eumm_version < 6.5503) {
        #EUMM 6.5502 has problems with BUILD_REQUIRES
        $params{PREREQ_PM}={ %{$params{PREREQ_PM} || {}} , %{$params{BUILD_REQUIRES}} };
        delete $params{BUILD_REQUIRES};
    }
    delete $params{TEST_REQUIRES} if $eumm_version < 6.64;
    delete $params{CONFIGURE_REQUIRES} if $eumm_version < 6.52;
    delete $params{MIN_PERL_VERSION} if $eumm_version < 6.48;
    delete $params{META_MERGE} if $eumm_version < 6.46;
    delete $params{META_ADD} if $eumm_version < 6.46;
    delete $params{LICENSE} if $eumm_version < 6.31;
    delete $params{NO_MYMETA} if $eumm_version < 6.58;
    delete $params{AUTHOR} if $] < 5.005;
    delete $params{ABSTRACT_FROM} if $] < 5.005;
    delete $params{BINARY_LOCATION} if $] < 5.005;

    WriteMakefile(%params);
}


package MY;

# build .o files in src.
sub c_o {
    my $t = shift->SUPER::c_o(@_);
    $t =~ s{(\.c\$\(OBJ_EXT\) :\s+\$\(CCCMD\))}{$1 -o \$*.o}s;
    $t;
}

# silence "cp_nonempty" bootstrap.
# silence chmod bootstrap.
sub dynamic_bs {
    my $t = shift->SUPER::dynamic_bs(@_);
    $t =~ s{^\t-}{\t- \$(NOECHO)}m;
    $t =~ s{CHMOD}{NOECHO) \$(CHMOD}s;
    $t;
}

# dont manifypods every.single.time.
sub manifypods {
    my $t = shift->SUPER::manifypods(@_);
    return $t if $t =~ /NOOP/;
    $t =~ s{\\$}{\\\n\t\$(INST_MAN3DIR)/UUID.\$(MAN3EXT)\n\n\$(INST_MAN3DIR)/UUID.\$(MAN3EXT): \\}ms;
    $t;
}

# add distlicense and distreadme prereqs.
# silence manicopy step during config.
sub distdir {
    my $t = shift->SUPER::distdir(@_);
    $t =~ s{^(distdir :.*?)\s*$}{$1 distlicense distreadme}m;
    $t =~ s{PERLRUN}{NOECHO) \$(PERLRUN};
    $t;
}

# remove metafile comments in manifest.
# make metafiles authoritative to cpan.
sub distmeta {
    my $t = <<'EOS';
distmeta : create_distdir metafile
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd -e 'exit unless -e q{META.yml};' \
	  -e 'eval { maniadd({ q{META.yml} => q{} }) }' \
	  -e '    or die "Could not add META.yml to MANIFEST: $${'\''@'\''}"' --
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd -e 'exit unless -f q{META.json};' \
	  -e 'eval { maniadd({ q{META.json} => q{} }) }' \
	  -e '    or die "Could not add META.json to MANIFEST: $${'\''@'\''}"' --
EOS
    $t;
}

# add UUID_DISTTEST flag to 'make disttest'
sub dist_test {
    my $t = shift->SUPER::dist_test(@_);
    $t =~ s{ test }{ test UUID_DISTTEST=1 };
    $t;
}

# make TEST_VERBOSE=1 when AUTOMATED_TESTING=1
sub test {
    my $t = shift->SUPER::test(@_);
    if ( $ENV{AUTOMATED_TESTING}
        or $ENV{NONINTERACTIVE_TESTING}
        or $ENV{PERL_CPAN_REPORTER_CONFIG}
    ) {
        $t =~ s{TEST_VERBOSE=0}{TEST_VERBOSE=1}msg;
    }
    $t;
}

# add distlicense and distreadme targets
sub postamble {
    return <<'EOP';
license: create_distdir
	$(NOECHO) $(ECHO) Generating LICENSE
	$(NOECHO) $(RM_F) LICENSE_new
	$(NOECHO) $(ABSPERLRUN) -MSoftware::License::Artistic_2_0 \
	  -e 'print Software::License::Artistic_2_0->new({holder => q{Rick Myers}, year => sprintf(qq{2014-%04d}, 1900+(localtime(time))[5])})->fulltext' \
	  > LICENSE_new
	$(NOECHO) $(MV) LICENSE_new $(DISTVNAME)/LICENSE

distlicense: create_distdir license
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd -e 'exit unless -e q{LICENSE};' \
	  -e 'eval { maniadd({ q{LICENSE} => q{} }) }' \
	  -e '    or die "Could not add LICENSE to MANIFEST: $${'\''@'\''}"' --
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -e 'print sort <>' MANIFEST > MANIFEST_new
	$(NOECHO) $(MV) $(DISTVNAME)/MANIFEST_new $(DISTVNAME)/MANIFEST

readme: create_distdir
	$(NOECHO) $(ECHO) Generating README
	$(NOECHO) $(RM_F) README_new
	$(NOECHO) pod2text UUID.pm README_new
	$(NOECHO) $(ABSPERLRUN) -i -pe's{\*(\S+)\*}{\1}g' README_new
	$(NOECHO) $(MV) README_new $(DISTVNAME)/README

distreadme: create_distdir readme
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd -e 'exit unless -e q{README};' \
	  -e 'eval { maniadd({ q{README} => q{} }) }' \
	  -e '    or die "Could not add README to MANIFEST: $${'\''@'\''}"' --
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -e 'print sort <>' MANIFEST > MANIFEST_new
	$(NOECHO) $(MV) $(DISTVNAME)/MANIFEST_new $(DISTVNAME)/MANIFEST

src/config.h: src/config.h.in bin/subst.pl
	$(NOECHO) $(ECHO) Generating config.h
	$(NOECHO) $(ABSPERLRUN) bin/subst.pl src/config.h

src/uuid.h: src/uuid.h.in bin/subst.pl
	$(NOECHO) $(ECHO) Generating uuid.h
	$(NOECHO) $(ABSPERLRUN) bin/subst.pl src/uuid.h

src/uuid_types.h: src/uuid_types.h.in bin/subst.pl
	$(NOECHO) $(ECHO) Generating uuid_types.h
	$(NOECHO) $(ABSPERLRUN) bin/subst.pl src/uuid_types.h

config :: $(H_FILES)
	$(NOECHO) $(NOOP)

EOP
}
