use utf8;
use strict;
use warnings;
use open qw( :encoding(UTF-8) :std );
use Test::More tests => 110;
use Lingua::Stem::Patch::EO qw( stem );

is stem('mia'),         'mia',       '-a possesive adjective';
is stem('miaj'),        'mia',       '-aj plural possesive adjective';
is stem('mian'),        'mia',       '-an accusative possesive adjective';
is stem('miajn'),       'mia',       '-ajn accusative plural possesive adjective';
is stem('hundo'),       'hundo',     '-o noun';
is stem('hundoj'),      'hundo',     '-oj plural noun';
is stem('hundon'),      'hundo',     '-on accusative noun';
is stem('hundojn'),     'hundo',     '-ojn accusative plural noun';
is stem('longa'),       'longa',     '-a adjective';
is stem('longaj'),      'longa',     '-aj plural adjective';
is stem('longan'),      'longa',     '-an accusative adjective';
is stem('longajn'),     'longa',     '-ajn accusative plural adjective';
is stem('labori'),      'labori',    '-i infinitive verb';
is stem('laboris'),     'labori',    '-is past indicative verb';
is stem('laboras'),     'labori',    '-as present indicative verb';
is stem('laboros'),     'labori',    '-os future indicative verb';
is stem('laborus'),     'labori',    '-us conditional verb';
is stem('laboru'),      'labori',    '-u jussive verb';
is stem('labore'),      'labore',    '-e adverb';
is stem('hejmen'),      'hejmo',     '-en accusative adverb';
is stem('laborinti'),   'labori',    '-inti';
is stem('laboranti'),   'labori',    '-anti';
is stem('laboronti'),   'labori',    '-onti';
is stem('laboriti'),    'labori',    '-iti';
is stem('laborati'),    'labori',    '-ati';
is stem('laboroti'),    'labori',    '-oti';
is stem('laborintis'),  'labori',    '-intis';
is stem('laborantis'),  'labori',    '-antis';
is stem('laborontis'),  'labori',    '-ontis';
is stem('laboritis'),   'labori',    '-itis';
is stem('laboratis'),   'labori',    '-atis';
is stem('laborotis'),   'labori',    '-otis';
is stem('laborintas'),  'labori',    '-intas';
is stem('laborantas'),  'labori',    '-antas';
is stem('laborontas'),  'labori',    '-ontas';
is stem('laboritas'),   'labori',    '-itas';
is stem('laboratas'),   'labori',    '-atas';
is stem('laborotas'),   'labori',    '-otas';
is stem('laborintos'),  'labori',    '-intos';
is stem('laborantos'),  'labori',    '-antos';
is stem('laborontos'),  'labori',    '-ontos';
is stem('laboritos'),   'labori',    '-itos';
is stem('laboratos'),   'labori',    '-atos';
is stem('laborotos'),   'labori',    '-otos';
is stem('laborintus'),  'labori',    '-intus';
is stem('laborantus'),  'labori',    '-antus';
is stem('laborontus'),  'labori',    '-ontus';
is stem('laboritus'),   'labori',    '-itus';
is stem('laboratus'),   'labori',    '-atus';
is stem('laborotus'),   'labori',    '-otus';
is stem('laborintu'),   'labori',    '-intu';
is stem('laborantu'),   'labori',    '-antu';
is stem('laborontu'),   'labori',    '-ontu';
is stem('laboritu'),    'labori',    '-itu';
is stem('laboratu'),    'labori',    '-atu';
is stem('laborotu'),    'labori',    '-otu';
is stem('laborinte'),   'labori',    '-inte';
is stem('laborante'),   'labori',    '-ante';
is stem('laboronte'),   'labori',    '-onte';
is stem('laborite'),    'labori',    '-ite';
is stem('laborate'),    'labori',    '-ate';
is stem('laborote'),    'labori',    '-ote';
is stem('laborinta'),   'labori',    '-inta';
is stem('laboranta'),   'labori',    '-anta';
is stem('laboronta'),   'labori',    '-onta';
is stem('laborita'),    'labori',    '-ita';
is stem('laborata'),    'labori',    '-ata';
is stem('laborota'),    'labori',    '-ota';
is stem('laborintaj'),  'labori',    '-intaj';
is stem('laborantaj'),  'labori',    '-antaj';
is stem('laborontaj'),  'labori',    '-ontaj';
is stem('laboritaj'),   'labori',    '-itaj';
is stem('laborataj'),   'labori',    '-ataj';
is stem('laborotaj'),   'labori',    '-otaj';
is stem('laborintan'),  'labori',    '-intan';
is stem('laborantan'),  'labori',    '-antan';
is stem('laborontan'),  'labori',    '-ontan';
is stem('laboritan'),   'labori',    '-itan';
is stem('laboratan'),   'labori',    '-atan';
is stem('laborotan'),   'labori',    '-otan';
is stem('laborintajn'), 'labori',    '-intajn';
is stem('laborantajn'), 'labori',    '-antajn';
is stem('laborontajn'), 'labori',    '-ontajn';
is stem('laboritajn'),  'labori',    '-itajn';
is stem('laboratajn'),  'labori',    '-atajn';
is stem('laborotajn'),  'labori',    '-otajn';
is stem('laboradi'),    'labori',    '-adi';
is stem('laboradas'),   'labori',    '-adas';
is stem('laborado'),    'labori',    '-ado';
is stem('eklabori'),    'labori',    'ek-';
is stem('eksciti'),     'eksciti',   'ek- exception';
is stem('ellabori'),    'labori',    'el-';
is stem('elefanto'),    'elefanto',  'el- exception';
is stem('laboranto'),   'laboranto', '-anto';
is stem('laborinto'),   'laboranto', '-into';
is stem('laboronto'),   'laboranto', '-onto';
is stem('laborato'),    'laborato',  '-ato';
is stem('laborito'),    'laborato',  '-ito';
is stem('laboroto'),    'laborato',  '-oto';
is stem('esperanto'),   'esperanto', 'esperanto: keep -anto';
is stem('kanto'),       'kanto',     'kanto: keep -anto';
is stem('hund’'),       'hundo',     '-’ noun with typographic apostrophe';
is stem("hund'"),       'hundo',     "-' noun with typewriter apostrophe";
is stem('l’'),          'la',        'l’ with typographic apostrophe';
is stem("l'"),          'la',        "l' with typewriter apostrophe";
is stem('’stas'),       'esti',      '’stas with typographic apostrophe';
is stem("'stas"),       'esti',      "'stas with typewriter apostrophe";
is stem('un’'),         'unu',       'un’ with typographic apostrophe';
is stem("un'"),         'unu',       "un' with typewriter apostrophe";
is stem('unuj'),        'unu',       'plural unu';
