# Generated by default/object.tt
package Paws::GreengrassV2::AssociatedClientDevice;
  use Moose;
  has AssociationTimestamp => (is => 'ro', isa => 'Str', request_name => 'associationTimestamp', traits => ['NameInRequest']);
  has ThingName => (is => 'ro', isa => 'Str', request_name => 'thingName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::AssociatedClientDevice

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::AssociatedClientDevice object:

  $service_obj->Method(Att1 => { AssociationTimestamp => $value, ..., ThingName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::AssociatedClientDevice object:

  $result = $service_obj->Method(...);
  $result->Att1->AssociationTimestamp

=head1 DESCRIPTION

Contains information about a client device that is associated to a core
device for cloud discovery.

=head1 ATTRIBUTES


=head2 AssociationTimestamp => Str

The time that the client device was associated, expressed in ISO 8601
format.


=head2 ThingName => Str

The name of the AWS IoT thing that represents the associated client
device.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

