# NAME

RT-Extension-BooleanCustomField - CF with checkbox to set or unset its value

# DESCRIPTION

Provide a new type of [custom field](https://metacpan.org/pod/RT::CustomField), which value can only be set or unset. Editing a `BooleanCustomField` is done through a single checkbox.

This enhances the behaviour allowed by core `Request Tracker` through `SelectCustomField`, where editing a `SelectCustomField`, with only a single value, should be done through a dropdown menu, radio buttons or checkboxes, including the single value and `no value`. With `BooleanCustomField`, you have only a single checkbox to check or uncheck.

# RT VERSION

Works with RT 4.0 or greater

# INSTALLATION

- `perl Makefile.PL`
- `make`
- `make install`

    May need root permissions

- Edit your `/opt/rt4/etc/RT_SiteConfig.pm`

    If you are using RT 4.2 or greater, add this line:

        Plugin('RT::Extension::BooleanCustomField');

    For RT 4.0, add this line:

        Set(@Plugins, qw(RT::Extension::BooleanCustomField));

    or add `RT::Extension::BooleanCustomField` to your existing `@Plugins` line.

- Clear your mason cache

        rm -rf /opt/rt4/var/mason_data/obj

- Restart your webserver

# AUTHOR

Grald Sdrati-Dinet <gibus@easter-eggs.com>

# REPOSITORY

[https://github.com/gibus/RT-Extension-BooleanCustomField](https://github.com/gibus/RT-Extension-BooleanCustomField)

# BUGS

All bugs should be reported via email to

[bug-RT-Extension-BooleanCustomField@rt.cpan.org](mailto:bug-RT-Extension-BooleanCustomField@rt.cpan.org)

or via the web at

[rt.cpan.org](http://rt.cpan.org/Public/Dist/Display.html?Name=RT-Extension-BooleanCustomField).

# LICENSE AND COPYRIGHT

This software is Copyright (c) 2018 by Grald Sdrati-Dinet, Easter-Eggs

This is free software, licensed under:

The GNU General Public License, Version 3, June 2007
