# Generated by default/object.tt
package Paws::CodeGuruProfiler::Match;
  use Moose;
  has FrameAddress => (is => 'ro', isa => 'Str', request_name => 'frameAddress', traits => ['NameInRequest']);
  has TargetFramesIndex => (is => 'ro', isa => 'Int', request_name => 'targetFramesIndex', traits => ['NameInRequest']);
  has ThresholdBreachValue => (is => 'ro', isa => 'Num', request_name => 'thresholdBreachValue', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruProfiler::Match

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruProfiler::Match object:

  $service_obj->Method(Att1 => { FrameAddress => $value, ..., ThresholdBreachValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruProfiler::Match object:

  $result = $service_obj->Method(...);
  $result->Att1->FrameAddress

=head1 DESCRIPTION

The part of a profile that contains a recommendation found during
analysis.

=head1 ATTRIBUTES


=head2 FrameAddress => Str

The location in the profiling graph that contains a recommendation
found during analysis.


=head2 TargetFramesIndex => Int

The target frame that triggered a match.


=head2 ThresholdBreachValue => Num

The value in the profile data that exceeded the recommendation
threshold.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruProfiler>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

