# Generated by default/object.tt
package Paws::DevOpsGuru::ServiceIntegrationConfig;
  use Moose;
  has OpsCenter => (is => 'ro', isa => 'Paws::DevOpsGuru::OpsCenterIntegration');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::ServiceIntegrationConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::ServiceIntegrationConfig object:

  $service_obj->Method(Att1 => { OpsCenter => $value, ..., OpsCenter => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::ServiceIntegrationConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->OpsCenter

=head1 DESCRIPTION

Information about the integration of DevOps Guru with another AWS
service, such as AWS Systems Manager.

=head1 ATTRIBUTES


=head2 OpsCenter => L<Paws::DevOpsGuru::OpsCenterIntegration>

Information about whether DevOps Guru is configured to create an
OpsItem in AWS Systems Manager OpsCenter for each created insight.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

