# Generated by default/object.tt
package Paws::LookoutMetrics::RDSSourceConfig;
  use Moose;
  has DatabaseHost => (is => 'ro', isa => 'Str', required => 1);
  has DatabaseName => (is => 'ro', isa => 'Str', required => 1);
  has DatabasePort => (is => 'ro', isa => 'Int', required => 1);
  has DBInstanceIdentifier => (is => 'ro', isa => 'Str', required => 1);
  has RoleArn => (is => 'ro', isa => 'Str', required => 1);
  has SecretManagerArn => (is => 'ro', isa => 'Str', required => 1);
  has TableName => (is => 'ro', isa => 'Str', required => 1);
  has VpcConfiguration => (is => 'ro', isa => 'Paws::LookoutMetrics::VpcConfiguration', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::RDSSourceConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::RDSSourceConfig object:

  $service_obj->Method(Att1 => { DatabaseHost => $value, ..., VpcConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::RDSSourceConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->DatabaseHost

=head1 DESCRIPTION

Contains information about the Amazon Relational Database Service (RDS)
configuration.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DatabaseHost => Str

The host name of the database.


=head2 B<REQUIRED> DatabaseName => Str

The name of the RDS database.


=head2 B<REQUIRED> DatabasePort => Int

The port number where the database can be accessed.


=head2 B<REQUIRED> DBInstanceIdentifier => Str

A string identifying the database instance.


=head2 B<REQUIRED> RoleArn => Str

The Amazon Resource Name (ARN) of the role.


=head2 B<REQUIRED> SecretManagerArn => Str

The Amazon Resource Name (ARN) of the AWS Secrets Manager role.


=head2 B<REQUIRED> TableName => Str

The name of the table in the database.


=head2 B<REQUIRED> VpcConfiguration => L<Paws::LookoutMetrics::VpcConfiguration>

An object containing information about the Amazon Virtual Private Cloud
(VPC) configuration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

