# Generated by default/object.tt
package Paws::Athena::TableMetadata;
  use Moose;
  has Columns => (is => 'ro', isa => 'ArrayRef[Paws::Athena::Column]');
  has CreateTime => (is => 'ro', isa => 'Str');
  has LastAccessTime => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Parameters => (is => 'ro', isa => 'Paws::Athena::ParametersMap');
  has PartitionKeys => (is => 'ro', isa => 'ArrayRef[Paws::Athena::Column]');
  has TableType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Athena::TableMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Athena::TableMetadata object:

  $service_obj->Method(Att1 => { Columns => $value, ..., TableType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Athena::TableMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->Columns

=head1 DESCRIPTION

Contains metadata for a table.

=head1 ATTRIBUTES


=head2 Columns => ArrayRef[L<Paws::Athena::Column>]

A list of the columns in the table.


=head2 CreateTime => Str

The time that the table was created.


=head2 LastAccessTime => Str

The last time the table was accessed.


=head2 B<REQUIRED> Name => Str

The name of the table.


=head2 Parameters => L<Paws::Athena::ParametersMap>

A set of custom key/value pairs for table properties.


=head2 PartitionKeys => ArrayRef[L<Paws::Athena::Column>]

A list of the partition keys in the table.


=head2 TableType => Str

The type of table. In Athena, only C<EXTERNAL_TABLE> is supported.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Athena>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

