/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.List;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.util.FactoryException;

final class SubOperationInfo {
    private static final Class<?>[][] COMPATIBLE_TYPES = new Class[][]{{GeodeticCRS.class}, {VerticalCRS.class, GeodeticCRS.class}, {TemporalCRS.class}, {DefaultParametricCRS.class}, {EngineeringCRS.class}, {ImageCRS.class}};
    final CoordinateOperation operation;
    final int startAtDimension;
    final int endAtDimension;

    private static Class<?> type(SingleCRS singleCRS) {
        while (singleCRS instanceof GeneralDerivedCRS) {
            singleCRS = (SingleCRS)((GeneralDerivedCRS)singleCRS).getBaseCRS();
        }
        return singleCRS.getClass();
    }

    private SubOperationInfo(CoordinateOperation coordinateOperation, int n, int n2) {
        this.operation = coordinateOperation;
        this.startAtDimension = n;
        this.endAtDimension = n2;
    }

    static SubOperationInfo create(CoordinateOperationFinder coordinateOperationFinder, boolean[] blArray, List<? extends SingleCRS> list, SingleCRS singleCRS) throws FactoryException {
        OperationNotFoundException operationNotFoundException = null;
        Class<?> clazz = SubOperationInfo.type(singleCRS);
        for (Class<?>[] classArray : COMPATIBLE_TYPES) {
            if (!classArray[0].isAssignableFrom(clazz)) continue;
            for (Class<?> clazz2 : classArray) {
                int n = 0;
                for (int i = 0; i < blArray.length; ++i) {
                    CoordinateOperation coordinateOperation;
                    SingleCRS singleCRS2 = list.get(i);
                    int n2 = n;
                    n += singleCRS2.getCoordinateSystem().getDimension();
                    if (blArray[i] || !clazz2.isAssignableFrom(SubOperationInfo.type(singleCRS2))) continue;
                    try {
                        coordinateOperation = coordinateOperationFinder.createOperation(singleCRS2, singleCRS);
                    }
                    catch (OperationNotFoundException operationNotFoundException2) {
                        if (operationNotFoundException == null) {
                            operationNotFoundException = operationNotFoundException2;
                            continue;
                        }
                        operationNotFoundException.addSuppressed(operationNotFoundException2);
                        continue;
                    }
                    blArray[i] = true;
                    if (operationNotFoundException != null) {
                        Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), CoordinateOperationFinder.class, "decompose", operationNotFoundException);
                    }
                    return new SubOperationInfo(coordinateOperation, n2, n);
                }
            }
        }
        if (operationNotFoundException != null) {
            throw operationNotFoundException;
        }
        return null;
    }

    static int startOfIdentity(SubOperationInfo[] subOperationInfoArray) {
        int n = subOperationInfoArray.length;
        while (n != 0 && subOperationInfoArray[--n].operation.getMathTransform().isIdentity()) {
        }
        return n;
    }

    static Matrix sourceToSelected(int n, int n2, SubOperationInfo[] subOperationInfoArray) {
        MatrixSIS matrixSIS = Matrices.createZero(n2 + 1, n + 1);
        matrixSIS.setElement(n2, n, 1.0);
        int n3 = 0;
        for (SubOperationInfo subOperationInfo : subOperationInfoArray) {
            for (int i = subOperationInfo.startAtDimension; i < subOperationInfo.endAtDimension; ++i) {
                matrixSIS.setElement(n3++, i, 1.0);
            }
        }
        return matrixSIS;
    }
}

